/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.opensymphony.xwork2.validator.annotations.Validation;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.Fund;
import org.egov.egf.model.ReportSearch;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.report.FundFlowBean;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ManualEntryReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ManualEntryReport.xls"})})
@ParentPackage(value="egov")
@Validation
public class FundFlowManualEntryReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -6817974441103230738L;
    protected ReportSearch reportSearch = new ReportSearch();
    private String selectedAccountNumber;
    public List<Object> manualEntryReportList = new ArrayList();
    FundFlowBean manualEntry = new FundFlowBean();
    List<FundFlowBean> entryReportList = new ArrayList();
    private InputStream inputStream;
    private ReportHelper reportHelper;
    private StringBuffer heading = new StringBuffer();
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private static final Logger LOGGER = Logger.getLogger(FundFlowManualEntryReportAction.class);
    private final Map<String, Object> paramMap = new HashMap();
    BigDecimal grandTotal = BigDecimal.ZERO;
    private static final String JASPERPATH = "/reports/templates/manualEntryReport.jasper";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.reportSearch;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
    }

    @Action(value="/report/fundFlowManualEntryReport-newForm")
    public String newForm() {
        this.manualEntryReportList = null;
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/fundFlowManualEntryReport-search")
    public String search() {
        this.populateReAppropriationData();
        return "new";
    }

    private void populateReAppropriationData() {
        this.setRelatedEntitesOn();
        this.getResultList();
    }

    public void getResultList() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  getResultList ");
        }
        Date startdt = null;
        Date enddt = null;
        this.grandTotal = BigDecimal.ZERO;
        try {
            startdt = Constants.DDMMYYYYFORMAT2.parse(this.reportSearch.getStartDate());
            enddt = Constants.DDMMYYYYFORMAT2.parse(this.reportSearch.getEndDate());
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Error in parsing Date ");
        }
        Criteria critQuery = this.persistenceService.getSession().createCriteria(FundFlowBean.class).add(Restrictions.between((String)"reportDate", (Object)startdt, (Object)enddt)).add((Criterion)Restrictions.ne((String)"currentReceipt", (Object)BigDecimal.ZERO)).add((Criterion)Restrictions.eq((String)"bankAccountId", (Object)BigDecimal.valueOf(this.reportSearch.getBankAccount().getId()))).addOrder(Order.asc((String)"reportDate"));
        this.entryReportList.addAll(critQuery.list());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("No of Fund flow Manual entry during the period " + this.reportSearch.getStartDate() + "to " + this.reportSearch.getEndDate() + "is " + this.entryReportList.size()));
        }
        for (FundFlowBean entry : this.entryReportList) {
            this.manualEntry = new FundFlowBean();
            this.manualEntry.setReportDate(entry.getReportDate());
            this.manualEntry.setCurrentReceipt(entry.getCurrentReceipt());
            this.grandTotal = this.grandTotal.add(entry.getCurrentReceipt());
            this.manualEntryReportList.add(this.manualEntry);
        }
        this.getSession().put("entryResultReportList", this.entryReportList);
        this.getSession().put("headingStr", this.heading);
        this.getSession().put("total", this.grandTotal);
        this.getSession().put("manualEntryReportList", this.manualEntryReportList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("manualEntryReportList+" + this.manualEntryReportList.size()));
        }
    }

    private void populateData() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting the value from session");
        }
        this.entryReportList = (List)this.getSession().get("entryResultReportList");
        for (FundFlowBean entry : this.entryReportList) {
            this.manualEntry = new FundFlowBean();
            this.manualEntry.setReportDate(entry.getReportDate());
            this.manualEntry.setCurrentReceipt(entry.getCurrentReceipt());
            this.manualEntryReportList.add(this.manualEntry);
        }
        this.setParamMap();
    }

    protected void setRelatedEntitesOn() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)" Inside setRelatedEntitesOn:-  Adding heading and getting object values");
        }
        this.heading.append("Manual Entry Report for ");
        if (this.reportSearch.getBankAccount() != null && this.reportSearch.getBankAccount().getId() != null && this.reportSearch.getBankAccount().getId() != 0L) {
            this.reportSearch.setBankAccount((Bankaccount)this.getPersistenceService().find("from Bankaccount where id=?", new Object[]{Integer.parseInt(this.reportSearch.getBankAccount().getId().toString())}));
            this.heading.append(" Bank Name -" + this.reportSearch.getBankAccount().getBankbranch().getBank().getName());
            this.heading.append(" Account Number-" + this.reportSearch.getBankAccount().getAccountnumber());
        }
        if (this.reportSearch.getStartDate() != null && this.reportSearch.getEndDate() != null) {
            this.heading.append(" From " + this.reportSearch.getStartDate() + " to " + this.reportSearch.getEndDate());
        }
    }

    public FundFlowManualEntryReportAction() {
        this.addRelatedEntity("fund", Fund.class);
        this.addRelatedEntity("bankAccount", Bankaccount.class);
        this.addRelatedEntity("bankbranch", Bankbranch.class);
        this.addRelatedEntity("bank", Bank.class);
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public void setParamMap() {
        String str = this.getSession().get("headingStr").toString();
        BigDecimal amt = (BigDecimal)this.getSession().get("total");
        this.getUlbName();
        this.paramMap.put("title", this.getUlbName());
        this.paramMap.put("heading", str);
        this.paramMap.put("grandTotal", amt);
    }

    protected Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public String generatePdf() throws Exception {
        this.populateData();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, JASPERPATH, this.getParamMap(), this.manualEntryReportList);
        return "PDF";
    }

    public String generateXls() throws Exception {
        this.populateData();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, JASPERPATH, this.getParamMap(), this.manualEntryReportList);
        return "XLS";
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public ReportSearch getReportSearch() {
        return this.reportSearch;
    }

    public void setReportSearch(ReportSearch reportSearch) {
        this.reportSearch = reportSearch;
    }

    public StringBuffer getHeading() {
        return this.heading;
    }

    public String getSelectedAccountNumber() {
        return this.selectedAccountNumber;
    }

    public void setSelectedAccountNumber(String selectedAccountNumber) {
        this.selectedAccountNumber = selectedAccountNumber;
    }

    public void setHeading(StringBuffer heading) {
        this.heading = heading;
    }

    public List<Object> getManualEntryReportList() {
        return this.manualEntryReportList;
    }

    public List<FundFlowBean> getEntryReportList() {
        return this.entryReportList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setManualEntryReportList(List<Object> manualEntryReportList) {
        this.manualEntryReportList = manualEntryReportList;
    }

    public void setEntryReportList(List<FundFlowBean> entryReportList) {
        this.entryReportList = entryReportList;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public BigDecimal getGrandTotal() {
        return this.grandTotal;
    }

    public void setGrandTotal(BigDecimal grandTotal) {
        this.grandTotal = grandTotal;
    }
}

