/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.model.CommonReportBean;
import org.egov.egf.model.FunctionwiseIE;
import org.egov.egf.model.ReportSearch;
import org.egov.egf.web.actions.report.ReportAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.report.FunctionwiseIEService;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="functionwiseIE-PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=FunctionwiseIE.pdf"}), @Result(name="functionwiseIE-XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=FunctionwiseIE.xls"}), @Result(name="functionwiseIE-HTML", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class FunctionwiseIEAction
extends ReportAction {
    private static final long serialVersionUID = 1L;
    protected InputStream inputStream;
    private ReportHelper reportHelper;
    private FunctionwiseIEService functionwiseIEService;
    private final FunctionwiseIE functionwiseIE = new FunctionwiseIE();
    private CityService cityService;
    private City cityWebsite;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    private FinancialYearDAO financialYearDAO;
    private String heading = "";
    private Date todayDate;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private static final Logger LOGGER = Logger.getLogger(FunctionwiseIEAction.class);
    private List<CommonReportBean> ieWithBudgetList;

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    public void setFunctionwiseIEService(FunctionwiseIEService functionwiseIEService) {
        this.functionwiseIEService = functionwiseIEService;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (this.reportSearch.getStartDate() == null || this.reportSearch.getStartDate().equals("")) {
            this.reportSearch.setStartDate(this.sdf.format(((CFinancialYear)this.persistenceService.find(" from CFinancialYear where startingDate <= '" + this.formatter.format(new Date()) + "' and endingDate >= '" + this.formatter.format(new Date()) + "'")).getStartingDate()));
        }
        if (this.reportSearch.getEndDate() == null || this.reportSearch.getEndDate().equals("")) {
            this.reportSearch.setEndDate(this.sdf.format(new Date()));
        }
        this.setTodayDate(new Date());
    }

    public void preparebeforesearchWithBudget() {
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
    }

    public Object getModel() {
        return this.reportSearch;
    }

    @SkipValidation
    @Action(value="/report/functionwiseIE-beforesearch")
    public String beforesearch() {
        return "report";
    }

    @SkipValidation
    @Action(value="/report/functionwiseIE-beforeSearchWithBudget")
    public String beforeSearchWithBudget() {
        return "reportWithBudget";
    }

    @SkipValidation
    @Action(value="/report/functionwiseIE-exportMajorAndMinorCodewise")
    public String exportMajorAndMinorCodewise() {
        try {
            this.searchWithBudget();
            this.removEmptyRows(this.reportSearch);
            if (this.reportSearch.getExportType().equalsIgnoreCase("xls")) {
                this.inputStream = this.reportHelper.exportXls(this.inputStream, this.reportHelper.exportMajorAndMinorCodewise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
                return "functionwiseIE-XLS";
            }
            this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.reportHelper.exportMajorAndMinorCodewise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
            return "functionwiseIE-PDF";
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return "functionwiseIE-XLS";
    }

    @SkipValidation
    @Action(value="/report/functionwiseIE-exportDeptwise")
    public String exportDeptwise() {
        try {
            this.deptWiseIEWithBudget();
            this.removEmptyRows(this.reportSearch);
            if (this.reportSearch.getExportType().equalsIgnoreCase("xls")) {
                this.inputStream = this.reportHelper.exportXls(this.inputStream, this.reportHelper.exportDeptwise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
                return "functionwiseIE-XLS";
            }
            this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.reportHelper.exportDeptwise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
            return "functionwiseIE-PDF";
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return "functionwiseIE-XLS";
    }

    @SkipValidation
    @Action(value="/report/functionwiseIE-exportDetailwise")
    public String exportDetailwise() {
        try {
            this.detailWiseIEWithBudget();
            this.removEmptyRows(this.reportSearch);
            if (this.reportSearch.getExportType().equalsIgnoreCase("xls")) {
                this.inputStream = this.reportHelper.exportXls(this.inputStream, this.reportHelper.exportDetailwise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
                return "functionwiseIE-XLS";
            }
            this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.reportHelper.exportDetailwise(this.ieWithBudgetList, this.cityWebsite.getName(), this.reportSearch, this.heading));
            return "functionwiseIE-PDF";
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return "functionwiseIE-XLS";
    }

    private void removEmptyRows(ReportSearch reportSearch) {
        ArrayList ieWithBudgetList2 = new ArrayList();
        ieWithBudgetList2.addAll(this.ieWithBudgetList);
        if (reportSearch.getIncExp().equalsIgnoreCase("E")) {
            for (CommonReportBean crb : ieWithBudgetList2) {
                if (!crb.isZero()) continue;
                this.ieWithBudgetList.remove(crb);
            }
        } else {
            for (CommonReportBean crb : ieWithBudgetList2) {
                if (!crb.isZeroForIncome()) continue;
                this.ieWithBudgetList.remove(crb);
            }
        }
        int i = 1;
        for (CommonReportBean crb : this.ieWithBudgetList) {
            crb.setSlNo(Integer.valueOf(i++));
        }
    }

    @SkipValidation
    public String searchWithBudget() throws Exception {
        this.setDatasForBudgetWise();
        this.populateDataSourceWithBudget(this.reportSearch);
        this.heading = this.generateHeading();
        return "resultWithBudget";
    }

    private void setDatasForBudgetWise() {
        Integer majorCodeLen = Integer.valueOf(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length").get(0)).getValue());
        this.reportSearch.setMajorCodeLen(majorCodeLen);
        Integer minorCodeLen = Integer.valueOf(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_minorcode_length").get(0)).getValue());
        this.reportSearch.setMinorCodeLen(minorCodeLen);
        if (this.reportSearch.getAsOnDate() != null) {
            CFinancialYear financialYearByDate = this.getFinancialYearDAO().getFinancialYearByDate(this.reportSearch.getAsOnDate());
            this.reportSearch.setFinYearId(financialYearByDate.getId());
            this.reportSearch.setYearStartDate(financialYearByDate.getStartingDate());
            this.setPreviousYearDates();
        }
    }

    private void setPreviousYearDates() {
        CFinancialYear previousfinancialYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.reportSearch.getAsOnDate());
        this.reportSearch.setPreviousFinYearId(previousfinancialYear.getId());
        this.reportSearch.setPreviousYearStartDate(previousfinancialYear.getStartingDate());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.reportSearch.getAsOnDate());
        cal.add(1, -1);
        this.reportSearch.setPreviousYearDate(cal.getTime());
    }

    private String generateHeading() {
        StringBuffer heading = new StringBuffer(256);
        heading.append(" FunctionWise ");
        if (this.reportSearch.getIncExp().equalsIgnoreCase("E")) {
            heading.append(" Expense Subsidary Register ");
        } else {
            heading.append(" Income Subsidary Register ");
        }
        if (this.reportSearch.getFunction() != null && this.reportSearch.getFunction().getId() != null && this.reportSearch.getFunction().getId() != -1L) {
            heading.append(" For the Function Code ");
            String code = (String)this.persistenceService.find("select code from CFunction where id=?", new Object[]{this.reportSearch.getFunction().getId()});
            heading.append(code);
        }
        if (this.reportSearch.getScheduleName() != null) {
            heading.append(" For Schedule " + this.reportSearch.getScheduleName());
        }
        if (this.reportSearch.getDepartment() != null && !this.reportSearch.getDepartment().getName().isEmpty()) {
            heading.append(" For Department " + this.reportSearch.getDepartment().getName());
        }
        if (this.reportSearch.getFund() != null && this.reportSearch.getFund().getId() != -1) {
            heading.append(" In Fund ");
            String name = (String)this.persistenceService.find("select name from Fund where id=?", new Object[]{this.reportSearch.getFund().getId()});
            heading.append(name);
        }
        heading.append(" from " + this.sdf.format(this.reportSearch.getYearStartDate()) + " - " + this.sdf.format(this.reportSearch.getAsOnDate()));
        return heading.toString();
    }

    @Action(value="/report/functionwiseIE-deptWiseIEWithBudget")
    public String deptWiseIEWithBudget() throws Exception {
        this.setDatasForBudgetWise();
        this.reportSearch.setByDepartment(true);
        this.reportSearch.setDeptList(this.masterDataCache.get("egi-department"));
        this.populateDataSourceWithBudget(this.reportSearch);
        this.heading = this.generateHeading();
        return "deptWiseWithBudget";
    }

    @Action(value="/report/functionwiseIE-detailWiseIEWithBudget")
    public String detailWiseIEWithBudget() throws Exception {
        this.setDatasForBudgetWise();
        Integer minorCodeLen = Integer.valueOf(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_detailcode_length").get(0)).getValue());
        this.reportSearch.setMinorCodeLen(minorCodeLen);
        this.reportSearch.setByDepartment(true);
        this.reportSearch.setByDetailCode(true);
        this.reportSearch.setDeptList(this.masterDataCache.get("egi-department"));
        this.populateDataSourceWithBudget(this.reportSearch);
        this.heading = this.generateHeading();
        return "detailWiseWithBudget";
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    @Action(value="/report/functionwiseIE-search")
    public String search() throws Exception {
        Integer majorCodeLen = Integer.valueOf(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length").get(0)).getValue());
        this.reportSearch.setMajorCodeLen(majorCodeLen);
        this.populateDataSource(this.reportSearch);
        return "print";
    }

    public String generateFunctionwiseIEHtml() throws Exception {
        this.populateDataSource(this.reportSearch);
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.reportHelper.generateFunctionwiseIEJasperPrint(this.functionwiseIE, this.cityWebsite.getName(), this.getvalue(this.reportSearch.getIncExp())));
        return "functionwiseIE-HTML";
    }

    @Action(value="/report/functionwiseIE-generateFunctionwiseIEPdf")
    public String generateFunctionwiseIEPdf() throws Exception {
        this.populateDataSource(this.reportSearch);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.reportHelper.generateFunctionwiseIEJasperPrint(this.functionwiseIE, this.cityWebsite.getName(), this.getvalue(this.reportSearch.getIncExp())));
        return "functionwiseIE-PDF";
    }

    @Action(value="/report/functionwiseIE-generateFunctionwiseIEXls")
    public String generateFunctionwiseIEXls() throws Exception {
        this.populateDataSource(this.reportSearch);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.reportHelper.generateFunctionwiseIEJasperPrint(this.functionwiseIE, this.cityWebsite.getName(), this.getvalue(this.reportSearch.getIncExp())));
        return "functionwiseIE-XLS";
    }

    public void populateDataSource(ReportSearch reportSearch) throws Exception {
        this.functionwiseIEService.populateData(this.functionwiseIE, reportSearch);
        this.cityWebsite = this.cityService.getCityByURL((String)this.getSession().get("cityurl"));
        this.functionwiseIE.setCityName(this.cityWebsite.getName());
    }

    public void populateDataSourceWithBudget(ReportSearch reportSearch) throws Exception {
        this.ieWithBudgetList = reportSearch.getIncExp().equalsIgnoreCase("E") ? this.functionwiseIEService.populateDataWithBudget(this.functionwiseIE, reportSearch) : this.functionwiseIEService.populateIncomeDataWithBudget(this.functionwiseIE, reportSearch);
        this.cityWebsite = this.cityService.getCityByURL((String)this.getSession().get("cityurl"));
        this.functionwiseIE.setCityName(this.cityWebsite.getName());
    }

    public List<CommonReportBean> getIeWithBudgetList() {
        return this.ieWithBudgetList;
    }

    public void setIeWithBudgetList(List<CommonReportBean> ieWithBudgetList) {
        this.ieWithBudgetList = ieWithBudgetList;
    }

    public String getvalue(String incExp) {
        if ("I".equals(incExp)) {
            return "Income";
        }
        return "Expense";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void validate() {
        if (this.reportSearch.getIncExp() == null || this.reportSearch.getIncExp().equals("-1")) {
            this.addFieldError("incExp", this.getMessage("report.income.expense.mandatory"));
        }
        if (this.reportSearch.getStartDate() == null || this.reportSearch.getStartDate().equals("")) {
            this.addFieldError("startDate", this.getMessage("report.startdate.mandatory"));
        }
        if (this.reportSearch.getEndDate() == null || this.reportSearch.getEndDate().equals("")) {
            this.addFieldError("endDate", this.getMessage("report.enddate.mandatory"));
        }
        try {
            if (!this.reportSearch.getStartDate().equals("")) {
                this.sdf.parse(this.reportSearch.getStartDate());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            this.addFieldError("startDate", this.getMessage("report.startdate.invalid.format"));
        }
        try {
            if (!this.reportSearch.getEndDate().equals("")) {
                this.sdf.parse(this.reportSearch.getEndDate());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            this.addFieldError("endDate", this.getMessage("report.enddate.invalid.format"));
        }
        super.validate();
    }

    public FunctionwiseIE getFunctionwiseIE() {
        return this.functionwiseIE;
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }
}

