/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.VoucherReport;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillregistermis;
import org.egov.services.budget.BudgetAppropriationService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="print", location="expenseJournalVoucherPrint-print.jsp"), @Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ExpenseJournalVoucherReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ExpenseJournalVoucherReport.xls"}), @Result(name="HTML", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class ExpenseJournalVoucherPrintAction
extends BaseFormAction {
    String jasperpath = "/reports/templates/expenseJournalVoucherReport.jasper";
    private static final long serialVersionUID = 1L;
    static final String PRINT = "print";
    private CVoucherHeader voucher = new CVoucherHeader();
    List<Object> voucherReportList = new ArrayList();
    InputStream inputStream;
    ReportHelper reportHelper;
    Long id;
    EgBillregistermis billRegistermis;
    List<EgBillPayeedetails> billPayeeDetails = new ArrayList();
    private static final String ACCDETAILTYPEQUERY = " from Accountdetailtype where id=?";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovCommon egovCommon;

    public Long getId() {
        return this.id;
    }

    public void setBudgetAppropriationService(BudgetAppropriationService budgetAppropriationService) {
    }

    public void setReportHelper(ReportHelper helper) {
        this.reportHelper = helper;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Object> getVoucherReportList() {
        return this.voucherReportList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() {
        return this.print();
    }

    @Action(value="/report/expenseJournalVoucherPrint-ajaxPrint")
    public String ajaxPrint() {
        return this.exportHtml();
    }

    public Object getModel() {
        return this.voucher;
    }

    @Action(value="/report/expenseJournalVoucherPrint-print")
    public String print() {
        return PRINT;
    }

    private void populateVoucher() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (!StringUtils.isBlank((String)((String[])this.parameters.get("id"))[0])) {
            Long id = Long.valueOf(((String[])this.parameters.get("id"))[0]);
            CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.getSession().get(CVoucherHeader.class, (Serializable)id);
            if (voucherHeader != null) {
                this.voucher = voucherHeader;
                this.billRegistermis = (EgBillregistermis)this.persistenceService.find("from EgBillregistermis where voucherHeader.id=?", new Object[]{voucherHeader.getId()});
                if (this.billRegistermis != null) {
                    this.billPayeeDetails = this.persistenceService.findAllBy("from EgBillPayeedetails where egBilldetailsId.egBillregister.id=?", new Object[]{this.billRegistermis.getEgBillregister().getId()});
                }
                this.generateVoucherReportList();
            }
        }
    }

    private void generateVoucherReportList() {
        if (this.voucher != null) {
            VoucherReport voucherReport;
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getCreditAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                if (this.billRegistermis != null) {
                    voucherReport.setDepartment(this.billRegistermis.getEgDepartment());
                }
                this.voucherReportList.add(voucherReport);
            }
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getDebitAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                if (this.billRegistermis != null) {
                    voucherReport.setDepartment(this.billRegistermis.getEgDepartment());
                }
                this.voucherReportList.add(voucherReport);
            }
        }
    }

    private String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public String exportPdf() throws JRException, IOException {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList);
        return "PDF";
    }

    public String exportHtml() {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList, "px");
        return "HTML";
    }

    public String exportXls() throws JRException, IOException {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList);
        return "XLS";
    }

    protected Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("voucherNumber", this.getVoucherNumber());
        paramMap.put("voucherDate", this.getVoucherDate());
        paramMap.put("voucherDescription", this.getVoucherDescription());
        if (this.voucher != null && this.voucher.getState() != null) {
            this.loadInboxHistoryData(this.voucher.getStateHistory(), paramMap);
        }
        if (this.billRegistermis != null) {
            paramMap.put("billDate", Constants.DDMMYYYYFORMAT2.format(this.billRegistermis.getEgBillregister().getBilldate()));
            paramMap.put("partyBillNumber", this.billRegistermis.getPartyBillNumber());
            paramMap.put("serviceOrder", this.billRegistermis.getNarration());
            paramMap.put("partyName", this.billRegistermis.getPayto());
            paramMap.put("billNumber", this.billRegistermis.getEgBillregister().getBillnumber());
            BigDecimal billamount = this.billRegistermis.getEgBillregister().getBillamount();
            String amountInFigures = billamount == null ? " " : billamount.setScale(2).toPlainString();
            String amountInWords = billamount == null ? " " : NumberToWord.convertToWord((String)billamount.toPlainString());
            paramMap.put("certificate", this.getText("ejv.report.text", new String[]{amountInFigures, amountInWords}));
        }
        paramMap.put("ulbName", ReportUtil.getCityName());
        return paramMap;
    }

    public Map<String, Object> getAccountDetails(Integer detailtypeid, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{detailtypeid});
        tempMap.put("detailtype", detailtype.getName());
        tempMap.put("detailtypeid", detailtype.getId());
        tempMap.put("detailkeyid", detailkeyid);
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        tempMap.put("detailkey", entityType.getName());
        tempMap.put("detailcode", entityType.getCode());
        return tempMap;
    }

    private String getVoucherNumber() {
        return this.voucher == null || this.voucher.getVoucherNumber() == null ? "" : this.voucher.getVoucherNumber();
    }

    private String getVoucherDescription() {
        return this.voucher == null || this.voucher.getDescription() == null ? "" : this.voucher.getDescription();
    }

    private String getVoucherDate() {
        return this.voucher == null || this.voucher.getVoucherDate() == null ? "" : DateUtils.getDefaultFormattedDate((Date)this.voucher.getVoucherDate());
    }

    void loadInboxHistoryData(List<StateHistory> stateHistory, Map<String, Object> paramMap) throws ApplicationRuntimeException {
        ArrayList<String> history = new ArrayList<String>();
        ArrayList<String> workFlowDate = new ArrayList<String>();
        for (StateHistory historyState : stateHistory) {
            if ("NEW".equalsIgnoreCase(historyState.getValue())) continue;
            history.add(historyState.getSenderName());
            workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(historyState.getLastModifiedDate()));
        }
        for (int i = 0; i < history.size(); ++i) {
            paramMap.put("workFlow_" + i, history.get(i));
            paramMap.put("workFlowDate_" + i, workFlowDate.get(i));
        }
    }
}

