/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.BudgetProposalStatus;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetDetail;
import org.egov.utils.BudgetDetailHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="reportSearch", location="budgetProposalStatusReport-reportSearch.jsp")})
public class BudgetProposalStatusReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 2763108637417639564L;
    private List<BudgetProposalStatus> budgetProposalStatusDeptList = new ArrayList();
    private List<BudgetProposalStatus> budgetProposalStatusFuncList = new ArrayList();
    private List<Department> departmentList = new ArrayList();
    private List<CFunction> functionList = new ArrayList();
    private Department department;
    private String fundType;
    private String budgetType;
    private String mode;
    private BudgetDetailHelper budgetDetailHelper;
    private final String asstBudDesg = "ASSISTANT";
    private final String smBudDesg = "SECTION MANAGER";
    private final String aoBudDesg = "ACCOUNTS OFFICER";
    private final String caoBudDesg = "CHIEF ACCOUNTS OFFICER";
    private final String asstAdminDesg = "ASSISTANT";
    private final String smAdminDesg = "SECTION MANAGER";
    private final String asstBudFunc = "FMU";
    private final String smBudFunc = "FMU";
    private final String aoBudFunc = "FMU";
    private final String caoBudFunc = "FMU";
    private final String asstAdminFunc = "ADMIN";
    private final String smAdminFunc = "ADMIN";
    private final String heavyCheckMark = "\u2714";
    private String finYearId;
    private Date todayDate;
    private StringBuffer statementheading = new StringBuffer();
    private FinancialYearHibernateDAO financialYearDAO;
    protected EisCommonService eisCommonService;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
    }

    @Action(value="/report/budgetProposalStatusReport-beforeSearch")
    public String beforeSearch() {
        this.addDropdownData("departmentList", this.getPersistenceService().findAllBy("from Department order by deptName", new Object[0]));
        return "reportSearch";
    }

    @Action(value="/report/budgetProposalStatusReport-search")
    public String search() {
        this.addDropdownData("departmentList", this.getPersistenceService().findAllBy("from Department order by deptName", new Object[0]));
        if (this.mode.equals("function")) {
            this.functionWise();
        } else {
            this.departmentWise();
        }
        return "reportSearch";
    }

    public void departmentWise() {
        this.departmentList = this.persistenceService.findAllBy("from Department order by id", new Object[0]);
        this.finYearId = this.financialYearDAO.getCurrYearFiscalId();
        CFinancialYear currYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{Long.valueOf(this.finYearId)});
        this.setTodayDate(new Date());
        for (Department dept : this.departmentList) {
            Assignment assignment;
            BudgetProposalStatus budgetProposalStatus = new BudgetProposalStatus();
            budgetProposalStatus.setDepartment(dept);
            BudgetDetail budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget.financialYear.id=? and executingDepartment=? and budget.isbere='RE' and budget.state.value<>'END' and budgetGroup.accountType=?", new Object[]{Long.valueOf(this.finYearId), dept, this.fundType + "_" + this.budgetType});
            if (budgetDetail != null && budgetDetail.getBudget() != null && budgetDetail.getBudget().getState() != null && budgetDetail.getBudget().getState().getOwnerPosition() != null && (assignment = (Assignment)this.persistenceService.find("from Assignment where isPrimary=? and position=?", new Object[]{Character.valueOf('Y'), budgetDetail.getBudget().getState().getOwnerPosition()})) != null) {
                if (this.eisCommonService.isHod(assignment.getId()).booleanValue()) {
                    budgetProposalStatus.setHod("\u2714");
                } else if (assignment.getDesignation().getName().equals("ASSISTANT") && assignment.getFunctionary().getName().equals("FMU")) {
                    budgetProposalStatus.setAsstBud("\u2714");
                } else if (assignment.getDesignation().getName().equals("SECTION MANAGER") && assignment.getFunctionary().getName().equals("FMU")) {
                    budgetProposalStatus.setSmBud("\u2714");
                } else if (assignment.getDesignation().getName().equals("ACCOUNTS OFFICER") && assignment.getFunctionary().getName().equals("FMU")) {
                    budgetProposalStatus.setAoBud("\u2714");
                } else if (assignment.getDesignation().getName().equals("CHIEF ACCOUNTS OFFICER") && assignment.getFunctionary().getName().equals("FMU")) {
                    budgetProposalStatus.setCaoBud("\u2714");
                }
            }
            this.budgetProposalStatusDeptList.add(budgetProposalStatus);
        }
        this.setStatementheading(this.statementheading.append("Budget Proposal Status for Financial Year ").append(currYear.getFinYearRange()));
    }

    public void functionWise() {
        String accountType = this.budgetDetailHelper.accountTypeForFunctionDeptMap(this.budgetType);
        this.functionList = this.persistenceService.findAllBy("select dfm.function from EgDepartmentFunctionMap dfm where dfm.department.id=? and dfm.budgetAccountType=? ", new Object[]{this.department.getId(), accountType});
        this.finYearId = this.financialYearDAO.getCurrYearFiscalId();
        CFinancialYear currYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{Long.valueOf(this.finYearId)});
        Department dept = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.getId()});
        this.setTodayDate(new Date());
        for (CFunction func : this.functionList) {
            Assignment assignment;
            BudgetProposalStatus budgetProposalStatus = new BudgetProposalStatus();
            budgetProposalStatus.setFunction(func);
            BudgetDetail budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget.financialYear.id=? and executingDepartment.id=? and budget.isbere='RE' and budget.state.value<>'END' and state.value<>'END' and function=? and budgetGroup.accountType=?", new Object[]{Long.valueOf(this.finYearId), this.department.getId(), func, this.fundType + "_" + this.budgetType});
            if (budgetDetail != null && budgetDetail.getState() != null && budgetDetail.getState().getOwnerPosition() != null && (assignment = (Assignment)this.persistenceService.find("from Assignment where isPrimary=? and position=?", new Object[]{Character.valueOf('Y'), budgetDetail.getState().getOwnerPosition()})) != null) {
                if (assignment.getDesignation().getName().equals("ASSISTANT") && assignment.getFunctionary().getName().equals("ADMIN")) {
                    budgetProposalStatus.setAsstAdmin("\u2714");
                } else if (assignment.getDesignation().getName().equals("SECTION MANAGER") && assignment.getFunctionary().getName().equals("ADMIN")) {
                    budgetProposalStatus.setSmAdmin("\u2714");
                } else if (this.eisCommonService.isHod(assignment.getId()).booleanValue()) {
                    budgetProposalStatus.setHod("\u2714");
                }
            }
            this.budgetProposalStatusFuncList.add(budgetProposalStatus);
        }
        this.setStatementheading(this.statementheading.append("Budget Detail Proposal Status of Department ").append(dept.getName()).append(" for Financial Year ").append(currYear.getFinYearRange()));
    }

    public List<BudgetProposalStatus> getBudgetProposalStatusDeptList() {
        return this.budgetProposalStatusDeptList;
    }

    public void setBudgetProposalStatusDeptList(List<BudgetProposalStatus> budgetProposalStatusDeptList) {
        this.budgetProposalStatusDeptList = budgetProposalStatusDeptList;
    }

    public List<BudgetProposalStatus> getBudgetProposalStatusFuncList() {
        return this.budgetProposalStatusFuncList;
    }

    public void setBudgetProposalStatusFuncList(List<BudgetProposalStatus> budgetProposalStatusFuncList) {
        this.budgetProposalStatusFuncList = budgetProposalStatusFuncList;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public StringBuffer getStatementheading() {
        return this.statementheading;
    }

    public void setStatementheading(StringBuffer statementheading) {
        this.statementheading = statementheading;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getFundType() {
        return this.fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    public String getBudgetType() {
        return this.budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetDetailHelper) {
        this.budgetDetailHelper = budgetDetailHelper;
    }
}

