/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.egf.model.BudgetReAppReportBean;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetReAppropriation;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="new", location="budgetAppropriationReport-new.jsp"), @Result(name="result", location="budgetAppropriationReport-result.jsp"), @Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetAppropriationReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetAppropriationReport.xls"})})
@ParentPackage(value="egov")
public class BudgetAppropriationReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetAppropriationReportAction.class);
    public static final SimpleDateFormat YYYY_MM_DD_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private Date fromDate = null;
    private Date toDate = null;
    private InputStream inputStream;
    private ReportHelper reportHelper;
    private List<Budget> budgetList = null;
    private BudgetReAppropriation budgetRep = new BudgetReAppropriation();
    private List<BudgetReAppReportBean> budgetAppropriationList = new ArrayList();
    private List<BudgetReAppReportBean> budgetDisplayList = new ArrayList();
    private StringBuffer heading = new StringBuffer();
    private String budgetName;
    private String deptName = "";
    private String fundName = "";
    private String functionName = "";
    private String isFundSelected = "false";
    private String isFunctionSelected = "false";
    private String isDepartmentSelected = "false";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (!this.parameters.containsKey("showDropDown")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
            this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
            this.addDropdownData("fundDropDownList", this.masterDataCache.get("egi-fund"));
            this.budgetList = this.persistenceService.findAllBy("from Budget bud where bud.isActiveBudget=true  and bud.parent is null  order by bud.financialYear.id  desc", new Object[0]);
            this.addDropdownData("budList", this.budgetList);
        }
    }

    public Object getModel() {
        return this.budgetRep;
    }

    @Action(value="/report/budgetAppropriationReport-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/report/budgetAppropriationReport-ajaxGenerateReport")
    public String ajaxGenerateReport() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting ajaxGenerateReport..");
        }
        this.populateReAppropriationData();
        return "result";
    }

    private void prepareFormattedList() {
        int slNo = 1;
        for (int index = 0; index < this.budgetDisplayList.size(); ++index) {
            this.budgetAppropriationList.add(this.budgetDisplayList.get(index));
            ((BudgetReAppReportBean)this.budgetAppropriationList.get(index)).setSlNo(Integer.valueOf(slNo++));
            ((BudgetReAppReportBean)this.budgetAppropriationList.get(index)).setAppDate(Constants.DDMMYYYYFORMAT2.format(((BudgetReAppReportBean)this.budgetDisplayList.get(index)).getAppropriationDate()));
        }
    }

    private void populateReAppropriationData() {
        this.setRelatedEntitesOn();
        Query query = this.generateQuery();
        query.setResultTransformer(Transformers.aliasToBean(BudgetReAppReportBean.class));
        this.budgetDisplayList.addAll(query.list());
    }

    private StringBuffer getQueryString() {
        StringBuffer queryString = new StringBuffer();
        String deptQry = "";
        String fundQry = "";
        String functionQry = "";
        if (this.budgetRep.getBudgetDetail().getExecutingDepartment() != null && this.budgetRep.getBudgetDetail().getExecutingDepartment().getId() != null) {
            deptQry = " and bd.EXECUTING_DEPARTMENT=" + this.budgetRep.getBudgetDetail().getExecutingDepartment().getId();
        }
        if (this.budgetRep.getBudgetDetail().getFund() != null && this.budgetRep.getBudgetDetail().getFund().getId() != null) {
            fundQry = "  and bd.fund=" + this.budgetRep.getBudgetDetail().getFund().getId();
        }
        if (this.budgetRep.getBudgetDetail().getFunction() != null && this.budgetRep.getBudgetDetail().getFunction().getId() != null) {
            functionQry = "  and bd.function=" + this.budgetRep.getBudgetDetail().getFunction().getId();
        }
        queryString = queryString.append("select dept.name as department,funct.name as function ,fnd.name as fund , bg.name  as budgetHead,bmisc.sequence_number as budgetAppropriationNo,bmisc.reappropriation_date as appropriationDate, bd.approvedamount as actualAmount,br.addition_amount as additionAmount,br.deduction_amount as deductionAmount from egf_budget B,egf_budget_reappropriation br,egf_budgetdetail bd,egf_budgetgroup bg,egf_reappropriation_misc bmisc, eg_department dept,fund fnd , function funct  where  bd.id =br.budgetdetail and bd.budgetgroup=bg.id and br.REAPPROPRIATION_MISC=bmisc.id and bd.budget=b.id  and funct.id=bd.function and fnd.id=bd.fund and dept.id= bd.EXECUTING_DEPARTMENT " + deptQry + fundQry + functionQry + " and bmisc.reappropriation_date between '" + YYYY_MM_DD_FORMAT.format(this.getFromDate()) + "' and '" + YYYY_MM_DD_FORMAT.format(this.getToDate()) + "'" + "  and bd.MATERIALIZEDPATH like ''||(select budinn.MATERIALIZEDPATH ||'%' from egf_budget budinn where budinn.id=" + this.budgetRep.getBudgetDetail().getBudget().getId() + ")||''");
        return queryString.append("  order by fnd.id,dept.id,funct.id,bmisc.reappropriation_date");
    }

    private Query generateQuery() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(this.getQueryString().toString()).addScalar("department").addScalar("function").addScalar("fund").addScalar("budgetHead").addScalar("budgetAppropriationNo").addScalar("appropriationDate").addScalar("actualAmount").addScalar("additionAmount", (Type)BigDecimalType.INSTANCE).addScalar("deductionAmount", (Type)BigDecimalType.INSTANCE);
        return query;
    }

    protected void setRelatedEntitesOn() {
        this.heading.append("Budget Addition/Deduction Appropriation ");
        if (!this.getFundName().equals("")) {
            this.heading.append(" in " + this.getFundName());
            this.isFundSelected = "true";
        }
        if (!this.getFunctionName().equals("")) {
            this.heading.append(" under " + this.getFunctionName());
            this.isFunctionSelected = "true";
        }
        if (!this.getDeptName().equals("")) {
            this.heading.append(" For " + this.getDeptName() + "Department");
            this.isDepartmentSelected = "true";
        }
        if (this.getFromDate() != null && this.getToDate() != null) {
            this.heading.append(" From " + this.getFormattedDate(this.getFromDate()) + " To " + this.getFormattedDate(this.getToDate()));
        }
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    @Action(value="/report/budgetAppropriationReport-ajaxGenerateReportXls")
    public String ajaxGenerateReportXls() throws Exception {
        this.populateReAppropriationData();
        this.prepareFormattedList();
        String title = ReportUtil.getCityName();
        String subtitle = "Amount in Rupess";
        JasperPrint jasper = this.reportHelper.generateBudgetAppropriationJasperPrint(this.budgetAppropriationList, title, "Amount in Rupess", this.budgetName, this.getIsFundSelected(), this.getIsFunctionSelected(), this.getIsDepartmentSelected());
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return "XLS";
    }

    @Action(value="/report/budgetAppropriationReport-ajaxGenerateReportPdf")
    public String ajaxGenerateReportPdf() throws Exception {
        this.populateReAppropriationData();
        this.prepareFormattedList();
        String title = ReportUtil.getCityName();
        String subtitle = "Amount in Rupess";
        JasperPrint jasper = this.reportHelper.generateBudgetAppropriationJasperPrint(this.budgetAppropriationList, title, "Amount in Rupess", this.budgetName, this.getIsFundSelected(), this.getIsFunctionSelected(), this.getIsDepartmentSelected());
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return "PDF";
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public StringBuffer getHeading() {
        return this.heading;
    }

    public BudgetReAppropriation getBudgetRep() {
        return this.budgetRep;
    }

    public void setBudgetRep(BudgetReAppropriation budgetRep) {
        this.budgetRep = budgetRep;
    }

    public void setHeading(StringBuffer heading) {
        this.heading = heading;
    }

    public List<BudgetReAppReportBean> getBudgetDisplayList() {
        return this.budgetDisplayList;
    }

    public void setBudgetDisplayList(List<BudgetReAppReportBean> budgetDisplayList) {
        this.budgetDisplayList = budgetDisplayList;
    }

    public List<BudgetReAppReportBean> getBudgetAppropriationList() {
        return this.budgetAppropriationList;
    }

    public void setBudgetAppropriationList(List<BudgetReAppReportBean> budgetAppropriationList) {
        this.budgetAppropriationList = budgetAppropriationList;
    }

    public String getIsFundSelected() {
        return this.isFundSelected;
    }

    public void setIsFundSelected(String isFundSelected) {
        this.isFundSelected = isFundSelected;
    }

    public String getIsFunctionSelected() {
        return this.isFunctionSelected;
    }

    public void setIsFunctionSelected(String isFunctionSelected) {
        this.isFunctionSelected = isFunctionSelected;
    }

    public String getIsDepartmentSelected() {
        return this.isDepartmentSelected;
    }

    public void setIsDepartmentSelected(String isDepartmentSelected) {
        this.isDepartmentSelected = isDepartmentSelected;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getFundName() {
        return this.fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }
}

