/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.pea;

import java.util.ArrayList;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.services.pea.TransferClosingBalanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="transferClosingBalance-new.jsp")})
public class TransferClosingBalanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 7217194113772563333L;
    @Autowired
    @Qualifier(value="financialYearDAO")
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    @Qualifier(value="transferClosingBalanceService")
    private TransferClosingBalanceService transferClosingBalanceService;
    private Long financialYear;
    private CFinancialYear fy;
    private CFinancialYear previousFinancialYear;
    private CFinancialYear nextFinancialYear;

    public StateAware getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("financialYearList", this.financialYearDAO.getAllNotClosedFinancialYears());
    }

    public void prepareNewform() {
    }

    @SkipValidation
    @Action(value="/pea/transferClosingBalance-new")
    public String newform() {
        return "new";
    }

    @SkipValidation
    @ValidationErrorPage(value="new")
    @Action(value="/pea/transferClosingBalance-transfer")
    public String transfer() {
        try {
            this.fy = this.financialYearDAO.getFinancialYearById(this.financialYear);
            try {
                this.previousFinancialYear = this.financialYearDAO.getPreviousFinancialYearByDate(this.fy.getStartingDate());
            }
            catch (ApplicationRuntimeException applicationRuntimeException) {
            }
            catch (Exception e) {
                e.printStackTrace();
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
            try {
                this.nextFinancialYear = this.financialYearDAO.getNextFinancialYearByDate(this.fy.getStartingDate());
            }
            catch (ApplicationRuntimeException e) {
                throw new ValidationException("Next Financial Year does not exist in system.", "Next Financial Year does not exist in system.", new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
            if (this.nextFinancialYear == null || !this.nextFinancialYear.getIsActive().booleanValue()) {
                throw new ValidationException("Next Financial Year is not active", "Next Financial Year is not active", new String[0]);
            }
            this.transferClosingBalanceService.transfer(this.financialYear, this.fy, this.nextFinancialYear);
            this.addActionMessage("Transfer Closing Balance Successful");
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "new";
    }

    private boolean validatePreviousFinancialYear() {
        return this.previousFinancialYear != null ? this.previousFinancialYear.getIsClosed() : true;
    }

    public Long getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(Long financialYear) {
        this.financialYear = financialYear;
    }

    public CFinancialYear getFy() {
        return this.fy;
    }

    public void setFy(CFinancialYear fy) {
        this.fy = fy;
    }

    public CFinancialYear getPreviousFinancialYear() {
        return this.previousFinancialYear;
    }

    public void setPreviousFinancialYear(CFinancialYear previousFinancialYear) {
        this.previousFinancialYear = previousFinancialYear;
    }

    public CFinancialYear getNextFinancialYear() {
        return this.nextFinancialYear;
    }

    public void setNextFinancialYear(CFinancialYear nextFinancialYear) {
        this.nextFinancialYear = nextFinancialYear;
    }
}

