/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.commons.VoucherSearchUtil;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.payment.Paymentheader;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="reversalVouchers", location="paymentReversal-reversalVouchers.jsp")})
public class PaymentReversalAction
extends BaseVoucherAction {
    private static final long serialVersionUID = -5576463753189498214L;
    private VoucherSearchUtil voucherSearchUtil;
    private Date fromDate;
    private Date toDate;
    private List<CVoucherHeader> voucherHeaderList = new ArrayList();
    private boolean close = false;
    private String message = "";
    private EgovCommon egovCommon;
    Bankaccount bankAccount;
    private List<Paymentheader> paymentHeaderList = new ArrayList();
    private Paymentheader paymentHeader = new Paymentheader();
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public void prepare() {
        super.prepare();
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        if ("".equalsIgnoreCase(statusExclude) || statusExclude == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("voucher.excludestatus.not.set", "voucher.excludestatus.not.set")));
        }
        this.addDropdownData("bankList", this.egovCommon.getBankBranchForActiveBanks());
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("voucherNameList", this.persistenceService.findAllBy("select distinct vh.name from CVoucherHeader vh where vh.type='Payment' and status not in (" + statusExclude + ") order by vh.name", new Object[0]));
    }

    public PaymentReversalAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
    }

    public String reverse() {
        if (this.paymentHeader.getId() != null) {
            this.paymentHeader = (Paymentheader)this.persistenceService.find("from Paymentheader where id=?", new Object[]{this.paymentHeader.getId()});
            this.voucherHeader = this.paymentHeader.getVoucherheader();
        }
        return "reverse";
    }

    public String saveReverse() {
        if (this.voucherHeader.getId() != null) {
            this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{this.voucherHeader.getId()});
        }
        this.saveReverse(this.voucherHeader.getName(), "Receipt");
        this.message = this.getText("transaction.success") + this.voucherHeader.getVoucherNumber();
        return "reverse";
    }

    public String saveReverseAndClose() {
        this.close = true;
        return this.saveReverse();
    }

    @Action(value="/payment/paymentReversal-vouchersForReversal")
    public String vouchersForReversal() {
        return "reversalVouchers";
    }

    public String searchVouchersForReversal() throws ApplicationException, ParseException {
        this.voucherHeader.setType("Payment");
        this.voucherHeaderList = this.voucherSearchUtil.search(this.voucherHeader, this.getFromDate(), this.getToDate(), "reverse");
        String query = this.formQuery(this.voucherHeaderList);
        if (this.voucherHeaderList != null && this.voucherHeaderList.size() > 0) {
            this.paymentHeaderList = this.bankAccount != null && this.bankAccount.getId() != null ? this.persistenceService.findAllBy(query + " and bankaccount.id=?", new Object[]{this.bankAccount.getId()}) : this.persistenceService.findAllBy(query, new Object[0]);
        }
        if (this.paymentHeaderList.size() == 0) {
            this.message = this.getText("no.records");
        }
        return "reversalVouchers";
    }

    private String formQuery(List<CVoucherHeader> voucherHeaderList) {
        StringBuffer query = new StringBuffer("from Paymentheader where voucherheader.id in (");
        for (CVoucherHeader voucherHeader : voucherHeaderList) {
            query = query.append(voucherHeader.getId()).append(",");
        }
        if (voucherHeaderList.size() > 0) {
            return query.substring(0, query.length() - 1).concat(" ) ");
        }
        return query.toString().concat(" ) ");
    }

    public void setVoucherSearchUtil(VoucherSearchUtil voucherSearchUtil) {
        this.voucherSearchUtil = voucherSearchUtil;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public List<CVoucherHeader> getVoucherHeaderList() {
        return this.voucherHeaderList;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public String getMessage() {
        return this.message;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public List<Paymentheader> getPaymentHeaderList() {
        return this.paymentHeaderList;
    }

    public Paymentheader getPaymentHeader() {
        return this.paymentHeader;
    }

    public CVoucherHeader getVoucherHeader() {
        return super.getVoucherHeader();
    }
}

