/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.payment.Paymentheader;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=OutstandingPaymentReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=OutstandingPaymentReport.xls"})})
@ParentPackage(value="egov")
public class OutstandingPaymentAction
extends BaseFormAction {
    private static final long serialVersionUID = 3437296032021248608L;
    private static final Logger LOGGER = Logger.getLogger(OutstandingPaymentAction.class);
    private List<Paymentheader> paymentHeaderList = new ArrayList();
    private final Map<Long, String> voucherHeaderMap = new HashMap();
    private Date asOnDate = new Date();
    private BigDecimal bankBalance = BigDecimal.ZERO;
    private EgovCommon egovCommon;
    private BigDecimal currentReceiptsAmount = BigDecimal.ZERO;
    private BigDecimal runningBalance = BigDecimal.ZERO;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    private Bankaccount bankAccount;
    private String voucherStatusKey = "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE";
    private final String jasperpath = "/reports/templates/OutstandingPaymentReport.jasper";
    private ReportHelper reportHelper;
    private InputStream inputStream;
    private String selectedVhs;
    private Long[] selectdVhs;
    private BigDecimal rBalance = BigDecimal.ZERO;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public String execute() throws Exception {
        return "form";
    }

    public Long[] getSelectdVhs() {
        return this.selectdVhs;
    }

    public void setSelectdVhs(Long[] selectdVhs) {
        this.selectdVhs = selectdVhs;
    }

    public void prepare() {
        super.prepare();
        if (!this.parameters.containsKey("skipPrepare")) {
            this.addDropdownData("bankList", Collections.EMPTY_LIST);
            this.addDropdownData("accNumList", Collections.EMPTY_LIST);
            this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        }
    }

    @Action(value="/payment/outstandingPayment-ajaxLoadPaymentHeader")
    public String ajaxLoadPaymentHeader() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting ajaxLoadPaymentHeader...");
        }
        if (this.parameters.containsKey("bankAccount.id") && ((String[])this.parameters.get("bankAccount.id"))[0] != null) {
            if (this.parameters.containsKey("asOnDate") && ((String[])this.parameters.get("asOnDate"))[0] != null) {
                try {
                    this.setAsOnDate(Constants.DDMMYYYYFORMAT2.parse(((String[])this.parameters.get("asOnDate"))[0]));
                }
                catch (ParseException e) {
                    throw new ValidationException("Invalid date", "Invalid date", new String[0]);
                }
            }
            if (this.parameters.containsKey("asOnDate") && ((String[])this.parameters.get("asOnDate"))[0] != null) {
                this.setSelectedVhs("selectedVhs");
            }
            Integer id = Integer.valueOf(((String[])this.parameters.get("bankAccount.id"))[0]);
            this.bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{id});
            List appConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE");
            if (appConfig == null || appConfig.isEmpty()) {
                throw new ValidationException("", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE is not defined in AppConfig", new String[0]);
            }
            String appConfigValue = "";
            boolean condtitionalAppConfigIsPresent = false;
            String designationName = null;
            String functionaryName = null;
            String stateWithoutCondition = "";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Beginning app config check...");
            }
            for (AppConfigValues app : appConfig) {
                appConfigValue = app.getValue();
                if (appConfigValue.contains(",")) {
                    condtitionalAppConfigIsPresent = true;
                    String[] array = appConfigValue.split(",");
                    if (array.length != 2) {
                        throw new ValidationException("", "VOUCHER_STATUS_TO_CHECK_BANK_BALANCE is invalid", new String[0]);
                    }
                    designationName = array[0];
                    functionaryName = array[1];
                    continue;
                }
                stateWithoutCondition = appConfigValue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Ending app config check...");
            }
            StringBuffer query = new StringBuffer();
            query.append("from Paymentheader where voucherheader.voucherDate<=? and voucherheader.status in ( " + FinancialConstants.CREATEDVOUCHERSTATUS + "," + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + ") and bankaccount.id=? and" + " state.type='Paymentheader'");
            if (condtitionalAppConfigIsPresent) {
                String ownerIdList = this.getCommaSeperatedListForDesignationNameAndFunctionaryName(designationName, functionaryName);
                query.append(" and state.owner in (" + ownerIdList + ") order by state.createdDate desc ");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("In condtitionalAppConfigIsPresent - qry" + query.toString()));
                }
                this.paymentHeaderList.addAll(this.persistenceService.findPageBy(query.toString(), Integer.valueOf(1), Integer.valueOf(100), new Object[]{this.getAsOnDate(), id}).getList());
            } else {
                query.append(" and state.value like '" + stateWithoutCondition + "' order by state.createdDate desc ");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("In ELSE - qry" + query.toString()));
                }
                this.paymentHeaderList.addAll(this.persistenceService.findPageBy(query.toString(), Integer.valueOf(1), Integer.valueOf(100), new Object[]{this.getAsOnDate(), id}).getList());
            }
            this.bankBalance = this.egovCommon.getBankBalanceAvailableforPayment(this.getAsOnDate(), id);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Ending ajaxLoadPaymentHeader...");
        }
        return "results";
    }

    private String getCommaSeperatedListForDesignationNameAndFunctionaryName(String designationName, String functionaryName) {
        String qrySQL = "select pos_id from eg_eis_employeeinfo empinfo, eg_designation desg, functionary func    where empinfo.functionary_id=func.id and empinfo.DESIGNATIONID=desg.DESIGNATIONID  and empinfo.isactive=true    and desg.DESIGNATION_NAME like '" + designationName + "' and func.NAME like '" + functionaryName + "' ";
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qrySQL);
        List result = query.list();
        if (result == null || result.isEmpty()) {
            throw new ValidationException("", "No employee with functionary -" + functionaryName + " and designation - " + designationName, new String[0]);
        }
        StringBuffer returnListSB = new StringBuffer();
        String commaSeperatedList = "";
        for (BigDecimal posId : result) {
            returnListSB.append(posId.toString() + ",");
        }
        commaSeperatedList = returnListSB.substring(0, returnListSB.length() - 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Commo seperated  list - " + commaSeperatedList));
        }
        return commaSeperatedList;
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    @Action(value="/payment/outstandingPayment-exportPdf")
    public String exportPdf() throws JRException, IOException {
        List dataSource = this.generateReportData();
        this.setInputStream(this.reportHelper.exportPdf(this.getInputStream(), "/reports/templates/OutstandingPaymentReport.jasper", this.getParamMap(), dataSource));
        return "PDF";
    }

    public void setPaymentHeaderList(List<Paymentheader> paymentHeaderList) {
        this.paymentHeaderList = paymentHeaderList;
    }

    @Action(value="/payment/outstandingPayment-exportXls")
    public String exportXls() throws JRException, IOException {
        List dataSource = this.generateReportData();
        this.setInputStream(this.reportHelper.exportXls(this.getInputStream(), "/reports/templates/OutstandingPaymentReport.jasper", this.getParamMap(), dataSource));
        return "XLS";
    }

    private List<Object> generateReportData() {
        String[] splitVh = null;
        if (this.parameters.containsKey("selectedVhs") && ((String[])this.parameters.get("selectedVhs"))[0] != null) {
            String[] vh_ids = (String[])this.parameters.get("selectedVhs");
            splitVh = vh_ids[0].split(",");
            for (int i = 0; i < splitVh.length; ++i) {
                this.voucherHeaderMap.put(Long.parseLong(splitVh[i]), "Selected");
            }
        }
        this.ajaxLoadPaymentHeader();
        ArrayList<Object> dataSource = new ArrayList<Object>();
        for (Paymentheader row : this.paymentHeaderList) {
            String chkSelected = (String)this.voucherHeaderMap.get(row.getVoucherheader().getId());
            if ("Selected".equals(chkSelected)) {
                row.setIsSelected("Selected");
            } else {
                row.setIsSelected(null);
            }
            dataSource.add(row);
        }
        return dataSource;
    }

    public String getSelectedVhs() {
        return this.selectedVhs;
    }

    public BigDecimal getRunningBalance() {
        return this.runningBalance;
    }

    public void setRunningBalance(BigDecimal runningBalance) {
        this.runningBalance = runningBalance;
    }

    public void setSelectedVhs(String selectedVhs) {
        this.selectedVhs = selectedVhs;
    }

    public BigDecimal getRBalance() {
        return this.rBalance;
    }

    public void setRBalance(BigDecimal balance) {
        this.rBalance = balance;
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ulbName", this.getUlbName());
        this.bankAccount.getBankbranch().getBank().getName().concat("-").concat(this.bankAccount.getBankbranch().getBranchname()).concat("-").concat(this.bankAccount.getAccountnumber());
        String heading = "Outstanding Payment Report as on " + Constants.DDMMYYYYFORMAT2.format(this.asOnDate);
        String bankDetail = "Bank Balance Details as on " + Constants.DDMMYYYYFORMAT2.format(this.asOnDate);
        paramMap.put("heading", heading);
        paramMap.put("bankDetail", bankDetail);
        paramMap.put("bankName", this.bankAccount.getBankbranch().getBank().getName().toString());
        paramMap.put("bankBranchName", this.bankAccount.getBankbranch().getBranchname());
        paramMap.put("bankAccountNumber", this.bankAccount.getAccountnumber().toString());
        paramMap.put("chartOfAccount", this.bankAccount.getChartofaccounts().getGlcode());
        paramMap.put("currentBalance", this.bankBalance.toString());
        paramMap.put("runningBalance", this.runningBalance.toString());
        return paramMap;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public List<Paymentheader> getPaymentHeaderList() {
        return this.paymentHeaderList;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public BigDecimal getBankBalance() {
        return this.bankBalance;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public Object getModel() {
        return null;
    }

    public void setVoucherStatusKey(String voucherStatus) {
        this.voucherStatusKey = voucherStatus;
    }

    public String getVoucherStatusKey() {
        return this.voucherStatusKey;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setCurrentReceiptsAmount(BigDecimal currentReceiptsAmount) {
        this.currentReceiptsAmount = currentReceiptsAmount;
    }

    public BigDecimal getCurrentReceiptsAmount() {
        return this.currentReceiptsAmount;
    }

    public void setBankAccount(Bankaccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Bankaccount getBankAccount() {
        return this.bankAccount;
    }
}

