/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import com.exilant.exility.common.TaskFailedException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.DishonorCheque;
import org.egov.model.instrument.DishonorChequeDetails;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentOtherDetails;
import org.egov.model.recoveries.Recovery;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.egov.services.instrument.DishonorChequeService;
import org.egov.services.instrument.FinancialIntegrationService;
import org.egov.services.instrument.InstrumentService;
import org.egov.utils.Constants;
import org.egov.utils.VoucherHelper;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Results(value={@Result(name="viewMessage", location="dishonorChequeWorkflow-viewMessage.jsp"), @Result(name="view", location="dishonorChequeWorkflow-view.jsp")})
public class DishonorChequeWorkflowAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DishonorChequeWorkflowAction.class);
    public PersistenceService<InstrumentHeader, Long> instrumentHeaderService;
    private PersistenceService persistenceService;
    private EisUtilService eisService;
    private DishonorChequeService dishonorChequeService;
    private SimpleWorkflowService<DishonorCheque> dishonorChequeWorkflowService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    private InstrumentService instrumentService;
    private static final String RECEIPT = "Receipt";
    private static final String JOURNAL_VOUCHER = "Journal Voucher";
    private EisCommonService eisCommonService;
    private boolean isRestrictedtoOneFunctionCenter;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private CVoucherHeader paymentVoucher;
    private static final String APPROVE = "approve";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
    private VoucherHelper voucherHelper;
    private List<String> validActions = Collections.emptyList();
    protected Long dishonourChqId;
    private DishonorCheque dishonorChequeView = new DishonorCheque();
    private PersistenceService<CChartOfAccounts, Long> chartOfAccountService;
    private List<Department> approverDepartmentList = new ArrayList();
    private CVoucherHeader bankChargesReversalVoucher;
    private String actionName;
    private String approverDepartment;
    private Integer approverPositionId;
    private String approverDesignation;
    private String mode = null;
    private List desgnationList;

    public DishonorChequeWorkflowAction() {
        this.addRelatedEntity("instrumentHeader", InstrumentHeader.class);
        this.addRelatedEntity("originalVoucherHeader", CVoucherHeader.class);
        this.addRelatedEntity("status", EgwStatus.class);
        this.addRelatedEntity("bankchargeGlCodeId", CChartOfAccounts.class);
        this.addRelatedEntity("modifiedBy", User.class);
        this.addRelatedEntity("createdBy", User.class);
        this.addRelatedEntity("state", State.class);
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("approverList", Collections.EMPTY_LIST);
    }

    public Object getModel() {
        return this.dishonorChequeView;
    }

    @SkipValidation
    @Action(value="/payment/dishonorChequeWorkflow-view")
    public String view() {
        this.mode = APPROVE;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(">>>>>>" + this.dishonourChqId));
        }
        this.dishonorChequeView = (DishonorCheque)this.dishonorChequeService.find(" from DishonorCheque where id=?", new Object[]{this.dishonourChqId});
        for (DishonorChequeDetails dc : this.dishonorChequeView.getDetails()) {
            if (dc.getFunctionId() == null) continue;
            CFunction function = (CFunction)this.persistenceService.find("from CFunction  where id=? ", new Object[]{dc.getFunctionId().longValue()});
            dc.setFunction(function);
        }
        this.populateWorkflowEntities();
        return "view";
    }

    public List<String> getValidActions() {
        List validActionsList = Collections.emptyList();
        String tempValidAction = null;
        if (null == this.dishonorChequeView || this.dishonorChequeView.getId() == null) {
            this.validActions = Arrays.asList("forward");
        } else {
            String validAction = (String)this.persistenceService.find("select validActions from WorkFlowMatrix where objectType=? and currentState =?", new Object[]{this.dishonorChequeView.getStateType(), this.dishonorChequeView.getCurrentState().getValue()});
            if (null != validAction) {
                StringTokenizer strToken = new StringTokenizer(validAction, ",");
                tempValidAction = null;
                validActionsList = new ArrayList();
                while (strToken.hasMoreElements()) {
                    tempValidAction = strToken.nextToken();
                    validActionsList.add(tempValidAction);
                }
            }
        }
        this.validActions = validActionsList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(">>>>>>" + this.validActions));
        }
        return this.validActions;
    }

    public String getNextAction() {
        String nextActionTemp = "";
        if (null != this.dishonorChequeView && null != this.dishonorChequeView.getId()) {
            nextActionTemp = (String)this.persistenceService.find("select nextAction from WorkFlowMatrix where objectType=?  and currentState=?", new Object[]{this.dishonorChequeView.getStateType(), this.dishonorChequeView.getCurrentState().getValue()});
        }
        return nextActionTemp;
    }

    public void populateWorkflowEntities() {
        this.approverDepartmentList = this.persistenceService.findAllBy("from Department order by deptName", new Object[0]);
        this.eisCommonService.getEmployeeByUserId(ApplicationThreadLocals.getUserId());
        this.desgnationList = this.persistenceService.findAllBy("from Designation where name=?", new Object[]{"ACCOUNTS OFFICER"});
        this.addDropdownData("approverDepartmentList", this.approverDepartmentList);
        this.addDropdownData("desgnationList", this.desgnationList);
    }

    private String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    private CVoucherHeader createVoucherHeader(String type, String reason) throws ParseException {
        CVoucherHeader voucherHeader = new CVoucherHeader();
        voucherHeader.setType(type);
        voucherHeader.setVoucherDate(this.dishonorChequeView.getTransactionDate());
        voucherHeader.setDescription(reason);
        return voucherHeader;
    }

    public CVoucherHeader createBankReversalVoucher() throws ParseException, HibernateException, TaskFailedException, SQLException {
        CVoucherHeader BankVoucher = null;
        String narration = "Reversal Bank Charges Entry for receipt number " + this.dishonorChequeView.getOriginalVoucherHeader().getVoucherNumber() + ", Cheque Number " + this.dishonorChequeView.getInstrumentHeader().getInstrumentNumber() + " Cheque Dated :" + this.getFormattedDate(this.dishonorChequeView.getInstrumentHeader().getInstrumentDate());
        BankVoucher = this.createVoucherHeader("Payment", this.dishonorChequeView.getBankreason());
        if (null != this.dishonorChequeView.getBankreason() || !this.dishonorChequeView.getBankreason().equals("")) {
            BankVoucher.setDescription(narration);
        } else {
            BankVoucher.setDescription(this.dishonorChequeView.getBankreason());
        }
        InstrumentHeader instrument = (InstrumentHeader)this.instrumentService.addToInstrument(this.createInstruments("1", this.dishonorChequeView.getBankChargesAmt(), "banktobank")).get(0);
        this.instrumentService.updateInstrumentOtherDetailsStatus(instrument, this.dishonorChequeView.getTransactionDate(), BigDecimal.ZERO);
        BankVoucher.setName("Bank Entry");
        HashMap headerDetails = this.createHeaderAndMisDetails(BankVoucher);
        BankVoucher = this.createVoucher(BankVoucher, headerDetails, "Bank Entry");
        this.updateInstrumentVoucherReference(Arrays.asList(instrument), BankVoucher);
        return BankVoucher;
    }

    private void updateInstrumentDetailsAfterDishonor() {
        InstrumentHeader instHeader = (InstrumentHeader)this.instrumentHeaderService.findByNamedQuery("INSTRUMENTHEADERBYID", new Object[]{this.dishonorChequeView.getInstrumentHeader().getId()});
        instHeader.setStatusId(this.getDishonoredStatus());
        this.instrumentHeaderService.persist((Object)instHeader);
        String instOtherDetailUpdate = "Update InstrumentOtherDetails iod set iod.dishonorBankRefNo=:refNo, iod.modifiedBy.id=:modifiedby , iod.modifiedDate=:modifiedDate , iod.instrumentStatusDate=:InstrumentUpdatedDate where  iod.instrumentHeaderId=:instrumentHeaderId ";
        Query instOtherDetailUpdateQuery = this.persistenceService.getSession().createQuery("Update InstrumentOtherDetails iod set iod.dishonorBankRefNo=:refNo, iod.modifiedBy.id=:modifiedby , iod.modifiedDate=:modifiedDate , iod.instrumentStatusDate=:InstrumentUpdatedDate where  iod.instrumentHeaderId=:instrumentHeaderId ".toString());
        instOtherDetailUpdateQuery.setString("refNo", this.dishonorChequeView.getBankReferenceNumber());
        instOtherDetailUpdateQuery.setLong("modifiedby", (long)ApplicationThreadLocals.getUserId().intValue());
        instOtherDetailUpdateQuery.setDate("modifiedDate", new Date());
        instOtherDetailUpdateQuery.setDate("InstrumentUpdatedDate", this.dishonorChequeView.getTransactionDate());
        instOtherDetailUpdateQuery.setLong("instrumentHeaderId", this.dishonorChequeView.getInstrumentHeader().getId().longValue());
        instOtherDetailUpdateQuery.executeUpdate();
    }

    @Action(value="/payment/dishonorChequeWorkflow-save")
    public String save() throws ParseException {
        LOGGER.info((Object)(">>>>>>>>>>" + this.getActionName()));
        String returnValue = "view";
        String actionNm = this.getActionName();
        Integer userId = null;
        if (actionNm.equalsIgnoreCase(APPROVE)) {
            userId = this.parameters.get("approverUserId") != null ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]).intValue() : ApplicationThreadLocals.getUserId().intValue();
            this.createReversalVoucher();
            this.updateInstrumentDetailsAfterDishonor();
            this.addActionMessage("Cheque Dishonored Succesfully");
            this.mode = "print";
            this.dishonorChequeView.setBankchargesVoucherHeader(this.bankChargesReversalVoucher);
            this.dishonorChequeView.setReversalVoucherHeader(this.paymentVoucher);
            this.startChequeWorkflow(this.dishonorChequeView, actionNm, null);
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
            FinancialIntegrationService financialService = (FinancialIntegrationService)wac.getBean("financialIntegrationService");
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)this.dishonorChequeView.getInstrumentHeader());
                    LOGGER.debug((Object)"Calling integrated system");
                }
                if (null != financialService) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Calling integrated service is " + financialService.getClass().getSimpleName()));
                    }
                } else {
                    LOGGER.error((Object)"Unable to find the Integrated modules service  with name financialIntegrationService in  Web Applicaton context. ");
                    throw new ApplicationRuntimeException("Integrated modules service not found");
                }
                financialService.updateCollectionsOnInstrumentDishonor(this.dishonorChequeView.getInstrumentHeader().getId());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Completed  integrated system update.");
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("Error in updating integrated system  " + e.getMessage()), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e.getMessage()));
                throw new ValidationException(errors);
            }
            returnValue = "viewMessage";
        } else if (actionNm.equalsIgnoreCase("forward")) {
            userId = this.parameters.get("approverUserId") != null ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]).intValue() : ApplicationThreadLocals.getUserId().intValue();
            this.startChequeWorkflow(this.dishonorChequeView, actionNm, null != this.parameters.get("approverComments") ? ((String[])this.parameters.get("approverComments"))[0] : null);
            EmployeeView nextUser = (EmployeeView)this.persistenceService.find("from EmployeeView where position.id=?", null);
            this.addActionMessage(" Cheque is forwared successfully  " + nextUser.getName());
            returnValue = "viewMessage";
        } else if (actionNm.equalsIgnoreCase("cancel")) {
            this.startChequeWorkflow(this.dishonorChequeView, actionNm, null != this.parameters.get("approverComments") ? ((String[])this.parameters.get("approverComments"))[0] : null);
            InstrumentHeader instHeader = (InstrumentHeader)this.instrumentHeaderService.findByNamedQuery("INSTRUMENTHEADERBYID", new Object[]{this.dishonorChequeView.getInstrumentHeader().getId()});
            instHeader.setStatusId(this.getDepositedStatus());
            this.instrumentHeaderService.persist((Object)instHeader);
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
            FinancialIntegrationService financialService = (FinancialIntegrationService)wac.getBean("financialIntegrationService");
            if (null != financialService) {
                financialService.updateSourceInstrumentVoucher("INSTRUMENT_DISHONOR_CANCEL", this.dishonorChequeView.getInstrumentHeader().getId());
            }
            this.addActionMessage(this.getText("Dishonor Workflow Cancelled"));
            returnValue = "viewMessage";
        } else if (actionNm.equalsIgnoreCase("reject")) {
            InstrumentOtherDetails iob = (InstrumentOtherDetails)this.persistenceService.find("from InstrumentOtherDetails where instrumentHeaderId.id=?", new Object[]{this.dishonorChequeView.getInstrumentHeader().getId()});
            User approverUser = (User)this.persistenceService.find("from User where id=?", new Object[]{iob.getPayinslipId().getCreatedBy().getId()});
            this.eisService.getPrimaryPositionForUser(approverUser.getId(), new Date());
            this.startChequeWorkflow(this.dishonorChequeView, actionNm, null != this.parameters.get("approverComments") ? ((String[])this.parameters.get("approverComments"))[0] : null);
            this.addActionMessage(this.getText("Cheque is rejected Sent back to " + approverUser.getName()));
            returnValue = "viewMessage";
        }
        return returnValue;
    }

    private String createReversalVoucher() throws ParseException {
        String appConfigKey = "GJV_FOR_RCPT_CHQ_DISHON";
        AppConfigValues appConfigValues = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "GJV_FOR_RCPT_CHQ_DISHON").get(0);
        appConfigValues.getValue();
        CVoucherHeader voucherHeader = null;
        if (this.dishonorChequeView.getBankChargesAmt().compareTo(BigDecimal.ZERO) > 0) {
            try {
                this.bankChargesReversalVoucher = this.createBankReversalVoucher();
            }
            catch (HibernateException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e.getMessage()));
                throw new ValidationException(errors);
            }
            catch (TaskFailedException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e.getMessage()));
                throw new ValidationException(errors);
            }
            catch (SQLException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e.getMessage()));
                throw new ValidationException(errors);
            }
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getType() && this.dishonorChequeView.getOriginalVoucherHeader().getType().equalsIgnoreCase(RECEIPT) || JOURNAL_VOUCHER.equalsIgnoreCase(this.dishonorChequeView.getOriginalVoucherHeader().getType())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"CREATING RECEIPT Reversal  >>>>>>>>>>");
            }
            voucherHeader = this.createVoucherHeader(JOURNAL_VOUCHER, this.dishonorChequeView.getInstrumentDishonorReason());
            if (null != this.dishonorChequeView.getInstrumentDishonorReason() || !this.dishonorChequeView.getInstrumentDishonorReason().equals("")) {
                String narration = "Reversal Voucher Entry for receipt number " + this.dishonorChequeView.getOriginalVoucherHeader().getVoucherNumber() + ", Cheque Number " + this.dishonorChequeView.getInstrumentHeader().getInstrumentNumber() + " Cheque Dated :" + this.getFormattedDate(this.dishonorChequeView.getInstrumentHeader().getInstrumentDate());
                voucherHeader.setDescription(narration);
            } else {
                voucherHeader.setDescription(this.dishonorChequeView.getInstrumentDishonorReason());
            }
            List instrument = this.instrumentService.addToInstrument(this.createInstruments("1", this.getTotalAmount(), "banktobank"));
            ((InstrumentHeader)instrument.get(0)).setStatusId(this.getReconciledStatus());
            this.instrumentHeaderService.persist(instrument.get(0));
            this.instrumentService.updateInstrumentOtherDetailsStatus((InstrumentHeader)instrument.get(0), this.dishonorChequeView.getTransactionDate(), this.getTotalAmount());
            voucherHeader.setName("Receipt Reversal");
            HashMap headerDetails = this.createHeaderAndMisDetails(voucherHeader);
            this.paymentVoucher = this.createVoucher(voucherHeader, headerDetails, "Receipt Reversal");
            this.instrumentService.addToBankReconcilation(voucherHeader, (InstrumentHeader)instrument.get(0));
            this.updateInstrumentVoucherReference(instrument, this.paymentVoucher);
        }
        return "view";
    }

    private EgwStatus getReconciledStatus() {
        return this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Reconciled");
    }

    private BigDecimal getTotalAmount() {
        BigDecimal total = new BigDecimal(0);
        List tempdetails = new ArrayList();
        this.dishonorChequeView.setDetails(new HashSet(tempdetails));
        tempdetails = this.persistenceService.findAllBy(" from DishonorChequeDetails where header.id=? ", new Object[]{this.dishonorChequeView.getId()});
        for (DishonorChequeDetails dishonordetails : tempdetails) {
            if (null != dishonordetails.getDebitAmt() && dishonordetails.getDebitAmt().compareTo(BigDecimal.ZERO) > 0) {
                total = total.add(dishonordetails.getDebitAmt());
                continue;
            }
            total = total.add(null != dishonordetails.getCreditAmount() ? dishonordetails.getCreditAmount() : BigDecimal.ZERO);
        }
        return total;
    }

    void updateInstrumentVoucherReference(List<InstrumentHeader> instrumentList, CVoucherHeader voucherHeader) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
        iMap.put("Instrument header", instrumentList.get(0));
        iMap.put("Voucher header", voucherHeader);
        iList.add(iMap);
        this.instrumentService.updateInstrumentVoucherReference(iList);
    }

    private EgwStatus getDepositedStatus() {
        return this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Deposited");
    }

    private EgwStatus getDishonoredStatus() {
        return this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Dishonored");
    }

    private List<HashMap<String, Object>> populateSubledgerDetails(List<HashMap<String, Object>> accountdetails) {
        LOGGER.debug((Object)"Populating Subledger");
        ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> subledgerMap = new HashMap<String, Object>();
        BigDecimal value = BigDecimal.ZERO;
        String reversalGlCodesStr = "";
        List slDetailsCredit = new ArrayList();
        List slDetailsDebit = new ArrayList();
        StringBuffer reversalGlCodes = new StringBuffer();
        List tempdetails = this.persistenceService.findAllBy("from DishonorChequeDetails where header.id=? ", new Object[]{this.dishonorChequeView.getId()});
        for (DishonorChequeDetails dishonorChequeDetails : tempdetails) {
            reversalGlCodes = reversalGlCodes.append(dishonorChequeDetails.getGlcodeId().getGlcode()).append(',');
        }
        reversalGlCodesStr = reversalGlCodes.substring(0, reversalGlCodes.length() - 1);
        new StringBuffer();
        slDetailsCredit = this.persistenceService.findAllBy("select distinct gl.glcode, gd.detailTypeId.id, gd.detailKeyId,SUM(gd.amount) from CGeneralLedger gl, CGeneralLedgerDetail gd where gl.voucherHeaderId in(" + this.dishonorChequeView.getOriginalVoucherHeader().getId() + ")" + " and gl.id = gd.generalLedgerId.id and gl.debitAmount >0 and gl.glcode in (" + reversalGlCodesStr + ") group by gl.glcode, gd.detailTypeId.id, gd.detailKeyId", new Object[0]);
        slDetailsDebit = this.persistenceService.findAllBy("select distinct gl.glcode, gd.detailTypeId.id, gd.detailKeyId,SUM(gd.amount) from CGeneralLedger gl, CGeneralLedgerDetail gd where gl.voucherHeaderId in(" + this.dishonorChequeView.getOriginalVoucherHeader().getId() + ")" + " and gl.id = gd.generalLedgerId.id and gl.creditAmount >0 and gl.glcode in (" + reversalGlCodesStr + ") group by gl.glcode, gd.detailTypeId.id, gd.detailKeyId", new Object[0]);
        LOGGER.debug((Object)("Debit Side Subledger list size is " + slDetailsDebit.size()));
        LOGGER.debug((Object)("Credit Side Subledger list size is " + slDetailsCredit.size()));
        for (HashMap hashMap : accountdetails) {
            List tdslist;
            if (null != slDetailsDebit && slDetailsDebit.size() > 0) {
                for (Object[] obj : slDetailsDebit) {
                    LOGGER.info((Object)(">>>>>>" + obj[0]));
                    subledgerMap = new HashMap();
                    if (!hashMap.get("glcode").equals(obj[0])) continue;
                    value = BigDecimal.ZERO;
                    subledgerMap.put("glcode", obj[0].toString());
                    subledgerMap.put("detailtypeid", obj[1].toString());
                    subledgerMap.put("detailkeyid", obj[2].toString());
                    value = new BigDecimal(hashMap.get("debitamount").toString());
                    if (value.compareTo(BigDecimal.ZERO) > 0) {
                        subledgerMap.put("debitamount", hashMap.get("debitamount"));
                    } else {
                        subledgerMap.put("creditamount", hashMap.get("creditamount"));
                        tdslist = new ArrayList();
                        tdslist = this.persistenceService.findAllBy(" from Recovery where chartofaccounts.glcode=" + obj[0].toString(), new Object[0]);
                        if (!tdslist.isEmpty()) {
                            for (Recovery tds : tdslist) {
                                if (!tds.getType().equals(obj[0].toString())) continue;
                                subledgerMap.put("tdsId", tds.getId());
                            }
                        } else {
                            throw new ApplicationRuntimeException("DishonoredChequeAction |  populatesubledgerDetails | not able to find either debit or credit amount");
                        }
                    }
                    subledgerDetails.add(subledgerMap);
                }
            }
            if (null == slDetailsCredit || slDetailsCredit.size() <= 0) continue;
            for (Object[] obj : slDetailsCredit) {
                LOGGER.info((Object)(">>>>>>" + obj[0]));
                subledgerMap = new HashMap();
                if (!hashMap.get("glcode").equals(obj[0])) continue;
                value = BigDecimal.ZERO;
                subledgerMap.put("glcode", obj[0].toString());
                subledgerMap.put("detailtypeid", obj[1].toString());
                subledgerMap.put("detailkeyid", obj[2].toString());
                value = new BigDecimal(hashMap.get("debitamount").toString());
                if (value.compareTo(BigDecimal.ZERO) > 0) {
                    subledgerMap.put("debitamount", hashMap.get("debitamount"));
                } else {
                    subledgerMap.put("creditamount", hashMap.get("creditamount"));
                    tdslist = new ArrayList();
                    tdslist = this.persistenceService.findAllBy(" from Recovery where chartofaccounts.glcode=" + obj[0].toString(), new Object[0]);
                    if (!tdslist.isEmpty()) {
                        for (Recovery tds : tdslist) {
                            if (!tds.getType().equals(obj[0].toString())) continue;
                            subledgerMap.put("tdsId", tds.getId());
                        }
                    } else {
                        throw new ApplicationRuntimeException("DishonoredChequeAction |  populatesubledgerDetails | not able to find either debit or credit amount");
                    }
                }
                subledgerDetails.add(subledgerMap);
            }
        }
        return subledgerDetails;
    }

    private CVoucherHeader createVoucher(CVoucherHeader voucher, HashMap<String, Object> headerDetails, String voucherType) {
        CVoucherHeader voucherHeader = null;
        List accountdetails = null;
        ArrayList subledgerDetails = null;
        try {
            headerDetails.put("sourcepath", "");
            if ("Receipt Reversal".equalsIgnoreCase(voucherType)) {
                accountdetails = this.populateAccountDetails();
                subledgerDetails = this.populateSubledgerDetails(accountdetails);
            } else if ("Bank Entry".equalsIgnoreCase(voucherType)) {
                accountdetails = this.populateBankChargesAccountDetails();
                subledgerDetails = new ArrayList();
            }
            voucherHeader = this.createVoucher.createVoucher(headerDetails, accountdetails, (List)subledgerDetails);
            voucherHeader.getVouchermis().setSourcePath("");
            voucherHeader.setOriginalvcId(null);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return voucherHeader;
    }

    private List<HashMap<String, Object>> populateAccountDetails() {
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        List tempdetails = this.persistenceService.findAllBy("from DishonorChequeDetails where header.id=? ", new Object[]{this.dishonorChequeView.getId()});
        BigDecimal totalAmountDbt = BigDecimal.ZERO;
        BigDecimal totalAmountCrd = BigDecimal.ZERO;
        CFunction glFunctionObj = new CFunction();
        if (RECEIPT.equals(this.dishonorChequeView.getOriginalVoucherHeader().getType()) || JOURNAL_VOUCHER.equals(this.dishonorChequeView.getOriginalVoucherHeader().getType())) {
            Integer funct;
            String code;
            BigDecimal amount;
            for (DishonorChequeDetails dishonordetails : tempdetails) {
                if (null == dishonordetails.getDebitAmt()) continue;
                amount = dishonordetails.getDebitAmt();
                code = dishonordetails.getGlcodeId().getGlcode();
                funct = dishonordetails.getFunctionId();
                if (null != funct && funct > 0) {
                    glFunctionObj = (CFunction)this.persistenceService.find(" from CFunction fn where id=?", new Object[]{funct.longValue()});
                }
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    accountdetails.add(this.populateDetailMap(code, BigDecimal.ZERO, amount, glFunctionObj.getCode()));
                }
                totalAmountDbt = totalAmountDbt.add(amount);
            }
            for (DishonorChequeDetails dishonordetails : tempdetails) {
                if (null == dishonordetails.getCreditAmount()) continue;
                amount = dishonordetails.getCreditAmount();
                code = dishonordetails.getGlcodeId().getGlcode();
                funct = dishonordetails.getFunctionId();
                if (null != funct && funct > 0) {
                    glFunctionObj = (CFunction)this.persistenceService.find(" from CFunction fn where id=?", new Object[]{funct.longValue()});
                }
                if (null == amount || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                accountdetails.add(this.populateDetailMap(code, BigDecimal.ZERO, amount, glFunctionObj.getCode()));
                totalAmountCrd = totalAmountCrd.add(amount);
            }
            accountdetails.add(this.populateDetailMap(this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getChartofaccounts().getGlcode(), totalAmountDbt.subtract(totalAmountCrd), BigDecimal.ZERO));
        } else {
            for (DishonorChequeDetails dishonordetails : tempdetails) {
                if (null == dishonordetails.getDebitAmt()) continue;
                BigDecimal amount = dishonordetails.getDebitAmt();
                String code = dishonordetails.getGlcodeId().getGlcode();
                accountdetails.add(this.populateDetailMap(code, BigDecimal.ZERO, amount));
                totalAmountDbt = totalAmountDbt.add(amount);
            }
            accountdetails.add(this.populateDetailMap(this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getChartofaccounts().getGlcode(), BigDecimal.ZERO, totalAmountDbt));
        }
        return accountdetails;
    }

    List<HashMap<String, Object>> populateBankChargesAccountDetails() {
        String code;
        BigDecimal amount;
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        BigDecimal totalAmountDbt = BigDecimal.ZERO;
        BigDecimal totalAmountCrd = BigDecimal.ZERO;
        new CFunction();
        if (null != this.dishonorChequeView.getBankChargesAmt() && this.dishonorChequeView.getBankChargesAmt().compareTo(BigDecimal.ZERO) > 0) {
            amount = this.dishonorChequeView.getBankChargesAmt();
            code = this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getChartofaccounts().getGlcode();
            accountdetails.add(this.populateDetailMap(code, amount, BigDecimal.ZERO));
            totalAmountDbt = totalAmountDbt.add(amount);
        }
        if (null != this.dishonorChequeView.getBankChargesAmt() && null != this.dishonorChequeView.getBankchargeGlCodeId()) {
            amount = this.dishonorChequeView.getBankChargesAmt();
            code = this.dishonorChequeView.getBankchargeGlCodeId().getGlcode();
            accountdetails.add(this.populateDetailMap(code, BigDecimal.ZERO, amount));
            totalAmountCrd = totalAmountCrd.add(amount);
        }
        return accountdetails;
    }

    HashMap<String, Object> populateDetailMap(String glCode, BigDecimal creditAmount, BigDecimal debitAmount) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("creditamount", creditAmount.toString());
        detailMap.put("debitamount", debitAmount.toString());
        detailMap.put("glcode", glCode);
        return detailMap;
    }

    HashMap<String, Object> populateDetailMap(String glCode, BigDecimal creditAmount, BigDecimal debitAmount, String function) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("creditamount", creditAmount.toString());
        detailMap.put("debitamount", debitAmount.toString());
        detailMap.put("glcode", glCode);
        detailMap.put("functioncode", function);
        return detailMap;
    }

    public void startChequeWorkflow(DishonorCheque dishonorCheque, String workFlowAction, String approverComments) {
        if (null == dishonorCheque.getState()) {
            Position pos = this.eisService.getPrimaryPositionForUser(null, new Date());
            dishonorCheque.start().withOwner(pos).withComments("DishonorCheque Work flow started");
            this.dishonorChequeWorkflowService.transition("forward", (StateAware)dishonorCheque, "Created by SM");
        }
        if (null != workFlowAction && !"".equals(workFlowAction)) {
            String comments = null == approverComments || "".equals(approverComments.trim()) ? "" : approverComments;
            this.dishonorChequeWorkflowService.transition(workFlowAction.toLowerCase(), (StateAware)dishonorCheque, comments);
        }
    }

    HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        headerdetails.put("originalvoucher", String.valueOf(this.dishonorChequeView.getOriginalVoucherHeader().getId()));
        if (voucherHeader.getType().equalsIgnoreCase("Bank Entry")) {
            headerdetails.put("status", 0);
        } else {
            headerdetails.put("status", 0);
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getDepartmentid()) {
            headerdetails.put("departmentcode", ((Department)this.persistenceService.find("from Department where id=?", new Object[]{this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getDepartmentid().getId()})).getCode());
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getFundId()) {
            headerdetails.put("fundcode", ((Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.dishonorChequeView.getOriginalVoucherHeader().getFundId().getId()})).getCode());
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getFundsource()) {
            headerdetails.put("fundsourcecode", ((Fundsource)this.persistenceService.find("from Fundsource where id=?", new Object[]{this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getFundsource().getId()})).getCode());
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getFunction()) {
            headerdetails.put("functioncode", ((CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getFunction()})).getCode());
        }
        if (null != this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getDivisionid()) {
            headerdetails.put("divisionid", this.dishonorChequeView.getOriginalVoucherHeader().getVouchermis().getDivisionid().getId());
        }
        return headerdetails;
    }

    List<Map<String, Object>> createInstruments(String isPayCheque, BigDecimal instrumentAmount, String instrumentType) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        iMap.put("Transaction number", this.dishonorChequeView.getInstrumentHeader().getInstrumentNumber());
        iMap.put("Transaction date", this.dishonorChequeView.getTransactionDate());
        iMap.put("Instrument amount", null != instrumentAmount ? instrumentAmount.doubleValue() : 0.0);
        iMap.put("Instrument type", instrumentType);
        iMap.put("Bank code", this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", this.dishonorChequeView.getInstrumentHeader().getBankAccountId().getId());
        iMap.put("Is pay cheque", isPayCheque);
        iList.add(iMap);
        return iList;
    }

    public boolean isRestrictedtoOneFunctionCenter() {
        return this.isRestrictedtoOneFunctionCenter;
    }

    public void setRestrictedtoOneFunctionCenter(boolean isRestrictedtoOneFunctionCenter) {
        this.isRestrictedtoOneFunctionCenter = isRestrictedtoOneFunctionCenter;
    }

    public PersistenceService<InstrumentHeader, Long> getInstrumentHeaderService() {
        return this.instrumentHeaderService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public EisUtilService getEisService() {
        return this.eisService;
    }

    public PersistenceService<CChartOfAccounts, Long> getChartOfAccountService() {
        return this.chartOfAccountService;
    }

    public void setInstrumentHeaderService(PersistenceService<InstrumentHeader, Long> instrumentHeaderService) {
        this.instrumentHeaderService = instrumentHeaderService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public void setChartOfAccountService(PersistenceService<CChartOfAccounts, Long> chartOfAccountService) {
        this.chartOfAccountService = chartOfAccountService;
    }

    public void setDishonorChequeService(DishonorChequeService dishonorChequeService) {
        this.dishonorChequeService = dishonorChequeService;
    }

    public VoucherHelper getVoucherHelper() {
        return this.voucherHelper;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public Long getDishonourChqId() {
        return this.dishonourChqId;
    }

    public DishonorCheque getDishonorChequeView() {
        return this.dishonorChequeView;
    }

    public void setDishonourChqId(Long dishonourChqId) {
        this.dishonourChqId = dishonourChqId;
    }

    public void setDishonorChequeView(DishonorCheque dishonorChequeView) {
        this.dishonorChequeView = dishonorChequeView;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public String getActionName() {
        return this.actionName;
    }

    public InstrumentService getInstrumentService() {
        return this.instrumentService;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public CVoucherHeader getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(CVoucherHeader paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
    }

    public CVoucherHeader getBankChargesReversalVoucher() {
        return this.bankChargesReversalVoucher;
    }

    public void setBankChargesReversalVoucher(CVoucherHeader bankChargesReversalVoucher) {
        this.bankChargesReversalVoucher = bankChargesReversalVoucher;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getApproverDepartment() {
        return this.approverDepartment;
    }

    public List<Department> getApproverDepartmentList() {
        return this.approverDepartmentList;
    }

    public void setApproverDepartmentList(List<Department> approverDepartmentList) {
        this.approverDepartmentList = approverDepartmentList;
    }

    public void setApproverDepartment(String approverDepartment) {
        this.approverDepartment = approverDepartment;
    }

    public Integer getApproverPositionId() {
        return this.approverPositionId;
    }

    public void setApproverPositionId(Integer approverPositionId) {
        this.approverPositionId = approverPositionId;
    }

    public String getApproverDesignation() {
        return this.approverDesignation;
    }

    public void setApproverDesignation(String approverDesignation) {
        this.approverDesignation = approverDesignation;
    }

    public SimpleWorkflowService<DishonorCheque> getDishonorChequeWorkflowService() {
        return this.dishonorChequeWorkflowService;
    }

    public void setDishonorChequeWorkflowService(SimpleWorkflowService<DishonorCheque> dishonorChequeWorkflowService) {
        this.dishonorChequeWorkflowService = dishonorChequeWorkflowService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

