/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.SubSchemeHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.masters.SubSchemeService;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="subScheme-new.jsp"), @Result(name="search", location="subScheme-search.jsp"), @Result(name="fieldUniqueCheck", location="subScheme-fieldUniqueCheck.jsp"), @Result(name="view", location="subScheme-view.jsp")})
public class SubSchemeAction
extends BaseFormAction {
    private static final long serialVersionUID = -3712472100095261379L;
    private SubScheme subScheme = new SubScheme();
    @Autowired
    SubSchemeHibernateDAO subSchemeHibernateDAO;
    private boolean isactive = false;
    private boolean clearValues = false;
    private int fundId;
    private static final String REQUIRED = "required";
    private int schemeId;
    private Long subSchemeId;
    private List<SubScheme> subSchemeList;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private String showMode;
    private SubSchemeService subSchemeService;
    public static final String UNIQUECHECKFIELD = "fieldUniqueCheck";
    private boolean uniqueCode = false;
    private String code;
    private String name;
    @Autowired
    private EgovMasterDataCaching egovMasterDataCaching;

    public Object getModel() {
        return this.subScheme;
    }

    public SubSchemeAction() {
        this.addRelatedEntity("scheme", Scheme.class, "name");
        this.addRelatedEntity("department", Department.class, "name");
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isactive=true order by name", new Object[0]));
    }

    @SkipValidation
    @Action(value="/masters/subScheme-newForm")
    public String newForm() {
        this.showMode = "new";
        return "new";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="scheme", message="", key="required"), @RequiredFieldValidator(fieldName="code", message="", key="required"), @RequiredFieldValidator(fieldName="name", message="", key="required"), @RequiredFieldValidator(fieldName="validfrom", message="", key="required"), @RequiredFieldValidator(fieldName="validto", message="", key="required")})
    @ValidationErrorPage(value="new")
    @Action(value="/masters/subScheme-create")
    public String save() {
        if (this.isactive) {
            this.subScheme.setIsactive(Boolean.valueOf(true));
        } else {
            this.subScheme.setIsactive(Boolean.valueOf(false));
        }
        this.subScheme.setCreatedDate(new Date());
        this.subScheme.setCreatedBy(this.getLoggedInUser());
        this.subScheme.setLastmodifieddate(new Date());
        try {
            this.subSchemeService.persist((Object)this.subScheme);
            this.subSchemeService.getSession().flush();
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (ConstraintViolationException e) {
            this.addActionError(this.getText("duplicate.subscheme"));
            return "new";
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        this.clearValues = true;
        this.addActionMessage(this.getText("subscheme.saved.successfully"));
        this.showMode = "new";
        EgovMasterDataCaching.removeFromCache((String)" egi-subscheme");
        return VIEW;
    }

    @Action(value="/masters/subScheme-edit")
    public String edit() {
        if (this.subSchemeId != null) {
            this.subScheme.setId(Integer.valueOf(this.subSchemeId.intValue()));
        }
        if (this.isactive) {
            this.subScheme.setIsactive(Boolean.valueOf(true));
        } else {
            this.subScheme.setIsactive(Boolean.valueOf(false));
        }
        this.subScheme.setLastModifiedBy(this.getLoggedInUser());
        this.subScheme.setLastmodifieddate(new Date());
        try {
            this.subSchemeService.persist((Object)this.subScheme);
            this.subSchemeService.getSession().flush();
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (ConstraintViolationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("duplicate.subscheme", "duplicate.subscheme")));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        this.clearValues = true;
        this.addActionMessage(this.getText("subscheme.modified.successfully"));
        this.showMode = "";
        EgovMasterDataCaching.removeFromCache((String)"egi-subscheme");
        return VIEW;
    }

    @SkipValidation
    @Action(value="/masters/subScheme-beforeEdit")
    public String beforeEdit() {
        this.subScheme = (SubScheme)this.persistenceService.find("from SubScheme where id=?", new Object[]{this.subScheme.getId()});
        if (this.subScheme != null && this.subScheme.getIsactive().booleanValue()) {
            this.isactive = true;
        }
        return "new";
    }

    @SkipValidation
    @Action(value="/masters/subScheme-beforeSearch")
    public String beforeSearch() {
        this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isActive=true order by name", new Object[0]));
        this.dropdownData.put("schemeList", Collections.emptyList());
        this.dropdownData.put("subSchemeList", Collections.emptyList());
        this.fundId = 0;
        return SEARCH;
    }

    @SkipValidation
    @Action(value="/masters/subScheme-search")
    public String search() {
        StringBuffer query = new StringBuffer(500);
        new StringBuffer(100);
        query.append("From SubScheme s ");
        if (this.fundId != 0) {
            query.append("where s.scheme.fund.id= " + this.fundId);
            if (this.schemeId != -1) {
                query.append("and  s.scheme.id= " + this.schemeId);
                if (this.subScheme.getId() != -1) {
                    query.append("and s.id=" + this.subScheme.getId());
                }
            }
        }
        this.loadDropDowns();
        this.subSchemeList = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        return SEARCH;
    }

    @SkipValidation
    @Action(value="/masters/subScheme-viewSubScheme")
    public String viewSubScheme() {
        this.subScheme = (SubScheme)this.persistenceService.find("from SubScheme where id=?", new Object[]{this.subScheme.getId()});
        this.showMode = VIEW;
        return VIEW;
    }

    private void loadDropDowns() {
        this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isActive=true order by name", new Object[0]));
        StringBuffer st = new StringBuffer();
        if (this.fundId != 0) {
            st.append("from Scheme where isactive=true and fund.id=");
            st.append(this.fundId);
            this.dropdownData.put("schemeList", this.persistenceService.findAllBy(st.toString(), new Object[0]));
            st.delete(0, st.length() - 1);
        } else {
            this.dropdownData.put("schemeList", Collections.emptyList());
        }
        if (this.schemeId != -1) {
            this.dropdownData.put("subSchemeList", this.persistenceService.findAllBy("from SubScheme where isactive=true and scheme.id=?", new Object[]{this.schemeId}));
        } else {
            this.dropdownData.put("subSchemeList", Collections.emptyList());
        }
    }

    @SkipValidation
    public boolean getCheckField() {
        SubScheme subScheme_validate = null;
        boolean isDuplicate = false;
        if (this.uniqueCode) {
            if (!this.subScheme.getCode().equals("") && this.subScheme.getId() != null) {
                subScheme_validate = (SubScheme)this.persistenceService.find("from SubScheme where code=? and id!=?", new Object[]{this.subScheme.getCode().toLowerCase(), this.subScheme.getId()});
            } else if (!this.subScheme.getCode().equals("")) {
                subScheme_validate = (SubScheme)this.persistenceService.find("from SubScheme where code=?", new Object[]{this.subScheme.getCode().toLowerCase()});
            }
            this.uniqueCode = false;
        } else if (!this.subScheme.getName().equals("") && this.subScheme.getId() != null) {
            subScheme_validate = (SubScheme)this.persistenceService.find("from SubScheme where name=? and id!=?", new Object[]{this.subScheme.getName().toLowerCase(), this.subScheme.getId()});
        } else if (!this.subScheme.getName().equals("")) {
            subScheme_validate = (SubScheme)this.persistenceService.find("from SubScheme where name=?", new Object[]{this.subScheme.getName().toLowerCase()});
        }
        if (subScheme_validate != null) {
            isDuplicate = true;
        }
        return isDuplicate;
    }

    @SkipValidation
    @Action(value="/masters/subScheme-codeUniqueCheck")
    public String codeUniqueCheck() {
        this.uniqueCode = true;
        return UNIQUECHECKFIELD;
    }

    @SkipValidation
    @Action(value="/masters/subScheme-nameUniqueCheck")
    public String nameUniqueCheck() {
        return UNIQUECHECKFIELD;
    }

    private User getLoggedInUser() {
        return (User)this.persistenceService.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
    }

    public void setFundId(int fundId) {
        this.fundId = fundId;
    }

    public int getFundId() {
        return this.fundId;
    }

    public void setSchemeId(int schemeId) {
        this.schemeId = schemeId;
    }

    public int getSchemeId() {
        return this.schemeId;
    }

    public void setSubSchemeList(List<SubScheme> subSchemeList) {
        this.subSchemeList = subSchemeList;
    }

    public List<SubScheme> getSubSchemeList() {
        return this.subSchemeList;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public SubSchemeService getSubSchemeService() {
        return this.subSchemeService;
    }

    public void setSubSchemeService(SubSchemeService subSchemeService) {
        this.subSchemeService = subSchemeService;
    }

    public void setSubScheme(SubScheme subScheme) {
        this.subScheme = subScheme;
    }

    public SubScheme getSubScheme() {
        return this.subScheme;
    }

    public boolean isIsactive() {
        return this.isactive;
    }

    public void setIsactive(boolean isactive) {
        this.isactive = isactive;
    }

    public void setClearValues(boolean clearValues) {
        this.clearValues = clearValues;
    }

    public boolean isClearValues() {
        return this.clearValues;
    }

    public Long getSubSchemeId() {
        return this.subSchemeId;
    }

    public void setSubSchemeId(Long subSchemeId) {
        this.subSchemeId = subSchemeId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

