/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.opensymphony.xwork2.validator.annotations.Validation;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgPartytype;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name="new", location="partyType-new.jsp"), @Result(name="search", location="partyType-search.jsp"), @Result(name="edit", location="partyType-edit.jsp")})
public class PartyTypeAction
extends BaseFormAction {
    private static final long serialVersionUID = -1076021355881784888L;
    private EgPartytype partyType = new EgPartytype();
    private boolean close = false;
    private String showMode = "view";
    private List<EgPartytype> partyTypeList;
    private List<EgPartytype> partySearchList;
    private EgPartytype parentParty = null;
    protected static final String REQUIRED = "required";
    private String success = "";
    protected static final Logger LOGGER = Logger.getLogger(PartyTypeAction.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    @SkipValidation
    public Object getModel() {
        return this.partyType;
    }

    @SkipValidation
    public void prepare() {
        super.prepare();
        this.dropdownData.put("partyTypeList", this.persistenceService.findAllBy("from EgPartytype order by code", new Object[0]));
    }

    @SkipValidation
    @Action(value="/masters/partyType-newform")
    public String newform() {
        return "new";
    }

    @SkipValidation
    @ValidationErrorPage(value="new")
    @Action(value="/masters/partyType-create")
    public String create() {
        this.validatemandatoryFields();
        try {
            if (this.partyType.getEgPartytype() != null && this.partyType.getEgPartytype().getId() != null) {
                this.parentParty = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.partyType.getEgPartytype().getId()});
            }
            this.partyType.setEgPartytype(this.parentParty);
            this.partyType.setCode(this.partyType.getCode());
            this.partyType.setDescription(this.partyType.getDescription());
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeMaster");
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeAllChild");
            EgovMasterDataCaching.removeFromCache((String)"egi-typeOfWorkParent");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodesForLiability");
            EgovMasterDataCaching.removeFromCache((String)"egi-tds");
            EgovMasterDataCaching.removeFromCache((String)"egi-tdsType");
            EgovMasterDataCaching.removeFromCache((String)"egi-recovery");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwTypeOfWork");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwSubTypeOfWork");
            this.persistenceService.persist((Object)this.partyType);
            this.persistenceService.getSession().flush();
            this.persistenceService.getSession().clear();
            this.setSuccess("yes");
        }
        catch (Exception e) {
            this.setSuccess("no");
            LOGGER.error((Object)"Exception occurred in PartyTypeAction-create ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception occurred in PartyTypeAction-create ", (Throwable)e);
        }
        return "new";
    }

    @SkipValidation
    @ValidationErrorPage(value="edit")
    @Action(value="/masters/partyType-edit")
    public String edit() {
        this.validatemandatoryFields();
        try {
            EgPartytype partyOld = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.partyType.getId()});
            partyOld.setCode(this.partyType.getCode());
            partyOld.setDescription(this.partyType.getDescription());
            if (this.partyType.getEgPartytype() != null && this.partyType.getEgPartytype().getId() != null) {
                this.parentParty = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.partyType.getEgPartytype().getId()});
            }
            partyOld.setEgPartytype(this.parentParty);
            this.setPartyType(partyOld);
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeMaster");
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeAllChild");
            EgovMasterDataCaching.removeFromCache((String)"egi-typeOfWorkParent");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodesForLiability");
            EgovMasterDataCaching.removeFromCache((String)"egi-tds");
            EgovMasterDataCaching.removeFromCache((String)"egi-tdsType");
            EgovMasterDataCaching.removeFromCache((String)"egi-recovery");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwTypeOfWork");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwSubTypeOfWork");
            this.persistenceService.persist((Object)this.partyType);
            this.setSuccess("yes");
        }
        catch (Exception e) {
            this.setSuccess("no");
            LOGGER.error((Object)"Exception occurred in PartyTypeAction-edit ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception occurred in PartyTypeAction-edit ", (Throwable)e);
        }
        this.showMode = "edit";
        return "edit";
    }

    @SkipValidation
    @Action(value="/masters/partyType-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/partyType-search")
    public String search() {
        StringBuffer query = new StringBuffer();
        query.append("From EgPartytype where createdBy is not null ");
        if (!this.partyType.getCode().isEmpty()) {
            query.append(" and upper(code) like upper('%" + this.partyType.getCode() + "%')");
        }
        if (!this.partyType.getDescription().isEmpty()) {
            query.append(" and upper(description) like upper('%" + this.partyType.getDescription() + "%')");
        }
        if (this.partyType.getEgPartytype() != null && this.partyType.getEgPartytype().getId() != null) {
            query.append(" and egPartytype =" + this.partyType.getEgPartytype());
        }
        this.partySearchList = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/partyType-beforeModify")
    public String beforeModify() {
        this.partyType = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.partyType.getId()});
        return "edit";
    }

    private void validatemandatoryFields() {
        if (this.partyType.getCode() == null || "".equals(this.partyType.getCode())) {
            throw new ValidationException(Arrays.asList(new ValidationError("party.code.mandatory", this.getText("mandatory.party.code"))));
        }
        if (this.partyType.getDescription() == null || "".equals(this.partyType.getDescription())) {
            throw new ValidationException(Arrays.asList(new ValidationError("party.desc.mandatory", this.getText("mandatory.party.description"))));
        }
        if (this.partyType.getCode() != null && this.getCheckCode()) {
            throw new ValidationException(Arrays.asList(new ValidationError("party.code.unique", this.getText("party.code.unique"))));
        }
    }

    @SkipValidation
    public boolean getCheckCode() {
        EgPartytype pt = null;
        boolean isDuplicate = false;
        if (!this.partyType.getCode().equals("") && this.partyType.getId() != null) {
            pt = (EgPartytype)this.persistenceService.find("from EgPartytype where code=? and id!=?", new Object[]{this.partyType.getCode(), this.partyType.getId()});
        } else if (!this.partyType.getCode().equals("")) {
            pt = (EgPartytype)this.persistenceService.find("from EgPartytype where code=?", new Object[]{this.partyType.getCode()});
        }
        if (pt != null) {
            isDuplicate = true;
        }
        return isDuplicate;
    }

    public EgPartytype getPartyType() {
        return this.partyType;
    }

    public void setPartyType(EgPartytype partyType) {
        this.partyType = partyType;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public List<EgPartytype> getPartyTypeList() {
        return this.partyTypeList;
    }

    public void setPartyTypeList(List<EgPartytype> partyTypeList) {
        this.partyTypeList = partyTypeList;
    }

    public List<EgPartytype> getPartySearchList() {
        return this.partySearchList;
    }

    public void setPartySearchList(List<EgPartytype> partySearchList) {
        this.partySearchList = partySearchList;
    }

    public String getSuccess() {
        return this.success;
    }

    public void setSuccess(String success) {
        this.success = success;
    }
}

