/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bankaccount;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.egf.masters.model.FundingAgency;
import org.egov.egf.masters.model.LoanGrantBean;
import org.egov.egf.masters.model.LoanGrantDetail;
import org.egov.egf.masters.model.LoanGrantHeader;
import org.egov.egf.masters.model.LoanGrantReceiptDetail;
import org.egov.egf.masters.model.SchemeBankaccount;
import org.egov.egf.masters.model.SubSchemeProject;
import org.egov.egf.web.actions.masters.loangrant.LoanGrantBaseAction;
import org.egov.egf.web.actions.voucher.CommonAction;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="new", location="loanGrant-new.jsp"), @Result(name="search", location="loanGrant-search.jsp"), @Result(name="new", location="loanGrant-new.jsp"), @Result(name="edit", location="loanGrant-edit.jsp"), @Result(name="codeUniqueCheckCode", location="loanGrant-codeUniqueCheckCode.jsp"), @Result(name="view", location="loanGrant-view.jsp")})
public class LoanGrantAction
extends LoanGrantBaseAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -5126017690888146473L;
    private static final String VIEW = "view";
    private LoanGrantHeader loanGrantHeader = new LoanGrantHeader();
    private List<LoanGrantDetail> sanctionedAmountLGDetails;
    private List<LoanGrantDetail> unsanctionedAmountLGDetails;
    private List<LoanGrantDetail> revisedAmountLGDetails;
    private List<FundingAgency> fundingAgencyList;
    private List<LoanGrantBean> projectCodeList;
    private Integer bankaccount;
    private Integer bank_branch;
    private CommonAction common;
    private String mode;
    private Map<String, String> bankBranchMap;
    private List<LoanGrantHeader> loanGrantHeaderList;
    private Query query;
    private static final String SANCTIONEDTYPE = "sanctioned";
    private static final String UNSANCTIONEDTYPE = "unsanctioned";
    private static final String REVISEDTYPE = "revised";

    public void prepare() {
        super.prepare();
    }

    public void prepareNewForm() {
        this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
    }

    public void prepareBeforeEdit() {
        this.loanGrantHeader = (LoanGrantHeader)this.persistenceService.find("from LoanGrantHeader where id=?", new Object[]{((LoanGrantHeader)this.getModel()).getId()});
        SchemeBankaccount account = (SchemeBankaccount)this.persistenceService.find("from SchemeBankaccount where subScheme=?", new Object[]{this.loanGrantHeader.getSubScheme()});
        this.setFundId(this.loanGrantHeader.getSubScheme().getScheme().getFund().getId());
        this.setBank_branch(account.getBankAccount().getBankbranch().getId());
        List accNumList = this.persistenceService.findAllBy("from Bankaccount ba where ba.bankbranch.id=? and fund.id=? and isactive=true order by ba.chartofaccounts.glcode", new Object[]{this.bank_branch, this.fundId});
        this.setBankaccount(Integer.valueOf(account.getBankAccount().getId().intValue()));
        this.addDropdownData("bankaccountList", accNumList);
        List branchList = this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund.id=? ) and br.isactive=true order by br.bank.name asc", new Object[]{this.fundId});
        this.addDropdownData("bankbranchList", branchList);
        this.fundingAgencyList = new ArrayList();
        this.fundingAgencyList.addAll(this.persistenceService.findAllBy(" from FundingAgency where isActive=true order by name", new Object[0]));
        this.schemeId = this.loanGrantHeader.getSubScheme().getScheme().getId();
        this.subSchemeId = this.loanGrantHeader.getSubScheme().getId();
        this.projectCodeList = new ArrayList();
        String strQuery = "select pc.id as id , pc.code as code, pc.name as name from egw_projectcode pc, egf_subscheme_project sp where pc.id= sp.projectcodeid and sp.subschemeid=" + this.subSchemeId;
        this.query = this.persistenceService.getSession().createSQLQuery(strQuery).addScalar("id", (Type)LongType.INSTANCE).addScalar("code").addScalar("name").setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        this.projectCodeList = this.query.list();
        List lgDetailList = this.loanGrantHeader.getDetailList();
        if (lgDetailList != null && lgDetailList.size() != 0) {
            boolean revisedDetailsPresent = false;
            boolean unsanctionedDetailsPresent = false;
            boolean sanctionedDetailsPresent = false;
            for (LoanGrantDetail lgDetail : lgDetailList) {
                if (lgDetail.getPatternType().equalsIgnoreCase(SANCTIONEDTYPE)) {
                    sanctionedDetailsPresent = true;
                }
                if (lgDetail.getPatternType().equalsIgnoreCase(UNSANCTIONEDTYPE)) {
                    unsanctionedDetailsPresent = true;
                }
                if (!lgDetail.getPatternType().equalsIgnoreCase(REVISEDTYPE)) continue;
                revisedDetailsPresent = true;
            }
            if (!sanctionedDetailsPresent) {
                this.sanctionedAmountLGDetails = new ArrayList();
                this.sanctionedAmountLGDetails.add(new LoanGrantDetail());
            }
            if (!unsanctionedDetailsPresent) {
                this.unsanctionedAmountLGDetails = new ArrayList();
                this.unsanctionedAmountLGDetails.add(new LoanGrantDetail());
            }
            if (!revisedDetailsPresent) {
                this.revisedAmountLGDetails = new ArrayList();
                this.revisedAmountLGDetails.add(new LoanGrantDetail());
            }
        }
    }

    public void prepareBeforeView() {
        this.prepareBeforeEdit();
    }

    public Object getModel() {
        return this.loanGrantHeader;
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-search")
    public String search() {
        this.loanGrantHeaderList = new ArrayList();
        if (this.schemeId != null && this.subSchemeId == null) {
            this.loanGrantHeaderList.addAll(this.persistenceService.findAllBy("from LoanGrantHeader where subScheme.scheme.id=? order by subScheme.name ", new Object[]{this.schemeId}));
        }
        if (this.schemeId != null && this.subSchemeId != null) {
            this.loanGrantHeaderList.addAll(this.persistenceService.findAllBy("from LoanGrantHeader where subScheme.id=? order by subScheme.name ", new Object[]{this.subSchemeId}));
        }
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-beforeView")
    public String beforeView() {
        this.beforeEdit();
        return VIEW;
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-beforeEdit")
    public String beforeEdit() {
        return "edit";
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-newForm")
    public String newForm() {
        this.projectCodeList = new ArrayList();
        this.projectCodeList.add(new LoanGrantBean());
        this.setBankBranchMap(new HashMap());
        this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
        this.sanctionedAmountLGDetails = new ArrayList();
        this.sanctionedAmountLGDetails.add(new LoanGrantDetail());
        this.unsanctionedAmountLGDetails = new ArrayList();
        this.unsanctionedAmountLGDetails.add(new LoanGrantDetail());
        this.revisedAmountLGDetails = new ArrayList();
        this.revisedAmountLGDetails.add(new LoanGrantDetail());
        this.fundingAgencyList = new ArrayList();
        this.fundingAgencyList.addAll(this.persistenceService.findAllBy(" from FundingAgency where isActive=true order by name", new Object[0]));
        this.loanGrantHeader.getReceiptList().add(new LoanGrantReceiptDetail());
        return "new";
    }

    @SkipValidation
    @Action(value="/masters/loanGrant-codeUniqueCheckCode")
    public String codeUniqueCheckCode() {
        return "codeUniqueCheckCode";
    }

    @SkipValidation
    public boolean getCodeCheckCode() {
        LoanGrantHeader header = null;
        boolean isDuplicate = false;
        if (this.subSchemeId != null && this.loanGrantHeader.getId() != null) {
            header = (LoanGrantHeader)this.persistenceService.find("from LoanGrantHeader where subScheme.id=? and id!=?", new Object[]{this.subSchemeId, this.loanGrantHeader.getId()});
        } else if (this.subSchemeId != null) {
            header = (LoanGrantHeader)this.persistenceService.find("from LoanGrantHeader where subScheme.id=?", new Object[]{this.subSchemeId});
        }
        if (header != null) {
            isDuplicate = true;
        }
        return isDuplicate;
    }

    public void validate() {
        if (this.schemeId == null || this.schemeId == -1) {
            this.addFieldError("schemeId", this.getText("masters.loangrant.scheme.mandatory"));
        }
        if (this.subSchemeId == null || this.subSchemeId == -1) {
            this.addFieldError("subSchemeId", this.getText("masters.loangrant.subscheme.mandatory"));
        }
        if (this.bankaccount == null || this.bankaccount == -1) {
            this.addFieldError("bankaccount", this.getText("masters.loangrant.bankaccount.mandatory"));
        }
        if (this.loanGrantHeader.getAmendmentDate() == null) {
            this.addFieldError("amendmentDate", this.getText("masters.loangrant.amendmentdate.mandatory"));
        }
        if (this.loanGrantHeader.getAmendmentNo() == null) {
            this.addFieldError("amendmentNo", this.getText("masters.loangrant.amendmentno.mandatory"));
        }
        if (this.loanGrantHeader.getCouncilResDate() == null) {
            this.addFieldError("councilResDate", this.getText("masters.loangrant.councilresdate.mandatory"));
        }
        if (this.loanGrantHeader.getCouncilResNo() == null) {
            this.addFieldError("councilResNo", this.getText("masters.loangrant.councilresno.mandatory"));
        }
        if (this.loanGrantHeader.getGovtOrderDate() == null) {
            this.addFieldError("govtOrderDate", this.getText("masters.loangrant.govtorderdate.mandatory"));
        }
        if (this.loanGrantHeader.getGovtOrderNo() == null) {
            this.addFieldError("govtOrderNo", this.getText("masters.loangrant.govtorderno.mandatory"));
        }
        if (this.loanGrantHeader.getProjectCost() == null || this.loanGrantHeader.getProjectCost().compareTo(BigDecimal.ZERO) == 0) {
            this.addFieldError("projectCost", this.getText("masters.loangrant.projectcost.mandatory"));
        }
        if (this.loanGrantHeader.getProjectCost() != null && this.loanGrantHeader.getSanctionedCost() != null && this.loanGrantHeader.getSanctionedCost().compareTo(this.loanGrantHeader.getProjectCost()) > 0) {
            this.addFieldError("projectCost", this.getText("masters.loangrant.validate.projectcost"));
        }
        if (this.loanGrantHeader.getProjectCost() != null && this.loanGrantHeader.getRevisedCost() != null && this.loanGrantHeader.getRevisedCost().compareTo(this.loanGrantHeader.getProjectCost()) < 0) {
            this.addFieldError("revisedCost", this.getText("masters.loangrant.validate.revisedcost"));
        }
        if (this.getCodeCheckCode()) {
            this.addActionError(this.getText("loangrant.subscheme.already.exists"));
        }
    }

    @ValidationErrorPage(value="new")
    @Action(value="/masters/loanGrant-save")
    public String save() {
        if (!this.getFieldErrors().isEmpty()) {
            return "new";
        }
        try {
            Scheme scheme = (Scheme)this.persistenceService.find(" from Scheme where id=?", new Object[]{this.getSchemeId()});
            SubScheme subScheme = (SubScheme)this.persistenceService.find(" from SubScheme where id=?", new Object[]{this.getSubSchemeId()});
            this.loanGrantHeader.setSubScheme(subScheme);
            if (this.loanGrantHeader.getRevisedCost() == null) {
                this.loanGrantHeader.setRevisedCost(BigDecimal.ZERO);
            }
            for (LoanGrantBean bean : this.projectCodeList) {
                SubSchemeProject subSchemeProject = new SubSchemeProject();
                subSchemeProject.setSubScheme(subScheme);
                subSchemeProject.setProjectCode(bean.getId());
                this.persistenceService.persist((Object)subSchemeProject);
            }
            Bankaccount bankaccObj = (Bankaccount)this.persistenceService.find(" from Bankaccount where id=?", new Object[]{this.bankaccount});
            SchemeBankaccount schemeBankaccount = new SchemeBankaccount();
            schemeBankaccount.setBankAccount(bankaccObj);
            schemeBankaccount.setScheme(scheme);
            schemeBankaccount.setSubScheme(subScheme);
            this.persistenceService.persist((Object)schemeBankaccount);
            this.createDetailAndReceiptList();
            this.persistenceService.persist((Object)this.loanGrantHeader);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        return "result";
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/masters/loanGrant-update")
    public String update() {
        if (!this.getFieldErrors().isEmpty()) {
            return "edit";
        }
        try {
            SubScheme subScheme = (SubScheme)this.persistenceService.find(" from SubScheme where id=?", new Object[]{this.getSubSchemeId()});
            this.loanGrantHeader.setSubScheme(subScheme);
            User user = (User)this.persistenceService.find("from User where id=?", new Object[]{ApplicationThreadLocals.getUserId()});
            Date currDate = new Date();
            this.loanGrantHeader.setCreatedBy(user);
            this.loanGrantHeader.setModifiedBy(user);
            this.loanGrantHeader.setCreatedDate(currDate);
            this.loanGrantHeader.setModifiedDate(currDate);
            if (this.loanGrantHeader.getRevisedCost() == null) {
                this.loanGrantHeader.setRevisedCost(BigDecimal.ZERO);
            }
            this.createDetailAndReceiptList();
            for (LoanGrantDetail lgDetail : this.loanGrantHeader.getDetailList()) {
                if (lgDetail.getId() == null) continue;
                lgDetail.setCreatedBy(user);
                lgDetail.setModifiedBy(user);
                lgDetail.setCreatedDate(currDate);
                lgDetail.setModifiedDate(currDate);
            }
            for (Object lgRecptDetail : this.loanGrantHeader.getReceiptList()) {
                if (lgRecptDetail.getId() == null) continue;
                lgRecptDetail.setCreatedBy(user);
                lgRecptDetail.setModifiedBy(user);
                lgRecptDetail.setCreatedDate(currDate);
                lgRecptDetail.setModifiedDate(currDate);
            }
            this.query = this.persistenceService.getSession().createSQLQuery("delete from egf_subscheme_project where subschemeid= " + this.getSubSchemeId());
            this.query.executeUpdate();
            for (LoanGrantBean bean : this.projectCodeList) {
                SubSchemeProject subSchemeProject = new SubSchemeProject();
                subSchemeProject.setSubScheme(subScheme);
                subSchemeProject.setProjectCode(bean.getId());
                this.persistenceService.persist((Object)subSchemeProject);
            }
            SchemeBankaccount schemeBankaccount = (SchemeBankaccount)this.persistenceService.find("from SchemeBankaccount where scheme.id=?", new Object[]{this.getSchemeId()});
            Bankaccount accountObj = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.bankaccount});
            schemeBankaccount.setBankAccount(accountObj);
            this.persistenceService.persist((Object)this.loanGrantHeader);
        }
        catch (ValidationException e) {
            this.prepareBeforeEdit();
            throw e;
        }
        catch (Exception e) {
            this.prepareBeforeEdit();
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        return "result";
    }

    @SkipValidation
    private void createDetailAndReceiptList() {
        for (LoanGrantDetail detail : this.sanctionedAmountLGDetails) {
            if (detail == null || detail.getFundingAgency() == null || detail.getFundingAgency().getId() == -1L || (detail.getLoanAmount() == null || detail.getLoanAmount().compareTo(BigDecimal.ZERO) == 0) && (detail.getGrantAmount() == null || detail.getGrantAmount().compareTo(BigDecimal.ZERO) == 0)) continue;
            if (detail.getLoanAmount() == null) {
                detail.setLoanAmount(BigDecimal.ZERO);
            }
            if (detail.getGrantAmount() == null) {
                detail.setGrantAmount(BigDecimal.ZERO);
            }
            detail.setPatternType(SANCTIONEDTYPE);
            detail.setHeader(this.loanGrantHeader);
            this.loanGrantHeader.getDetailList().add(detail);
        }
        for (LoanGrantDetail detail : this.unsanctionedAmountLGDetails) {
            if (detail == null || detail.getFundingAgency() == null || detail.getFundingAgency().getId() == -1L || (detail.getLoanAmount() == null || detail.getLoanAmount().compareTo(BigDecimal.ZERO) == 0) && (detail.getGrantAmount() == null || detail.getGrantAmount().compareTo(BigDecimal.ZERO) == 0)) continue;
            if (detail.getLoanAmount() == null) {
                detail.setLoanAmount(BigDecimal.ZERO);
            }
            if (detail.getGrantAmount() == null) {
                detail.setGrantAmount(BigDecimal.ZERO);
            }
            detail.setPatternType(UNSANCTIONEDTYPE);
            detail.setHeader(this.loanGrantHeader);
            this.loanGrantHeader.getDetailList().add(detail);
        }
        for (LoanGrantDetail detail : this.revisedAmountLGDetails) {
            if (detail == null || detail.getFundingAgency() == null || detail.getFundingAgency().getId() == -1L || (detail.getLoanAmount() == null || detail.getLoanAmount().compareTo(BigDecimal.ZERO) == 0) && (detail.getGrantAmount() == null || detail.getGrantAmount().compareTo(BigDecimal.ZERO) == 0)) continue;
            if (detail.getLoanAmount() == null) {
                detail.setLoanAmount(BigDecimal.ZERO);
            }
            if (detail.getGrantAmount() == null) {
                detail.setGrantAmount(BigDecimal.ZERO);
            }
            detail.setPatternType(REVISEDTYPE);
            detail.setHeader(this.loanGrantHeader);
            this.loanGrantHeader.getDetailList().add(detail);
        }
        ArrayList<LoanGrantReceiptDetail> newReceiptList = new ArrayList<LoanGrantReceiptDetail>();
        for (LoanGrantReceiptDetail receiptDetail : this.loanGrantHeader.getReceiptList()) {
            if (receiptDetail.getVoucherHeader() == null || receiptDetail.getVoucherHeader().getId() == null) continue;
            if (receiptDetail.getBankaccount() != null && receiptDetail.getBankaccount().getId() == null) {
                receiptDetail.setBankaccount(null);
            }
            if (receiptDetail.getInstrumentHeader() != null && receiptDetail.getInstrumentHeader().getId() == null) {
                receiptDetail.setInstrumentHeader(null);
            }
            if (receiptDetail.getFundingAgency() != null && receiptDetail.getFundingAgency().getId() == null) {
                receiptDetail.setFundingAgency(null);
            }
            receiptDetail.setLoanGrantHeader(this.loanGrantHeader);
            newReceiptList.add(receiptDetail);
        }
        this.loanGrantHeader.setReceiptList(newReceiptList);
    }

    @SkipValidation
    public void loadBanks() {
        this.common.ajaxLoadBanks();
        this.addDropdownData("bankBranchList", this.common.getBankBranchList());
    }

    public void setLoanGrantHeader(LoanGrantHeader loanGrantHeader) {
        this.loanGrantHeader = loanGrantHeader;
    }

    public LoanGrantHeader getLoanGrantHeader() {
        return this.loanGrantHeader;
    }

    public List<LoanGrantHeader> getLoanGrantHeaderList() {
        return this.loanGrantHeaderList;
    }

    public void setUnsanctionedAmountLGDetails(List<LoanGrantDetail> unsanctionedAmountLGDetails) {
        this.unsanctionedAmountLGDetails = unsanctionedAmountLGDetails;
    }

    public List<LoanGrantDetail> getUnsanctionedAmountLGDetails() {
        return this.unsanctionedAmountLGDetails;
    }

    public void setRevisedAmountLGDetails(List<LoanGrantDetail> revisedAmountLGDetails) {
        this.revisedAmountLGDetails = revisedAmountLGDetails;
    }

    public List<LoanGrantDetail> getRevisedAmountLGDetails() {
        return this.revisedAmountLGDetails;
    }

    public void setSanctionedAmountLGDetails(List<LoanGrantDetail> sanctionedAmountLGDetails) {
        this.sanctionedAmountLGDetails = sanctionedAmountLGDetails;
    }

    public List<LoanGrantDetail> getSanctionedAmountLGDetails() {
        return this.sanctionedAmountLGDetails;
    }

    public void setCommon(CommonAction common) {
        this.common = common;
    }

    public List<LoanGrantBean> getProjectCodeList() {
        return this.projectCodeList;
    }

    public void setProjectCodeList(List<LoanGrantBean> projectCodeList) {
        this.projectCodeList = projectCodeList;
    }

    public void setBankBranchMap(Map<String, String> bankBranchMap) {
        this.bankBranchMap = bankBranchMap;
    }

    public Map<String, String> getBankBranchMap() {
        return this.bankBranchMap;
    }

    public void setFundingAgencyList(List<FundingAgency> fundingAgencyList) {
        this.fundingAgencyList = fundingAgencyList;
    }

    public List<FundingAgency> getFundingAgencyList() {
        return this.fundingAgencyList;
    }

    public void setBankaccount(Integer bankaccount) {
        this.bankaccount = bankaccount;
    }

    public Integer getBankaccount() {
        return this.bankaccount;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Integer getBank_branch() {
        return this.bank_branch;
    }

    public void setBank_branch(Integer bank_branch) {
        this.bank_branch = bank_branch;
    }
}

