/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name="new", location="contractType-new.jsp"), @Result(name="search", location="contractType-search.jsp"), @Result(name="edit", location="contractType-edit.jsp")})
public class ContractTypeAction
extends BaseFormAction {
    private static final long serialVersionUID = -8067645108656316667L;
    private EgwTypeOfWork typeOfWork = new EgwTypeOfWork();
    private EgwTypeOfWork parentTypeOfWk = null;
    private EgPartytype appliedParty = null;
    private boolean close = false;
    private String showMode = "view";
    private List<EgwTypeOfWork> typeOfWorkList;
    private List<EgPartytype> partyTypeList;
    private List<EgwTypeOfWork> typeOfWkSearchList;
    protected static final String REQUIRED = "required";
    private String success = "";
    protected static final Logger LOGGER = Logger.getLogger(ContractTypeAction.class);
    private boolean duplicateCode = false;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.typeOfWork;
    }

    @SkipValidation
    public void prepare() {
        super.prepare();
        this.dropdownData.put("partyTypeList", this.persistenceService.findAllBy("from EgPartytype order by code", new Object[0]));
        this.dropdownData.put("typeOfWorkList", this.persistenceService.findAllBy("from EgwTypeOfWork order by code", new Object[0]));
    }

    @SkipValidation
    @Action(value="/masters/contractType-newform")
    public String newform() {
        return "new";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="code", message="Please Enter Code", key="required"), @RequiredFieldValidator(fieldName="description", message="Please Enter Description", key="required"), @RequiredFieldValidator(fieldName="typeOfWork.egPartytype.id", message="Please Select Applied To", key="required")})
    @SkipValidation
    @ValidationErrorPage(value="new")
    @Action(value="/masters/contractType-create")
    public String create() {
        try {
            if (this.typeOfWork.getCode() != null && this.getCheckCode()) {
                this.addActionError(this.getText("typeofwork.code.unique"));
                return "new";
            }
            if (this.typeOfWork.getParentid() != null && this.typeOfWork.getParentid().getId() != null) {
                this.parentTypeOfWk = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where id=?", new Object[]{this.typeOfWork.getParentid().getId()});
            }
            if (this.typeOfWork.getEgPartytype() != null && this.typeOfWork.getEgPartytype().getId() != null) {
                this.appliedParty = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.typeOfWork.getEgPartytype().getId()});
            }
            this.typeOfWork.setParentid(this.parentTypeOfWk);
            this.typeOfWork.setEgPartytype(this.appliedParty);
            this.typeOfWork.setCreatedby(this.getLoggedInUser());
            this.typeOfWork.setCreateddate(new Date());
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeMaster");
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeAllChild");
            EgovMasterDataCaching.removeFromCache((String)"egi-typeOfWorkParent");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodesForLiability");
            EgovMasterDataCaching.removeFromCache((String)"egi-tds");
            EgovMasterDataCaching.removeFromCache((String)"egi-tdsType");
            EgovMasterDataCaching.removeFromCache((String)"egi-recovery");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwTypeOfWork");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwSubTypeOfWork");
            this.persistenceService.persist((Object)this.typeOfWork);
            this.persistenceService.getSession().flush();
            this.persistenceService.getSession().clear();
            this.setSuccess("yes");
        }
        catch (Exception e) {
            this.setSuccess("no");
            LOGGER.error((Object)"Exception occurred in ContractTypeAction-create ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception occurred in ContractTypeAction-create ", (Throwable)e);
        }
        return "new";
    }

    @SkipValidation
    @ValidationErrorPage(value="edit")
    @Action(value="/masters/contractType-edit")
    public String edit() {
        try {
            EgwTypeOfWork typeOfWkOld = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where id=?", new Object[]{this.typeOfWork.getId()});
            if (this.typeOfWork.getCode() != null && this.getCheckCode()) {
                this.addActionError(this.getText("typeofwork.code.unique"));
                return "edit";
            }
            typeOfWkOld.setCode(this.typeOfWork.getCode());
            typeOfWkOld.setDescription(this.typeOfWork.getDescription());
            if (this.typeOfWork.getParentid() != null && this.typeOfWork.getParentid().getId() != null) {
                this.parentTypeOfWk = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where id=?", new Object[]{this.typeOfWork.getParentid().getId()});
            }
            if (this.typeOfWork.getEgPartytype() != null && this.typeOfWork.getEgPartytype().getId() != null) {
                this.appliedParty = (EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{this.typeOfWork.getEgPartytype().getId()});
            }
            typeOfWkOld.setParentid(this.parentTypeOfWk);
            typeOfWkOld.setEgPartytype(this.appliedParty);
            typeOfWkOld.setLastmodifieddate(new Date());
            typeOfWkOld.setLastmodifiedby(this.getLoggedInUser());
            this.setTypeOfWork(typeOfWkOld);
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeMaster");
            EgovMasterDataCaching.removeFromCache((String)"egi-partyTypeAllChild");
            EgovMasterDataCaching.removeFromCache((String)"egi-typeOfWorkParent");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodesForLiability");
            EgovMasterDataCaching.removeFromCache((String)"egi-tds");
            EgovMasterDataCaching.removeFromCache((String)"egi-tdsType");
            EgovMasterDataCaching.removeFromCache((String)"egi-recovery");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwTypeOfWork");
            EgovMasterDataCaching.removeFromCache((String)"egi-egwSubTypeOfWork");
            this.persistenceService.persist((Object)this.typeOfWork);
            this.showMode = "view";
            this.setSuccess("yes");
        }
        catch (Exception e) {
            this.setSuccess("no");
            LOGGER.error((Object)"Exception occurred in ContractTypeAction-edit ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception occurred in ContractTypeAction-edit ", (Throwable)e);
        }
        return "edit";
    }

    @SkipValidation
    @Action(value="/masters/contractType-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/contractType-search")
    public String search() {
        StringBuffer query = new StringBuffer();
        query.append("From EgwTypeOfWork where createdBy is not null ");
        if (!this.typeOfWork.getCode().isEmpty()) {
            query.append(" and upper(code) like upper('%" + this.typeOfWork.getCode() + "%')");
        }
        if (!this.typeOfWork.getDescription().isEmpty()) {
            query.append(" and upper(description) like upper('%" + this.typeOfWork.getDescription() + "%')");
        }
        if (this.typeOfWork.getEgPartytype() != null && this.typeOfWork.getEgPartytype().getId() != null) {
            query.append(" and egPartytype =" + this.typeOfWork.getEgPartytype());
        }
        if (this.typeOfWork.getParentid() != null && this.typeOfWork.getParentid().getId() != null) {
            query.append(" and parentid = " + this.typeOfWork.getParentid());
        }
        this.typeOfWorkList = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        return "search";
    }

    @SkipValidation
    @Action(value="/masters/contractType-beforeModify")
    public String beforeModify() {
        this.typeOfWork = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where id=?", new Object[]{this.typeOfWork.getId()});
        return "edit";
    }

    @SkipValidation
    public boolean getCheckCode() {
        EgwTypeOfWork tow = null;
        if (!this.typeOfWork.getCode().equals("") && this.typeOfWork.getId() != null) {
            tow = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where code=? and id!=?", new Object[]{this.typeOfWork.getCode(), this.typeOfWork.getId()});
        } else if (!this.typeOfWork.getCode().equals("")) {
            tow = (EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where code=?", new Object[]{this.typeOfWork.getCode()});
        }
        if (tow != null) {
            this.duplicateCode = true;
        }
        return this.duplicateCode;
    }

    @SkipValidation
    private Integer getLoggedInUser() {
        Integer userId = (Integer)this.getSession().get("com.egov.user.LoginUserId");
        return userId;
    }

    public EgwTypeOfWork getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(EgwTypeOfWork typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public List<EgwTypeOfWork> getTypeOfWorkList() {
        return this.typeOfWorkList;
    }

    public void setTypeOfWorkList(List<EgwTypeOfWork> typeOfWorkList) {
        this.typeOfWorkList = typeOfWorkList;
    }

    public List<EgwTypeOfWork> getTypeOfWkSearchList() {
        return this.typeOfWkSearchList;
    }

    public void setTypeOfWkSearchList(List<EgwTypeOfWork> typeOfWkSearchList) {
        this.typeOfWkSearchList = typeOfWkSearchList;
    }

    public String getSuccess() {
        return this.success;
    }

    public void setSuccess(String success) {
        this.success = success;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public EgwTypeOfWork getParentTypeOfWk() {
        return this.parentTypeOfWk;
    }

    public void setParentTypeOfWk(EgwTypeOfWork parentTypeOfWk) {
        this.parentTypeOfWk = parentTypeOfWk;
    }

    public EgPartytype getAppliedParty() {
        return this.appliedParty;
    }

    public void setAppliedParty(EgPartytype appliedParty) {
        this.appliedParty = appliedParty;
    }

    public List<EgPartytype> getPartyTypeList() {
        return this.partyTypeList;
    }

    public void setPartyTypeList(List<EgPartytype> partyTypeList) {
        this.partyTypeList = partyTypeList;
    }

    public void setDuplicateCode(boolean duplicateCode) {
        this.duplicateCode = duplicateCode;
    }

    public boolean isDuplicateCode() {
        return this.duplicateCode;
    }
}

