/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.exility.common.TaskFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgfAccountcodePurpose;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.masters.AccountCodePurpose;
import org.egov.utils.Constants;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="detailed-code", location="chartOfAccounts-detailed-code.jsp"), @Result(name="detailed", location="chartOfAccounts-detailed.jsp"), @Result(name="edit", location="chartOfAccounts-edit.jsp"), @Result(name="view", location="chartOfAccounts-view.jsp"), @Result(name="new", location="chartOfAccounts-new.jsp"), @Result(name="generated-glcode", location="chartOfAccounts-generated-glcode.jsp")})
public class ChartOfAccountsAction
extends BaseFormAction {
    private static final long serialVersionUID = 3393565721493478018L;
    private static final long LONG_FOUR = 4L;
    private static final long LONG_TWO = 2L;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private PersistenceService<CChartOfAccounts, Long> chartOfAccountsService;
    @Autowired
    @Qualifier(value="chartOfAccountDetailService")
    private PersistenceService<CChartOfAccountDetail, Long> chartOfAccountDetailService;
    CChartOfAccounts model = new CChartOfAccounts();
    List<String> accountDetailTypeList = new ArrayList();
    List<Accountdetailtype> accountDetailType = new ArrayList();
    private static final Logger LOGGER = Logger.getLogger(ChartOfAccountsAction.class);
    boolean activeForPosting = false;
    boolean functionRequired = false;
    boolean budgetCheckRequired = false;
    Long coaId;
    Long parentId;
    @Autowired
    AppConfigValueService appConfigValuesService;
    @Autowired
    private ChartOfAccounts chartOfAccounts;
    String glCode = "";
    List<CChartOfAccounts> allChartOfAccounts;
    int majorCodeLength = 0;
    int minorCodeLength = 0;
    int subMinorCodeLength = 0;
    int detailedCodeLength = 0;
    EgfAccountcodePurpose accountcodePurpose;
    private String generatedGlcode;
    String newGlcode;
    String parentForDetailedCode = "";
    private final Map<Long, Integer> glCodeLengths = new HashMap();
    private boolean updateOnly = false;

    public Object getModel() {
        return this.model;
    }

    public ChartOfAccountsAction() {
        this.addRelatedEntity("purpose", AccountCodePurpose.class);
        this.addRelatedEntity("chartOfAccountDetails.detailTypeId", AccountCodePurpose.class);
    }

    public void prepare() {
        super.prepare();
        this.populateChartOfAccounts();
        this.populateCodeLength();
        this.parentForDetailedCode = this.getAppConfigValueFor("EGF", "parent_for_detailcode");
        this.populateGlCodeLengths();
        this.allChartOfAccounts = this.chartOfAccountsService.findAllBy("from CChartOfAccounts where classification=?", new Object[]{Long.valueOf(this.parentForDetailedCode)});
        if (this.model != null && this.accountcodePurpose != null && this.accountcodePurpose.getId() != null) {
            this.accountcodePurpose = this.getPurposeCode(Integer.valueOf(this.accountcodePurpose.getId()));
        }
        this.dropdownData.put("purposeList", this.persistenceService.findAllBy("from EgfAccountcodePurpose order by name", new Object[0]));
        this.dropdownData.put("accountDetailTypeList", this.persistenceService.findAllBy("from Accountdetailtype order by name", new Object[0]));
    }

    private void populateAccountDetailTypeList() {
        if (this.model.getChartOfAccountDetails() != null) {
            for (CChartOfAccountDetail entry : this.model.getChartOfAccountDetails()) {
                this.accountDetailTypeList.add(entry.getDetailTypeId().getId().toString());
            }
        }
    }

    void populateGlCodeLengths() {
        this.getGlCodeLengths().put(Constants.LONG_ONE, this.majorCodeLength);
        this.getGlCodeLengths().put(2L, this.minorCodeLength - this.majorCodeLength);
        this.getGlCodeLengths().put(3L, this.subMinorCodeLength - this.minorCodeLength);
        if (this.parentForDetailedCode.equals("2")) {
            this.getGlCodeLengths().put(4L, this.detailedCodeLength - this.minorCodeLength);
        } else if (this.parentForDetailedCode.equals("3")) {
            this.getGlCodeLengths().put(4L, this.detailedCodeLength - this.subMinorCodeLength);
        }
    }

    private EgfAccountcodePurpose getPurposeCode(Integer id) {
        return (EgfAccountcodePurpose)this.persistenceService.find("from EgfAccountcodePurpose where id=?", new Object[]{id});
    }

    private void populateChartOfAccounts() {
        if (this.model.getId() != null) {
            this.model = (CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)this.model.getId(), false);
        }
    }

    public String execute() throws Exception {
        return "new";
    }

    @Action(value="/masters/chartOfAccounts-view")
    public String view() throws Exception {
        this.populateAccountCodePurpose();
        this.populateAccountDetailTypeList();
        this.populateCoaRequiredFields();
        this.coaId = this.model.getId();
        return "view";
    }

    public boolean shouldAllowCreation() {
        return !Long.valueOf("4").equals(this.model.getClassification());
    }

    @Action(value="/masters/chartOfAccounts-modify")
    public String modify() throws Exception {
        this.populateAccountDetailTypeList();
        this.populateCoaRequiredFields();
        this.populateAccountCodePurpose();
        return "edit";
    }

    private void populateCoaRequiredFields() {
        this.activeForPosting = this.getIsActiveForPosting();
        this.functionRequired = this.getFunctionReqd();
        this.budgetCheckRequired = this.budgetCheckReq();
    }

    private void populateAccountCodePurpose() {
        if (this.model != null && this.model.getPurposeId() != null) {
            this.accountcodePurpose = this.getPurposeCode(Integer.valueOf(this.model.getPurposeId().intValue()));
        }
    }

    @Action(value="/masters/chartOfAccounts-update")
    public String update() throws Exception {
        this.setPurposeOnCoa();
        this.updateOnly = true;
        this.populateAccountDetailType();
        this.model.setIsActiveForPosting(Boolean.valueOf(this.activeForPosting));
        this.model.setFunctionReqd(Boolean.valueOf(this.functionRequired));
        this.model.setBudgetCheckReq(Boolean.valueOf(this.budgetCheckRequired));
        this.chartOfAccountsService.persist((Object)this.model);
        this.saveCoaDetails(this.model);
        this.addActionMessage(this.getText("chartOfAccount.modified.successfully"));
        this.clearCache();
        this.coaId = this.model.getId();
        return "view";
    }

    private void setPurposeOnCoa() {
        if (this.accountcodePurpose != null && this.accountcodePurpose.getId() != null) {
            this.model.setPurposeId(Long.valueOf(this.accountcodePurpose.getId().longValue()));
        }
        if (this.model.getPurposeId() != null && this.model.getPurposeId().compareTo(0L) == 0) {
            this.model.setPurposeId(null);
        }
    }

    private void populateAccountDetailType() {
        for (String row : this.accountDetailTypeList) {
            this.accountDetailType.add((Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{Integer.valueOf(row)}));
        }
    }

    void deleteAccountDetailType(List<Accountdetailtype> accountDetailType, CChartOfAccounts accounts) {
        String accountDetail = "";
        if (accounts.getChartOfAccountDetails() == null) {
            return;
        }
        this.chartOfAccountsService.getSession().flush();
        try {
            for (Accountdetailtype row : accountDetailType) {
                Iterator iterator = accounts.getChartOfAccountDetails().iterator();
                while (iterator.hasNext()) {
                    CChartOfAccountDetail next = (CChartOfAccountDetail)iterator.next();
                    accountDetail = row.getName();
                    if (next != null && !next.getDetailTypeId().getId().equals(row.getId())) continue;
                    iterator.remove();
                    this.chartOfAccountDetailService.delete(this.chartOfAccountDetailService.findById((Serializable)next.getId(), false));
                    this.persistenceService.getSession().flush();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.populateAccountDetailTypeList();
            String message = accountDetail.concat(" ").concat(e.toString());
            throw new ValidationException(Arrays.asList(new ValidationError(message, message)));
        }
    }

    boolean hasReference(Integer id, String glCode) {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select * from chartofaccounts c,generalledger gl,generalledgerdetail gd where c.glcode='" + glCode + "' and gl.glcodeid=c.id and gd.generalledgerid=gl.id and gd.DETAILTYPEID=" + id);
        List list = query.list();
        return list != null && list.size() > 0;
    }

    boolean validAddtition(String glCode) {
        StringBuffer strQuery = new StringBuffer();
        strQuery.append("select bd.billid from  eg_billdetails bd, chartofaccounts coa,  eg_billregistermis brm where coa.glcode = '" + glCode + "' and bd.glcodeid = coa.id and brm.billid = bd.billid and brm.voucherheaderid is null ");
        strQuery.append(" intersect SELECT br.id FROM eg_billregister br, eg_billdetails bd, chartofaccounts coa,egw_status  sts WHERE coa.glcode = '" + glCode + "' AND bd.glcodeid = coa.id AND br.id= bd.billid AND br.statusid=sts.id ");
        strQuery.append(" and sts.id not in (select id from egw_status where upper(moduletype) like '%BILL%' and upper(description) like '%CANCELLED%') ");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(strQuery.toString());
        List list = query.list();
        return list == null || list.size() <= 0;
    }

    void saveCoaDetails(CChartOfAccounts accounts) {
        List rowsToBeDeleted = this.getAccountDetailTypeToBeDeleted(this.accountDetailType, accounts);
        List rowsToBeAdded = this.getAccountDetailTypeToBeAdded(this.accountDetailType, accounts);
        this.deleteAccountDetailType(rowsToBeDeleted, accounts);
        if (this.accountDetailType.size() == 1 && rowsToBeAdded.size() == 1 && rowsToBeDeleted.size() == 0 && this.updateOnly && !this.validAddtition(this.model.getGlcode())) {
            String message = this.getText("chartOfAccount.accDetail.uncancelled.bills");
            throw new ValidationException(Arrays.asList(new ValidationError(message, message)));
        }
        for (Accountdetailtype entry : rowsToBeAdded) {
            if (this.coaHasAccountdetailtype(entry, accounts)) continue;
            CChartOfAccountDetail chartOfAccountDetail = new CChartOfAccountDetail();
            chartOfAccountDetail.setDetailTypeId(entry);
            chartOfAccountDetail.setGlCodeId(accounts);
            accounts.getChartOfAccountDetails().add(chartOfAccountDetail);
            this.chartOfAccountsService.persist((Object)accounts);
        }
        this.chartOfAccountsService.getSession().flush();
    }

    List<Accountdetailtype> getAccountDetailTypeToBeDeleted(List<Accountdetailtype> accountDetailType, CChartOfAccounts accounts) {
        ArrayList<Accountdetailtype> rowsToBeDeleted = new ArrayList<Accountdetailtype>();
        for (CChartOfAccountDetail entry : accounts.getChartOfAccountDetails()) {
            if (accountDetailType != null && accountDetailType.isEmpty()) {
                rowsToBeDeleted.add(entry.getDetailTypeId());
                continue;
            }
            if (this.accountDetailTypeContains(accountDetailType, entry.getDetailTypeId())) continue;
            rowsToBeDeleted.add(entry.getDetailTypeId());
        }
        return rowsToBeDeleted;
    }

    List<Accountdetailtype> getAccountDetailTypeToBeAdded(List<Accountdetailtype> accountDetailType, CChartOfAccounts accounts) {
        ArrayList<Accountdetailtype> rowsToBeAdded = new ArrayList<Accountdetailtype>();
        for (Accountdetailtype row : accountDetailType) {
            if (this.coaHasAccountdetailtype(row, accounts)) continue;
            rowsToBeAdded.add(row);
        }
        return rowsToBeAdded;
    }

    private boolean coaHasAccountdetailtype(Accountdetailtype entry, CChartOfAccounts accounts) {
        for (CChartOfAccountDetail row : accounts.getChartOfAccountDetails()) {
            if (!row.getDetailTypeId().getId().equals(entry.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean accountDetailTypeContains(List<Accountdetailtype> list, Accountdetailtype entry) {
        for (Accountdetailtype row : list) {
            if (!row.getId().equals(entry.getId())) continue;
            return true;
        }
        return false;
    }

    @Action(value="/masters/chartOfAccounts-addNewCoa")
    public String addNewCoa() throws Exception {
        this.model = new CChartOfAccounts();
        if (this.parentId != null) {
            this.model.setParentId(this.parentId);
        }
        CChartOfAccounts parent = (CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)this.parentId, false);
        this.model.setType(parent.getType());
        this.setClassification(parent);
        Long glCode = this.findNextGlCode(parent);
        this.generatedGlcode = parent.getClassification() == null || parent.getClassification() == 0L ? "" : parent.getGlcode();
        if (glCode == null) {
            this.populateGlcode(parent.getClassification());
            this.newGlcode = this.model.getGlcode();
        } else {
            this.newGlcode = String.valueOf(glCode + 1L);
            if (this.model.getClassification().equals(2L)) {
                this.newGlcode = this.newGlcode.substring(this.majorCodeLength, this.newGlcode.length());
            } else if (this.model.getClassification().equals(3L)) {
                this.newGlcode = this.newGlcode.substring(this.minorCodeLength, this.newGlcode.length());
            } else if (this.model.getClassification().equals(4L)) {
                this.extractDetailCode();
            }
        }
        return "new";
    }

    private Long findNextGlCode(CChartOfAccounts parentCoa) {
        String glcode = (String)this.persistenceService.find("select max(glcode) from CChartOfAccounts where parentId=?", new Object[]{parentCoa.getId()});
        return glcode != null ? Long.valueOf(glcode) : null;
    }

    void setClassification(CChartOfAccounts parentCoa) {
        if (parentCoa.getClassification() == null) {
            this.model.setClassification(Constants.LONG_ONE);
        } else if (Constants.LONG_ZERO.equals(parentCoa.getClassification())) {
            this.model.setClassification(Constants.LONG_ONE);
        } else if (Constants.LONG_ONE.equals(parentCoa.getClassification())) {
            this.model.setClassification(Long.valueOf(2L));
        } else if (parentCoa.getClassification().equals(2L)) {
            if (this.parentForDetailedCode.equals("2")) {
                this.model.setClassification(Long.valueOf(4L));
            } else {
                this.model.setClassification(Long.valueOf(3L));
            }
        } else if (parentCoa.getClassification().equals(3L)) {
            this.model.setClassification(Long.valueOf(4L));
        }
    }

    String getAppConfigValueFor(String module, String key) {
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key).get(0)).getValue();
    }

    void populateCodeLength() {
        this.majorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        this.minorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.subMinorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_subminorcode_length"));
        this.detailedCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_detailcode_length"));
    }

    void populateGlcode(Long classification) {
        this.model.setGlcode(StringUtils.leftPad((String)"", (int)((Integer)this.glCodeLengths.get(classification)), (char)'0'));
    }

    @Action(value="/masters/chartOfAccounts-save")
    public String save() throws Exception {
        if (this.generatedGlcode == null || this.newGlcode == null) {
            this.addActionMessage(this.getText("chartOfAccount.invalid.glcode"));
            return "new";
        }
        CChartOfAccounts coa = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{this.generatedGlcode.concat(this.newGlcode)});
        if (coa != null) {
            this.addActionMessage(this.getText("chartOfAccount.glcode.already.exists"));
            return "new";
        }
        this.model.setGlcode(this.generatedGlcode.concat(this.newGlcode));
        if ("0".equals(this.model.getPurposeId())) {
            this.model.setPurposeId(null);
        }
        if (this.parentId != null) {
            CChartOfAccounts parent = (CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)this.parentId, false);
            this.model.setParentId(this.parentId);
            this.model.setType(parent.getType());
        }
        this.setPurposeOnCoa();
        this.model.setIsActiveForPosting(Boolean.valueOf(this.activeForPosting));
        this.model.setBudgetCheckReq(Boolean.valueOf(this.budgetCheckRequired));
        this.model.setFunctionReqd(Boolean.valueOf(this.functionRequired));
        this.populateAccountDetailType();
        this.model.setMajorCode(this.model.getGlcode().substring(0, this.majorCodeLength));
        this.chartOfAccountsService.persist((Object)this.model);
        this.saveCoaDetails(this.model);
        this.addActionMessage(this.getText("chartOfAccount.saved.successfully"));
        this.clearCache();
        this.coaId = this.model.getId();
        return "view";
    }

    private void reset() {
        this.activeForPosting = false;
        this.budgetCheckRequired = false;
        this.functionRequired = false;
        this.generatedGlcode = "";
        this.newGlcode = "";
        this.model = new CChartOfAccounts();
    }

    public boolean isActiveForPosting() {
        return this.activeForPosting;
    }

    public boolean budgetCheckReq() {
        return this.model != null && this.model.getBudgetCheckReq() != null && this.model.getBudgetCheckReq() != false;
    }

    public boolean getFunctionReqd() {
        return this.model != null && this.model.getFunctionReqd() != null && this.model.getFunctionReqd() != false;
    }

    public boolean getIsActiveForPosting() {
        return this.model != null && this.model.getIsActiveForPosting() != null && this.model.getIsActiveForPosting() != false;
    }

    @Action(value="/masters/chartOfAccounts-detailed")
    public String detailed() throws Exception {
        this.allChartOfAccounts = this.chartOfAccountsService.findAllBy("from CChartOfAccounts where classification=4", new Object[0]);
        return "detailed-code";
    }

    @SkipValidation
    @Action(value="/masters/chartOfAccounts-modifySearch")
    public String modifySearch() throws Exception {
        if (this.glCode != null) {
            this.model = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where classification=4 and glcode=?", new Object[]{this.glCode.split("-")[0]});
            if (this.model == null) {
                this.addActionMessage(this.getText("charOfAccount.no.record"));
                return this.detailed();
            }
            this.populateAccountDetailTypeList();
            this.populateCoaRequiredFields();
            this.populateAccountCodePurpose();
            return "edit";
        }
        this.addActionMessage(this.getText("charOfAccount.no.record"));
        return this.detailed();
    }

    @SkipValidation
    @Action(value="/masters/chartOfAccounts-viewSearch")
    public String viewSearch() throws Exception {
        if (this.glCode != null) {
            this.model = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where classification=4 and glcode=?", new Object[]{this.glCode.split("-")[0]});
            if (this.model == null) {
                this.addActionMessage(this.getText("charOfAccount.no.record"));
                return this.detailed();
            }
            this.coaId = this.model.getId();
            this.populateAccountDetailTypeList();
            this.populateCoaRequiredFields();
            this.populateAccountCodePurpose();
            return "view";
        }
        this.addActionMessage(this.getText("charOfAccount.no.record"));
        return this.detailed();
    }

    @Action(value="/masters/chartOfAccounts-addNew")
    public String addNew() throws Exception {
        this.populateCodeLength();
        this.model = new CChartOfAccounts();
        return "detailed";
    }

    @Action(value="/masters/chartOfAccounts-create")
    public String create() throws Exception {
        if (this.glCode != null) {
            CChartOfAccounts parent = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{this.glCode.split("-")[0]});
            if (parent == null) {
                this.addActionMessage(this.getText("chartOfAccount.no.data"));
                return this.detailed();
            }
            if (this.generatedGlcode == null || this.newGlcode == null) {
                this.addActionMessage(this.getText("chartOfAccount.invalid.glcode"));
                return "detailed";
            }
            CChartOfAccounts coa = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{this.generatedGlcode.concat(this.newGlcode)});
            if (coa != null) {
                this.addActionMessage(this.getText("chartOfAccount.glcode.already.exists"));
                return "detailed";
            }
            this.parentId = parent.getId();
            this.model.setParentId(this.parentId);
            this.model.setBudgetCheckReq(Boolean.valueOf(this.budgetCheckRequired));
            this.model.setFunctionReqd(Boolean.valueOf(this.functionRequired));
            this.model.setType(parent.getType());
            this.setClassification(parent);
            this.model.setGlcode(this.generatedGlcode.concat(this.newGlcode));
            this.model.setMajorCode(this.model.getGlcode().substring(0, this.majorCodeLength));
            this.setPurposeOnCoa();
            this.model.setIsActiveForPosting(Boolean.valueOf(this.activeForPosting));
            this.populateAccountDetailType();
            this.chartOfAccountsService.persist((Object)this.model);
            this.saveCoaDetails(this.model);
            this.addActionMessage(this.getText("chartOfAccount.detailed.saved"));
        } else {
            this.addActionMessage(this.getText("chartOfAccount.no.data"));
        }
        this.clearCache();
        return this.detailed();
    }

    public void setGeneratedGlcode(String generatedGlcode) {
        this.generatedGlcode = generatedGlcode;
    }

    public String getGeneratedGlcode() {
        return this.generatedGlcode;
    }

    public void setNewGlcode(String newGlcode) {
        this.newGlcode = newGlcode;
    }

    public String getNewGlcode() {
        return this.newGlcode;
    }

    @Action(value="/masters/chartOfAccounts-ajaxNextGlCode")
    public String ajaxNextGlCode() {
        String parentGlcode = ((String[])this.parameters.get("parentGlcode"))[0];
        if (parentGlcode != null || !StringUtils.isBlank((String)parentGlcode)) {
            CChartOfAccounts coa = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{parentGlcode});
            Long glCode = this.findNextGlCode(coa);
            if (glCode == null) {
                this.populateGlcode(coa.getClassification());
                this.newGlcode = this.model.getGlcode();
            } else {
                this.newGlcode = String.valueOf(glCode + 1L);
                this.extractDetailCode();
            }
        }
        return "generated-glcode";
    }

    void extractDetailCode() {
        this.newGlcode = this.parentForDetailedCode.equals("2") ? this.newGlcode.substring(this.minorCodeLength, this.newGlcode.length()) : this.newGlcode.substring(this.subMinorCodeLength, this.newGlcode.length());
    }

    public Map<Long, Integer> getGlCodeLengths() {
        return this.glCodeLengths;
    }

    void clearCache() {
        try {
            this.chartOfAccounts.reLoadAccountData();
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)("Error" + e.getMessage()), (Throwable)e);
        }
    }

    public EgfAccountcodePurpose getAccountcodePurpose() {
        return this.accountcodePurpose;
    }

    public void setAccountcodePurpose(EgfAccountcodePurpose purposeName) {
        this.accountcodePurpose = purposeName;
    }

    public List<CChartOfAccounts> getAllChartOfAccounts() {
        return this.allChartOfAccounts;
    }

    public String getGlCode() {
        return this.glCode;
    }

    public void setGlCode(String glCode) {
        this.glCode = glCode;
    }

    public boolean isBudgetCheckRequired() {
        return this.budgetCheckRequired;
    }

    public boolean isFunctionRequired() {
        return this.functionRequired;
    }

    public void setBudgetCheckRequired(boolean budgetCheckReq) {
        this.budgetCheckRequired = budgetCheckReq;
    }

    public void setFunctionRequired(boolean functionReqd) {
        this.functionRequired = functionReqd;
    }

    public Long getCoaId() {
        return this.coaId;
    }

    public void setCoaId(Long id) {
        this.coaId = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long id) {
        this.parentId = id;
    }

    public void setActiveForPosting(boolean activeForPosting) {
        this.activeForPosting = activeForPosting;
    }

    public List<String> getAccountDetailTypeList() {
        return this.accountDetailTypeList;
    }

    public void setAccountDetailTypeList(List<String> accountDetailTypeList) {
        this.accountDetailTypeList = accountDetailTypeList;
    }

    public List<Accountdetailtype> getAccountDetailType() {
        return this.accountDetailType;
    }

    public void setAccountDetailType(List<Accountdetailtype> accountDetailType) {
        this.accountDetailType = accountDetailType;
    }

    public PersistenceService<CChartOfAccounts, Long> getChartOfAccountsService() {
        return this.chartOfAccountsService;
    }

    public void setChartOfAccountsService(PersistenceService<CChartOfAccounts, Long> chartOfAccountsService) {
        this.chartOfAccountsService = chartOfAccountsService;
    }

    public void setModel(CChartOfAccounts model) {
        this.model = model;
    }
}

