/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.validator.annotations.Validation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.BudgetGroup;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.BudgetingType;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name="new", location="budgetGroup-new.jsp"), @Result(name="search", location="budgetGroup-search.jsp"), @Result(name="edit", location="budgetGroup-edit.jsp"), @Result(name="success", type="redirect", location="budgetGroup.action")})
public class BudgetGroupAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private BudgetGroup budgetGroup = new BudgetGroup();
    private PersistenceService<BudgetGroup, Long> budgetGroupService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private List<BudgetGroup> budgetGroupList = new ArrayList();
    private static final String SEARCH = "search";
    private static final String VIEW = "view";
    private static final String MAJORCODE = "majorCode";
    private static final String LENGTHQUERY = " from CChartOfAccounts c where length(c.glcode)=? order by c.glcode";
    private static final String BGQUERYID = " from BudgetGroup where minCode.glcode<=? and maxCode.glcode>=? and id!=? ";
    private static final String BGQUERY = "from BudgetGroup where majorCode.glcode<=? and majorCode.glcode>=?";
    private String target = "";
    private String mode = "";
    private int majorcodelength = 0;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.budgetGroup;
    }

    public BudgetGroupAction() {
        this.addRelatedEntity(MAJORCODE, CChartOfAccounts.class);
        this.addRelatedEntity("minCode", CChartOfAccounts.class);
        this.addRelatedEntity("maxCode", CChartOfAccounts.class);
    }

    public String execute() {
        return "index";
    }

    public void prepare() {
        super.prepare();
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length");
        this.majorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
        appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetgroup_range_minor_or_detailed");
        String range = ((AppConfigValues)appList.get(0)).getValue();
        appList = range.equalsIgnoreCase("minor") ? this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_minorcode_length") : this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_detailcode_length");
        int rangecodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
        this.addDropdownData("majorCodeList", this.getPersistenceService().findAllBy(LENGTHQUERY, new Object[]{this.majorcodelength}));
        this.addDropdownData("minCodeList", this.getPersistenceService().findAllBy(LENGTHQUERY, new Object[]{rangecodelength}));
        this.addDropdownData("maxCodeList", this.getPersistenceService().findAllBy(LENGTHQUERY, new Object[]{rangecodelength}));
        this.addDropdownData("accountTypeList", Arrays.asList(BudgetAccountType.values()));
        this.addDropdownData("budgetingTypeList", Arrays.asList(BudgetingType.values()));
    }

    @SkipValidation
    @Action(value="/budget/budgetGroup-newform")
    public String newform() {
        return "new";
    }

    @Action(value="/budget/budgetGroup-create")
    public String create() {
        if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getMaxCode() == null) {
            this.budgetGroup.setMaxCode(this.budgetGroup.getMinCode());
        }
        if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getMinCode() == null) {
            this.budgetGroup.setMinCode(this.budgetGroup.getMaxCode());
        }
        this.budgetGroupService.create((Object)this.budgetGroup);
        this.addActionMessage(this.getMessage("budgetgroup.create", new String[0]));
        this.clearBudgetGroupCache();
        this.target = "SUCCESS";
        return "new";
    }

    protected String getMessage(String key, String ... value) {
        return this.getText(key, value);
    }

    @SkipValidation
    public String list() {
        this.budgetGroupList = this.budgetGroup.getName() == null || this.budgetGroup.getName().equals("") ? this.budgetGroupService.findAllBy(" from BudgetGroup ", new Object[0]) : this.budgetGroupService.findAllBy(" from BudgetGroup where name=?", new Object[]{this.budgetGroup.getName()});
        if (this.budgetGroupList.isEmpty()) {
            this.target = "EMPTY";
        }
        return SEARCH;
    }

    @Action(value="/budget/budgetGroup-save")
    public String save() {
        if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getMaxCode() == null) {
            this.budgetGroup.setMaxCode(this.budgetGroup.getMinCode());
        }
        if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getMinCode() == null) {
            this.budgetGroup.setMinCode(this.budgetGroup.getMaxCode());
        }
        this.budgetGroupService.update((Object)this.budgetGroup);
        this.clearBudgetGroupCache();
        this.addActionMessage(this.getMessage("budgetgroup.update", new String[0]));
        this.target = "SUCCESS";
        this.mode = "edit";
        return "new";
    }

    private void clearBudgetGroupCache() {
        EgovMasterDataCaching.removeFromCache((String)"egf-budgetGroup");
    }

    @SkipValidation
    @Action(value="/budget/budgetGroup-edit")
    public String edit() {
        this.budgetGroup = (BudgetGroup)this.budgetGroupService.findById((Serializable)this.budgetGroup.getId(), false);
        if (this.getMode().equals("edit")) {
            return "edit";
        }
        return VIEW;
    }

    @SkipValidation
    @Action(value="/budget/budgetGroup-search")
    public String search() {
        this.mode = ((String[])this.parameters.get("mode"))[0];
        this.target = "NONE";
        return SEARCH;
    }

    public void validate() {
        if (this.budgetGroup.getMajorCode() == null && this.budgetGroup.getMinCode() == null && this.budgetGroup.getMaxCode() == null) {
            this.addFieldError(MAJORCODE, this.getMessage("budgetgroup.select.accountcode", new String[0]));
        }
        if (this.budgetGroup.getMajorCode() != null && (this.budgetGroup.getMinCode() != null || this.budgetGroup.getMaxCode() != null)) {
            this.addFieldError(MAJORCODE, this.getMessage("budgetgroup.invalid.mapping", new String[0]));
        }
        if (this.budgetGroup.getIsActive()) {
            BudgetGroup bg = null;
            if (this.budgetGroup.getMajorCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where majorCode=? ", new Object[]{this.budgetGroup.getMajorCode()});
            } else if (this.budgetGroup.getMajorCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where majorCode=? and id!=? ", new Object[]{this.budgetGroup.getMajorCode(), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError(MAJORCODE, this.getMessage("budgetgroup.invalid.majorcode", new String[]{bg.getName()}));
            }
            bg = null;
            if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where minCode.glcode<=? and maxCode.glcode>=? ", new Object[]{this.budgetGroup.getMinCode().getGlcode(), this.budgetGroup.getMinCode().getGlcode()});
            } else if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERYID, new Object[]{this.budgetGroup.getMinCode().getGlcode(), this.budgetGroup.getMinCode().getGlcode(), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError("minCode", this.getMessage("budgetgroup.invalid.mincode", new String[]{bg.getName()}));
            }
            bg = null;
            if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where minCode.glcode<=? and maxCode.glcode>=? ", new Object[]{this.budgetGroup.getMaxCode().getGlcode(), this.budgetGroup.getMaxCode().getGlcode()});
            } else if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERYID, new Object[]{this.budgetGroup.getMaxCode().getGlcode(), this.budgetGroup.getMaxCode().getGlcode(), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError("maxCode", this.getMessage("budgetgroup.invalid.maxcode", new String[]{bg.getName()}));
            }
            bg = null;
            if (this.budgetGroup.getMajorCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where substr(minCode.glcode,1," + this.budgetGroup.getMajorCode().getGlcode().length() + ")<=? and substr(maxCode.glcode,1," + this.budgetGroup.getMajorCode().getGlcode().length() + ")>=? ", new Object[]{this.budgetGroup.getMajorCode().getGlcode(), this.budgetGroup.getMajorCode().getGlcode()});
            } else if (this.budgetGroup.getMajorCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(" from BudgetGroup where substr(minCode.glcode,1," + this.budgetGroup.getMajorCode().getGlcode().length() + ")<=? and substr(maxCode.glcode,1," + this.budgetGroup.getMajorCode().getGlcode().length() + ")>=? and id!=?", new Object[]{this.budgetGroup.getMajorCode().getGlcode(), this.budgetGroup.getMajorCode().getGlcode(), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError(MAJORCODE, this.getMessage("budgetgroup.invalid.majorcode1", new String[]{bg.getName()}));
            }
            bg = null;
            if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERY, new Object[]{this.budgetGroup.getMinCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getMinCode().getGlcode().substring(0, this.majorcodelength)});
            } else if (this.budgetGroup.getMinCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERYID, new Object[]{this.budgetGroup.getMinCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getMinCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError("minCode", this.getMessage("budgetgroup.invalid.mincode1", new String[]{bg.getName()}));
            }
            bg = null;
            if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getId() == null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERY, new Object[]{this.budgetGroup.getMaxCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getMaxCode().getGlcode().substring(0, this.majorcodelength)});
            } else if (this.budgetGroup.getMaxCode() != null && this.budgetGroup.getId() != null) {
                bg = (BudgetGroup)this.getPersistenceService().find(BGQUERYID, new Object[]{this.budgetGroup.getMaxCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getMaxCode().getGlcode().substring(0, this.majorcodelength), this.budgetGroup.getId()});
            }
            if (bg != null) {
                this.addFieldError("maxCode", this.getMessage("budgetgroup.invalid.maxcode1", new String[]{bg.getName()}));
            }
            Object var1_1 = null;
        }
    }

    public void setBudgetGroupService(PersistenceService<BudgetGroup, Long> budgetGroupService) {
        this.budgetGroupService = budgetGroupService;
    }

    public BudgetGroup getBudgetGroup() {
        return this.budgetGroup;
    }

    public void setBudgetGroup(BudgetGroup budgetGroup) {
        this.budgetGroup = budgetGroup;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public List<BudgetGroup> getBudgetGroupList() {
        return this.budgetGroupList;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

