/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.validator.annotations.Validation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name="new", location="budget-new.jsp"), @Result(name="referenceBudgets", location="budget-referenceBudgets.jsp"), @Result(name="search", location="budget-search.jsp"), @Result(name="parentbudgets", location="budget-parentbudgets.jsp"), @Result(name="success", type="redirect", location="budget.action"), @Result(name="edit", location="budget-edit.jsp")})
public class BudgetAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private Budget budget = new Budget();
    private PersistenceService<Budget, Long> budgetService;
    private PersistenceService<CFinancialYear, Long> finYearService;
    private List<String> isbereList;
    private List<Budget> budgetList = new ArrayList();
    private static final String SEARCH = "search";
    private Integer parentId;
    private Integer referenceId;
    private Map<Long, String> parMap = new HashMap();
    private SimpleWorkflowService<Budget> budgetWorkflowService;
    private String target = "";
    private String bere = "";
    private Long tempId = null;
    private List<Budget> parentBudgets;
    private static final String PARENTBUDGETS = "parentbudgets";
    private static final Logger LOGGER = Logger.getLogger(BudgetAction.class);
    private EisCommonService eisCommonService = null;
    private List<Budget> referenceBudgetList = new ArrayList();
    private CFinancialYear financialYear;
    private FinancialYearDAO financialYearDAO;
    private Long financialYearId;

    public BudgetAction() {
        this.addRelatedEntity("financialYear", CFinancialYear.class);
    }

    public Object getModel() {
        return this.budget;
    }

    public String execute() {
        return "index";
    }

    public void prepare() {
        super.prepare();
        this.isbereList = new ArrayList();
        this.isbereList.add("BE");
        this.isbereList.add("RE");
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.addDropdownData("referenceBudgetList", Collections.EMPTY_LIST);
        this.setupDropdownDataExcluding(new String[]{"financialYear"});
    }

    @SkipValidation
    @Action(value="/budget/budget-newform")
    public String newform() {
        return "new";
    }

    @Action(value="/budget/budget-create")
    public String create() {
        this.addMaterializedPath(this.budget);
        this.budgetService.create((Object)this.budget);
        if (this.getParentId() != null && this.getParentId() > 0) {
            this.budget.setParent((Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getParentId().intValue()), false));
        }
        if (this.getReferenceId() != null && this.getReferenceId() != -1) {
            this.budget.setReferenceBudget((Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getReferenceId().intValue()), false));
        }
        if (this.budget.getParent() != null && this.budget.getParent().getIsPrimaryBudget()) {
            this.budget.setIsPrimaryBudget(true);
        }
        Position p = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        this.budget.start().withOwner(p);
        this.addActionMessage(this.getMessage("budget.create"));
        this.target = "SUCCESS";
        return "new";
    }

    private void addMaterializedPath(Budget budget) {
        Budget parent;
        String materializedPath = "";
        String count = "";
        if (this.getParentId() != null && this.getParentId() > 0 && (parent = (Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getParentId().intValue()), false)) != null) {
            materializedPath = parent.getMaterializedPath();
        }
        List parallelBudgets = null;
        parallelBudgets = this.getParentId() == null || this.getParentId() <= 0 ? this.budgetService.findAllBy("from Budget b where b.parent is null", new Object[0]) : this.budgetService.findAllBy("from Budget b where b.parent.id=?", new Object[]{(long)this.getParentId().intValue()});
        if (parallelBudgets != null) {
            count = String.valueOf(parallelBudgets.size() + 1);
        }
        materializedPath = materializedPath == null || materializedPath.isEmpty() ? count : materializedPath + "." + count;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("MaterializedPath..." + materializedPath));
        }
        budget.setMaterializedPath(materializedPath);
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    @SkipValidation
    @Action(value="/budget/budget-ajaxLoadReferenceBudgets")
    public String ajaxLoadReferenceBudgets() {
        this.referenceBudgetList = new ArrayList();
        this.financialYear = this.financialYearDAO.getFinancialYearById(this.financialYear.getId());
        CFinancialYear previousYear = this.financialYearDAO.getFinancialYearByFinYearRange(this.computeYearRange(this.financialYear.getFinYearRange()));
        this.referenceBudgetList.addAll(this.getReferenceBudgetsFor(previousYear));
        return "referenceBudgets";
    }

    private List getReferenceBudgetsFor(CFinancialYear previousYear) {
        return this.persistenceService.findAllBy("from Budget where isactivebudget = 1 and state.type='Budget' and isbere='RE' and state.value='NEW' and financialYear.id = " + previousYear.getId() + " and id not in (select referenceBudget.id from Budget where" + " financialYear.id=" + this.financialYear.getId() + " and referenceBudget is not null) order by name", new Object[0]);
    }

    private String computeYearRange(String range) {
        if (StringUtils.isNotBlank((String)range)) {
            String[] list = range.split("-");
            return this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
        return "";
    }

    protected String subtract(String value) {
        int val = Integer.parseInt(value) - 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    @Action(value="/budget/budget-save")
    public String save() {
        if (this.getParentId() != null && this.getParentId() > 0) {
            this.budget.setParent((Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getParentId().intValue()), false));
        }
        if (this.getReferenceId() != null && this.getReferenceId() > 0) {
            this.budget.setReferenceBudget((Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getReferenceId().intValue()), false));
        }
        if (this.budget.getState() != null) {
            State state = (State)this.persistenceService.find("from org.egov.infra.workflow.entity.State where id=?", new Object[]{this.budget.getState().getId()});
        }
        this.persistenceService.getSession().flush();
        this.budgetService.persist((Object)this.budget);
        this.addActionMessage(this.getMessage("budget.update"));
        this.target = "SUCCESS";
        return "new";
    }

    @SkipValidation
    public String list() {
        this.budgetList = this.budgetService.findAllBy(" from Budget b where b.financialYear=? and b.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='NEW' ) ", new Object[]{this.budget.getFinancialYear()});
        if (this.budgetList.isEmpty()) {
            this.target = "EMPTY";
        }
        return SEARCH;
    }

    @SkipValidation
    @Action(value="/budget/budget-edit")
    public String edit() {
        this.budget = (Budget)this.budgetService.findById((Serializable)this.budget.getId(), false);
        if (this.budget.getParent() != null) {
            this.setParentId(Integer.valueOf(this.budget.getParent().getId().toString()));
        }
        if (this.budget.getReferenceBudget() != null) {
            this.setReferenceId(Integer.valueOf(this.budget.getReferenceBudget().getId().toString()));
        }
        List budgetDetailList = this.persistenceService.findAllBy(" from BudgetDetail where budget=?", new Object[]{this.budget});
        this.financialYear = this.financialYearDAO.getFinancialYearById(this.budget.getFinancialYear().getId());
        CFinancialYear previousYear = this.financialYearDAO.getFinancialYearByFinYearRange(this.computeYearRange(this.financialYear.getFinYearRange()));
        this.referenceBudgetList.addAll(this.getReferenceBudgetsFor(previousYear));
        if (this.budget.getReferenceBudget() != null) {
            this.referenceBudgetList.add(this.budget.getReferenceBudget());
        }
        this.target = budgetDetailList.isEmpty() ? "allowToEdit" : "NotAllowToEdit";
        return "edit";
    }

    @SkipValidation
    @Action(value="/budget/budget-search")
    public String search() {
        this.target = "NONE";
        return SEARCH;
    }

    public List<String> getIsbereList() {
        return this.isbereList;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public void setBudgetService(PersistenceService<Budget, Long> budgetService) {
        this.budgetService = budgetService;
    }

    public List<Budget> getBudgetList() {
        return this.budgetList;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public Map<Long, String> getParMap() {
        List parList = null;
        parList = this.budget == null || this.budget.getId() == null ? this.getPersistenceService().findAllBy("from Budget b where b.isbere='BE' and b.id not in (select budget from BudgetDetail) and b.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='NEW' ) ", new Object[0]) : this.getPersistenceService().findAllBy("from Budget b where b.isbere='BE' and b.id not in (select budget from BudgetDetail) and b.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='NEW' ) and b.id!=" + this.budget.getId(), new Object[0]);
        for (Budget b : parList) {
            this.parMap.put(b.getId(), b.getName());
        }
        return this.parMap;
    }

    public void setParMap(Map<Long, String> parMap) {
        this.parMap = parMap;
    }

    public void validate() {
        List list;
        CFinancialYear finyear;
        Budget b;
        if (this.getParentId() != null && this.getParentId() > 0 && !(b = (Budget)this.budgetService.findById((Serializable)Long.valueOf(this.getParentId().intValue()), false)).getIsbere().equals(this.budget.getIsbere())) {
            this.addFieldError("parentId", this.getText("budget.parent.invalid", new String[]{this.budget.getIsbere()}));
        }
        Date dt = new Date();
        if (this.budget.getFinancialYear() != null && (finyear = (CFinancialYear)this.finYearService.findByNamedQuery("validateFinancialYear", new Object[]{this.budget.getFinancialYear().getId(), dt, dt, dt})) == null) {
            this.addFieldError("financialYear", this.getText("budget.finyear.invalid"));
        }
        if (this.budget.getIsPrimaryBudget() && this.budget.getFinancialYear() != null && (this.getParentId() == null || this.getParentId() <= 0) && (list = this.getPersistenceService().findAllBy(" from Budget where isbere=? and financialYear=? and isPrimaryBudget=1 and parent is null", new Object[]{this.budget.getIsbere(), this.budget.getFinancialYear()})) != null && list.size() > 1) {
            this.addFieldError("isPrimaryBudget", this.getText("budget.primary.invalid2", new String[]{this.budget.getFinancialYear().getFinYearRange(), this.budget.getIsbere()}));
        }
    }

    public void setFinYearService(PersistenceService<CFinancialYear, Long> finYearService) {
        this.finYearService = finYearService;
    }

    public void setBudgetWorkflowService(SimpleWorkflowService<Budget> workflowService) {
        this.budgetWorkflowService = workflowService;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @SkipValidation
    @Action(value="/budget/budget-ajaxLoadParentBudgets")
    public String ajaxLoadParentBudgets() {
        this.parentBudgets = this.tempId == null ? this.getPersistenceService().findAllBy("from Budget b where b.isbere=? and b.id not in (select budget from BudgetDetail) and b.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='NEW' ) and b.financialYear.id=?", new Object[]{this.bere, this.financialYearId}) : this.getPersistenceService().findAllBy("from Budget b where b.isbere=? and b.id not in (select budget from BudgetDetail) and b.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='NEW' ) and b.financialYear.id=? and b.id!=" + this.tempId, new Object[]{this.bere, this.financialYearId});
        return PARENTBUDGETS;
    }

    public List<Budget> getParentBudgets() {
        return this.parentBudgets;
    }

    public String getBere() {
        return this.bere;
    }

    public void setBere(String bere) {
        this.bere = bere;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public Long getTempId() {
        return this.tempId;
    }

    public void setTempId(Long tempId) {
        this.tempId = tempId;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setReferenceBudgetList(List<Budget> referenceBudgetList) {
        this.referenceBudgetList = referenceBudgetList;
    }

    public List<Budget> getReferenceBudgetList() {
        return this.referenceBudgetList;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setReferenceId(Integer referenceId) {
        this.referenceId = referenceId;
    }

    public Integer getReferenceId() {
        return this.referenceId;
    }

    public void setFinancialYearId(Long financialYearId) {
        this.financialYearId = financialYearId;
    }

    public Long getFinancialYearId() {
        return this.financialYearId;
    }
}

