/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.egf.web.actions.brs.AjaxDishonoredAction;
import org.egov.egf.web.actions.brs.DishonoredChequeBean;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.receipt.ReceiptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="search", location="dishonoredCheque-search.jsp"), @Result(name="success", location="dishonoredCheque-success.jsp")})
public class DishonoredChequeAction
extends SearchFormAction {
    private static final long serialVersionUID = 1998083631926900402L;
    public static final String SEARCH = "search";
    private static final Logger LOGGER = Logger.getLogger(DishonoredChequeAction.class);
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    private String bankBranchId;
    private Long accountCodes;
    private String instrumentMode;
    private String chequeNo;
    private Date chqDDDate;
    private EgovPaginatedList paginatedList;
    @Autowired
    @Qualifier(value="receiptService")
    private ReceiptService receiptService;
    @Autowired
    private InstrumentService instrumentService;
    private String installmentIds;
    protected List<DishonoredChequeBean> dishonoredChequeDisplayList = new ArrayList();

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("bankBranchList", this.persistenceService.findAllBy("select bb from Bankbranch bb where bb.isactive=true order by bb.bank.name", new Object[0]));
        AjaxDishonoredAction ajaxDishonoredAction = new AjaxDishonoredAction();
        ajaxDishonoredAction.setPersistenceService(this.getPersistenceService());
        this.populateAccountCodes(ajaxDishonoredAction);
    }

    public List getBankBranch() {
        return null;
    }

    private void populateAccountCodes(AjaxDishonoredAction ajaxDishonoredAction) {
        if (this.bankBranchId != null && this.bankBranchId != "-1" && this.bankBranchId != "") {
            ajaxDishonoredAction.setBankBranchId(this.bankBranchId);
            ajaxDishonoredAction.populateAccountCodes();
            this.addDropdownData("accountCodeList", ajaxDishonoredAction.getBankAccountList());
        } else {
            this.addDropdownData("accountCodeList", Collections.emptyList());
        }
    }

    @Actions(value={@Action(value="/brs/dishonoredCheque-search")})
    public String show() {
        return SEARCH;
    }

    @Action(value="/brs/dishonoredCheque-list")
    public String list() throws Exception {
        this.setPageSize(30);
        super.search();
        this.prepareResults();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EBConsumerAction | list | End");
        }
        return SEARCH;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        Long bankId = null;
        if (!this.bankBranchId.equals("-1") && this.bankBranchId != null && this.bankBranchId != "") {
            String[] id = this.bankBranchId.split("-");
            bankId = Long.parseLong(id[0]);
        }
        String searchQuery = this.receiptService.getReceiptHeaderforDishonor(this.instrumentMode, this.accountCodes, bankId, this.chequeNo, this.chqDDDate.toString());
        String srchQry = "select rpt.id as receiptheaderid,ih.id as instrumentheaderid,rpt.receiptnumber as receiptnumber,rpt.receiptdate as receiptdate,ih.instrumentnumber as instrumentnumber,ih.instrumentdate as instrumentdate,ih.instrumentamount as instrumentamount,b.name as bankname,ba.accountnumber as accountnumber,ih.payto as payto,status.description as description " + searchQuery + " ORDER BY rpt.receiptnumber, rpt.receiptdate ";
        String countQry = "select count(distinct rpt) " + searchQuery + "";
        return new SearchQuerySQL(srchQry, countQry, null);
    }

    @Action(value="/brs/dishonoredCheque-dishonorCheque")
    public String dishonorCheque() throws Exception {
        String[] installmentIdsStr;
        for (String installmentIdStr : installmentIdsStr = this.installmentIds.split(",")) {
            InstrumentHeader ih = new InstrumentHeader();
            ih = (InstrumentHeader)this.getPersistenceService().find("from InstrumentHeader where id=?", new Object[]{Long.valueOf(installmentIdStr)});
            this.instrumentService.cancelInstrument(ih);
        }
        return "success";
    }

    private void prepareResults() {
        LOGGER.debug((Object)"Entering into prepareResults");
        this.paginatedList = (EgovPaginatedList)this.searchResult;
        List list = this.paginatedList.getList();
        for (Object[] object : list) {
            DishonoredChequeBean chequeBean = new DishonoredChequeBean();
            chequeBean.setReceiptHeaderid(this.getLongValue(object[0]));
            chequeBean.setInstrumentHeaderid(this.getLongValue(object[1]));
            chequeBean.setReceiptNumber(this.getStringValue(object[2]));
            chequeBean.setReceiptDate(this.getDateValue(object[3]));
            chequeBean.setInstrumentNumber(this.getStringValue(object[4]));
            chequeBean.setInstrumentDate(this.getDateValue(object[5]));
            chequeBean.setInstrumentAmount(this.getBigDecimalValue(object[6]));
            chequeBean.setBankName(this.getStringValue(object[7]));
            chequeBean.setAccountNumber(this.getStringValue(object[8]));
            chequeBean.setPayTo(this.getStringValue(object[9]));
            chequeBean.setDescription(this.getStringValue(object[10]));
            this.dishonoredChequeDisplayList.add(chequeBean);
        }
        this.paginatedList.setList(this.dishonoredChequeDisplayList);
        LOGGER.debug((Object)"Exiting from prepareResults");
    }

    protected String getStringValue(Object object) {
        return object != null ? object.toString() : "";
    }

    protected String getDateValue(Object object) {
        return object != null ? this.formatter.format((Date)object) : "";
    }

    protected Long getLongValue(Object object) {
        return object != null ? Long.valueOf(object.toString()) : null;
    }

    private BigDecimal getBigDecimalValue(Object object) {
        return object != null ? new BigDecimal(object.toString()).setScale(2) : BigDecimal.ZERO.setScale(2);
    }

    public String getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public Long getAccountCodes() {
        return this.accountCodes;
    }

    public void setAccountCodes(Long accountCodes) {
        this.accountCodes = accountCodes;
    }

    public String getInstrumentMode() {
        return this.instrumentMode;
    }

    public void setInstrumentMode(String instrumentMode) {
        this.instrumentMode = instrumentMode;
    }

    public String getChequeNo() {
        return this.chequeNo;
    }

    public void setChequeNo(String chequeNo) {
        this.chequeNo = chequeNo;
    }

    public Date getChqDDDate() {
        return this.chqDDDate;
    }

    public void setChqDDDate(Date chqDDDate) {
        this.chqDDDate = chqDDDate;
    }

    public String getInstallmentIds() {
        return this.installmentIds;
    }

    public void setInstallmentIds(String installmentIds) {
        this.installmentIds = installmentIds;
    }

    public EgovPaginatedList getPaginatedList() {
        return this.paginatedList;
    }

    public void setPaginatedList(EgovPaginatedList paginatedList) {
        this.paginatedList = paginatedList;
    }

    public List<DishonoredChequeBean> getDishonoredChequeDisplayList() {
        return this.dishonoredChequeDisplayList;
    }

    public void setDishonoredChequeDisplayList(List<DishonoredChequeBean> dishonoredChequeDisplayList) {
        this.dishonoredChequeDisplayList = dishonoredChequeDisplayList;
    }
}

