/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import com.exilant.eGov.src.domain.BankReconciliationSummary;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.services.masters.BankService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="reconciliationSummary-new.jsp"), @Result(name="result", location="reconciliationSummary-result.jsp")})
public class BankReconciliationAction
extends BaseFormAction {
    @Autowired
    FinancialYearHibernateDAO financialYearDAO;
    private EgovCommon egovCommon;
    @Autowired
    BankService bankService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    private List<Bankbranch> branchList = Collections.EMPTY_LIST;
    private final List<Bankaccount> accountList = Collections.EMPTY_LIST;
    Date bankStmtDate = new Date();
    private String accountNumber;
    private Integer branchId;
    private Integer accountId;
    private Integer bankId;
    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
    Bankaccount bankAccount;
    String bankSDate;
    String balanceAsPerStatement;
    String bank;
    String accountNum;
    String branch;
    BigDecimal accountBalance;
    double unReconciledCr;
    double unReconciledCrOthers;
    double unReconciledDr;
    double unReconciledDrOthers;
    double unReconciledCrBrsEntry;
    double unReconciledDrBrsEntry;
    double subTotal;
    double netTotal;
    private static final Logger LOGGER = Logger.getLogger(BankReconciliationAction.class);
    @Autowired
    BankReconciliationSummary bankReconciliationSummary;

    public Object getModel() {
        return null;
    }

    @Action(value="/brs/bankReconciliation-newForm")
    public String newForm() {
        return "new";
    }

    public void prepare() {
        List allBankHavingAccounts = this.bankHibernateDAO.getAllBankHavingBranchAndAccounts();
        this.dropdownData.put("bankList", allBankHavingAccounts);
        this.dropdownData.put("branchList", this.branchList);
        this.dropdownData.put("accountList", this.accountList);
        if (this.branchId != null) {
            this.branchList = this.persistenceService.findAllBy("select  bb from Bankbranch bb,Bankaccount ba where bb.bank.id=? and ba.bankbranch=bb and bb.isactive=true", new Object[]{this.bankId});
            this.dropdownData.put("branchList", this.branchList);
        }
        if (this.accountId != null) {
            List accountList = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=? and isactive=true order by ba.chartofaccounts.glcode", new Object[]{this.branchId});
            this.dropdownData.put("accountList", accountList);
        }
    }

    @Action(value="/brs/bankReconciliation-brsSummary")
    public String brsSummary() {
        this.bankSDate = ((String[])this.parameters.get("bankStmtDate"))[0];
        this.balanceAsPerStatement = ((String[])this.parameters.get("bankStBalance"))[0];
        this.bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.accountId.longValue()});
        this.bank = this.bankAccount.getBankbranch().getBank().getName();
        this.accountNum = this.bankAccount.getAccountnumber();
        this.branch = this.bankAccount.getBankbranch().getBranchname();
        Date dt = new Date();
        try {
            dt = this.sdf.parse(this.bankSDate);
            this.accountBalance = this.egovCommon.getAccountBalance(dt, this.bankAccount.getId());
            CFinancialYear finYearByDate = this.financialYearDAO.getFinYearByDate(dt);
            String recDate = this.formatter.format(dt);
            Date fromDate = finYearByDate.getStartingDate();
            String unReconciledDrCr = this.bankReconciliationSummary.getUnReconciledDrCr(Integer.valueOf(this.bankAccount.getId().intValue()), fromDate, dt);
            String[] drcrValues = unReconciledDrCr.split("/");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  unReconciledDrCr   " + unReconciledDrCr));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  drcrValues[]   " + drcrValues[1]));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  drcrValues   " + drcrValues.length));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(drcrValues[0] + "  " + drcrValues[1] + "  " + drcrValues[2] + "   " + drcrValues[3]));
            }
            this.unReconciledCr = Double.parseDouble(drcrValues[0]);
            this.unReconciledCrOthers = Double.parseDouble(drcrValues[1]);
            this.unReconciledDr = Double.parseDouble(drcrValues[2]);
            this.unReconciledDrOthers = Double.parseDouble(drcrValues[3]);
            this.unReconciledCrBrsEntry = Double.parseDouble(drcrValues[4]);
            this.unReconciledDrBrsEntry = Double.parseDouble(drcrValues[5]);
            this.subTotal = this.unReconciledCr + this.unReconciledCrOthers + this.accountBalance.doubleValue();
            this.netTotal = this.unReconciledCr + this.unReconciledCrOthers + this.accountBalance.doubleValue() + this.unReconciledDr + this.unReconciledDrOthers;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "result";
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getBankStmtDate() {
        return this.bankStmtDate;
    }

    public String getBankSDate() {
        return this.bankSDate;
    }

    public String getBalanceAsPerStatement() {
        return this.balanceAsPerStatement;
    }

    public String getBank() {
        return this.bank;
    }

    public String getAccountNum() {
        return this.accountNum;
    }

    public void setBankStmtDate(Date bankStmtDate) {
        this.bankStmtDate = bankStmtDate;
    }

    public void setBankSDate(String bankSDate) {
        this.bankSDate = bankSDate;
    }

    public void setBalanceAsPerStatement(String balanceAsPerStatement) {
        this.balanceAsPerStatement = balanceAsPerStatement;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public BigDecimal getAccountBalance() {
        return this.accountBalance;
    }

    public double getUnReconciledCr() {
        return this.unReconciledCr;
    }

    public double getUnReconciledCrOthers() {
        return this.unReconciledCrOthers;
    }

    public double getUnReconciledDr() {
        return this.unReconciledDr;
    }

    public double getUnReconciledDrOthers() {
        return this.unReconciledDrOthers;
    }

    public double getUnReconciledCrBrsEntry() {
        return this.unReconciledCrBrsEntry;
    }

    public double getUnReconciledDrBrsEntry() {
        return this.unReconciledDrBrsEntry;
    }

    public double getSubTotal() {
        return this.subTotal;
    }

    public double getNetTotal() {
        return this.netTotal;
    }

    public void setAccountBalance(BigDecimal accountBalance) {
        this.accountBalance = accountBalance;
    }

    public void setUnReconciledCr(double unReconciledCr) {
        this.unReconciledCr = unReconciledCr;
    }

    public void setUnReconciledCrOthers(double unReconciledCrOthers) {
        this.unReconciledCrOthers = unReconciledCrOthers;
    }

    public void setUnReconciledDr(double unReconciledDr) {
        this.unReconciledDr = unReconciledDr;
    }

    public void setUnReconciledDrOthers(double unReconciledDrOthers) {
        this.unReconciledDrOthers = unReconciledDrOthers;
    }

    public void setUnReconciledCrBrsEntry(double unReconciledCrBrsEntry) {
        this.unReconciledCrBrsEntry = unReconciledCrBrsEntry;
    }

    public void setUnReconciledDrBrsEntry(double unReconciledDrBrsEntry) {
        this.unReconciledDrBrsEntry = unReconciledDrBrsEntry;
    }

    public void setSubTotal(double subTotal) {
        this.subTotal = subTotal;
    }

    public void setNetTotal(double netTotal) {
        this.netTotal = netTotal;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public Integer getAccountId() {
        return this.accountId;
    }

    public Integer getBankId() {
        return this.bankId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public void setAccountId(Integer accountId) {
        this.accountId = accountId;
    }

    public void setBankId(Integer bankId) {
        this.bankId = bankId;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }
}

