/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.Bankreconciliation;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.web.actions.brs.AutoReconcileHelper;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.model.brs.AutoReconcileBean;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="autoReconciliation-new.jsp"), @Result(name="result", location="autoReconciliation-result.jsp"), @Result(name="report", location="autoReconciliation-report.jsp"), @Result(name="upload", location="autoReconciliation-upload.jsp"), @Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=AutoReconcileReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=AutoReconcileReport.xls"})})
public class AutoReconciliationAction
extends BaseFormAction {
    private static final long serialVersionUID = -4207341983597707193L;
    private static final Logger LOGGER = Logger.getLogger(AutoReconciliationAction.class);
    private List<Bankbranch> branchList = Collections.EMPTY_LIST;
    private final List<Bankaccount> accountList = Collections.EMPTY_LIST;
    private Integer accountId;
    private Integer bankId;
    private Integer branchId;
    private Date reconciliationDate;
    private Date fromDate;
    private Date toDate;
    private String accNo;
    private File bankStatmentInXls;
    private String bankStatmentInXlsFileName;
    private String failureMessage = "Invalid data in  the  following row(s), please correct and upload again\n";
    private final String successMessage = "BankStatement upload completed Successfully # rows processed";
    private boolean isFailed;
    private final String jasperpath = "/reports/templates/AutoReconcileReport.jasper";
    private ReportHelper reportHelper;
    private InputStream inputStream;
    private final String BRS_MESSAGE_MORE_THAN_ONE_MATCH = "found more than one match in instruments";
    private final String BRS_MESSAGE_DUPPLICATE_IN_BANKSTATEMENT = "duplicate instrument number within the bankstament";
    private List<AutoReconcileBean> statementsNotInBankBookList;
    private List<AutoReconcileBean> statementsFoundButNotProcessed;
    private FinancialYearDAO financialYearDAO;
    private Date finYearStartDate;
    private List<AutoReconcileBean> entriesNotInBankStament;
    private Bankaccount bankAccount;
    private BigDecimal notInBooktotalDebit;
    private BigDecimal notInBooktotalCredit;
    private BigDecimal notprocessedCredit;
    private BigDecimal notprocessedDebit;
    private BigDecimal notprocessedNet;
    private BigDecimal notInBookNet;
    private String notInBookNetBal;
    private BigDecimal notInStatementTotalDebit;
    private BigDecimal notInStatementTotalCredit;
    private BigDecimal notInStatementNet;
    private BigDecimal bankBookBalance;
    @Autowired
    private AutoReconcileHelper autoReconcileHelper;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    private BigDecimal brsBalance;
    private BigDecimal totalNotReconciledAmount;
    private Integer statusId;

    public BigDecimal getBankBookBalance() {
        return this.autoReconcileHelper.getBankBookBalance();
    }

    public void setBankBookBalance(BigDecimal bankBookBalance) {
        this.bankBookBalance = bankBookBalance;
    }

    public BigDecimal getBrsBalance() {
        return this.autoReconcileHelper.getBrsBalance();
    }

    public void setBrsBalance(BigDecimal brsBalance) {
        this.brsBalance = brsBalance;
    }

    public Bankaccount getBankAccount() {
        return this.autoReconcileHelper.getBankAccount();
    }

    public void setBankAccount(Bankaccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Object getModel() {
        return new Bankreconciliation();
    }

    public void prepare() {
        List allBankHavingAccounts = this.bankHibernateDAO.getAllBankHavingBranchAndAccounts();
        this.dropdownData.put("bankList", allBankHavingAccounts);
        this.dropdownData.put("branchList", this.branchList);
        this.dropdownData.put("accountList", this.accountList);
        if (this.branchId != null) {
            this.branchList = this.persistenceService.findAllBy("select  bb from Bankbranch bb,Bankaccount ba where bb.bank.id=? and ba.bankbranch=bb and bb.isactive=true", new Object[]{this.bankId});
            this.dropdownData.put("branchList", this.branchList);
        }
        if (this.accountId != null) {
            List accountList = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=? and isactive=true order by ba.chartofaccounts.glcode", new Object[]{this.branchId});
            this.dropdownData.put("accountList", accountList);
        }
    }

    private void setup() {
        this.autoReconcileHelper.setAccountId(this.accountId.intValue());
        this.autoReconcileHelper.setReconciliationDate(this.reconciliationDate);
        this.autoReconcileHelper.setFromDate(this.fromDate);
        this.autoReconcileHelper.setToDate(this.toDate);
        this.autoReconcileHelper.setBankStatmentInXls(this.bankStatmentInXls);
        this.autoReconcileHelper.setBankStatmentInXlsFileName(this.bankStatmentInXlsFileName);
    }

    @Action(value="/brs/autoReconciliation-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/brs/autoReconciliation-beforeUpload")
    public String beforeUpload() {
        return "upload";
    }

    @Action(value="/brs/autoReconciliation-upload")
    @ValidationErrorPage(value="upload")
    public String upload() {
        this.setup();
        this.autoReconcileHelper.upload();
        return "upload";
    }

    public void validate() {
    }

    public String getMessage() {
        return this.autoReconcileHelper.getMessage();
    }

    public String getFailureMessage() {
        return this.autoReconcileHelper.getFailureMessage();
    }

    @Action(value="/brs/autoReconciliation-schedule")
    public String schedule() {
        this.setup();
        this.autoReconcileHelper.schedule();
        return "result";
    }

    public int getRowCount() {
        return this.autoReconcileHelper.getRowCount();
    }

    public int getCount() {
        return this.autoReconcileHelper.getCount();
    }

    @Action(value="/brs/autoReconciliation-generateReport")
    public String generateReport() {
        this.setup();
        this.autoReconcileHelper.generateReport();
        return "report";
    }

    public BigDecimal getTotalNotReconciledAmount() {
        return this.autoReconcileHelper.getTotalNotReconciledAmount();
    }

    public BigDecimal getNotInBooktotalDebit() {
        return this.autoReconcileHelper.getNotInBooktotalDebit();
    }

    public BigDecimal getNotInBooktotalCredit() {
        return this.autoReconcileHelper.getNotInBooktotalCredit();
    }

    public BigDecimal getNotInBookNet() {
        return this.autoReconcileHelper.getNotInBookNet();
    }

    public BigDecimal getNotInStatementTotalDebit() {
        return this.autoReconcileHelper.getNotInStatementTotalDebit();
    }

    public BigDecimal getNotInStatementTotalCredit() {
        return this.autoReconcileHelper.getNotInStatementTotalCredit();
    }

    public BigDecimal getNotInStatementNet() {
        return this.autoReconcileHelper.getNotInStatementNet();
    }

    public Date getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public File getBankStatmentInXls() {
        return this.bankStatmentInXls;
    }

    public void setBankStatmentInXls(File bankStatmentInXls) {
        this.bankStatmentInXls = bankStatmentInXls;
    }

    public void setBankStatmentInXlsContentType(String bankStatmentInXlsContentType) {
    }

    public void setBankStatmentInXlsFileName(String bankStatmentInXlsFileName) {
        this.bankStatmentInXlsFileName = bankStatmentInXlsFileName;
    }

    public String getAccNo() {
        return this.accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public int getBankId() {
        return this.bankId;
    }

    public int getBranchId() {
        return this.branchId;
    }

    public void setBankId(int bankId) {
        this.bankId = bankId;
    }

    public void setBranchId(int branchId) {
        this.branchId = branchId;
    }

    public List<AutoReconcileBean> getStatementsNotInBankBookList() {
        return this.autoReconcileHelper.getStatementsNotInBankBookList();
    }

    public void setStatementsNotInBankBookList(List<AutoReconcileBean> statementsNotInBankBookList) {
        this.statementsNotInBankBookList = statementsNotInBankBookList;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public List<AutoReconcileBean> getEntriesNotInBankStament() {
        return this.autoReconcileHelper.getEntriesNotInBankStament();
    }

    public void setEntriesNotInBankStament(List<AutoReconcileBean> entriesNotInBankStament) {
        this.entriesNotInBankStament = entriesNotInBankStament;
    }

    public List<AutoReconcileBean> getStatementsFoundButNotProcessed() {
        return this.autoReconcileHelper.getStatementsFoundButNotProcessed();
    }

    public BigDecimal getNotprocessedNet() {
        return this.autoReconcileHelper.getNotprocessedNet();
    }

    public void setStatementsFoundButNotProcessed(List<AutoReconcileBean> statementsFoundButNotProcessed) {
        this.statementsFoundButNotProcessed = statementsFoundButNotProcessed;
    }

    public void setNotprocessedNet(BigDecimal notprocessedNet) {
        this.notprocessedNet = notprocessedNet;
    }

    @Action(value="/brs/autoReconciliation-generatePDF")
    public String generatePDF() throws Exception {
        ArrayList<AutoReconcileBean> dataSource = new ArrayList<AutoReconcileBean>();
        AutoReconcileBean AutoReconcileObj = new AutoReconcileBean();
        this.generateReport();
        if (this.getStatementsNotInBankBookList().size() == 0) {
            AutoReconcileObj.setNoDetailsFound("No Dteails Found");
            this.getStatementsNotInBankBookList().add(AutoReconcileObj);
        }
        for (AutoReconcileBean row : this.getStatementsNotInBankBookList()) {
            dataSource.add(row);
        }
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, "/reports/templates/AutoReconcileReport.jasper", this.getParamMap(), dataSource);
        return "PDF";
    }

    @Action(value="/brs/autoReconciliation-generateXLS")
    public String generateXLS() throws JRException, IOException {
        ArrayList<AutoReconcileBean> dataSource = new ArrayList<AutoReconcileBean>();
        AutoReconcileBean AutoReconcileObj = new AutoReconcileBean();
        this.generateReport();
        if (this.getStatementsNotInBankBookList().size() == 0) {
            AutoReconcileObj.setNoDetailsFound("No Details Found");
            this.getStatementsNotInBankBookList().add(AutoReconcileObj);
        }
        for (AutoReconcileBean row : this.getStatementsNotInBankBookList()) {
            dataSource.add(row);
        }
        this.inputStream = this.reportHelper.exportXls(this.inputStream, "/reports/templates/AutoReconcileReport.jasper", this.getParamMap(), dataSource);
        return "XLS";
    }

    protected Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        AutoReconcileBean AutoReconcileObj = new AutoReconcileBean();
        paramMap.put("heading", "Bank reconcilation statement from " + Constants.DDMMYYYYFORMAT2.format(this.fromDate) + " to " + Constants.DDMMYYYYFORMAT2.format(this.toDate));
        paramMap.put("bankName", this.autoReconcileHelper.getBankAccount().getBankbranch().getBank().getName());
        paramMap.put("accountNumber", this.autoReconcileHelper.getBankAccount().getAccountnumber());
        paramMap.put("accountCode", this.autoReconcileHelper.getBankAccount().getChartofaccounts().getGlcode());
        paramMap.put("accountDescription", this.autoReconcileHelper.getBankAccount().getChartofaccounts().getName());
        paramMap.put("bankBookBalance", this.autoReconcileHelper.getBankBookBalance());
        paramMap.put("notInBookNet", this.autoReconcileHelper.getNotInBookNetBal());
        paramMap.put("notprocessedNet", this.autoReconcileHelper.getNotprocessedNet());
        paramMap.put("notInStatementNet", this.autoReconcileHelper.getNotInStatementNet());
        paramMap.put("totalNotReconciledAmount", this.autoReconcileHelper.getTotalNotReconciledAmount());
        paramMap.put("brsBalance", this.autoReconcileHelper.getBrsBalance());
        ArrayList<AutoReconcileBean> statementDataSource = new ArrayList<AutoReconcileBean>();
        ArrayList<AutoReconcileBean> entriesNotInBankStamentDataSource = new ArrayList<AutoReconcileBean>();
        paramMap.put("BankStatement", this.reportHelper.getClass().getResourceAsStream("/reports/templates/BankStatement.jasper"));
        if (this.getStatementsFoundButNotProcessed().size() == 0) {
            AutoReconcileObj.setNoDetailsFound("No Details Found");
            this.autoReconcileHelper.getStatementsFoundButNotProcessed().add(AutoReconcileObj);
        }
        for (AutoReconcileBean row : this.getStatementsFoundButNotProcessed()) {
            statementDataSource.add(row);
        }
        paramMap.put("statementsFoundButNotProcessedList", statementDataSource);
        paramMap.put("EntriesNotinBankStatement", this.reportHelper.getClass().getResourceAsStream("/reports/templates/BankBookEntriesNotinBankStatement.jasper"));
        if (this.getEntriesNotInBankStament().size() == 0) {
            AutoReconcileObj.setNoDetailsFound("No Details Found");
            this.getEntriesNotInBankStament().add(AutoReconcileObj);
        }
        for (AutoReconcileBean row : this.getEntriesNotInBankStament()) {
            entriesNotInBankStamentDataSource.add(row);
        }
        paramMap.put("BankBookEntriesNotinBankStatementList", entriesNotInBankStamentDataSource);
        return paramMap;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getNotInBookNetBal() {
        return this.autoReconcileHelper.getNotInBookNetBal();
    }

    public void setNotInBookNetBal(String notInBookNetBal) {
        this.notInBookNetBal = notInBookNetBal;
    }
}

