/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgPartytype;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.egf.web.adaptor.RecoveryJsonAdaptor;
import org.egov.model.recoveries.Recovery;
import org.egov.model.service.RecoveryService;
import org.egov.services.masters.BankService;
import org.egov.services.masters.EgPartyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/recovery"})
public class RecoveryController {
    private static final String RECOVERY_NEW = "recovery-new";
    private static final String RECOVERY_RESULT = "recovery-result";
    private static final String RECOVERY_EDIT = "recovery-edit";
    private static final String RECOVERY_VIEW = "recovery-view";
    private static final String RECOVERY_SEARCH = "recovery-search";
    @Autowired
    @Qualifier(value="remittanceRecoveryService")
    private RecoveryService recoveryService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    @Qualifier(value="bankService")
    private BankService bankService;
    @Autowired
    @Qualifier(value="egPartyTypeService")
    private EgPartyTypeService egPartyTypeService;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;

    private void prepareNewForm(Model model) {
        model.addAttribute("chartOfAccountss", (Object)Collections.EMPTY_LIST);
        model.addAttribute("chartOfAccounts", (Object)this.chartOfAccountsDAO.getForRecovery());
        model.addAttribute("egPartytypes", (Object)this.egPartyTypeService.findAll());
        model.addAttribute("banks", (Object)this.bankService.findAll());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("recovery", (Object)new Recovery());
        return RECOVERY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Recovery recovery, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return RECOVERY_NEW;
        }
        if (recovery.getBank() != null && recovery.getBank().getId() != null) {
            recovery.setBank((Bank)this.bankService.findById((Serializable)recovery.getBank().getId(), false));
        } else {
            recovery.setBank(null);
        }
        recovery.setChartofaccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)recovery.getChartofaccounts().getId(), false));
        recovery.setEgPartytype((EgPartytype)this.egPartyTypeService.findById((Serializable)recovery.getEgPartytype().getId(), false));
        this.recoveryService.create(recovery);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.recovery.success", null, null));
        return "redirect:/recovery/result/" + recovery.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Recovery recovery = this.recoveryService.findOne(id);
        if (recovery.getBank() != null && recovery.getBank().getId() != null) {
            recovery.setBankLoan(Boolean.valueOf(true));
        }
        ArrayList<CChartOfAccounts> coas = new ArrayList<CChartOfAccounts>();
        CChartOfAccounts coa = (CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)recovery.getChartofaccounts().getId(), false);
        coas.add(coa);
        this.prepareNewForm(model);
        recovery.setChartofaccounts(coa);
        model.addAttribute("chartOfAccountss", coas);
        model.addAttribute("recovery", (Object)recovery);
        return RECOVERY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Recovery recovery, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return RECOVERY_EDIT;
        }
        if (recovery.getBank() != null && recovery.getBank().getId() != null) {
            recovery.setBank((Bank)this.bankService.findById((Serializable)recovery.getBank().getId(), false));
        } else {
            recovery.setBank(null);
        }
        recovery.setChartofaccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)recovery.getChartofaccounts().getId(), false));
        recovery.setEgPartytype((EgPartytype)this.egPartyTypeService.findById((Serializable)recovery.getEgPartytype().getId(), false));
        this.recoveryService.update(recovery);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.recovery.success", null, null));
        return "redirect:/recovery/result/" + recovery.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Recovery recovery = this.recoveryService.findOne(id);
        if (recovery.getBank() != null && recovery.getBank().getId() != null) {
            recovery.setBankLoan(Boolean.valueOf(true));
        }
        this.prepareNewForm(model);
        model.addAttribute("recovery", (Object)recovery);
        return RECOVERY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Recovery recovery = this.recoveryService.findOne(id);
        model.addAttribute("recovery", (Object)recovery);
        return RECOVERY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Recovery recovery = new Recovery();
        this.prepareNewForm(model);
        model.addAttribute("recovery", (Object)recovery);
        return RECOVERY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Recovery recovery) {
        if (recovery != null && recovery.getChartofaccounts().getId() != null) {
            recovery.setChartofaccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)recovery.getChartofaccounts().getId(), false));
        }
        List searchResultList = this.recoveryService.search(recovery);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/ajax/getAccountCodes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CChartOfAccounts> getAccountCodes(@RequestParam(value="subLedgerCode") String subLedgerCode) {
        List accounts = this.chartOfAccountsDAO.getBySubLedgerCode(subLedgerCode);
        return accounts;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Recovery.class, (Object)new RecoveryJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

