/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.commons.Fundsource;
import org.egov.commons.service.FundsourceService;
import org.egov.egf.web.adaptor.FundsourceJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/fundsource"})
public class FundsourceController {
    private static final String FUNDSOURCE_NEW = "fundsource-new";
    private static final String FUNDSOURCE_RESULT = "fundsource-result";
    private static final String FUNDSOURCE_EDIT = "fundsource-edit";
    private static final String FUNDSOURCE_VIEW = "fundsource-view";
    private static final String FUNDSOURCE_SEARCH = "fundsource-search";
    @Autowired
    private FundsourceService fundsourceService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
        model.addAttribute("fundsources", (Object)this.fundsourceService.findAll());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("fundsource", (Object)new Fundsource());
        return FUNDSOURCE_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Fundsource fundsource, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUNDSOURCE_NEW;
        }
        this.fundsourceService.create(fundsource);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fundsource.success", null, Locale.ENGLISH));
        return "redirect:/fundsource/result/" + fundsource.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Fundsource fundsource = this.fundsourceService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("fundsource", (Object)fundsource);
        return FUNDSOURCE_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Fundsource fundsource, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUNDSOURCE_EDIT;
        }
        this.fundsourceService.update(fundsource);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fundsource.success", null, Locale.ENGLISH));
        return "redirect:/fundsource/result/" + fundsource.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Fundsource fundsource = this.fundsourceService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("fundsource", (Object)fundsource);
        return FUNDSOURCE_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Fundsource fundsource = this.fundsourceService.findOne(id);
        model.addAttribute("fundsource", (Object)fundsource);
        return FUNDSOURCE_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Fundsource fundsource = new Fundsource();
        this.prepareNewForm(model);
        model.addAttribute("fundsource", (Object)fundsource);
        return FUNDSOURCE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Fundsource fundsource) {
        List searchResultList = this.fundsourceService.search(fundsource);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Fundsource.class, (Object)new FundsourceJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

