/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Fund;
import org.egov.commons.service.FundService;
import org.egov.egf.web.adaptor.FundJsonAdaptor;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/fund"})
public class FundController {
    private static final String FUND_NEW = "fund-new";
    private static final String FUND_RESULT = "fund-result";
    private static final String FUND_EDIT = "fund-edit";
    private static final String FUND_VIEW = "fund-view";
    private static final String FUND_SEARCH = "fund-search";
    @Autowired
    private FundService fundService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UserService userService;
    @Autowired
    private EgovMasterDataCaching egovMasterDataCaching;

    private void prepareNewForm(Model model) {
        model.addAttribute("funds", (Object)this.fundService.findByIsnotleaf());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("fund", (Object)new Fund());
        return FUND_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Fund fund, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUND_NEW;
        }
        fund.setCreatedDate(new Date());
        this.fundService.create(fund);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fund.success", null, null));
        EgovMasterDataCaching.removeFromCache((String)"egi-fund");
        return "redirect:/fund/result/" + fund.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        Fund fund = this.fundService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("fund", (Object)fund);
        return FUND_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Fund fund, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUND_EDIT;
        }
        this.fundService.update(fund);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fund.success", null, null));
        EgovMasterDataCaching.removeFromCache((String)"egi-fund");
        return "redirect:/fund/result/" + fund.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        Fund fund = this.fundService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("fund", (Object)fund);
        return FUND_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Integer id, Model model) {
        Fund fund = this.fundService.findOne(id);
        model.addAttribute("fund", (Object)fund);
        return FUND_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Fund fund = new Fund();
        this.prepareNewForm(model);
        model.addAttribute("fund", (Object)fund);
        return FUND_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Fund fund) {
        List searchResultList = this.fundService.search(fund);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Fund.class, (Object)new FundJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

