/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import java.io.Serializable;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetUploadReport;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/approvebudget"})
public class ApproveBudgetController {
    private static final String APPROVEBUDGET_SEARCH = "approvebudget-search";
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;

    private void prepareNewForm(Model model) {
        model.addAttribute("budgets", (Object)this.budgetService.getBudgetsForUploadReport());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        BudgetUploadReport budgetUploadReport = new BudgetUploadReport();
        this.prepareNewForm(model);
        model.addAttribute("budgetUploadReport", (Object)budgetUploadReport);
        return APPROVEBUDGET_SEARCH;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute BudgetUploadReport budgetUploadReport, BindingResult errors, RedirectAttributes redirectAttrs) {
        Budget reBudget = (Budget)this.budgetService.findById((Serializable)budgetUploadReport.getReBudget().getId(), false);
        Budget beBudget = this.budgetService.getReferenceBudgetFor(reBudget);
        this.budgetService.updateByMaterializedPath(reBudget.getMaterializedPath());
        this.budgetDetailService.updateByMaterializedPath(reBudget.getMaterializedPath());
        this.budgetService.updateByMaterializedPath(beBudget.getMaterializedPath());
        this.budgetDetailService.updateByMaterializedPath(beBudget.getMaterializedPath());
        this.chartOfAccountsService.updateActiveForPostingByMaterializedPath(reBudget.getMaterializedPath());
        redirectAttrs.addFlashAttribute("message", (Object)"msg.uploaded.budget.success");
        return "redirect:/approvebudget/search";
    }
}

