/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillregister;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.pims.service.EisUtilService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.egov.utils.VoucherHelper;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="billVoucher-new.jsp")})
public class BillVoucherAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BillVoucherAction.class);
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    private EisCommonService eisCommonService;
    private VoucherService voucherService;
    private String expType;
    private String billNumber;
    private List<EgBillregister> preApprovedVoucherList;
    private VoucherTypeBean voucherTypeBean;
    private EisUtilService eisUtilService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private AppConfigValueService appConfigValueService;

    public VoucherTypeBean getVoucherTypeBean() {
        return this.voucherTypeBean;
    }

    public void setVoucherTypeBean(VoucherTypeBean voucherTypeBean) {
        this.voucherTypeBean = voucherTypeBean;
    }

    public void prepare() {
        super.prepare();
        if (this.mandatoryFields.contains("department")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        }
    }

    @Action(value="/voucher/billVoucher-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillVoucherAction | newform | START");
        }
        List listBillReg = VoucherHelper.EXPENDITURE_TYPES;
        LinkedHashMap<String, String> expTypeList = new LinkedHashMap<String, String>();
        for (String expType : listBillReg) {
            expTypeList.put(expType, expType);
        }
        this.addDropdownData("expTypeList", listBillReg);
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/voucher/billVoucher-lists")
    public String lists() throws ValidationException {
        StringBuffer query = new StringBuffer(300);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Expenditure Type selected :=" + this.expType));
        }
        try {
            String statusid = this.getApprovalStatusForBills();
            query.append("from EgBillregister br where br.status.id in(").append(statusid).append(")and ( br.egBillregistermis.voucherHeader is null or br.egBillregistermis.voucherHeader in (from CVoucherHeader vh where vh.status =? ))");
            if (null != this.billNumber && StringUtils.isNotEmpty((String)this.billNumber)) {
                query.append(" and br.billnumber='").append(this.billNumber).append("'");
            }
            if (null != this.voucherHeader.getVouchermis().getDepartmentid()) {
                query.append(" and br.egBillregistermis.egDepartment.id=").append(this.voucherHeader.getVouchermis().getDepartmentid().getId());
            }
            if (null != this.voucherTypeBean.getVoucherDateFrom() && StringUtils.isNotEmpty((String)this.voucherTypeBean.getVoucherDateFrom())) {
                query.append(" and br.billdate>='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(this.voucherTypeBean.getVoucherDateFrom()))).append("'");
            }
            if (null != this.voucherTypeBean.getVoucherDateTo() && StringUtils.isNotEmpty((String)this.voucherTypeBean.getVoucherDateTo())) {
                query.append(" and br.billdate<='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(this.voucherTypeBean.getVoucherDateTo()))).append("'");
            }
            this.preApprovedVoucherList = this.persistenceService.findAllBy(query.toString(), new Object[]{4});
            if (this.preApprovedVoucherList.size() == 0) {
                this.addActionError("No records found.");
            }
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("not a valid date", "not a valid date")));
        }
        return this.newForm();
    }

    public List<WorkflowAction> getValidActions(String purpose) {
        ArrayList<WorkflowAction> validButtons = new ArrayList<WorkflowAction>();
        Script validScript = (Script)this.getPersistenceService().findAllByNamedQuery("Script.findByName", new Object[]{"pjv.validbuttons"}).get(0);
        List list = (List)this.scriptService.executeScript(validScript, ScriptService.createContext((Object[])new Object[]{"eisCommonServiceBean", this.eisCommonService, "userId", ApplicationThreadLocals.getUserId().intValue(), "date", new Date(), "purpose", purpose}));
        for (Object s : list) {
            if ("invalid".equals(s)) break;
            WorkflowAction action = (WorkflowAction)this.getPersistenceService().find(" from WorkflowAction where type='CVoucherHeader' and name=?", new Object[]{s.toString()});
            validButtons.add(action);
        }
        return validButtons;
    }

    private String getApprovalStatusForBills() {
        String statusid = "";
        List appConfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", this.expType + "BillApprovalStatus");
        if (appConfigList.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("Status for bill approval", "App Config value is missing for exp type :" + this.expType)));
        }
        for (AppConfigValues appConfigVal : appConfigList) {
            String configvalue = appConfigVal.getValue();
            EgwStatus egwstatus = this.egwStatusDAO.getStatusByModuleAndCode(configvalue.substring(0, configvalue.indexOf("|")), configvalue.substring(configvalue.indexOf("|") + 1));
            if (null == egwstatus || null == egwstatus.getId()) {
                throw new ValidationException(Arrays.asList(new ValidationError("Status for bill approval", " status for " + this.expType + " approval is not present in Egwstatus for app config value : " + configvalue)));
            }
            statusid = statusid.isEmpty() ? egwstatus.getId().toString() : statusid + "," + egwstatus.getId();
        }
        return statusid;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public String getExpType() {
        return this.expType;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public List<EgBillregister> getPreApprovedVoucherList() {
        return this.preApprovedVoucherList;
    }

    public void setPreApprovedVoucherList(List<EgBillregister> preApprovedVoucherList) {
        this.preApprovedVoucherList = preApprovedVoucherList;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public EisUtilService getEisUtilService() {
        return this.eisUtilService;
    }

    public void setEisUtilService(EisUtilService eisUtilService) {
        this.eisUtilService = eisUtilService;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
    }
}

