/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.contra.ContraBean;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.service.EisUtilService;
import org.egov.services.financingsource.FinancingSourceService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.VoucherHelper;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseVoucherAction
extends GenericWorkFlowAction {
    private static final long serialVersionUID = 1L;
    protected final String INVALIDPAGE = "invalidPage";
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    private static final Logger LOGGER = Logger.getLogger(BaseVoucherAction.class);
    public WorkflowBean workflowBean = new WorkflowBean();
    public CVoucherHeader voucherHeader = new CVoucherHeader();
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    protected String voucherNumManual;
    protected UserService userMngr;
    protected EisUtilService eisService;
    protected AssignmentService assignmentService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    protected SecurityUtils securityUtils;
    protected String reversalVoucherNumber;
    protected String reversalVoucherDate;
    final List<HashMap<String, Object>> accountdetails = new ArrayList();
    final List<HashMap<String, Object>> subledgerDetails = new ArrayList();
    private Integer voucherNumberPrefixLength;
    public static final String ZERO = "0";
    private FinancingSourceService financingSourceService;
    List<String> voucherTypes = VoucherHelper.VOUCHER_TYPES;
    @Autowired
    private CreateVoucher createVoucher;
    Map<String, List<String>> voucherNames = VoucherHelper.VOUCHER_TYPE_NAMES;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    public BaseVoucherAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.function", CFunction.class);
        this.addRelatedEntity("vouchermis.fundsource", Fundsource.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
    }

    public StateAware getModel() {
        return this.voucherHeader;
    }

    @SkipValidation
    public String newform() {
        return "new";
    }

    public void prepare() {
        super.prepare();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Prepare method");
        }
        this.getHeaderMandateFields();
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.headerFields.contains("function")) {
            this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.masterDataCache.get("egi-fundSource"));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        this.addDropdownData("typeList", VoucherHelper.VOUCHER_TYPES);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of  MIS attributes are :" + this.headerFields.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of mandate MIS attributes are :" + this.mandatoryFields.size()));
        }
    }

    @Deprecated
    protected void getHeaderMandateFields() {
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf("|"));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf("|") + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
        this.setOneFunctionCenterValue();
        this.mandatoryFields.add("voucherdate");
    }

    public void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.workFlowAction);
        this.workflowBean.setCurrentState(this.currentState);
    }

    public boolean isOneFunctionCenter() {
        this.setOneFunctionCenterValue();
        return this.voucherHeader.getIsRestrictedtoOneFunctionCenter();
    }

    public void setOneFunctionCenterValue() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "ifRestrictedToOneFunctionCenter");
        if (appConfigValues == null || appConfigValues.isEmpty()) {
            throw new ValidationException("Error", "ifRestrictedToOneFunctionCenter is not defined", new String[0]);
        }
        this.voucherHeader.setIsRestrictedtoOneFunctionCenter(Boolean.valueOf(((AppConfigValues)appConfigValues.get(0)).getValue().equalsIgnoreCase("yes")));
    }

    public boolean isBankBalanceMandatory() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "bank_balance_mandatory");
        if (appConfigValues == null) {
            throw new ValidationException("", "bank_balance_mandatory parameter is not defined", new String[0]);
        }
        return ((AppConfigValues)appConfigValues.get(0)).getValue().equals("Y");
    }

    protected void loadSchemeSubscheme() {
        if (this.headerFields.contains("scheme") && null != this.voucherHeader.getFundId()) {
            this.addDropdownData("schemeList", this.getPersistenceService().findAllBy("from Scheme where fund=?", new Object[]{this.voucherHeader.getFundId()}));
        }
        if (this.headerFields.contains("subscheme") && this.voucherHeader.getVouchermis() != null && null != this.voucherHeader.getVouchermis().getSchemeid()) {
            this.addDropdownData("subschemeList", this.getPersistenceService().findAllBy("from SubScheme where scheme.id=? and isActive=true order by name", new Object[]{this.voucherHeader.getVouchermis().getSchemeid().getId()}));
        }
    }

    protected void loadFundSource() {
        if (this.headerFields.contains("fundsource") && null != this.voucherHeader.getVouchermis().getSubschemeid()) {
            List fundSourceList = this.financingSourceService.getFinancialSourceBasedOnSubScheme(this.voucherHeader.getVouchermis().getSubschemeid().getId());
            this.addDropdownData("fundsourceList", fundSourceList);
        }
    }

    protected HashMap<String, Object> createHeaderAndMisDetails() throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", this.voucherHeader.getName());
        headerdetails.put("vouchertype", this.voucherHeader.getType());
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, this.voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", this.voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", this.voucherHeader.getVoucherDate());
        headerdetails.put("description", this.voucherHeader.getDescription());
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", this.voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (this.voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", this.voucherHeader.getFundId().getCode());
        }
        if (this.voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", this.voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (this.voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", this.voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (this.voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", this.voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (this.voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", this.voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (this.voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", this.voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (this.voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", this.voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    @Deprecated
    protected void validateFields() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Validate Method");
        }
        this.checkMandatoryField("vouchernumber", (Object)this.voucherHeader.getVoucherNumber(), "voucher.field.vouchernumber");
        this.checkMandatoryField("voucherdate", (Object)this.voucherHeader.getVoucherDate(), "voucher.field.voucherdate");
        this.checkMandatoryField("fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
        this.checkMandatoryField("function", (Object)this.voucherHeader.getVouchermis().getFunction(), "voucher.function.mandatory");
        this.checkMandatoryField("department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
        this.checkMandatoryField("scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
        this.checkMandatoryField("subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
        this.checkMandatoryField("functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatoryField("fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatoryField("field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
    }

    protected void checkMandatoryField(String fieldName, Object value, String errorKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Filed name :=" + fieldName + " Value = :" + value));
        }
        if (this.mandatoryFields.contains(fieldName) && (value == null || StringUtils.isEmpty((String)value.toString()))) {
            throw new ValidationException(Arrays.asList(new ValidationError(errorKey, errorKey)));
        }
    }

    public CVoucherHeader createVoucherAndledger(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist) {
        try {
            HashMap headerDetails = this.createHeaderAndMisDetails();
            HashMap<String, String> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            HashMap<String, String> glcodeMap = new HashMap<String, String>();
            for (VoucherDetails voucherDetail : billDetailslist) {
                detailMap = new HashMap();
                if (voucherDetail.getFunctionIdDetail() != null) {
                    if (this.voucherHeader.getIsRestrictedtoOneFunctionCenter().booleanValue()) {
                        detailMap.put("functioncode", this.voucherHeader.getVouchermis().getFunction().getCode());
                    } else if (null != voucherDetail.getFunctionIdDetail()) {
                        CFunction function = (CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)voucherDetail.getFunctionIdDetail());
                        detailMap.put("functioncode", function.getCode());
                    } else if (null != this.voucherHeader.getVouchermis().getFunction()) {
                        detailMap.put("functioncode", this.voucherHeader.getVouchermis().getFunction().getCode());
                    }
                }
                if (voucherDetail.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                    detailMap.put("debitamount", voucherDetail.getDebitAmountDetail().toString());
                    detailMap.put("creditamount", ZERO);
                    detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                    accountdetails.add(detailMap);
                    glcodeMap.put(voucherDetail.getGlcodeDetail(), "debit");
                    continue;
                }
                detailMap.put("creditamount", voucherDetail.getCreditAmountDetail().toString());
                detailMap.put("debitamount", ZERO);
                detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                accountdetails.add(detailMap);
                glcodeMap.put(voucherDetail.getGlcodeDetail(), "credit");
            }
            for (VoucherDetails voucherDetail : subLedgerlist) {
                String amountType;
                subledgertDetailMap = new HashMap<String, Object>();
                String string = amountType = glcodeMap.get(voucherDetail.getSubledgerCode()) != null ? glcodeMap.get(voucherDetail.getSubledgerCode()).toString() : null;
                if (voucherDetail.getFunctionDetail() != null && !voucherDetail.getFunctionDetail().equalsIgnoreCase("") && !voucherDetail.getFunctionDetail().equalsIgnoreCase(ZERO)) {
                    CFunction function = (CFunction)this.persistenceService.find("from CFunction where id = ?", new Object[]{Long.parseLong(voucherDetail.getFunctionDetail())});
                    subledgertDetailMap.put("functioncode", function != null ? function.getCode() : "");
                }
                if (null != amountType && amountType.equalsIgnoreCase("debit")) {
                    subledgertDetailMap.put("debitamount", voucherDetail.getAmount());
                } else if (null != amountType) {
                    subledgertDetailMap.put("creditamount", voucherDetail.getAmount());
                }
                subledgertDetailMap.put("detailtypeid", voucherDetail.getDetailType().getId());
                subledgertDetailMap.put("detailkeyid", voucherDetail.getDetailKeyId());
                subledgertDetailMap.put("glcode", voucherDetail.getSubledgerCode());
                subledgerDetails.add(subledgertDetailMap);
            }
            this.voucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + this.voucherHeader.getId()));
        }
        return this.voucherHeader;
    }

    protected boolean validateData(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerList) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        int index = 0;
        boolean isValFailed = false;
        HashMap<String, List> accCodeFuncMap = new HashMap<String, List>();
        for (VoucherDetails voucherDetails : billDetailslist) {
            ++index;
            totalDrAmt = totalDrAmt.add(voucherDetails.getDebitAmountDetail());
            totalCrAmt = totalCrAmt.add(voucherDetails.getCreditAmountDetail());
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getGlcodeDetail().trim().length() != 0) {
                this.addActionError(this.getText("journalvoucher.accdetail.amountZero", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                continue;
            }
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) > 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) > 0) {
                this.addActionError(this.getText("journalvoucher.accdetail.amount", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                continue;
            }
            if ((voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) > 0 || voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) > 0) && voucherDetails.getGlcodeDetail().trim().length() == 0 || voucherDetails.getGlcodeIdDetail() == null) {
                this.addActionError(this.getText("journalvoucher.accdetail.accmissing", new String[]{"" + index}));
                isValFailed = true;
                continue;
            }
            if (voucherDetails.getFunctionDetail() != null && !voucherDetails.getFunctionDetail().equalsIgnoreCase("") && voucherDetails.getFunctionIdDetail() == null) {
                this.addActionError(this.getText("jv.funcMissing", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                continue;
            }
            String functionId = null;
            functionId = voucherDetails.getFunctionIdDetail() != null ? voucherDetails.getFunctionIdDetail().toString() : ZERO;
            List existingFuncs = (List)accCodeFuncMap.get(voucherDetails.getGlcodeDetail());
            if (null == existingFuncs) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(functionId);
                accCodeFuncMap.put(voucherDetails.getGlcodeDetail(), list);
                continue;
            }
            if (functionId.equals(ZERO) || existingFuncs.contains(ZERO)) {
                this.addActionError(this.getText("jv.multiplecodes.funcMissing", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                break;
            }
            if (existingFuncs.contains(functionId)) {
                this.addActionError(this.getText("jv.multiplecodes.duplicateFunc", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                break;
            }
            existingFuncs.add(functionId);
            accCodeFuncMap.put(voucherDetails.getGlcodeDetail(), existingFuncs);
        }
        if (totalDrAmt.compareTo(totalCrAmt) != 0 && !isValFailed) {
            this.addActionError(this.getText("journalvoucher.accdetail.drcrmatch"));
            isValFailed = true;
        } else if (!isValFailed) {
            isValFailed = this.validateSubledgerDetails(billDetailslist, subLedgerList);
        }
        return isValFailed;
    }

    protected boolean validateSubledgerDetails(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist) {
        ArrayList subLegAccMap = new ArrayList();
        List repeatedglCodes = VoucherHelper.getRepeatedGlcodes(billDetailslist);
        for (VoucherDetails voucherDetails : billDetailslist) {
            CChartOfAccountDetail chartOfAccountDetail = (CChartOfAccountDetail)this.getPersistenceService().find(" from CChartOfAccountDetail where glCodeId=(select id from CChartOfAccounts where glcode=?)", new Object[]{voucherDetails.getGlcodeDetail()});
            if (null == chartOfAccountDetail) continue;
            HashMap<String, Object> accountDetailMap = new HashMap<String, Object>();
            if (repeatedglCodes.contains(voucherDetails.getGlcodeIdDetail().toString())) {
                accountDetailMap.put("glcodeId-funcId", voucherDetails.getGlcodeIdDetail() + "-" + voucherDetails.getFunctionIdDetail());
            } else {
                accountDetailMap.put("glcodeId-funcId", voucherDetails.getGlcodeIdDetail() + "-0");
            }
            accountDetailMap.put("glcode", voucherDetails.getGlcodeDetail());
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", voucherDetails.getCreditAmountDetail());
            } else if (voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", voucherDetails.getDebitAmountDetail());
            }
            subLegAccMap.add(accountDetailMap);
        }
        HashMap<String, BigDecimal> subledAmtmap = new HashMap<String, BigDecimal>();
        HashMap<String, String> subLedgerMap = new HashMap<String, String>();
        for (VoucherDetails voucherDetails : subLedgerlist) {
            String function;
            if (voucherDetails.getGlcode() == null) {
                this.addActionError(this.getText("journalvoucher.acccode.missing", new String[]{voucherDetails.getSubledgerCode()}));
                return true;
            }
            if (voucherDetails.getGlcode().getId() == 0L) continue;
            String string = function = repeatedglCodes.contains(voucherDetails.getGlcode().getId().toString()) ? voucherDetails.getFunctionDetail() : ZERO;
            if (null != subledAmtmap.get(voucherDetails.getGlcode().getId() + "-" + function)) {
                BigDecimal debitTotalAmount = ((BigDecimal)subledAmtmap.get(voucherDetails.getGlcode().getId() + "-" + function)).add(voucherDetails.getAmount());
                subledAmtmap.put(voucherDetails.getGlcode().getId() + "-" + function, debitTotalAmount);
            } else {
                subledAmtmap.put(voucherDetails.getGlcode().getId() + "-" + function, voucherDetails.getAmount());
            }
            StringBuffer subledgerDetailRow = new StringBuffer();
            if (voucherDetails.getDetailType().getId() == 0 || null == voucherDetails.getDetailKeyId()) {
                this.addActionError(this.getText("journalvoucher.subledger.entrymissing", new String[]{voucherDetails.getSubledgerCode()}));
                return true;
            }
            subledgerDetailRow.append(voucherDetails.getGlcode().getId().toString()).append(voucherDetails.getDetailType().getId().toString()).append(voucherDetails.getDetailKeyId().toString()).append(voucherDetails.getFunctionDetail());
            if (null == subLedgerMap.get(subledgerDetailRow.toString())) {
                subLedgerMap.put(subledgerDetailRow.toString(), subledgerDetailRow.toString());
                continue;
            }
            this.addActionError(this.getText("journalvoucher.samesubledger.repeated"));
            return true;
        }
        if (subLegAccMap.size() > 0) {
            for (Map map : subLegAccMap) {
                String functionId;
                String glcodeIdAndFuncId = map.get("glcodeId-funcId").toString();
                if (null == subledAmtmap.get(glcodeIdAndFuncId)) {
                    functionId = glcodeIdAndFuncId.split("-")[1];
                    if (functionId.equalsIgnoreCase(ZERO)) {
                        this.addActionError(this.getText("journalvoucher.subledger.entrymissing", new String[]{map.get("glcode").toString()}));
                    } else {
                        Object function = null;
                        this.addActionError(this.getText("journalvoucher.subledger.entrymissingFunc", new String[]{map.get("glcode").toString(), function.getName()}));
                    }
                    return true;
                }
                if (((BigDecimal)subledAmtmap.get(glcodeIdAndFuncId)).compareTo(new BigDecimal(map.get("amount").toString())) == 0) continue;
                functionId = glcodeIdAndFuncId.split("-")[1];
                if (functionId.equalsIgnoreCase(ZERO)) {
                    this.addActionError(this.getText("journalvoucher.subledger.amtnotmatchinng", new String[]{map.get("glcode").toString()}));
                } else {
                    CFunction function = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{Long.valueOf(functionId)});
                    this.addActionError(this.getText("journalvoucher.subledger.amtnotmatchinngFunc", new String[]{map.get("glcode").toString(), function.getName()}));
                }
                return true;
            }
        }
        StringBuffer fyQuery = new StringBuffer();
        fyQuery.append("from CFinancialYear where isActiveForPosting=true and startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(this.voucherHeader.getVoucherDate())).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(this.voucherHeader.getVoucherDate())).append("'");
        List list = this.persistenceService.findAllBy(fyQuery.toString(), new Object[0]);
        if (list.size() == 0) {
            this.addActionError(this.getText("journalvoucher.fYear.notActive"));
            return true;
        }
        return false;
    }

    protected void loadBankAccountNumber(ContraBean contraBean) {
        if (null != contraBean.getBankBranchId() && !contraBean.getBankBranchId().equalsIgnoreCase("-1")) {
            int index1 = contraBean.getBankBranchId().indexOf("-");
            Integer branchId = Integer.valueOf(contraBean.getBankBranchId().substring(index1 + 1, contraBean.getBankBranchId().length()));
            List bankAccountList = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=?   and isactive=true order by id", new Object[]{branchId});
            this.addDropdownData("accNumList", bankAccountList);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Account number list size " + bankAccountList.size()));
            }
        }
    }

    protected void loadBankAccountNumber(String bankBranchId) {
        if (null != bankBranchId && !bankBranchId.equalsIgnoreCase("-1")) {
            int index1 = bankBranchId.indexOf("-");
            Integer branchId = Integer.valueOf(bankBranchId.substring(index1 + 1, bankBranchId.length()));
            List bankAccountList = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=?   and isactive=true order by id", new Object[]{branchId});
            this.addDropdownData("accNumList", bankAccountList);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Account number list size " + bankAccountList.size()));
            }
        }
    }

    public void loadBankBranchForFund() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BaseVoucherAction | loadBankBranchForFund | Start");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("FUND ID = " + this.voucherHeader.getFundId().getId()));
            }
            List bankBranch = this.getPersistenceService().findAllBy("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),bankBranch.branchname) as bankbranchname  FROM Bank bank,Bankbranch bankBranch,Bankaccount bankaccount  where  bank.isactive=true  and bankBranch.isactive=true and bank.id = bankBranch.bank.id and bankBranch.id = bankaccount.bankbranch.id and bankaccount.fund.id=?", new Object[]{this.voucherHeader.getFundId().getId()});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Bank list size is " + bankBranch.size()));
            }
            ArrayList bankBranchList = new ArrayList();
            for (Object[] element : bankBranch) {
                HashMap<String, String> bankBrmap = new HashMap<String, String>();
                bankBrmap.put("bankBranchId", element[0].toString());
                bankBrmap.put("bankBranchName", element[1].toString());
                bankBranchList.add(bankBrmap);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Bank branch list size :" + bankBranchList.size()));
            }
            this.addDropdownData("bankList", bankBranchList);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Exception occured while getting the data for bank dropdown " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside shouldShowHeaderField menthod");
        }
        if (field.equals("vouchernumber")) {
            String vNumGenMode = "Manual";
            vNumGenMode = this.voucherHeader.getType() != null && this.voucherHeader.getType().equalsIgnoreCase("Journal Voucher") ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(this.voucherHeader.getType());
            if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
                this.mandatoryFields.add("vouchernumber");
                return true;
            }
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Header field contains = " + this.headerFields.contains(field)));
        }
        return this.headerFields.contains(field);
    }

    public String getTransactionType() {
        return this.voucherHeader.getType();
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public CVoucherHeader getVoucherHeader() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public String getVoucherNumManual() {
        return this.voucherNumManual;
    }

    public void setVoucherNumManual(String voucherNumManual) {
        this.voucherNumManual = voucherNumManual;
    }

    protected void removeEmptyRowsAccoutDetail(List list) {
        Iterator detail = list.iterator();
        while (detail.hasNext()) {
            VoucherDetails next = (VoucherDetails)detail.next();
            if (next != null && (next.getGlcodeDetail() == null || next.getGlcodeDetail().trim().isEmpty()) && (next.getFunctionDetail() == null || next.getFunctionDetail().trim().isEmpty()) && next.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && next.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                detail.remove();
                continue;
            }
            if (next != null) continue;
            detail.remove();
        }
    }

    protected void removeEmptyRowsSubledger(List<VoucherDetails> list) {
        Iterator<VoucherDetails> detail = list.iterator();
        while (detail.hasNext()) {
            VoucherDetails next = detail.next();
            if (next != null && (next.getSubledgerCode() == null || next.getSubledgerCode().equals(""))) {
                detail.remove();
                continue;
            }
            if (next != null) continue;
            detail.remove();
        }
    }

    public void saveReverse(String voucherName, String type) {
        CVoucherHeader reversalVoucher = null;
        HashMap<String, Object> reversalVoucherMap = new HashMap<String, Object>();
        reversalVoucherMap.put("Original voucher header id", this.voucherHeader.getId());
        reversalVoucherMap.put("Reversal voucher type", type);
        reversalVoucherMap.put("Reversal voucher name", voucherName);
        reversalVoucherMap.put("Reversal voucher date", this.getReversalVoucherDate());
        reversalVoucherMap.put("Reversal voucher number", this.getReversalVoucherNumber());
        ArrayList<HashMap<String, Object>> reversalList = new ArrayList<HashMap<String, Object>>();
        reversalList.add(reversalVoucherMap);
        try {
            reversalVoucher = this.createVoucher.reverseVoucher(reversalList);
        }
        catch (ValidationException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("ERROR in Reversing voucher" + e.getMessage()));
            }
            this.addActionError(this.getText(((ValidationError)e.getErrors().get(0)).getMessage()));
            return;
        }
        catch (ApplicationRuntimeException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("ERROR " + e.getMessage()));
            }
            this.addActionError(this.getText(e.getMessage()));
            return;
        }
        catch (ParseException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("ERROR " + e.getMessage()));
            }
            throw new ValidationException(Arrays.asList(new ValidationError("invalid.date.format", "invalid.date.format")));
        }
        this.addActionMessage(this.getText("transaction.success") + reversalVoucher.getVoucherNumber());
        this.voucherHeader = reversalVoucher;
    }

    protected void loadDefalutDates() {
        Date currDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.voucherHeader.setVoucherDate(sdf.parse(sdf.format(currDate)));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Inside loadDefalutDates" + e.getMessage()), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting voucher date", FAILED)));
        }
    }

    protected void resetVoucherHeader() {
        if (null != this.parameters.get("voucherNumberPrefix")) {
            String voucherNumeditPart = this.voucherHeader.getVoucherNumber();
            this.voucherHeader.setVoucherNumber(((String[])this.parameters.get("voucherNumberPrefix"))[0] + voucherNumeditPart);
        }
    }

    public Integer getVoucherNumberPrefixLength() {
        this.voucherNumberPrefixLength = Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH);
        return this.voucherNumberPrefixLength;
    }

    public void setVoucherNumberPrefixLength(Integer voucherNumberPrefixLength) {
        this.voucherNumberPrefixLength = voucherNumberPrefixLength;
    }

    public String getReversalVoucherNumber() {
        return this.reversalVoucherNumber;
    }

    public void setReversalVoucherNumber(String reversalVoucherNumber) {
        this.reversalVoucherNumber = reversalVoucherNumber;
    }

    public String getReversalVoucherDate() {
        return this.reversalVoucherDate;
    }

    public void setReversalVoucherDate(String reversalVoucherDate) {
        this.reversalVoucherDate = reversalVoucherDate;
    }

    public void setFinancingSourceService(FinancingSourceService financingSourceService) {
        this.financingSourceService = financingSourceService;
    }

    protected Boolean validateOwner(State state) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validating owner for user " + ApplicationThreadLocals.getUserId()));
        }
        List positionsForUser = null;
        positionsForUser = this.eisService.getPositionsForUser(ApplicationThreadLocals.getUserId(), new Date());
        if (positionsForUser.contains(state.getOwnerPosition())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Valid Owner :return true");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Invalid  Owner :return false");
        }
        return false;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public EisUtilService getEisService() {
        return this.eisService;
    }

    public List<String> getVoucherTypes() {
        return this.voucherTypes;
    }

    public void setVoucherTypes(List<String> voucherTypes) {
        this.voucherTypes = voucherTypes;
    }

    public Map<String, List<String>> getVoucherNames() {
        return this.voucherNames;
    }

    public void setVoucherNames(Map<String, List<String>> voucherNames) {
        this.voucherNames = voucherNames;
    }

    public AssignmentService getAssignmentService() {
        return this.assignmentService;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public FinancingSourceService getFinancingSourceService() {
        return this.financingSourceService;
    }
}

