/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.GLEngine.GeneralLedgerBean;
import com.exilant.eGov.src.transactions.RptSubLedgerSchedule;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.Fund;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"result"}, location="subLedgerScheduleReport-result.jsp"), @Result(name={"search"}, location="subLedgerScheduleReport-search.jsp")})
public class SubLedgerScheduleReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -8747832451260494901L;
    private static final Logger LOGGER = Logger.getLogger(SubLedgerScheduleReportAction.class);
    private GeneralLedgerBean subLedgerScheduleReport = new GeneralLedgerBean();
    @Autowired
    @Qualifier(value="rptSubLedgerSchedule")
    private RptSubLedgerSchedule rptSubLedgerSchedule;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected LinkedList subLedgerScheduleDisplayList = new LinkedList();
    String heading = "";

    public Object getModel() {
        return this.subLedgerScheduleReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        if (this.subLedgerScheduleReport != null && this.subLedgerScheduleReport.getGlcode() != null && !this.subLedgerScheduleReport.getGlcode().equalsIgnoreCase("")) {
            this.addDropdownData("subLedgerTypeList", this.persistenceService.findAllBy("select distinct adt from Accountdetailtype adt, CChartOfAccountDetail cad where cad.glCodeId.glcode = ? and cad.detailTypeId = adt ", new Object[]{this.subLedgerScheduleReport.getGlcode()}));
        } else {
            this.addDropdownData("subLedgerTypeList", Collections.EMPTY_LIST);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/subLedgerScheduleReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="glcode", message="", key="Required"), @RequiredFieldValidator(fieldName="fund_id", message="", key="Required"), @RequiredFieldValidator(fieldName="accEntityId", message="", key="Required"), @RequiredFieldValidator(fieldName="startDate", message="", key="Required"), @RequiredFieldValidator(fieldName="endDate", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/report/subLedgerScheduleReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SubLedgerScheduleReportAction | Search | start");
        }
        try {
            this.subLedgerScheduleDisplayList = this.rptSubLedgerSchedule.getSubLedgerTypeSchedule(this.subLedgerScheduleReport);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SubLedgerScheduleReportAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.prepareNewForm();
        return "result";
    }

    private String getGLHeading() {
        String heading = "";
        CChartOfAccounts glCode = new CChartOfAccounts();
        Fund fund = new Fund();
        if (this.checkNullandEmpty(this.subLedgerScheduleReport.getGlcode()) && this.checkNullandEmpty(this.subLedgerScheduleReport.getGlcode())) {
            glCode = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode = ?", new Object[]{this.subLedgerScheduleReport.getGlcode()});
            fund = (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{Integer.parseInt(this.subLedgerScheduleReport.getFund_id())});
        }
        heading = "Sub Ledger Schedule Report for " + glCode.getGlcode() + " - " + glCode.getName() + " for " + fund.getName() + " from " + this.subLedgerScheduleReport.getStartDate() + " to " + this.subLedgerScheduleReport.getEndDate() + " and Sub Ledger Type :" + this.subLedgerScheduleReport.getSubLedgerTypeName();
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public GeneralLedgerBean getSubLedgerScheduleReport() {
        return this.subLedgerScheduleReport;
    }

    public void setSubLedgerScheduleReport(GeneralLedgerBean subLedgerScheduleReport) {
        this.subLedgerScheduleReport = subLedgerScheduleReport;
    }

    public RptSubLedgerSchedule getSubLedgerSchedule() {
        return this.rptSubLedgerSchedule;
    }

    public void setSubLedgerSchedule(RptSubLedgerSchedule subLedgerSchedule) {
        this.rptSubLedgerSchedule = subLedgerSchedule;
    }

    public LinkedList getSubLedgerScheduleDisplayList() {
        return this.subLedgerScheduleDisplayList;
    }

    public void setSubLedgerScheduleDisplayList(LinkedList subLedgerScheduleDisplayList) {
        this.subLedgerScheduleDisplayList = subLedgerScheduleDisplayList;
    }
}

