/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.eGov.src.reports.GeneralLedgerReport;
import com.exilant.eGov.src.reports.GeneralLedgerReportBean;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"search"}, location="generalLedgerReport-search.jsp"), @Result(name={"results"}, location="generalLedgerReport-results.jsp"), @Result(name={"searchResult"}, location="generalLedgerReport-searchDrilldown.jsp")})
public class GeneralLedgerReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 4734431707050536319L;
    private static final Logger LOGGER = Logger.getLogger(GeneralLedgerReportAction.class);
    private GeneralLedgerReportBean generalLedgerReportBean = new GeneralLedgerReportBean();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="generalLedgerReport")
    private GeneralLedgerReport generalLedgerReport;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected LinkedList generalLedgerDisplayList = new LinkedList();
    String heading = "";
    List<CChartOfAccounts> allChartOfAccounts;
    String parentForDetailedCode = "";
    private String glCode;
    @Autowired
    AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private PersistenceService<CChartOfAccounts, Long> chartOfAccountsService;

    public GeneralLedgerReportAction() {
        LOGGER.error((Object)"creating instance of GeneralLedgerReportAction ");
    }

    public Object getModel() {
        return this.generalLedgerReportBean;
    }

    public void prepareNewForm() {
        super.prepare();
        this.allChartOfAccounts = this.persistenceService.findAllBy("select ca from CChartOfAccounts ca where ca.glcode not in(select glcode from CChartOfAccounts where glcode like '47%' and glcode not like '471%' and glcode !='4741') and ca.glcode not in (select glcode from CChartOfAccounts where glcode = '471%')  and ca.isActiveForPosting=true and ca.classification=4  and ca.glcode like ?", new Object[]{this.glCode + "%"});
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
        this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/generalLedgerReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="glCode1", message="", key="Required"), @RequiredFieldValidator(fieldName="fund_id", message="", key="Required"), @RequiredFieldValidator(fieldName="startDate", message="", key="Required"), @RequiredFieldValidator(fieldName="endDate", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/report/generalLedgerReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GeneralLedgerAction | Search | start");
        }
        try {
            this.generalLedgerDisplayList = this.generalLedgerReport.getGeneralLedgerList(this.generalLedgerReportBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GeneralLedgerAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.generalLedgerReportBean.setHeading(this.getGLHeading());
        this.prepareNewForm();
        return "results";
    }

    @Action(value="/report/generalLedgerReport-searchDrilldown")
    public String searchDrilldown() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GeneralLedgerAction | Search | start");
        }
        try {
            this.generalLedgerDisplayList = this.generalLedgerReport.getGeneralLedgerList(this.generalLedgerReportBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GeneralLedgerAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.generalLedgerReportBean.setHeading(this.getGLHeading());
        this.prepareNewForm();
        return "searchResult";
    }

    private String getGLHeading() {
        String heading = "";
        CChartOfAccounts glCode = new CChartOfAccounts();
        Fund fund = new Fund();
        if (this.checkNullandEmpty(this.generalLedgerReportBean.getGlCode1()) && this.checkNullandEmpty(this.generalLedgerReportBean.getGlCode1())) {
            glCode = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode = ?", new Object[]{this.generalLedgerReportBean.getGlCode1()});
            fund = this.generalLedgerReportBean.getFund_id().isEmpty() ? (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{0}) : (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{Integer.parseInt(this.generalLedgerReportBean.getFund_id())});
        }
        heading = fund == null ? "General Ledger Report for " + glCode.getGlcode() + ":" + glCode.getName() + " from " + this.generalLedgerReportBean.getStartDate() + " to " + this.generalLedgerReportBean.getEndDate() : "General Ledger Report for " + glCode.getGlcode() + ":" + glCode.getName() + " for " + fund.getName() + " from " + this.generalLedgerReportBean.getStartDate() + " to " + this.generalLedgerReportBean.getEndDate();
        if (this.checkNullandEmpty(this.generalLedgerReportBean.getDepartmentId())) {
            Department dept = (Department)this.persistenceService.find("from Department where id = ?", new Object[]{Long.parseLong(this.generalLedgerReportBean.getDepartmentId())});
            heading = heading + " under " + dept.getName() + " Department ";
        }
        if (this.checkNullandEmpty(this.generalLedgerReportBean.getFunctionCode())) {
            CFunction function = (CFunction)this.persistenceService.find("from CFunction where id = ?", new Object[]{Long.valueOf(this.generalLedgerReportBean.getFunctionCodeId())});
            heading = heading + " in " + function.getName() + " Function ";
        }
        if (this.checkNullandEmpty(this.generalLedgerReportBean.getFunctionaryId())) {
            Functionary functionary = (Functionary)this.persistenceService.find("from Functionary where id = ?", new Object[]{Integer.parseInt(this.generalLedgerReportBean.getFunctionaryId())});
            heading = heading + " in " + functionary.getName() + " Functionary ";
        }
        if (this.checkNullandEmpty(this.generalLedgerReportBean.getFieldId())) {
            Boundary ward = (Boundary)this.persistenceService.find("from Boundary where id = ?", new Object[]{Long.parseLong(this.generalLedgerReportBean.getFieldId())});
            heading = heading + " in " + ward.getName() + " Field ";
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public GeneralLedgerReportBean getGeneralLedgerReportBean() {
        return this.generalLedgerReportBean;
    }

    public void setGeneralLedgerReportBean(GeneralLedgerReportBean generalLedgerReportBean) {
        this.generalLedgerReportBean = generalLedgerReportBean;
    }

    public GeneralLedgerReport getGeneralLedgerReport() {
        return this.generalLedgerReport;
    }

    public void setGeneralLedgerReport(GeneralLedgerReport generalLedgerReport) {
        this.generalLedgerReport = generalLedgerReport;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public LinkedList getGeneralLedgerDisplayList() {
        return this.generalLedgerDisplayList;
    }

    public void setGeneralLedgerDisplayList(LinkedList generalLedgerDisplayList) {
        this.generalLedgerDisplayList = generalLedgerDisplayList;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public PersistenceService<CChartOfAccounts, Long> getChartOfAccountsService() {
        return this.chartOfAccountsService;
    }

    public void setChartOfAccountsService(PersistenceService<CChartOfAccounts, Long> chartOfAccountsService) {
        this.chartOfAccountsService = chartOfAccountsService;
    }
}

