/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.eGov.src.reports.DishonoredChequeBean;
import com.exilant.eGov.src.reports.DishonoredChequeReport;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Fund;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"search"}, location="dishonoredChequeReport-search.jsp"), @Result(name={"results"}, location="dishonoredChequeReport-results.jsp")})
public class DishonoredChequeReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -1526444081011004380L;
    private static final Logger LOGGER = Logger.getLogger(DishonoredChequeReportAction.class);
    private DishonoredChequeBean dishonoredChequeReport = new DishonoredChequeBean();
    private DishonoredChequeReport dishonoredCheque = new DishonoredChequeReport();
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected ArrayList dishonoredChequeDisplayList = new ArrayList();
    String heading = "";
    private String showMode = "";

    public Object getModel() {
        return this.dishonoredChequeReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/dishonoredChequeReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="mode", message="", key="Required"), @RequiredFieldValidator(fieldName="startDate", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/report/dishonoredChequeReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"DishonoredChequeAction | Search | start");
        }
        try {
            this.dishonoredChequeDisplayList = this.dishonoredCheque.getDishonoredChequeDetails(this.dishonoredChequeReport);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"DishonoredChequeAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.prepareNewForm();
        this.showMode = "result";
        return "results";
    }

    private String getGLHeading() {
        String heading = "";
        Fund fund = new Fund();
        heading = "Dishonored Cheque/DD Report under Mode of Payment:" + (this.dishonoredChequeReport.getMode().equalsIgnoreCase("2") ? "Cheque" : "DD") + " from " + this.dishonoredChequeReport.getStartDate();
        if (this.checkNullandEmpty(this.dishonoredChequeReport.getEndDate())) {
            heading = heading + " to " + this.dishonoredChequeReport.getEndDate();
        }
        if (this.checkNullandEmpty(this.dishonoredChequeReport.getFundLst())) {
            fund = (Fund)this.persistenceService.find("from Fund where  id = ?", new Object[]{Integer.parseInt(this.dishonoredChequeReport.getFundLst())});
            heading = heading + " and Fund :" + fund.getName();
        }
        if (this.checkNullandEmpty(this.dishonoredChequeReport.getChequeNo())) {
            heading = heading + " and Cheque/DD Number :" + this.dishonoredChequeReport.getChequeNo();
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public DishonoredChequeBean getDishonoredChequeReport() {
        return this.dishonoredChequeReport;
    }

    public void setDishonoredChequeReport(DishonoredChequeBean dishonoredChequeReport) {
        this.dishonoredChequeReport = dishonoredChequeReport;
    }

    public DishonoredChequeReport getDishonoredCheque() {
        return this.dishonoredCheque;
    }

    public void setDishonoredCheque(DishonoredChequeReport dishonoredCheque) {
        this.dishonoredCheque = dishonoredCheque;
    }

    public ArrayList getDishonoredChequeDisplayList() {
        return this.dishonoredChequeDisplayList;
    }

    public void setDishonoredChequeDisplayList(ArrayList dishonoredChequeDisplayList) {
        this.dishonoredChequeDisplayList = dishonoredChequeDisplayList;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }
}

