/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.egf.model.DepartmentwiseExpenditureReport;
import org.egov.egf.model.DepartmentwiseExpenditureResult;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.report.DEReportService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=DepartmentwiseExpenditureReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=DepartmentwiseExpenditureReport.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html", "contentDisposition", "no-cache;filename=DepartmentwiseExpenditureReport.html"})})
@ParentPackage(value="egov")
public class DepartmentwiseExpenditureReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private InputStream inputStream;
    private ReportHelper reportHelper;
    SimpleDateFormat sqlformat = new SimpleDateFormat("dd-MMM-yyyy");
    private DepartmentwiseExpenditureReport deptReport = new DepartmentwiseExpenditureReport();
    List<DepartmentwiseExpenditureReport> departmentwiseExpList = new ArrayList();
    private final List<Department> departmentList = new ArrayList();
    DEReportService deService = new DEReportService();
    private StringBuffer heading = new StringBuffer();
    private final StringBuffer Preheading = new StringBuffer();
    static final String CURRENT = "current";
    static final String PREVIOUS = "previous";
    static final Logger LOGGER = Logger.getLogger(DepartmentwiseExpenditureReportAction.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("fundDropDownList", this.masterDataCache.get("egi-fund"));
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true   and startingDate >='01-Apr-2010' order by finYearRange desc  ", new Object[0]));
    }

    public Object getModel() {
        return this.deptReport;
    }

    @SkipValidation
    @ValidationErrorPage(value="new")
    @Action(value="/report/departmentwiseExpenditureReport-search")
    public String search() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"@-- Inside search method --@");
        }
        this.setRelatedEntitesOn();
        this.validateBeforeSearch();
        this.populateResult();
        if (this.deptReport.getExportType().equals("xls")) {
            return this.generateReportXls();
        }
        if (this.deptReport.getExportType().equals("pdf")) {
            return this.generateReportPdf();
        }
        if (this.deptReport.getExportType().equals("html")) {
            return this.generateReportHTML();
        }
        return "new";
    }

    public void populateResult() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)" @-- Inside popgetConcurrenceDateForPeriodulateResult --@");
        }
        this.populateCurrentYearReport();
        this.populatePreviousYearReport();
    }

    public void populateCurrentYearReport() {
        this.deptReport.setPeriod(CURRENT);
        this.deService.populateDepartment(this.deptReport);
        this.populateConcurrenceGivenResult();
        this.populateConcurrenceForthePeriod();
        this.removeDepartmentWithNoValues();
        this.populateDaywiseTotal();
        this.populateTotalConcurrenceGiven();
        this.calculateDatewiseTotalAcrossDepartment();
    }

    public void populatePreviousYearReport() {
        this.deptReport.setPeriod(PREVIOUS);
        this.deService.populateDepartment(this.deptReport);
        this.populateConcurrenceGivenResult();
        this.populateConcurrenceForthePeriod();
        this.removeDepartmentWithNoValues();
        this.populateDaywiseTotal();
        this.populateTotalConcurrenceGiven();
        this.calculateDatewiseTotalAcrossDepartment();
    }

    void removeDepartmentWithNoValues() {
        LinkedList<DepartmentwiseExpenditureResult> resultList = new LinkedList<DepartmentwiseExpenditureResult>();
        if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
            resultList = new LinkedList();
            for (DepartmentwiseExpenditureResult obj : this.deptReport.getCurrentyearDepartmentList()) {
                if (obj.isDepartmentWithNodata()) continue;
                resultList.add(obj);
            }
            this.deptReport.setCurrentyearDepartmentList(resultList);
        }
        if (this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) {
            resultList = new LinkedList();
            for (DepartmentwiseExpenditureResult obj : this.deptReport.getPreviousyearDepartmentList()) {
                if (obj.isDepartmentWithNodata()) continue;
                resultList.add(obj);
            }
            this.deptReport.setPreviousyearDepartmentList(resultList);
        }
    }

    public void validateBeforeSearch() {
        if (null != this.deptReport.getFromDate() && null != this.deptReport.getToDate() && this.deptReport.getFromDate().after(this.deptReport.getToDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("date", "from date can not be greater than to date")));
        }
        if (!this.deService.validateDateRange(this.deptReport)) {
            throw new ValidationException(Arrays.asList(new ValidationError("date", "from date and to date should be in same financial year")));
        }
        if (this.deptReport.getReportType().equalsIgnoreCase("daterange") && this.deService.getNumberOfDays(this.deptReport.getFromDate(), this.deptReport.getToDate()) > 30) {
            throw new ValidationException(Arrays.asList(new ValidationError("date", "Maximun date range of 30 days can be selected")));
        }
    }

    public void populateConcurrenceGivenResult() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"------------------ Inside populateConcurrenceGivenResult--------------");
        }
        this.departmentwiseExpList = this.deService.getConcurrenceGivenFortheFinancialYearTillGivenDate(this.deptReport);
        for (DepartmentwiseExpenditureReport obj : this.departmentwiseExpList) {
            block8: {
                block7: {
                    if (!this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) break block7;
                    if (this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getCurrentyearDepartmentList())) {
                        for (DepartmentwiseExpenditureResult entry : this.deptReport.getCurrentyearDepartmentList()) {
                            if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                            entry.setConcurrenceGiven(obj.getConcurrenceAmount());
                            entry.setDepartmentWithNodata(false);
                            break;
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(" Concurrence Given till Date for Currentyear List" + this.deptReport.getCurrentyearDepartmentList().size()));
                    }
                    if (!LOGGER.isInfoEnabled()) break block8;
                    LOGGER.info((Object)(" Concurrence Given  List" + this.deptReport.getCurrentyearDepartmentList()));
                    break block8;
                }
                if (this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS) && this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getPreviousyearDepartmentList())) {
                    for (DepartmentwiseExpenditureResult entry : this.deptReport.getPreviousyearDepartmentList()) {
                        if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                        entry.setConcurrenceGiven(obj.getConcurrenceAmount());
                        entry.setDepartmentWithNodata(false);
                        break;
                    }
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)(" Concurrence Given till Date for previous List" + this.deptReport.getPreviousyearDepartmentList().size()));
        }
    }

    public void populateConcurrenceForthePeriod() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" --Inside populateConcurrenceForthePeriod--- ");
        }
        String subDate = "";
        List deList = new ArrayList();
        deList = this.deService.getConcurrenceGivenForthePeriodQuery(this.deptReport);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Total concurrence given for the period --- " + deList.size()));
        }
        for (DepartmentwiseExpenditureReport obj : deList) {
            DepartmentwiseExpenditureResult deptExpResult;
            subDate = Constants.DDMMYYYYFORMAT2.format(obj.getConcurrenceDate()).toString();
            subDate = subDate.substring(0, subDate.length() - 5);
            if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
                if (this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getCurrentyearDepartmentList())) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)(" obj.getDepartmentName()------ exists" + obj.getDepartmentName()));
                    }
                    for (DepartmentwiseExpenditureResult entry : this.deptReport.getCurrentyearDepartmentList()) {
                        if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                        if (obj.getConcurrenceAmount() != BigDecimal.ZERO) {
                            entry.getDayAmountMap().put(subDate, obj.getConcurrenceAmount());
                        }
                        entry.setDepartmentWithNodata(false);
                        break;
                    }
                } else {
                    deptExpResult = new DepartmentwiseExpenditureResult();
                    deptExpResult.setConcurrenceGiven(BigDecimal.ZERO);
                    deptExpResult.setDepartmentNm(obj.getDepartmentName());
                    deptExpResult.setDepartmentWithNodata(false);
                    deptExpResult.getDayAmountMap().put(subDate, obj.getConcurrenceAmount());
                    this.deptReport.getCurrentyearDepartmentList().add(deptExpResult);
                }
                this.deptReport.getConcurrenceDateSet().add(subDate);
                continue;
            }
            if (!this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) continue;
            if (this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getPreviousyearDepartmentList())) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)(" obj.getDepartmentName()------ exists" + obj.getDepartmentName()));
                }
                for (DepartmentwiseExpenditureResult entry : this.deptReport.getPreviousyearDepartmentList()) {
                    if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                    entry.getDayAmountMap().put(subDate, obj.getConcurrenceAmount());
                    entry.setDepartmentWithNodata(false);
                    break;
                }
            } else {
                deptExpResult = new DepartmentwiseExpenditureResult();
                deptExpResult.setConcurrenceGiven(BigDecimal.ZERO);
                deptExpResult.setDepartmentNm(obj.getDepartmentName());
                deptExpResult.setDepartmentWithNodata(false);
                deptExpResult.getDayAmountMap().put(subDate, obj.getConcurrenceAmount());
                this.deptReport.getPreviousyearDepartmentList().add(deptExpResult);
            }
            this.deptReport.getPreviousConcurrenceDateSet().add(subDate);
        }
    }

    public void populateTotalConcurrenceGiven() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"------------------ Inside populateTotalConcurrenceGiven--------------");
        }
        BigDecimal totalconGiven = BigDecimal.ZERO;
        new DepartmentwiseExpenditureResult();
        ArrayList<DepartmentwiseExpenditureResult> departmentwiseConcurrenceReport = new ArrayList<DepartmentwiseExpenditureResult>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Putting concurrene given values to the depratment map  ");
        }
        if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
            for (DepartmentwiseExpenditureResult entry : this.deptReport.getCurrentyearDepartmentList()) {
                totalconGiven = BigDecimal.ZERO;
                totalconGiven = totalconGiven.add(entry.getConcurrenceGiven() != null ? entry.getConcurrenceGiven() : BigDecimal.ZERO).add(entry.getDayAmountMap().get("Total") != null ? (BigDecimal)entry.getDayAmountMap().get("Total") : BigDecimal.ZERO);
                entry.setTotalConcurrenceGivenTillDate(totalconGiven);
                departmentwiseConcurrenceReport.add(entry);
            }
            this.deptReport.setCurrentyearDepartmentList(departmentwiseConcurrenceReport);
        } else if (this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) {
            for (DepartmentwiseExpenditureResult entry : this.deptReport.getPreviousyearDepartmentList()) {
                totalconGiven = BigDecimal.ZERO;
                totalconGiven = totalconGiven.add(entry.getConcurrenceGiven() != null ? entry.getConcurrenceGiven() : BigDecimal.ZERO).add(entry.getDayAmountMap().get("Total") != null ? (BigDecimal)entry.getDayAmountMap().get("Total") : BigDecimal.ZERO);
                entry.setTotalConcurrenceGivenTillDate(totalconGiven);
                departmentwiseConcurrenceReport.add(entry);
            }
            this.deptReport.setPreviousyearDepartmentList(departmentwiseConcurrenceReport);
        }
    }

    public void calculateDatewiseTotalAcrossDepartment() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------ Inside pupulateDatewiseTotalAcrossDepartment--------------");
        }
        BigDecimal conGivenTotal = BigDecimal.ZERO;
        BigDecimal dayConTotal = BigDecimal.ZERO;
        BigDecimal conGivenTillDateTotal = BigDecimal.ZERO;
        LinkedHashMap dayTotalMap = new LinkedHashMap();
        DepartmentwiseExpenditureResult deptExpResult = new DepartmentwiseExpenditureResult();
        new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Putting concurrene given values to the depratment map  ");
        }
        if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
            for (DepartmentwiseExpenditureResult entry : this.deptReport.getCurrentyearDepartmentList()) {
                conGivenTotal = conGivenTotal.add(entry.getConcurrenceGiven() != null ? entry.getConcurrenceGiven() : BigDecimal.ZERO);
                for (Map.Entry row : entry.getDayAmountMap().entrySet()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(" row.getKey() " + (String)row.getKey()));
                    }
                    if (dayTotalMap.containsKey(row.getKey())) {
                        dayConTotal = ((BigDecimal)dayTotalMap.get(row.getKey())).add((BigDecimal)row.getValue());
                        dayTotalMap.put(row.getKey(), dayConTotal);
                        continue;
                    }
                    dayTotalMap.put(row.getKey(), (BigDecimal)row.getValue());
                }
                conGivenTillDateTotal = conGivenTillDateTotal.add(entry.getTotalConcurrenceGivenTillDate() != null ? entry.getTotalConcurrenceGivenTillDate() : BigDecimal.ZERO);
            }
        } else if (this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) {
            for (DepartmentwiseExpenditureResult entry : this.deptReport.getPreviousyearDepartmentList()) {
                conGivenTotal = conGivenTotal.add(entry.getConcurrenceGiven() != null ? entry.getConcurrenceGiven() : BigDecimal.ZERO);
                for (Map.Entry row : entry.getDayAmountMap().entrySet()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(" row.getKey() " + (String)row.getKey()));
                    }
                    if (dayTotalMap.containsKey(row.getKey())) {
                        dayConTotal = ((BigDecimal)dayTotalMap.get(row.getKey())).add((BigDecimal)row.getValue());
                        dayTotalMap.put(row.getKey(), dayConTotal);
                        continue;
                    }
                    dayTotalMap.put(row.getKey(), (BigDecimal)row.getValue());
                }
                conGivenTillDateTotal = conGivenTillDateTotal.add(entry.getTotalConcurrenceGivenTillDate() != null ? entry.getTotalConcurrenceGivenTillDate() : BigDecimal.ZERO);
            }
        }
        deptExpResult.setConcurrenceGiven(conGivenTotal);
        deptExpResult.setDayAmountMap(dayTotalMap);
        deptExpResult.setTotalConcurrenceGivenTillDate(conGivenTillDateTotal);
        deptExpResult.setDepartmentNm("Total");
        if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
            this.deptReport.getCurrentyearDepartmentList().add(deptExpResult);
        } else if (this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) {
            this.deptReport.getPreviousyearDepartmentList().add(deptExpResult);
        }
    }

    public void populateDaywiseTotal() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------ Inside populateDaywiseTotal--------------");
        }
        new DepartmentwiseExpenditureResult();
        this.departmentwiseExpList = new ArrayList();
        Query query = this.deService.getConcurrenceDaywiseTotalQuery(this.deptReport);
        query.setResultTransformer(Transformers.aliasToBean(DepartmentwiseExpenditureReport.class));
        this.departmentwiseExpList.addAll(query.list());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Putting concurrene given values to the depratment map  ");
        }
        for (DepartmentwiseExpenditureReport obj : this.departmentwiseExpList) {
            new DepartmentwiseExpenditureResult();
            if (this.deptReport.getPeriod().equalsIgnoreCase(CURRENT)) {
                if (this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getCurrentyearDepartmentList())) {
                    for (DepartmentwiseExpenditureResult entry : this.deptReport.getCurrentyearDepartmentList()) {
                        if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                        entry.getDayAmountMap().put("Total", this.divideAndRound(obj.getConcurrenceAmount(), BigDecimal.valueOf(100000L)));
                        break;
                    }
                }
                this.deptReport.getConcurrenceDateSet().add("Total");
                continue;
            }
            if (!this.deptReport.getPeriod().equalsIgnoreCase(PREVIOUS)) continue;
            if (this.deptReport.containsDepartmentInResultList(obj.getDepartmentName(), this.deptReport.getPreviousyearDepartmentList())) {
                for (DepartmentwiseExpenditureResult entry : this.deptReport.getPreviousyearDepartmentList()) {
                    if (!obj.getDepartmentName().equalsIgnoreCase(entry.getDepartmentNm())) continue;
                    entry.getDayAmountMap().put("Total", this.divideAndRound(obj.getConcurrenceAmount(), BigDecimal.valueOf(100000L)));
                    break;
                }
            }
            this.deptReport.getPreviousConcurrenceDateSet().add("Total");
        }
    }

    @Action(value="/report/departmentwiseExpenditureReport-newForm")
    public String newForm() {
        return "new";
    }

    protected void setRelatedEntitesOn() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"------------------ Inside setRelatedEntites API @setting header values --------------");
        }
        this.heading.append(" Department wise Expenditure Report for the Period from ");
        this.Preheading.append(" Department wise Expenditure Report for the Period from ");
        if (this.deptReport.getFinancialYearId() != null && !this.deptReport.getFinancialYearId().toString().equals("0") && !this.deptReport.getFinancialYearId().equals(" ") && this.deptReport.getFinancialYearId() != 0L) {
            this.deptReport.setFinyearObj((CFinancialYear)this.getPersistenceService().find(" from CFinancialYear where id=?", new Object[]{this.deptReport.getFinancialYearId()}));
        } else {
            this.deptReport.setFinyearObj(this.deService.getFinancialYearDAO().getFinancialYearByDate(this.deptReport.getFromDate()));
        }
        if (this.deptReport.getFundId() != null && this.deptReport.getFundId() != 0) {
            this.deptReport.setFund((Fund)this.getPersistenceService().find("from Fund where id=?", new Object[]{this.deptReport.getFundId()}));
        }
        if (this.deptReport.getReportType() != null && this.deptReport.getReportType().equals("Month")) {
            this.deptReport.setFromDate(this.deService.getStartDayOfMonth(this.deptReport));
            this.deptReport.setToDate(this.deService.getLastDayOfMonth(this.deptReport));
            this.heading.append(this.deService.getFormattedDate(this.deptReport.getFromDate()) + " To " + this.deService.getFormattedDate(this.deptReport.getToDate()));
            this.Preheading.append(this.deService.getFormattedDate(this.deService.getPreviousYearFor(this.deptReport.getFromDate())) + " To " + this.deService.getFormattedDate(this.deService.getPreviousYearFor(this.deptReport.getToDate())));
        } else {
            this.heading.append(this.deService.getFormattedDate(this.deptReport.getFromDate()) + " To " + this.deService.getFormattedDate(this.deptReport.getToDate()));
            this.Preheading.append(this.deService.getFormattedDate(this.deService.getPreviousYearFor(this.deptReport.getFromDate())) + " To " + this.deService.getFormattedDate(this.deService.getPreviousYearFor(this.deptReport.getToDate())));
        }
        this.deptReport.setPreviousYearConcurrenceGivenTillDate(this.deService.getPreviousYearFor(this.deptReport.getToDate()));
        this.deptReport.setPreviousYearConcurrenceGivenUptoDate(this.deService.getPreviousDateFor(this.deService.getPreviousYearFor(this.deptReport.getFromDate())));
        this.deptReport.setCurrentYearConcurrenceGivenUptoDate(this.deService.getPreviousDateFor(this.deptReport.getFromDate()));
    }

    public String generateReportXls() throws Exception {
        String title = this.getUlbName() + "\\n" + this.heading.toString();
        JasperPrint jasper = this.reportHelper.generateDepartmentwiseExpenditureJasperPrint(this.deptReport, title, this.Preheading.toString());
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return "XLS";
    }

    public String generateReportPdf() throws Exception {
        String title = this.getUlbName() + "\\n" + this.heading.toString();
        JasperPrint jasper = this.reportHelper.generateDepartmentwiseExpenditureJasperPrint(this.deptReport, title, this.Preheading.toString());
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return "PDF";
    }

    public String generateReportHTML() throws Exception {
        String title = this.getUlbName() + "\\n" + this.heading.toString();
        JasperPrint jasper = this.reportHelper.generateDepartmentwiseExpenditureJasperPrint(this.deptReport, title, this.Preheading.toString());
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, jasper);
        return "HTML";
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public BigDecimal divideAndRound(BigDecimal value, BigDecimal divisor) {
        value = value.divide(divisor, 2, 4);
        return value;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public DepartmentwiseExpenditureReport getDeptReport() {
        return this.deptReport;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void setDeptReport(DepartmentwiseExpenditureReport deptReport) {
        this.deptReport = deptReport;
    }

    public DEReportService getDepartmentExpenditureService() {
        return this.deService;
    }

    public void setDepartmentExpenditureService(DEReportService departmentExpenditureService) {
        this.deService = departmentExpenditureService;
    }

    public StringBuffer getHeading() {
        return this.heading;
    }

    public void setHeading(StringBuffer heading) {
        this.heading = heading;
    }
}

