/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import com.opensymphony.xwork2.validator.annotations.Validation;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.FunctionService;
import org.egov.commons.utils.BankAccountType;
import org.egov.egf.web.actions.payment.BasePaymentAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.payment.PaymentBean;
import org.egov.model.payment.Paymentheader;
import org.egov.model.voucher.WorkflowBean;
import org.egov.payment.services.PaymentActionHelper;
import org.egov.services.payment.PaymentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.VoucherHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name={"search"}, location="payment-search.jsp"), @Result(name={"searchbills"}, location="payment-searchbills.jsp"), @Result(name={"tnebSearch"}, location="payment-tnebSearch.jsp"), @Result(name={"balance"}, location="payment-balance.jsp"), @Result(name={"modify"}, location="payment-modify.jsp"), @Result(name={"form"}, location="payment-form.jsp"), @Result(name={"view"}, location="payment-view.jsp"), @Result(name={"list"}, location="payment-list.jsp")})
public class PaymentAction
extends BasePaymentAction {
    private static final String FORWARD = "Forward";
    private static final long serialVersionUID = 1L;
    private String expType;
    private String fromDate;
    private String toDate;
    private String mode;
    private String voucherdate;
    private String paymentMode;
    private String contractorIds = "";
    private String supplierIds = "";
    private String vouchernumber;
    private String voucherNumberPrefix = "";
    private String voucherNumberSuffix = "";
    private Long functionSel;
    private String contingentIds = "";
    private String salaryIds = "";
    private String pensionIds = "";
    private int miscount = 0;
    private boolean isDepartmentDefault;
    private BigDecimal balance;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private Paymentheader paymentheader = new Paymentheader();
    @Qualifier(value="paymentService")
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FunctionService functionService;
    private Integer bankaccount;
    private Integer bankbranch;
    private Integer departmentId;
    private Integer defaultDept;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private static final Logger LOGGER = Logger.getLogger(PaymentAction.class);
    private static final String PAYMENTID = "paymentid";
    private static final String VIEW = "view";
    private static final String LIST = "list";
    private static final String MODIFY = "modify";
    private String wfitemstate;
    private String type;
    private String billNumber;
    private String typeOfAccount;
    private List<EgBillregister> contractorBillList = null;
    private List<EgBillregister> supplierBillList = null;
    private List<EgBillregister> contingentBillList = null;
    private List<EgBillregister> salaryBillList = new ArrayList();
    private List<EgBillregister> pensionBillList = new ArrayList();
    private List<EgBillregister> totalBillList = new ArrayList();
    private List<Bankaccount> bankaccountList = null;
    private List<Miscbilldetail> miscBillList = null;
    private List<PaymentBean> billList;
    private List<PaymentBean> contractorList = null;
    private List<PaymentBean> supplierList = null;
    private List<PaymentBean> contingentList = null;
    private List<PaymentBean> salaryList = new ArrayList();
    private List<PaymentBean> pensionList = new ArrayList();
    private List<InstrumentHeader> instrumentHeaderList;
    private List<Paymentheader> paymentheaderList;
    private EgBillregister billregister;
    private boolean disableExpenditureType = false;
    private boolean enablePensionType = false;
    private boolean changePartyName;
    private String newPartyname;
    private String chk = "";
    private String fundNameStr = "";
    private String functionNameStr = "";
    private String deptNameStr = "";
    private String fundSourceNameStr = "";
    private String schemeStr = "";
    private String subSchemeStr = "";
    private Map<String, String> payeeMap = new HashMap();
    private Map<Long, BigDecimal> deductionAmtMap = new HashMap();
    private Map<Long, BigDecimal> paidAmtMap = new HashMap();
    private List<EgAdvanceRequisition> advanceRequisitionList = new ArrayList();
    private VoucherHelper voucherHelper;
    private CFunction cFunctionobj;
    private String rtgsDefaultMode;
    private Date rtgsModeRestrictionDateForCJV;
    private String billSubType;
    private String region;
    private String month;
    private String year;
    private String bank_branch;
    private String bank_account;
    private ScriptService scriptService;
    private Map<Integer, String> monthMap = new LinkedHashMap();
    private String attributes = "";
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private PaymentActionHelper paymentActionHelper;
    private String cutOffDate;
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf1 = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;

    public PaymentAction() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"creating PaymentAction...");
        }
        this.addRelatedEntity("paymentheader", Paymentheader.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"creating PaymentAction completed.");
        }
    }

    public void prepare() {
        super.prepare();
        if (this.fromDate == null) {
            this.fromDate = "";
        }
        if (this.toDate == null) {
            this.toDate = "";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepare...");
        }
        if (this.parameters.containsKey("salaryType")) {
            this.setDisableExpenditureType(true);
        }
        if (this.parameters.containsKey("pensionType")) {
            this.setEnablePensionType(true);
            this.setDisableExpenditureType(true);
        }
        if (this.parameters.get("fundId") != null && !((String[])this.parameters.get("fundId"))[0].equals("-1")) {
            Fund fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{Integer.parseInt(((String[])this.parameters.get("fundId"))[0])});
            this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and type in ('RECEIPTS_PAYMENTS','PAYMENTS') ) and br.isactive=true order by br.bank.name asc", new Object[]{fund}));
        } else {
            this.addDropdownData("bankbranchList", Collections.EMPTY_LIST);
        }
        if (this.parameters.get("functionSel") != null && !((String[])this.parameters.get("functionSel"))[0].equals("-1") && !((String[])this.parameters.get("functionSel"))[0].equals("")) {
            this.cFunctionobj = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("functionSel"))[0])});
        }
        if (this.getBankbranch() != null) {
            this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true ", new Object[]{this.getBankbranch()}));
        } else if (this.parameters.get("paymentheader.bankaccount.bankbranch.id") != null && !((String[])this.parameters.get("paymentheader.bankaccount.bankbranch.id"))[0].equals("-1")) {
            this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true ", new Object[]{Integer.valueOf(((String[])this.parameters.get("paymentheader.bankaccount.bankbranch.id"))[0])}));
        } else {
            this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
        }
        if (this.getBillregister() != null && this.getBillregister().getId() != null) {
            this.billregister = (EgBillregister)this.persistenceService.find(" from EgBillregister where id=?", new Object[]{this.getBillregister().getId()});
            this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? ) and br.isactive=true order by br.bank.name asc", new Object[]{this.billregister.getEgBillregistermis().getFund()}));
        }
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.addDropdownData("regionsList", VoucherHelper.TNEB_REGIONS);
        this.addDropdownData("financialYearsList", this.financialYearDAO.getAllActiveFinancialYearList());
        this.monthMap = DateUtils.getAllMonthsWithFullNames();
        this.typeOfAccount = "PAYMENTS,RECEIPTS_PAYMENTS";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepare.");
        }
    }

    private void loadbankBranch(Fund fund) {
        if (this.typeOfAccount != null && !this.typeOfAccount.equals("")) {
            if (this.typeOfAccount.indexOf(",") != -1) {
                String[] strArray = this.typeOfAccount.split(",");
                this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and isactive = true and type in (?,?) ) and br.isactive=true and br.bank.isactive = true order by br.bank.name asc", new Object[]{fund, BankAccountType.valueOf((String)strArray[0]), BankAccountType.valueOf((String)strArray[1])}));
            } else {
                this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and isactive = true and type in (?) ) and br.isactive=true and br.bank.isactive = true order by br.bank.name asc", new Object[]{fund, this.typeOfAccount}));
            }
        } else {
            this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and isactive = true) and br.isactive=true and br.bank.isactive = true order by br.bank.name asc", new Object[]{fund}));
        }
        String bankCode = null;
        if (this.billSubType != null && !this.billSubType.equalsIgnoreCase("")) {
            try {
                List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "EB Voucher Property-Bank");
                for (AppConfigValues appConfigVal : configValues) {
                    bankCode = appConfigVal.getValue();
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Appconfig value for EB Voucher propartys is not defined in the system");
            }
            this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and type in ('RECEIPTS_PAYMENTS','PAYMENTS') ) and br.isactive=true and br.bank.code = ? order by br.bank.name asc", new Object[]{fund, bankCode}));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadbankBranch.");
        }
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        this.voucherHeader.setType("Payment");
        return this.voucherHeader;
    }

    @SkipValidation
    @Action(value="/payment/payment-beforeSearch")
    public String beforeSearch() throws Exception {
        return "search";
    }

    @SkipValidation
    @Action(value="/payment/payment-beforeTNEBSearch")
    public String beforeTNEBSearch() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeTNEBSearch...");
        }
        this.setTNEBMandatoryFields();
        this.voucherHeader.getVouchermis().setDepartmentid(this.paymentService.getAssignment().getDepartment());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSearch.");
        }
        return "tnebSearch";
    }

    private void setTNEBMandatoryFields() {
        ArrayList<String> propartyAppConfigKeysList = new ArrayList<String>();
        LinkedHashMap<String, String> propartyAppConfigResultList = new LinkedHashMap<String, String>();
        propartyAppConfigKeysList.add("EB Voucher Property-Fund");
        propartyAppConfigKeysList.add("EB Voucher Property-Function");
        propartyAppConfigKeysList.add("EB Voucher Property-Department");
        propartyAppConfigKeysList.add("EB Voucher Property-BankBranch");
        propartyAppConfigKeysList.add("EB Voucher Property-BankAccount");
        for (String key : propartyAppConfigKeysList) {
            String value = null;
            try {
                List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", key);
                for (AppConfigValues appConfigVal : configValues) {
                    value = appConfigVal.getValue();
                    propartyAppConfigResultList.put(key, value);
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Appconfig value for EB Voucher propartys is not defined in the system");
            }
        }
        for (String key : propartyAppConfigResultList.keySet()) {
            if (key.equals("EB Voucher Property-Fund")) {
                this.voucherHeader.setFundId((Fund)this.persistenceService.find("from Fund where code = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-Function")) {
                this.voucherHeader.getVouchermis().setFunction((CFunction)this.persistenceService.find("from CFunction where code = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-Department")) {
                this.voucherHeader.getVouchermis().setDepartmentid((Department)this.persistenceService.find("from Department where deptCode = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-BankBranch")) {
                this.bank_branch = (String)propartyAppConfigResultList.get(key);
            }
            if (!key.equals("EB Voucher Property-BankAccount")) continue;
            this.bank_account = (String)propartyAppConfigResultList.get(key);
            Bankaccount ba = (Bankaccount)this.persistenceService.find(" from Bankaccount where accountnumber=?", new Object[]{this.bank_account});
            if (ba.getId() == null) continue;
            this.bankaccount = ba.getId().intValue();
        }
    }

    @SkipValidation
    @ValidationErrorPage(value="search")
    @Action(value="/payment/payment-search")
    public String search() throws Exception {
        LinkedHashSet tempBillList;
        String statusCheck;
        EgwStatus egwStatus1;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting search...");
        }
        StringBuffer sql = new StringBuffer();
        if (!"".equals(this.billNumber)) {
            sql.append(" and bill.billnumber = '" + this.billNumber + "' ");
        }
        if (!"".equals(this.fromDate)) {
            sql.append(" and bill.billdate>='" + this.sdf.format(this.formatter.parse(this.fromDate)) + "' ");
        }
        if (!"".equals(this.toDate)) {
            sql.append(" and bill.billdate<='" + this.sdf.format(this.formatter.parse(this.toDate)) + "'");
        }
        if (this.voucherHeader.getFundId() != null) {
            sql.append(" and bill.egBillregistermis.fund.id=" + this.voucherHeader.getFundId().getId());
        }
        if (this.voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and bill.egBillregistermis.fundsource.id=" + this.voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and bill.egBillregistermis.egDepartment.id=" + this.voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (this.voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and bill.egBillregistermis.scheme.id=" + this.voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (this.voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and bill.egBillregistermis.subScheme.id=" + this.voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (this.voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and bill.egBillregistermis.functionaryid.id=" + this.voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (this.voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and bill.egBillregistermis.fieldid=" + this.voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (this.voucherHeader.getVouchermis().getFunction() != null) {
            sql.append(" and bill.egBillregistermis.function=" + this.voucherHeader.getVouchermis().getFunction().getId());
        }
        EgwStatus egwStatus = null;
        String mainquery = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))";
        String mainquery1 = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)";
        if (this.disableExpenditureType && !this.enablePensionType || this.expType != null && !this.expType.equals("-1") && this.expType.equals("Salary")) {
            return this.salaryBills(sql, "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))", "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)");
        }
        if (this.disableExpenditureType && this.enablePensionType || this.expType != null && !this.expType.equals("-1") && this.expType.equals("Pension")) {
            return this.pensionBills(sql, "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))", "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start purchase bill");
        }
        if (this.expType == null || this.expType.equals("-1") || this.expType.equals("Purchase")) {
            egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("SBILL", "Approved");
            egwStatus1 = this.egwStatusHibernateDAO.getStatusByModuleAndCode("PURCHBILL", "Passed");
            statusCheck = "";
            statusCheck = egwStatus == null ? " and bill.status in (" + egwStatus1.getId() + ") " : " and bill.status in (" + egwStatus.getId() + "," + egwStatus1.getId() + ") ";
            String supplierBillSql = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))" + statusCheck + sql.toString() + " order by bill.billdate desc";
            String supplierBillSql1 = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)" + statusCheck + sql.toString() + " order by bill.billdate desc";
            this.supplierBillList = this.getPersistenceService().findPageBy(supplierBillSql, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Purchase"}).getList();
            if (this.supplierBillList != null) {
                this.supplierBillList.addAll(this.getPersistenceService().findPageBy(supplierBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Purchase"}).getList());
            } else {
                this.supplierBillList = this.getPersistenceService().findPageBy(supplierBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Purchase", egwStatus, egwStatus1}).getList();
            }
            tempBillList = new LinkedHashSet(this.supplierBillList);
            this.supplierBillList.clear();
            this.supplierBillList.addAll(tempBillList);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("supplierBillSql  ===> " + supplierBillSql));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"end purchase bill");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start works bill");
        }
        if (this.expType == null || this.expType.equals("-1") || this.expType.equals("Works")) {
            egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("WORKSBILL", "Passed");
            egwStatus1 = this.egwStatusHibernateDAO.getStatusByModuleAndCode("CONTRACTORBILL", "APPROVED");
            statusCheck = "";
            statusCheck = egwStatus1 == null ? " and bill.status in (" + egwStatus.getId() + ") " : " and bill.status in (" + egwStatus.getId() + "," + egwStatus1.getId() + ") ";
            String contractorBillSql = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))" + statusCheck + sql.toString() + " order by bill.billdate desc";
            String contractorBillSql1 = "from EgBillregister bill where bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)" + statusCheck + sql.toString() + " order by bill.billdate desc";
            this.contractorBillList = this.getPersistenceService().findPageBy(contractorBillSql, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Works"}).getList();
            if (this.contractorBillList != null) {
                this.contractorBillList.addAll(this.getPersistenceService().findPageBy(contractorBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Works"}).getList());
            } else {
                this.contractorBillList = this.getPersistenceService().findPageBy(contractorBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Works"}).getList();
            }
            tempBillList = new LinkedHashSet(this.contractorBillList);
            this.contractorBillList.clear();
            this.contractorBillList.addAll(tempBillList);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("contractorBillSql  ===> " + contractorBillSql));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"end works bill");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start contingent bill");
        }
        if (this.expType == null || this.expType.equals("-1") || this.expType.equals("Expense")) {
            String cBillmainquery = "from EgBillregister bill left join fetch bill.egBillregistermis.egBillSubType egBillSubType where (egBillSubType is null or egBillSubType.name not in ('TNEB')) and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))";
            String cBillmainquery1 = "from EgBillregister bill left join fetch bill.egBillregistermis.egBillSubType egBillSubType where (egBillSubType is null or egBillSubType.name not in ('TNEB')) and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)";
            egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("EXPENSEBILL", "Approved");
            String cBillSql = "from EgBillregister bill left join fetch bill.egBillregistermis.egBillSubType egBillSubType where (egBillSubType is null or egBillSubType.name not in ('TNEB')) and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5)) and bill.status in (?) " + sql.toString() + " order by bill.billdate desc";
            String cBillSql1 = "from EgBillregister bill left join fetch bill.egBillregistermis.egBillSubType egBillSubType where (egBillSubType is null or egBillSubType.name not in ('TNEB')) and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4) and bill.status in (?) " + sql.toString() + " order by bill.billdate desc";
            this.contingentBillList = this.getPersistenceService().findPageBy(cBillSql, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus}).getList();
            if (this.contingentBillList != null) {
                this.contingentBillList.addAll(this.getPersistenceService().findPageBy(cBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus}).getList());
            } else {
                this.contingentBillList = this.getPersistenceService().findPageBy(cBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus}).getList();
            }
            tempBillList = new LinkedHashSet(this.contingentBillList);
            this.contingentBillList.clear();
            this.contingentBillList.addAll(tempBillList);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("cBillSql  ===> " + cBillSql));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"end contingent bill");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getting glcodeids");
        }
        this.paymentService.getGlcodeIds();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"done glcodeids");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction works start");
        }
        this.deductionAmtMap = this.paymentService.getDeductionAmt(this.contractorBillList, "Works");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction works end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction supplier start");
        }
        this.deductionAmtMap.putAll(this.paymentService.getDeductionAmt(this.supplierBillList, "Purchase"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction supplier end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction contingent start");
        }
        this.deductionAmtMap.putAll(this.paymentService.getDeductionAmt(this.contingentBillList, "Expense"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"deduction contingent end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt works start");
        }
        this.paidAmtMap = this.paymentService.getEarlierPaymentAmt(this.contractorBillList, "Works");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt works end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt purchase start");
        }
        this.paidAmtMap.putAll(this.paymentService.getEarlierPaymentAmt(this.supplierBillList, "Purchase"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt purchase end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt contingent start");
        }
        this.paidAmtMap.putAll(this.paymentService.getEarlierPaymentAmt(this.contingentBillList, "Expense"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"paidamt contingent end");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getCSList all 3 start");
        }
        this.contractorList = this.paymentService.getCSList(this.contractorBillList, this.deductionAmtMap, this.paidAmtMap);
        this.supplierList = this.paymentService.getCSList(this.supplierBillList, this.deductionAmtMap, this.paidAmtMap);
        this.contingentList = this.paymentService.getCSList(this.contingentBillList, this.deductionAmtMap, this.paidAmtMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getCSList all 3 end");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("contingentList size ===" + this.contingentList.size()));
        }
        this.setMode("search");
        this.paymentMode = "cheque";
        this.loadSchemeSubscheme();
        this.loadFundSource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed search.");
        }
        return "searchbills";
    }

    private String salaryBills(StringBuffer sql, String mainquery, String mainquery1) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting salaryBills...");
        }
        EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("SALBILL", "Approved");
        EgwStatus egwStatus1 = this.egwStatusHibernateDAO.getStatusByModuleAndCode("SBILL", "Approved");
        String sBillSql = mainquery + " and bill.status in (?,?) " + sql.toString() + " order by bill.billdate desc";
        String sBillSql1 = mainquery1 + " and bill.status in (?,?) " + sql.toString() + " order by bill.billdate desc";
        this.salaryBillList = this.getPersistenceService().findAllBy(sBillSql, new Object[]{"Salary", egwStatus, egwStatus1});
        if (this.salaryBillList != null) {
            this.salaryBillList.addAll(this.getPersistenceService().findAllBy(sBillSql1, new Object[]{"Salary", egwStatus, egwStatus1}));
        } else {
            this.salaryBillList = this.getPersistenceService().findAllBy(sBillSql1, new Object[]{"Salary", egwStatus, egwStatus1});
        }
        LinkedHashSet tempBillList = new LinkedHashSet(this.salaryBillList);
        this.salaryBillList.clear();
        this.salaryBillList.addAll(tempBillList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sBillSql  ===> " + sBillSql));
        }
        this.paymentService.getGlcodeIds();
        this.deductionAmtMap = this.paymentService.getDeductionAmt(this.salaryBillList, "Salary");
        this.paidAmtMap = this.paymentService.getEarlierPaymentAmt(this.salaryBillList, "Salary");
        this.salaryList = this.paymentService.getCSList(this.salaryBillList, this.deductionAmtMap, this.paidAmtMap);
        this.setMode("search");
        this.paymentMode = "cash";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed salaryBills.");
        }
        return "salaryBills";
    }

    private String pensionBills(StringBuffer sql, String mainquery, String mainquery1) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting pensionBills...");
        }
        EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("PENSIONBILL", "Approved");
        String pBillSql = mainquery + " and bill.status in (?) " + sql.toString() + " order by bill.billdate desc";
        String pBillSql1 = mainquery1 + " and bill.status in (?) " + sql.toString() + " order by bill.billdate desc";
        this.pensionBillList = this.getPersistenceService().findAllBy(pBillSql, new Object[]{"Pension", egwStatus});
        if (this.pensionBillList != null) {
            this.pensionBillList.addAll(this.getPersistenceService().findAllBy(pBillSql1, new Object[]{"Pension", egwStatus}));
        } else {
            this.pensionBillList = this.getPersistenceService().findAllBy(pBillSql1, new Object[]{"Pension", egwStatus});
        }
        LinkedHashSet tempBillList = new LinkedHashSet(this.pensionBillList);
        this.pensionBillList.clear();
        this.pensionBillList.addAll(tempBillList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("pBillSql  ===> " + pBillSql));
        }
        this.paymentService.getGlcodeIds();
        this.deductionAmtMap = this.paymentService.getDeductionAmt(this.pensionBillList, "Pension");
        this.paidAmtMap = this.paymentService.getEarlierPaymentAmt(this.pensionBillList, "Pension");
        this.pensionList = this.paymentService.getCSList(this.pensionBillList, this.deductionAmtMap, this.paidAmtMap);
        this.setMode("search");
        this.paymentMode = "cash";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed pensionBills.");
        }
        return "pensionBills";
    }

    @ValidationErrorPage(value="tnebSearch")
    public String tnebBills() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting tnebBills...");
        }
        StringBuffer sql = new StringBuffer();
        if (!"".equals(this.billNumber)) {
            sql.append(" and bill.billnumber = '" + this.billNumber + "' ");
        }
        if (this.voucherHeader.getFundId() != null) {
            sql.append(" and bill.egBillregistermis.fund.id=" + this.voucherHeader.getFundId().getId());
        }
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and bill.egBillregistermis.egDepartment.id=" + this.voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (this.voucherHeader.getVouchermis().getFunction() != null) {
            sql.append(" and bill.egBillregistermis.function=" + this.voucherHeader.getVouchermis().getFunction().getId());
        }
        String tnebSqlMainquery = "select bill from EgBillregister bill , EBDetails ebd   where  bill.id = ebd.egBillregister.id and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5))";
        String tnebSqlMainquery1 = "select bill from EgBillregister bill , EBDetails ebd  where  bill.id = ebd.egBillregister.id and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4)";
        if (this.billSubType != null && !this.billSubType.equalsIgnoreCase("")) {
            sql.append(" and bill.egBillregistermis.egBillSubType.name='" + this.billSubType + "'");
        }
        if (this.region != null && !this.region.equalsIgnoreCase("")) {
            sql.append(" and ebd.region='" + this.region + "'");
        }
        if (this.month != null && !this.month.equalsIgnoreCase("")) {
            sql.append(" and ebd.month=" + this.month + "");
        }
        if (this.year != null && !this.year.equalsIgnoreCase("")) {
            sql.append(" and ebd.financialyear.id=" + this.year + "");
        }
        EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("EXPENSEBILL", "Approved");
        EgwStatus egwStatus1 = this.egwStatusHibernateDAO.getStatusByModuleAndCode("CBILL", "APPROVED");
        String tnebBillSql = "select bill from EgBillregister bill , EBDetails ebd   where  bill.id = ebd.egBillregister.id and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.passedamount > (select SUM(misc.paidamount) from Miscbilldetail misc where misc.billVoucherHeader = bill.egBillregistermis.voucherHeader  and misc.payVoucherHeader.status in (0,5)) and bill.status in (?,?) " + sql.toString() + " order by bill.billdate desc";
        String tnebBillSql1 = "select bill from EgBillregister bill , EBDetails ebd  where  bill.id = ebd.egBillregister.id and bill.expendituretype=? and bill.egBillregistermis.voucherHeader.status=0  and bill.egBillregistermis.voucherHeader NOT IN (select misc.billVoucherHeader from Miscbilldetail misc where misc.billVoucherHeader is not null and misc.payVoucherHeader.status <> 4) and bill.status in (?,?) " + sql.toString() + " order by bill.billdate desc";
        this.contingentBillList = this.getPersistenceService().findPageBy(tnebBillSql, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus, egwStatus1}).getList();
        if (this.contingentBillList != null) {
            this.contingentBillList.addAll(this.getPersistenceService().findPageBy(tnebBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus, egwStatus1}).getList());
        } else {
            this.contingentBillList = this.getPersistenceService().findPageBy(tnebBillSql1, Integer.valueOf(1), Integer.valueOf(500), new Object[]{"Expense", egwStatus, egwStatus1}).getList();
        }
        LinkedHashSet tempBillList = new LinkedHashSet(this.contingentBillList);
        this.contingentBillList.clear();
        this.contingentBillList.addAll(tempBillList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("tnebBillSql  ===> " + tnebBillSql));
        }
        this.paymentService.getGlcodeIds();
        this.deductionAmtMap = this.paymentService.getDeductionAmt(this.contingentBillList, "Expense");
        this.paidAmtMap = this.paymentService.getEarlierPaymentAmt(this.contingentBillList, "Expense");
        this.contingentList = this.paymentService.getCSList(this.contingentBillList, this.deductionAmtMap, this.paidAmtMap);
        this.setMode("search");
        this.paymentMode = "rtgs";
        this.setTNEBMandatoryFields();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed tnebBills.");
        }
        return "tnebBills";
    }

    @SkipValidation
    @ValidationErrorPage(value="searchbills")
    @Action(value="/payment/payment-save")
    public String save() throws ValidationException {
        ArrayList paymentList = new ArrayList();
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            try {
                this.date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.cutOffDate = this.formatter.format(this.date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        try {
            String paymentMd = ((String[])this.parameters.get("paymentMode"))[0];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Starting generatePayment...");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Expenditure type is--------------------------------- " + this.expType));
            }
            if (null != this.contractorList && !this.contractorList.isEmpty()) {
                paymentList.addAll(this.contractorList);
            }
            if (null != this.supplierList && !this.supplierList.isEmpty()) {
                paymentList.addAll(this.supplierList);
            }
            if (null != this.contingentList && !this.contingentList.isEmpty()) {
                paymentList.addAll(this.contingentList);
            }
            if (null != this.salaryList && !this.salaryList.isEmpty()) {
                paymentList.addAll(this.salaryList);
            }
            if (null != this.pensionList && !this.pensionList.isEmpty()) {
                paymentList.addAll(this.pensionList);
            }
            if (this.rtgsDefaultMode != null && this.rtgsDefaultMode.equalsIgnoreCase("Y") && !paymentMd.equalsIgnoreCase("rtgs") && this.paymentService.CheckForContractorSubledgerCodes(paymentList, this.rtgsModeRestrictionDateForCJV)) {
                throw new ValidationException(Arrays.asList(new ValidationError("Payment Mode of any bill having Contractor/Supplier subledger should  RTGS For Bill Date Greater than 01-Oct-2013", "Payment Mode of any bill having Contractor/Supplier subledger should  RTGS For Bill Date Greater than 01-Oct-2013")));
            }
            this.billList = new ArrayList();
            this.contractorIds = this.contractorIds + this.populateBillListFor(this.contractorList, this.contractorIds);
            this.supplierIds = this.supplierIds + this.populateBillListFor(this.supplierList, this.supplierIds);
            this.contingentIds = this.contingentIds + this.populateBillListFor(this.contingentList, this.contingentIds);
            this.salaryIds = this.salaryIds + this.populateBillListFor(this.salaryList, this.salaryIds);
            this.pensionIds = this.pensionIds + this.populateBillListFor(this.pensionList, this.pensionIds);
            if (this.salaryIds != null && this.salaryIds.length() > 0) {
                this.disableExpenditureType = true;
            }
            if (this.pensionIds != null && this.pensionIds.length() > 0) {
                this.disableExpenditureType = true;
                this.enablePensionType = true;
            }
            this.billregister = (EgBillregister)this.persistenceService.find(" from EgBillregister where id=?", new Object[]{((PaymentBean)this.billList.get(0)).getBillId()});
            if (this.billregister.getEgBillregistermis().getFunction() != null) {
                this.setFunctionSel(this.billregister.getEgBillregistermis().getFunction().getId());
            }
            this.loadbankBranch(this.billregister.getEgBillregistermis().getFund());
            this.miscount = this.billList.size();
            if (((String[])this.parameters.get("paymentMode"))[0].equalsIgnoreCase("RTGS")) {
                this.paymentService.validateForRTGSPayment(this.contractorList, "Contractor");
                this.paymentService.validateForRTGSPayment(this.supplierList, "Supplier");
                if (this.billSubType == null || this.billSubType.equalsIgnoreCase("")) {
                    this.paymentService.validateForRTGSPayment(this.contingentList, "Expense");
                }
            }
            if (!"Auto".equalsIgnoreCase(this.voucherTypeForULB.readVoucherTypes("Payment"))) {
                this.headerFields.add("vouchernumber");
                this.mandatoryFields.add("vouchernumber");
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Expenditure type is--------------------------------- " + this.expType));
            }
            this.voucherdate = this.formatter.format(new Date());
        }
        catch (ValidationException e) {
            try {
                this.search();
            }
            catch (Exception e1) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e1);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e1.getMessage()));
                throw new ValidationException(errors);
            }
            LOGGER.error((Object)e.getErrors(), (Throwable)e);
            throw new ValidationException(e.getErrors());
        }
        catch (ApplicationException e) {
            try {
                this.search();
            }
            catch (Exception e1) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e1);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exception", e1.getMessage()));
                throw new ValidationException(errors);
            }
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generatePayment.");
        }
        return "form";
    }

    private String populateBillListFor(List<PaymentBean> list, String ids) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting populateBillListFor...");
        }
        String tempAttributes = "";
        if (list != null) {
            for (PaymentBean bean : list) {
                if (bean == null) continue;
                if (this.chk.equals("")) {
                    this.chk = "checked";
                    this.fundNameStr = bean.getFundName() == null ? "" : bean.getFundName();
                    this.functionNameStr = bean.getFunctionName() == null ? "" : bean.getFunctionName();
                    this.deptNameStr = bean.getDeptName() == null ? "" : bean.getDeptName();
                    this.fundSourceNameStr = bean.getFundsourceName() == null ? "" : bean.getFundsourceName();
                    this.schemeStr = bean.getSchemeName() == null ? "" : bean.getSchemeName();
                    this.subSchemeStr = bean.getSubschemeName() == null ? "" : bean.getSubschemeName();
                    this.region = bean.getRegion() == null ? "" : bean.getRegion();
                    this.attributes = this.fundNameStr + "-" + this.fundSourceNameStr + "-" + this.schemeStr + "-" + this.subSchemeStr;
                }
                if (this.attributes.equalsIgnoreCase(tempAttributes = (bean.getFundName() == null ? "" : bean.getFundName()) + "-" + (bean.getFundsourceName() == null ? "" : bean.getFundsourceName()) + "-" + (bean.getSchemeName() == null ? "" : bean.getSchemeName()) + "-" + (bean.getSubschemeName() == null ? "" : bean.getSubschemeName()))) {
                    this.billList.add(bean);
                    ids = ids + bean.getBillId() + ",";
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Validation Error mismatch in attributes ");
                }
                throw new ValidationException(Arrays.asList(new ValidationError("Mismatch in attributes", "Mismatch in attributes!!")));
            }
            if (ids.length() > 0) {
                ids = ids.substring(0, ids.length() - 1);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed populateBillListFor.");
        }
        return ids;
    }

    @ValidationErrorPage(value="form")
    @SkipValidation
    @Action(value="/payment/payment-create")
    public String create() {
        try {
            String vdate = ((String[])this.parameters.get("voucherdate"))[0];
            Date date1 = this.sdf1.parse(vdate);
            String voucherDate = this.formatter1.format(date1);
            String cutOffDate1 = null;
            this.paymentActionHelper.setbillRegisterFunction(this.billregister, this.cFunctionobj);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Starting createPayment...");
            }
            this.populateWorkflowBean();
            if (this.parameters.get("department") != null) {
                this.billregister.getEgBillregistermis().setEgDepartment(this.departmentService.getDepartmentById(Long.valueOf(((String[])this.parameters.get("department"))[0].toString())));
            }
            if (this.parameters.get("function") != null) {
                this.billregister.getEgBillregistermis().setFunction(this.functionService.findOne(Long.valueOf(((String[])this.parameters.get("function"))[0].toString())));
            }
            this.paymentheader = this.paymentService.createPayment(this.parameters, this.billList, this.billregister, this.workflowBean);
            this.miscBillList = this.paymentActionHelper.getPaymentBills(this.paymentheader);
            if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                try {
                    this.date = this.sdf1.parse(this.cutOffDate);
                    cutOffDate1 = this.formatter1.format(this.date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getMessage("payment.transaction.success", new String[]{this.paymentheader.getVoucherheader().getVoucherNumber()}));
            } else {
                this.addActionMessage(this.getMessage("payment.transaction.success", new String[]{this.paymentheader.getVoucherheader().getVoucherNumber()}));
                if (FORWARD.equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                    this.addActionMessage(this.getMessage("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
                }
            }
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", ((ValidationError)e.getErrors().get(0)).getMessage()));
            this.loadbankBranch(this.billregister.getEgBillregistermis().getFund());
            throw new ValidationException(errors);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            this.loadbankBranch(this.billregister.getEgBillregistermis().getFund());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            this.loadbankBranch(this.billregister.getEgBillregistermis().getFund());
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createPayment.");
        }
        this.setMode(VIEW);
        return VIEW;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/payment/payment-sendForApproval")
    public String sendForApproval() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting sendForApproval...");
        }
        if (this.paymentheader.getId() == null) {
            this.paymentheader = this.getPayment();
        }
        this.populateWorkflowBean();
        this.paymentheader = this.paymentActionHelper.sendForApproval(this.paymentheader, this.workflowBean);
        this.paymentActionHelper.getPaymentBills(this.paymentheader);
        if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.rejected", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        if (FORWARD.equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getMessage("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.cancelled"));
        } else if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            if ("Closed".equals(this.paymentheader.getState().getValue())) {
                this.addActionMessage(this.getMessage("payment.voucher.final.approval"));
            } else {
                this.addActionMessage(this.getMessage("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
            }
        }
        if ("Advance Payment".equalsIgnoreCase(this.paymentheader.getVoucherheader().getName())) {
            this.advanceRequisitionList.addAll(this.paymentActionHelper.getAdvanceRequisitionDetails(this.paymentheader));
            return "advancePaymentView";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed sendForApproval.");
        }
        this.setMode(VIEW);
        return VIEW;
    }

    public String getComments() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getComments...");
        }
        return this.getText("payment.comments", new String[]{this.paymentheader.getPaymentAmount().setScale(2, 6).toPlainString()});
    }

    @SkipValidation
    @Action(value="/payment/payment-view")
    public String view() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting view...");
        }
        this.paymentheader = this.getPayment();
        this.miscBillList = this.paymentActionHelper.getPaymentBills(this.paymentheader);
        this.getChequeInfo(this.paymentheader);
        if (null != this.parameters.get("showMode") && ((String[])this.parameters.get("showMode"))[0].equalsIgnoreCase(VIEW)) {
            this.mode = ((String[])this.parameters.get("showMode"))[0];
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("defaultDept in vew : " + this.getDefaultDept()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed view.");
        }
        return VIEW;
    }

    @SkipValidation
    public String advanceView() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting advanceView...");
        }
        this.paymentheader = this.getPayment();
        if (this.paymentheader.getState().getValue() != null && !this.paymentheader.getState().getValue().isEmpty() && this.paymentheader.getState().getValue().contains("Rejected")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Completed advanceView.");
            }
            return this.modifyAdvancePayment();
        }
        this.advanceRequisitionList.addAll(this.paymentActionHelper.getAdvanceRequisitionDetails(this.paymentheader));
        this.getChequeInfo(this.paymentheader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed advanceView.");
        }
        return "advancePaymentView";
    }

    public void getChequeInfo(Paymentheader paymentheader) {
        paymentheader = this.getPayment();
        this.instrumentHeaderList = this.getPersistenceService().findAllBy(" from InstrumentHeader ih where ih.id in (select iv.instrumentHeaderId.id from InstrumentVoucher iv where iv.voucherHeaderId.id=?) order by instrumentNumber", new Object[]{paymentheader.getVoucherheader().getId()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Retrived cheque info details for the paymentheader");
        }
    }

    @SkipValidation
    public boolean validateUser(String purpose) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"------------------Starting validateUser...");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"-------------------------------------------------------------------------------------------------");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Calling Validate User " + purpose));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"-------------------------------------------------------------------------------------------------");
        }
        Script validScript = (Script)this.getPersistenceService().findAllByNamedQuery("Script.findByName", new Object[]{"Paymentheader.show.bankbalance"}).get(0);
        List list = (List)this.scriptService.executeScript(validScript, ScriptService.createContext((Object[])new Object[]{"persistenceService", this.paymentService, "purpose", purpose}));
        if (((String)list.get(0)).equals("true")) {
            if (purpose.equals("balancecheck")) {
                this.paymentheader = this.getPayment();
                try {
                    this.getBankBalance(this.paymentheader.getBankaccount().getId().toString(), this.formatter.format(new Date()), this.paymentheader.getPaymentAmount(), this.paymentheader.getId(), this.paymentheader.getBankaccount().getChartofaccounts().getId());
                }
                catch (ValidationException e) {
                    LOGGER.error((Object)("Error" + e.getMessage()), (Throwable)e);
                    this.balance = BigDecimal.valueOf(-1L);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Completed validateUser.");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateUser.");
        }
        return false;
    }

    @SkipValidation
    public String ajaxLoadBankAccounts() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting ajaxLoadBankAccounts...");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Bankbranch id = " + ((String[])this.parameters.get("bankbranch"))[0]));
        }
        Bankbranch bankbranch = (Bankbranch)this.persistenceService.find("from Bankbranch where id = ?", new Object[]{Integer.parseInt(((String[])this.parameters.get("bankbranch"))[0])});
        this.bankaccountList = this.getPersistenceService().findAllBy(" FROM Bankaccount where bankbranch=? and isactive=true ", new Object[]{bankbranch});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed ajaxLoadBankAccounts.");
        }
        return "bankaccount";
    }

    @SkipValidation
    @Action(value="/payment/payment-ajaxGetAccountBalance")
    public String ajaxGetAccountBalance() throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside ajaxGetAccountBalance.");
        }
        this.getBankBalance(((String[])this.parameters.get("bankaccount"))[0], ((String[])this.parameters.get("voucherDate"))[0], null, null, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed ajaxGetAccountBalance.");
        }
        return "balance";
    }

    @SkipValidation
    public void getBankBalance(String accountId, String vdate, BigDecimal amount, Long paymentId, Long bankGlcodeId) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getBankBalance.");
        }
        try {
            this.balance = this.paymentService.getAccountBalance(accountId, vdate, amount, paymentId, bankGlcodeId);
        }
        catch (Exception e) {
            this.balance = BigDecimal.valueOf(-1L);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getBankBalance.");
        }
    }

    @SkipValidation
    @Action(value="/payment/payment-beforeModify")
    public String beforeModify() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeModify.");
        }
        this.voucherHeader.getVouchermis().setDepartmentid(this.paymentService.getAssignment().getDepartment());
        this.action = "search";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeModify.");
        }
        return LIST;
    }

    @ValidationErrorPage(value="list")
    public String list() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting list...");
        }
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Deposited");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        String statusId = "";
        for (EgwStatus egwStatus : egwStatusList) {
            statusId = statusId + egwStatus.getId() + ",";
        }
        statusId = statusId.substring(0, statusId.length() - 1);
        StringBuffer sql = new StringBuffer();
        if (!StringUtils.isBlank((String)this.fromDate)) {
            sql.append(" and ph.voucherheader.voucherDate>='" + this.sdf.format(this.formatter.parse(this.fromDate)) + "' ");
        }
        if (!StringUtils.isBlank((String)this.toDate)) {
            sql.append(" and ph.voucherheader.voucherDate<='" + this.sdf.format(this.formatter.parse(this.toDate)) + "'");
        }
        if (!StringUtils.isBlank((String)this.voucherHeader.getVoucherNumber())) {
            sql.append(" and ph.voucherheader.voucherNumber like '%" + this.voucherHeader.getVoucherNumber() + "%'");
        }
        if (this.voucherHeader.getFundId() != null) {
            sql.append(" and ph.voucherheader.fundId.id=" + this.voucherHeader.getFundId().getId());
        }
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and ph.voucherheader.vouchermis.departmentid.id=" + this.voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (this.voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and ph.voucherheader.vouchermis.schemeid.id=" + this.voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (this.voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and ph.voucherheader.vouchermis.subschemeid.id=" + this.voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (this.voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and ph.voucherheader.vouchermis.functionary.id=" + this.voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (this.voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and ph.voucherheader.vouchermis.divisionid.id=" + this.voucherHeader.getVouchermis().getDivisionid().getId());
        }
        this.paymentheaderList = this.getPersistenceService().findAllBy(" from Paymentheader ph where ph.voucherheader.status=0 and (ph.voucherheader.isConfirmed=null or ph.voucherheader.isConfirmed=0) " + sql.toString() + "  and ph.voucherheader.id not in (select iv.voucherHeaderId.id from InstrumentVoucher iv where iv.instrumentHeaderId in (from InstrumentHeader ih where ih.statusId.id in (" + statusId + ") ))", new Object[0]);
        this.action = LIST;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed list...");
        }
        return LIST;
    }

    @ValidationErrorPage(value="list")
    @SkipValidation
    @Action(value="/payment/payment-modify")
    public String modify() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting modify...");
        }
        this.paymentheader = this.getPayment();
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
            this.voucherNumberPrefix = this.paymentheader.getVoucherheader().getVoucherNumber().substring(0, Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH));
            this.voucherNumberSuffix = this.paymentheader.getVoucherheader().getVoucherNumber().substring(Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH, this.paymentheader.getVoucherheader().getVoucherNumber().length()));
        }
        this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true ", new Object[]{this.paymentheader.getBankaccount().getBankbranch().getId()}));
        this.loadbankBranch(this.paymentheader.getVoucherheader().getFundId());
        this.billList = this.paymentService.getMiscBillList(this.paymentheader);
        if ("Salary Bill Payment".equalsIgnoreCase(this.paymentheader.getVoucherheader().getName())) {
            this.disableExpenditureType = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed modify.");
        }
        return MODIFY;
    }

    @ValidationErrorPage(value="list")
    @SkipValidation
    public String modifyAdvancePayment() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting modifyAdvancePayment...");
        }
        this.paymentheader = (Paymentheader)this.persistenceService.find(" from Paymentheader where id=? ", new Object[]{this.paymentheader.getId()});
        this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true and fund.id=?", new Object[]{this.paymentheader.getBankaccount().getBankbranch().getId(), this.paymentheader.getBankaccount().getFund().getId()}));
        this.loadbankBranch(this.paymentheader.getVoucherheader().getFundId());
        this.advanceRequisitionList.addAll(this.paymentActionHelper.getAdvanceRequisitionDetails(this.paymentheader));
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
            this.voucherNumberPrefix = this.paymentheader.getVoucherheader().getVoucherNumber().substring(0, Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH));
            this.voucherNumberSuffix = this.paymentheader.getVoucherheader().getVoucherNumber().substring(Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH, this.paymentheader.getVoucherheader().getVoucherNumber().length()));
        }
        try {
            this.balance = this.paymentService.getAccountBalance(this.paymentheader.getBankaccount().getId().toString(), this.formatter.format(new Date()), this.paymentheader.getPaymentAmount(), this.paymentheader.getId(), this.paymentheader.getBankaccount().getChartofaccounts().getId());
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error" + e.getMessage()), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("Error While formatting date", "Error While formatting date")));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed modifyAdvancePayment...");
        }
        return "advancePaymentModify";
    }

    @ValidationErrorPage(value="modify")
    @SkipValidation
    @Action(value="/payment/payment-cancel")
    public String cancelPayment() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting cancelPayment...");
        }
        this.paymentheader = (Paymentheader)this.persistenceService.find(" from Paymentheader where id=? ", new Object[]{this.paymentheader.getId()});
        this.voucherHeader = this.paymentheader.getVoucherheader();
        this.voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
        this.paymentheader.transition(true).end();
        this.persistenceService.persist((Object)this.voucherHeader);
        this.addActionMessage(this.getMessage("payment.cancel.success"));
        this.action = ((String[])this.parameters.get("actionname"))[0];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed cancelPayment...");
        }
        return VIEW;
    }

    @ValidationErrorPage(value="modify")
    @SkipValidation
    @Action(value="/payment/payment-edit")
    public String edit() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting update...");
        }
        try {
            this.validateForUpdate();
            if (!this.getFieldErrors().isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Completed update...");
                }
                return MODIFY;
            }
            this.paymentheader = this.paymentService.updatePayment(this.parameters, this.billList, this.paymentheader);
            this.miscBillList = this.paymentActionHelper.getPaymentBills(this.paymentheader);
            this.sendForApproval();
            this.addActionMessage(this.getMessage("payment.transaction.success", new String[]{this.paymentheader.getVoucherheader().getVoucherNumber()}));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error" + e.getMessage()), (Throwable)e);
            this.addDropdownData("bankbranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? ) and br.isactive=true order by br.bank.name asc", new Object[]{this.paymentheader.getVoucherheader().getFundId()}));
            throw new ValidationException(e.getErrors());
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed update...");
        }
        return VIEW;
    }

    @ValidationErrorPage(value="advancePaymentModify")
    @SkipValidation
    public String updateAdvancePayment() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting updateAdvancePayment...");
        }
        this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where id=?", new Object[]{this.paymentheader.getId()});
        this.advanceRequisitionList.addAll(this.paymentActionHelper.getAdvanceRequisitionDetails(this.paymentheader));
        try {
            this.validateAdvancePayment();
            this.paymentheader.setBankaccount((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Integer.valueOf(((String[])this.parameters.get("paymentheader.bankaccount.id"))[0])}));
            this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true and fund.id=?", new Object[]{this.paymentheader.getBankaccount().getBankbranch().getId(), this.paymentheader.getBankaccount().getFund().getId()}));
            this.loadbankBranch(this.paymentheader.getBankaccount().getFund());
            if (!this.getFieldErrors().isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Completed updateAdvancePayment.");
                }
                return "advancePaymentModify";
            }
            Integer userId = null;
            userId = null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue());
            this.addActionMessage(this.getMessage("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error" + e.getMessage()), (Throwable)e);
            this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true and fund.id=?", new Object[]{this.paymentheader.getBankaccount().getBankbranch().getId(), this.paymentheader.getBankaccount().getFund().getId()}));
            this.loadbankBranch(this.paymentheader.getBankaccount().getFund());
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true and fund.id=?", new Object[]{this.paymentheader.getBankaccount().getBankbranch().getId(), this.paymentheader.getBankaccount().getFund().getId()}));
            this.loadbankBranch(this.paymentheader.getBankaccount().getFund());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed updateAdvancePayment.");
        }
        return "advancePaymentView";
    }

    private void validateAdvancePayment() throws ValidationException, ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateAdvancePayment...");
        }
        if (this.paymentheader.getVoucherheader().getVoucherDate() == null || this.paymentheader.getVoucherheader().getVoucherDate().equals("")) {
            throw new ValidationException(Arrays.asList(new ValidationError("payment.voucherdate.empty", "payment.voucherdate.empty")));
        }
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        if (!"Auto".equalsIgnoreCase(vNumGenMode) && (this.voucherNumberSuffix == null || this.voucherNumberSuffix.equals(""))) {
            throw new ValidationException(Arrays.asList(new ValidationError("payment.vouchernumber.empty", "payment.vouchernumber.empty")));
        }
        if (((String[])this.parameters.get("paymentheader.bankaccount.bankbranch.id"))[0].equals("-1")) {
            throw new ValidationException(Arrays.asList(new ValidationError("bankbranch.empty", "bankbranch.empty")));
        }
        if (((String[])this.parameters.get("paymentheader.bankaccount.id"))[0].equals("-1")) {
            throw new ValidationException(Arrays.asList(new ValidationError("bankaccount.empty", "bankaccount.empty")));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateAdvancePayment...");
        }
    }

    private void validateForUpdate() throws ValidationException, ApplicationException, ParseException {
        String vNumGenMode;
        ArrayList<PaymentBean> tempBillList = new ArrayList<PaymentBean>();
        ArrayList<String> expenseTypeList = new ArrayList<String>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateForUpdate...");
        }
        if (this.paymentheader.getVoucherheader().getVoucherDate() == null || this.paymentheader.getVoucherheader().getVoucherDate().equals("")) {
            this.addFieldError("paymentheader.voucherheader.voucherDate", this.getMessage("payment.voucherdate.empty"));
        }
        if (!"Auto".equalsIgnoreCase(vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment")) && (this.voucherNumberSuffix == null || this.voucherNumberSuffix.equals(""))) {
            this.addFieldError("paymentheader.voucherheader.voucherNumber", this.getMessage("payment.vouchernumber.empty"));
        }
        if (((String[])this.parameters.get("paymentheader.bankaccount.bankbranch.id"))[0].equals("-1")) {
            this.addFieldError("paymentheader.bankaccount.bankbranch.id", this.getMessage("bankbranch.empty"));
        }
        if (((String[])this.parameters.get("paymentheader.bankaccount.id"))[0].equals("-1")) {
            this.addFieldError("paymentheader.bankaccount.id", this.getMessage("bankaccount.empty"));
        }
        if (this.billList == null) {
            this.addFieldError("paymentheader.bankaccount.id", this.getMessage("bill.details.empty"));
        }
        int i = 0;
        boolean selectedContractorPay = false;
        for (PaymentBean bean : this.billList) {
            tempBillList = new ArrayList();
            tempBillList.add(bean);
            if (expenseTypeList.size() != 0 && expenseTypeList.contains(bean.getExpType())) continue;
            expenseTypeList.add(bean.getExpType());
            if (!bean.getIsSelected()) continue;
            ++i;
            if (bean.getPaymentAmt().compareTo(BigDecimal.ZERO) <= 0) {
                this.addFieldError("billList[" + i + "].paymentAmt", this.getMessage("payment.amount.null"));
            }
            if (this.rtgsDefaultMode == null || !this.rtgsDefaultMode.equalsIgnoreCase("Y") || !bean.getExpType().equalsIgnoreCase("Works") || bean.getBillDate().compareTo(this.rtgsModeRestrictionDateForCJV) <= 0 || this.paymentheader.getType().equalsIgnoreCase("rtgs")) continue;
            selectedContractorPay = true;
            break;
        }
        try {
            for (int j = 0; j < expenseTypeList.size(); ++j) {
                if (!this.paymentheader.getType().equalsIgnoreCase("rtgs")) continue;
                this.paymentService.validateRTGSPaymentForModify(tempBillList);
            }
        }
        catch (ValidationException e) {
            this.addFieldError(((ValidationError)e.getErrors().get(0)).getMessage(), this.getMessage(((ValidationError)e.getErrors().get(0)).getMessage()));
        }
        if (selectedContractorPay) {
            this.addFieldError("contractor.bills.only.rtgs.payment", this.getMessage("contractor.bills.only.rtgs.payment"));
        }
        if (i == 0) {
            this.addFieldError("paymentheader.bankaccount.id", this.getMessage("bill.details.empty"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateForUpdate.");
        }
    }

    public void validate() {
        this.checkMandatory("fundId", "fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
        this.checkMandatory("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
        this.checkMandatory("vouchermis.function", "function", (Object)this.voucherHeader.getVouchermis().getFunction(), "voucher.function.mandatory");
        this.checkMandatory("vouchermis.schemeid", "scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
        this.checkMandatory("vouchermis.subschemeid", "subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
        this.checkMandatory("vouchermis.functionary", "functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatory("fundsourceId", "fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatory("vouchermis.divisionId", "field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validate.");
        }
    }

    private void checkMandatory(String objectName, String fieldName, Object value, String errorKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside checkMandatory.");
        }
        if (this.mandatoryFields.contains(fieldName) && value == null) {
            this.addFieldError(objectName, this.getMessage(errorKey));
        }
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList(FORWARD, "Create And Approve");
            } else if (this.paymentheader.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
            }
        } else if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList(FORWARD);
        } else if (this.paymentheader.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (this.paymentheader.getId() != null) {
            wfMatrix = this.paymentheader.getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    public Paymentheader getPayment() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPayment...");
        }
        String paymentid = null;
        paymentid = ((String[])this.parameters.get(PAYMENTID))[0];
        if (paymentid != null) {
            this.paymentheader = (Paymentheader)this.paymentService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(paymentid)});
        }
        if (this.paymentheader == null) {
            this.paymentheader = new Paymentheader();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPayment.");
        }
        return this.paymentheader;
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    protected String getMessage(String key, String[] value) {
        return this.getText(key, value);
    }

    public String getExpType() {
        return this.expType;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public List<EgBillregister> getContractorBillList() {
        return this.contractorBillList;
    }

    public void setContractorBillList(List<EgBillregister> contractorBillList) {
        this.contractorBillList = contractorBillList;
    }

    public List<EgBillregister> getSupplierBillList() {
        return this.supplierBillList;
    }

    public void setSupplierBillList(List<EgBillregister> supplierBillList) {
        this.supplierBillList = supplierBillList;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Map<String, String> getPayeeMap() {
        return this.payeeMap;
    }

    public void setPayeeMap(Map<String, String> payeeMap) {
        this.payeeMap = payeeMap;
    }

    public List<EgBillregister> getTotalBillList() {
        return this.totalBillList;
    }

    public void setTotalBillList(List<EgBillregister> totalBillList) {
        this.totalBillList = totalBillList;
    }

    public List<Bankaccount> getBankaccountList() {
        return this.bankaccountList;
    }

    public void setBankaccountList(List<Bankaccount> bankaccountList) {
        this.bankaccountList = bankaccountList;
    }

    public Paymentheader getPaymentheader() {
        return this.paymentheader;
    }

    public void setPaymentheader(Paymentheader paymentheader) {
        this.paymentheader = paymentheader;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Map<Long, BigDecimal> getDeductionAmtMap() {
        return this.deductionAmtMap;
    }

    public void setDeductionAmtMap(Map<Long, BigDecimal> deductionAmtMap) {
        this.deductionAmtMap = deductionAmtMap;
    }

    public Map<Long, BigDecimal> getPaidAmtMap() {
        return this.paidAmtMap;
    }

    public void setPaidAmtMap(Map<Long, BigDecimal> paidAmtMap) {
        this.paidAmtMap = paidAmtMap;
    }

    public String getVoucherdate() {
        return this.voucherdate;
    }

    public void setVoucherdate(String voucherdate) {
        this.voucherdate = voucherdate;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public List<Miscbilldetail> getMiscBillList() {
        return this.miscBillList;
    }

    public void setMiscBillList(List<Miscbilldetail> miscBillList) {
        this.miscBillList = miscBillList;
    }

    public int getMiscount() {
        return this.miscount;
    }

    public void setMiscount(int miscount) {
        this.miscount = miscount;
    }

    public Integer getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Integer bankaccount) {
        this.bankaccount = bankaccount;
    }

    public Integer getBankbranch() {
        return this.bankbranch;
    }

    public void setBankbranch(Integer bankbranch) {
        this.bankbranch = bankbranch;
    }

    public List<PaymentBean> getBillList() {
        return this.billList;
    }

    public void setBillList(List<PaymentBean> billList) {
        this.billList = billList;
    }

    public String getContractorIds() {
        return this.contractorIds;
    }

    public void setContractorIds(String contractorIds) {
        this.contractorIds = contractorIds;
    }

    public String getSalaryIds() {
        return this.salaryIds;
    }

    public void setSalaryIds(String salaryIds) {
        this.salaryIds = salaryIds;
    }

    public String getSupplierIds() {
        return this.supplierIds;
    }

    public void setSupplierIds(String supplierIds) {
        this.supplierIds = supplierIds;
    }

    public String getVouchernumber() {
        return this.vouchernumber;
    }

    public void setVouchernumber(String vouchernumber) {
        this.vouchernumber = vouchernumber;
    }

    public EgBillregister getBillregister() {
        return this.billregister;
    }

    public void setBillregister(EgBillregister billregister) {
        this.billregister = billregister;
    }

    public boolean isDepartmentDefault() {
        return this.isDepartmentDefault;
    }

    public void setDepartmentDefault(boolean isDepartmentDefault) {
        this.isDepartmentDefault = isDepartmentDefault;
    }

    public List<InstrumentHeader> getInstrumentHeaderList() {
        return this.instrumentHeaderList;
    }

    public void setInstrumentHeaderList(List<InstrumentHeader> instrumentHeaderList) {
        this.instrumentHeaderList = instrumentHeaderList;
    }

    public List<PaymentBean> getContractorList() {
        return this.contractorList;
    }

    public void setContractorList(List<PaymentBean> contractorList) {
        this.contractorList = contractorList;
    }

    public List<PaymentBean> getSupplierList() {
        return this.supplierList;
    }

    public void setSupplierList(List<PaymentBean> supplierList) {
        this.supplierList = supplierList;
    }

    public List<Paymentheader> getPaymentheaderList() {
        return this.paymentheaderList;
    }

    public void setPaymentheaderList(List<Paymentheader> paymentheaderList) {
        this.paymentheaderList = paymentheaderList;
    }

    public String getVoucherNumberPrefix() {
        return this.voucherNumberPrefix;
    }

    public void setVoucherNumberPrefix(String voucherNumberPrefix) {
        this.voucherNumberPrefix = voucherNumberPrefix;
    }

    public String getVoucherNumberSuffix() {
        return this.voucherNumberSuffix;
    }

    public void setVoucherNumberSuffix(String voucherNumberSuffix) {
        this.voucherNumberSuffix = voucherNumberSuffix;
    }

    public List<EgBillregister> getContingentBillList() {
        return this.contingentBillList;
    }

    public void setContingentBillList(List<EgBillregister> contingentBillList) {
        this.contingentBillList = contingentBillList;
    }

    public List<EgBillregister> getSalaryBillList() {
        return this.salaryBillList;
    }

    public void setSalaryBillList(List<EgBillregister> salaryBillList) {
        this.salaryBillList = salaryBillList;
    }

    public List<PaymentBean> getContingentList() {
        return this.contingentList;
    }

    public void setContingentList(List<PaymentBean> contingentList) {
        this.contingentList = contingentList;
    }

    public List<PaymentBean> getSalaryList() {
        return this.salaryList;
    }

    public void setSalaryList(List<PaymentBean> salaryList) {
        this.salaryList = salaryList;
    }

    public String getContingentIds() {
        return this.contingentIds;
    }

    public void setContingentIds(String contingentIds) {
        this.contingentIds = contingentIds;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDefaultDept() {
        return this.defaultDept;
    }

    public void setDefaultDept(Integer defaultDept) {
        this.defaultDept = defaultDept;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(String typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public void setAdvanceRequisition(List<EgAdvanceRequisition> advanceRequisition) {
        this.advanceRequisitionList = advanceRequisition;
    }

    public List<EgAdvanceRequisition> getAdvanceRequisitionList() {
        return this.advanceRequisitionList;
    }

    public void setDisableExpenditureType(boolean disableExpenditureType) {
        this.disableExpenditureType = disableExpenditureType;
    }

    public boolean isDisableExpenditureType() {
        return this.disableExpenditureType;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public boolean isChangePartyName() {
        return this.changePartyName;
    }

    public void setChangePartyName(boolean changePartyName) {
        this.changePartyName = changePartyName;
    }

    public String getNewPartyname() {
        return this.newPartyname;
    }

    public void setNewPartyname(String newPartyname) {
        this.newPartyname = newPartyname;
    }

    public boolean isEnablePensionType() {
        return this.enablePensionType;
    }

    public void setEnablePensionType(boolean enablePensionType) {
        this.enablePensionType = enablePensionType;
    }

    public List<EgBillregister> getPensionBillList() {
        return this.pensionBillList;
    }

    public void setPensionBillList(List<EgBillregister> pensionBillList) {
        this.pensionBillList = pensionBillList;
    }

    public List<PaymentBean> getPensionList() {
        return this.pensionList;
    }

    public void setPensionList(List<PaymentBean> pensionList) {
        this.pensionList = pensionList;
    }

    public String getPensionIds() {
        return this.pensionIds;
    }

    public void setPensionIds(String pensionIds) {
        this.pensionIds = pensionIds;
    }

    public Long getFunctionSel() {
        return this.functionSel;
    }

    public void setFunctionSel(Long functionSel) {
        this.functionSel = functionSel;
    }

    public String getRtgsDefaultMode() {
        return this.rtgsDefaultMode;
    }

    public void setRtgsDefaultMode(String rtgsDefaultMode) {
        this.rtgsDefaultMode = rtgsDefaultMode;
    }

    public Date getRtgsModeRestrictionDateForCJV() {
        return this.rtgsModeRestrictionDateForCJV;
    }

    public void setRtgsModeRestrictionDateForCJV(Date rtgsModeRestrictionDateForCJV) {
        this.rtgsModeRestrictionDateForCJV = rtgsModeRestrictionDateForCJV;
    }

    public String getBillSubType() {
        return this.billSubType;
    }

    public void setBillSubType(String billSubType) {
        this.billSubType = billSubType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Map<Integer, String> getMonthMap() {
        return this.monthMap;
    }

    public void setMonthMap(Map<Integer, String> monthMap) {
        this.monthMap = monthMap;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getBank_branch() {
        return this.bank_branch;
    }

    public void setBank_branch(String bank_branch) {
        this.bank_branch = bank_branch;
    }

    public String getBank_account() {
        return this.bank_account;
    }

    public void setBank_account(String bank_account) {
        this.bank_account = bank_account;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public EgwStatusHibernateDAO getEgwStatusHibernateDAO() {
        return this.egwStatusHibernateDAO;
    }

    public void setEgwStatusHibernateDAO(EgwStatusHibernateDAO egwStatusHibernateDAO) {
        this.egwStatusHibernateDAO = egwStatusHibernateDAO;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getCurrentState() {
        return this.paymentheader.getState().getValue();
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }
}

