/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bank;
import org.egov.commons.utils.BankAccountType;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.services.masters.BankService;
import org.hibernate.exception.ConstraintViolationException;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"modify"}, location="bank-modify.jsp"), @Result(name={"success"}, location="bank.jsp"), @Result(name={"search"}, location="bank-search.jsp")})
public class BankAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Bank bank = new Bank();
    private boolean isActive;
    public static final String MODIFY = "modify";
    public static final String SEARCH = "search";
    private String mode;
    private String term;
    private BankService bankService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @SkipValidation
    @Actions(value={@Action(value="/masters/bank"), @Action(value="/masters/bank-execute")})
    public String execute() {
        if ("MODIFY".equals(this.mode)) {
            if (StringUtils.isBlank((String)this.bank.getName())) {
                this.addDropdownData("bankList", this.bankService.findAll(new String[]{"name"}));
                return SEARCH;
            }
            this.bank = (Bank)this.bankService.find("FROM Bank WHERE name = ?", new Object[]{this.bank.getName()});
            if (this.bank == null) {
                return SEARCH;
            }
            this.isActive = this.bank.getIsactive() != false;
            return MODIFY;
        }
        if ("UNQ_NAME".equals(this.mode)) {
            this.checkUniqueBankName();
        } else if ("UNQ_CODE".equals(this.mode)) {
            this.checkUniqueBankCode();
        } else if ("AUTO_COMP_BANK_NAME".equals(this.mode)) {
            this.populateBankNames();
        }
        return "success";
    }

    public Object getModel() {
        return this.bank;
    }

    @ValidationErrorPage(value="modify")
    @Action(value="/masters/bank-save")
    public String save() {
        try {
            if (this.isActive) {
                this.bank.setIsactive(Boolean.valueOf(true));
            } else {
                this.bank.setIsactive(Boolean.valueOf(false));
            }
            if (this.bank.getId() == null) {
                Date currentDate = new Date();
                this.bank.setCreated(currentDate);
                this.bank.setLastmodified(currentDate);
                this.bank.setModifiedby(BigDecimal.valueOf((double)ApplicationThreadLocals.getUserId().longValue()));
                this.bankService.persist((Object)this.bank);
            } else {
                Date currentDate = new Date();
                this.bank.setCreated(currentDate);
                this.bank.setLastmodified(currentDate);
                this.bank.setModifiedby(BigDecimal.valueOf((double)ApplicationThreadLocals.getUserId().longValue()));
                this.bankService.update((Object)this.bank);
            }
            this.addActionMessage(this.getText("Bank Saved Successfully"));
        }
        catch (ConstraintViolationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Duplicate Bank", "Duplicate Bank")));
        }
        catch (Exception e) {
            this.addActionMessage(this.getText("Bank information can't be saved."));
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        return MODIFY;
    }

    private void checkUniqueBankCode() {
        Bank bank = (Bank)this.bankService.find("from Bank where lower(code)=?", new Object[]{this.bank.getCode().toLowerCase()});
        this.writeToAjaxResponse(String.valueOf(bank == null));
    }

    private void checkUniqueBankName() {
        Bank bank = (Bank)this.bankService.find("from Bank where lower(name)=?", new Object[]{this.bank.getName().toLowerCase()});
        this.writeToAjaxResponse(String.valueOf(bank == null));
    }

    private void populateBankNames() {
        JSONArray jsonArray = new JSONArray((Collection)this.persistenceService.findAllBy("select name FROM Bank WHERE lower(name) like ?", new Object[]{StringUtils.lowerCase((String)(this.term + "%"))}));
        this.writeToAjaxResponse(jsonArray.toString());
    }

    public String getBankAccountTypesJSON() {
        StringBuilder bankAcTypesJson = new StringBuilder(":;");
        for (BankAccountType value : BankAccountType.values()) {
            bankAcTypesJson.append(value.name()).append(":").append(value.name()).append(";");
        }
        bankAcTypesJson.deleteCharAt(bankAcTypesJson.lastIndexOf(";"));
        return bankAcTypesJson.toString();
    }

    public Boolean isAutoBankAccountGLCodeEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "auto_bankaccount_glcode").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getFundsJSON() {
        List funds = this.persistenceService.findAllBy("SELECT id, name FROM Fund WHERE isactive=?", new Object[]{true});
        StringBuilder fundJson = new StringBuilder(":;");
        for (Object[] fund : funds) {
            fundJson.append(fund[0]).append(":").append(fund[1]).append(";");
        }
        fundJson.deleteCharAt(fundJson.lastIndexOf(";"));
        return fundJson.toString();
    }

    public String getAccountTypesJSON() {
        List accounttypes = this.persistenceService.findAllBy("SELECT name,id FROM CChartOfAccounts WHERE glcode LIKE '4502%' AND classification=2 ORDER BY glcode", new Object[0]);
        StringBuilder accountdetailtypeJson = new StringBuilder("{\"\":\"\",");
        for (Object[] accType : accounttypes) {
            accType[0] = org.egov.infra.utils.StringUtils.escapeJavaScript((String)((String)accType[0]));
            accountdetailtypeJson.append("\"").append(accType[1] + "#" + accType[0]).append("\"").append(":").append("\"").append(accType[0]).append("\"").append(",");
        }
        accountdetailtypeJson.deleteCharAt(accountdetailtypeJson.lastIndexOf(","));
        return accountdetailtypeJson.append("}").toString();
    }

    public void validate() {
        if (this.bank.getName().equals("")) {
            this.addFieldError("name", this.getText("bank.name.field.required"));
        }
        if (this.bank.getCode().equals("")) {
            this.addFieldError("code", this.getText("bank.code.field.required"));
        }
    }

    private void writeToAjaxResponse(String response) {
        try {
            HttpServletResponse httpResponse = ServletActionContext.getResponse();
            PrintWriter httpResponseWriter = httpResponse.getWriter();
            IOUtils.write((String)response, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            LOG.error("Error occurred while processing Ajax response", (Throwable)e);
        }
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setBankService(BankService bankService) {
        this.bankService = bankService;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

