/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.contra;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraBean;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.cheque.ChequeService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.voucher.ContraJournalVoucherService;
import org.egov.utils.Constants;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class ContraBTBActionHelper {
    private static final Logger LOGGER = Logger.getLogger(ContraBTBActionHelper.class);
    private static final String MDC_CHEQUE = "cheque";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving Data";
    private static final String TRANSACTION_FAILED = "Transaction failed";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    @Autowired
    private InstrumentService instrumentService;
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    @Qualifier(value="chequeService")
    private ChequeService chequeService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="contraJournalVoucherService")
    private ContraJournalVoucherService contraJournalVoucherService;
    private CVoucherHeader voucherHeader2 = null;

    @Transactional
    public CVoucherHeader create(ContraBean contraBean, ContraJournalVoucher contraVoucher, CVoucherHeader voucherHeader) throws Exception {
        try {
            this.voucherHeader2 = null;
            List instrumentList = this.instrumentService.addToInstrument(this.createInstruments(contraBean, contraVoucher, voucherHeader));
            voucherHeader = contraBean.getToFundId() != null && !voucherHeader.getFundId().getId().equals(contraBean.getToFundId()) ? this.callCreateVoucherForInterFund(voucherHeader, contraVoucher, contraBean) : this.callCreateVoucher(voucherHeader, contraVoucher, contraBean);
            this.updateInstrument((InstrumentHeader)instrumentList.get(0), voucherHeader);
            contraVoucher = this.addOrupdateContraJournalVoucher(contraVoucher, (InstrumentHeader)instrumentList.get(0), voucherHeader, contraBean);
            ContraJournalVoucher contraVoucher2 = null;
            if (this.voucherHeader2 != null) {
                List createInstrumentMap = this.createInstrumentsForReceipt(contraBean, contraVoucher, voucherHeader);
                ((Map)createInstrumentMap.get(0)).put("Is pay cheque", "0");
                List instrumentList2 = this.instrumentService.addToInstrument(createInstrumentMap);
                contraVoucher2 = new ContraJournalVoucher();
                contraVoucher2 = this.addOrupdateContraJournalVoucher(contraVoucher2, (InstrumentHeader)instrumentList2.get(0), this.voucherHeader2, contraBean);
                this.updateInstrument((InstrumentHeader)instrumentList2.get(0), this.voucherHeader2);
            } else {
                List iList = new ArrayList();
                iList = this.createInstrumentsForReceipt(contraBean, contraVoucher, voucherHeader);
                List receiptInstrumentList = this.instrumentService.addToInstrument(iList);
                this.updateInstrument((InstrumentHeader)receiptInstrumentList.get(0), voucherHeader);
                contraVoucher = this.addOrupdateContraJournalVoucher(contraVoucher, (InstrumentHeader)receiptInstrumentList.get(0), voucherHeader, contraBean);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return voucherHeader;
    }

    private List<Map<String, Object>> createInstrumentsForReceipt(ContraBean cBean, ContraJournalVoucher cVoucher, CVoucherHeader voucherHeader) {
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        try {
            HashMap<String, Object> iMap = new HashMap<String, Object>();
            Date dt = null;
            iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
            iMap.put("Bank code", cVoucher.getToBankAccountId().getBankbranch().getBank().getCode());
            iMap.put("Bank branch name", cVoucher.getToBankAccountId().getBankbranch().getBranchaddress1());
            iMap.put("Bank account id", cVoucher.getToBankAccountId().getId());
            if (cBean.getModeOfCollection().equalsIgnoreCase(MDC_CHEQUE)) {
                if (!this.egovCommon.isShowChequeNumber()) {
                    try {
                        iMap.put("Instrument number", this.chequeService.nextChequeNumber(cVoucher.getToBankAccountId().getId().toString(), 1, voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                    }
                    catch (ApplicationRuntimeException e) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                    }
                    iMap.put("Instrument date", new Date());
                } else {
                    iMap.put("Instrument number", cBean.getChequeNumber());
                    try {
                        dt = this.sdf.parse(cBean.getChequeDate());
                    }
                    catch (ParseException e) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                    }
                    iMap.put("Instrument date", dt);
                }
                iMap.put("Instrument type", MDC_CHEQUE);
            } else {
                iMap.put("Transaction number", cBean.getChequeNumber());
                try {
                    dt = this.sdf.parse(cBean.getChequeDate());
                }
                catch (ParseException e) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                }
                iMap.put("Transaction date", dt);
                iMap.put("Instrument type", "advice");
            }
            iMap.put("Is pay cheque", "0");
            iList.add(iMap);
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return iList;
    }

    private List<Map<String, Object>> createInstruments(ContraBean cBean, ContraJournalVoucher cVoucher, CVoucherHeader voucherHeader) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        Date dt = null;
        iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
        iMap.put("Bank code", cVoucher.getFromBankAccountId().getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", cVoucher.getFromBankAccountId().getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", cVoucher.getFromBankAccountId().getId());
        if (cBean.getModeOfCollection().equalsIgnoreCase(MDC_CHEQUE)) {
            if (!this.egovCommon.isShowChequeNumber()) {
                try {
                    iMap.put("Instrument number", this.chequeService.nextChequeNumber(cVoucher.getFromBankAccountId().getId().toString(), 1, voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                }
                catch (ApplicationRuntimeException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                }
                iMap.put("Instrument date", new Date());
            } else {
                iMap.put("Instrument number", cBean.getChequeNumber());
                try {
                    dt = this.sdf.parse(cBean.getChequeDate());
                }
                catch (ParseException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                }
                iMap.put("Instrument date", dt);
            }
            iMap.put("Instrument type", MDC_CHEQUE);
        } else {
            iMap.put("Transaction number", cBean.getChequeNumber());
            try {
                dt = this.sdf.parse(cBean.getChequeDate());
            }
            catch (ParseException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
            }
            iMap.put("Transaction date", dt);
            iMap.put("Instrument type", "advice");
        }
        iMap.put("Is pay cheque", "1");
        iList.add(iMap);
        return iList;
    }

    @Transactional
    public CVoucherHeader callCreateVoucherForInterFund(CVoucherHeader voucher, ContraJournalVoucher contraVoucher, ContraBean contraBean) {
        try {
            Fund toFund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{contraBean.getToFundId()});
            Department toDepartment = new Department();
            if (contraBean.getToDepartment() != null && !contraBean.getToDepartment().equals("-1")) {
                toDepartment = (Department)this.persistenceService.find("from Department where id=?", new Object[]{contraBean.getToDepartment().longValue()});
            }
            HashMap headerDetails = this.createHeaderAndMisDetails(voucher);
            headerDetails.put("vouchername", "InterFundTransfer");
            if (voucher.getFundId().getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            }
            headerDetails.put("sourcepath", "/EGF/contra/contraBTB-beforeView.action?voucherHeader.id=");
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("fundcode", toFund.getCode());
            detailMap.put("debitamount", contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", contraBean.getSourceGlcode());
            accountdetails.add(detailMap);
            voucher = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
            accountdetails = new ArrayList();
            headerDetails.put("vouchername", "InterFundTransfer");
            headerDetails.put("vouchername", voucher.getName());
            headerDetails.put("fundcode", toFund.getCode());
            if (toFund.getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            } else {
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", toDepartment == null ? "" : toDepartment.getCode());
            }
            headerDetails.remove("schemecode");
            headerDetails.remove("subschemecode");
            headerDetails.remove("fundsourcecode");
            headerDetails.remove("divisionid");
            headerDetails.remove("functionarycode");
            headerDetails.put("refvoucher", voucher.getId());
            detailMap = new HashMap();
            detailMap.put("creditamount", contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", contraBean.getDestinationGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            this.voucherHeader2 = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + voucher.getId()));
        }
        return voucher;
    }

    private HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    @Transactional
    public CVoucherHeader callCreateVoucher(CVoucherHeader voucher, ContraJournalVoucher contraVoucher, ContraBean contraBean) {
        try {
            HashMap headerDetails = this.createHeaderAndMisDetails(voucher);
            headerDetails.put("sourcepath", "/EGF/contra/contraBTB-beforeView.action?voucherHeader.id=");
            if (voucher.getFundId().getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            }
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            voucher = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + voucher.getId()));
        }
        return voucher;
    }

    @Transactional
    public void updateInstrument(InstrumentHeader ih, CVoucherHeader vh) {
        try {
            HashMap<String, Object> iMap = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
            iMap.put("Instrument header", ih);
            iMap.put("Voucher header", vh);
            iList.add(iMap);
            this.instrumentService.updateInstrumentVoucherReference(iList);
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    @Transactional
    public ContraJournalVoucher addOrupdateContraJournalVoucher(ContraJournalVoucher cjv, InstrumentHeader ih, CVoucherHeader vh, ContraBean contraBean) {
        try {
            cjv.setInstrumentHeaderId(ih);
            cjv.setVoucherHeaderId(vh);
            cjv = this.getHibObjectsFromContraBean(contraBean, cjv);
            if (cjv.getId() != null) {
                this.contraJournalVoucherService.applyAuditing((AbstractAuditable)cjv);
                this.contraJournalVoucherService.update((Object)cjv);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Contra Journal Voucher Updated");
                }
            } else {
                this.contraJournalVoucherService.applyAuditing((AbstractAuditable)cjv);
                this.contraJournalVoucherService.persist((Object)cjv);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Contra Journal Voucher created");
                }
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return cjv;
    }

    private ContraJournalVoucher getHibObjectsFromContraBean(ContraBean contraBean, ContraJournalVoucher contraVoucher) {
        String bankQry = "from Bankaccount where id=?";
        if (contraBean != null && contraBean.getFromBankAccountId() != null && !contraBean.getFromBankAccountId().equals("-1")) {
            contraVoucher.setFromBankAccountId((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(contraBean.getFromBankAccountId())}));
        }
        if (contraBean != null && contraBean.getToBankAccountId() != null && !contraBean.getFromBankAccountId().equals("-1")) {
            contraVoucher.setToBankAccountId((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(contraBean.getToBankAccountId())}));
        }
        return contraVoucher;
    }
}

