/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.contra;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import com.exilant.exility.common.TaskFailedException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.Vouchermis;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.contra.ContraBTBActionHelper;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraBean;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.payment.Paymentheader;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.services.cheque.ChequeService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.payment.PaymentService;
import org.egov.services.report.FundFlowService;
import org.egov.services.voucher.ContraJournalVoucherService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.hibernate.HibernateException;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="contraBTB-new.jsp"), @Result(name={"edit"}, location="contraBTB-edit.jsp"), @Result(name={"reverse"}, location="contraBTB-reverse.jsp"), @Result(name={"view"}, location="contraBTB-view.jsp"), @Result(name={"success"}, location="contraBTB-success.jsp")})
public class ContraBTBAction
extends BaseVoucherAction {
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private SimpleDateFormat sqlformat = new SimpleDateFormat("dd-MMM-yyyy");
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving Data";
    private static final Logger LOGGER = Logger.getLogger(ContraBTBAction.class);
    private static final String MDC_CHEQUE = "cheque";
    private static final String MDC_OTHER = "RTGS/NEFT";
    private static final String REVERSE = "reverse";
    private static final long serialVersionUID = 1L;
    private static final String TRANSACTION_FAILED = "Transaction failed";
    private static final String VIEW = "view";
    private Date voucherDate;
    public ContraBean contraBean;
    public Map<String, String> fromBankBranchMap;
    public Map<String, String> ModeOfCollectionMap;
    public Map<String, String> toBankBranchMap;
    private String amount;
    private String button;
    private String sourceGlcode;
    private String destinationGlcode;
    private ContraJournalVoucher contraVoucher;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private InstrumentService instrumentService;
    private String mode;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    private VoucherTypeBean voucherTypeBean;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private Long vhId;
    @Autowired
    @Qualifier(value="paymentService")
    private PaymentService paymentService;
    @Autowired
    @Qualifier(value="chequeService")
    private ChequeService chequeService;
    private String fromAccnumnar;
    private Fund toFundCode;
    @Autowired
    @Qualifier(value="fundFlowService")
    private FundFlowService fundFlowService;
    private CGeneralLedger generalled;
    private CChartOfAccounts chartofAccountsList;
    private List<CGeneralLedger> generalLedgerDesList = new ArrayList();
    private List<CGeneralLedger> generalLedgerSrcList = new ArrayList();
    private Vouchermis vouchermis = new Vouchermis();
    private static Logger logger = Logger.getLogger(ContraBTBAction.class);
    private String toAccnumnar;
    private CVoucherHeader voucherHeader2;
    private CVoucherHeader voucherHeaderDes;
    private CVoucherHeader voucherHeader4;
    private ChartOfAccounts chartOfAccounts;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="contraJournalVoucherService")
    private ContraJournalVoucherService contraJournalVoucherService;
    @Autowired
    @Qualifier(value="contraBTBActionHelper")
    private ContraBTBActionHelper contraBTBActionHelper;
    @Autowired
    private EgovCommon egovCommon;

    public void prepare() {
        super.prepare();
        this.ModeOfCollectionMap = new LinkedHashMap();
        this.ModeOfCollectionMap.put(MDC_OTHER, MDC_OTHER);
        List glCodeList = this.persistenceService.findAllBy("from CChartOfAccounts coa where coa.purposeId=8 and coa.classification=4 and coa.isActiveForPosting=true order by coa.glcode ", new Object[0]);
        this.addDropdownData("interFundList", glCodeList);
        this.LoadAjaxedDropDowns();
    }

    @SkipValidation
    @Action(value="/contra/contraBTB-beforeEdit")
    public String beforeEdit() {
        this.prepareForViewModifyReverse();
        return "edit";
    }

    @SkipValidation
    @Action(value="/contra/contraBTB-beforeReverse")
    public String beforeReverse() {
        this.prepareForViewModifyReverse();
        return REVERSE;
    }

    @SkipValidation
    @Action(value="/contra/contraBTB-beforeView")
    public String beforeView() {
        this.prepareForViewModifyReverse();
        return VIEW;
    }

    public void setChequeService(ChequeService chequeService) {
        this.chequeService = chequeService;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/contra/contraBTB-create")
    public String create() throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting Bank to Bank Transfer ...");
        }
        try {
            this.getHibObjectsFromContraBean();
            if (this.egovCommon.isShowChequeNumber() && this.contraBean.getModeOfCollection().equals(MDC_CHEQUE)) {
                this.validateChqNumber(this.contraBean.getChequeNumber(), this.contraVoucher.getFromBankAccountId().getId(), this.voucherHeader);
            }
            this.voucherHeader = this.contraBTBActionHelper.create(this.contraBean, this.contraVoucher, this.voucherHeader);
            this.addActionMessage("Bank to Bank Transfer " + this.getText("transaction.success") + " with Voucher number: " + this.voucherHeader.getVoucherNumber());
            this.setVhId(this.voucherHeader.getId());
            this.LoadAjaxedDropDowns();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Completed Bank to Bank Transfer .");
            }
        }
        catch (ValidationException e) {
            this.LoadAjaxedDropDowns();
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            this.LoadAjaxedDropDowns();
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return "success";
    }

    @Action(value="/contra/contraBTB-edit")
    public String edit() {
        this.validateFields();
        this.getHibObjectsFromContraBean();
        CVoucherHeader oldVoucher = this.voucherService.updateVoucherHeader(this.voucherHeader, this.voucherTypeBean);
        if (oldVoucher.getRefvhId() != null) {
            this.voucherHeader2 = oldVoucher;
            this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where voucherNumber=?", new Object[]{oldVoucher.getVoucherNumber()});
        } else {
            this.voucherHeader2 = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where voucherNumber=?", new Object[]{oldVoucher.getVoucherNumber()});
            this.voucherHeader4 = new CVoucherHeader();
        }
        if (this.voucherHeader2 != null && this.contraBean.getToFundId() != null && this.voucherHeader.getFundId().getId().equals(this.contraBean.getToFundId())) {
            throw new ValidationException(Arrays.asList(new ValidationError("Same Fund Is Not Allowed Cancel this and create New One", "Same Fund Is Not Allowed Cancel this and create New One")));
        }
        CVoucherHeader oldVoucher2 = null;
        Fund toFund = null;
        if (this.voucherHeader2 != null) {
            toFund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.contraBean.getToFundId()});
            this.voucherTypeBean.setVoucherName("InterFundTransfer");
            this.voucherHeader4.setFundId(toFund);
            this.voucherHeader4.setCgvn(this.voucherHeader2.getCgvn());
            this.voucherHeader4.setVoucherNumber(this.voucherHeader2.getVoucherNumber());
            this.voucherHeader4.setType(this.voucherHeader2.getType());
            this.voucherHeader4.setVouchermis(this.voucherHeader2.getVouchermis());
            this.voucherHeader4.setVoucherDate(this.voucherDate);
            this.voucherTypeBean.setVoucherName("InterFundTransfer");
            oldVoucher2 = this.voucherService.updateVoucherHeader(this.voucherHeader4, this.voucherTypeBean);
        }
        ContraJournalVoucher oldContraVoucher = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where voucherHeaderId.id=?", new Object[]{oldVoucher.getId()});
        ContraJournalVoucher oldContraVoucher2 = null;
        if (this.voucherHeader2 != null) {
            oldContraVoucher2 = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where voucherHeaderId.id=?", new Object[]{oldVoucher2.getId()});
        }
        List exludeStatusList = this.getExcludeStatusListForInstruments();
        InstrumentVoucher instrumentVoucher = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher iv where iv.instrumentHeaderId.statusId not in (?) and voucherHeaderId.id=?", new Object[]{exludeStatusList.get(0), oldVoucher.getId()});
        InstrumentVoucher instrumentVoucher2 = null;
        if (this.voucherHeader2 != null) {
            instrumentVoucher2 = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher iv where iv.instrumentHeaderId.statusId not in (?) and voucherHeaderId.id=?", new Object[]{exludeStatusList.get(0), oldVoucher2.getId()});
        }
        if (instrumentVoucher == null) {
            LOGGER.error((Object)"System Error :Instrument is not linked with voucher ");
            throw new ApplicationRuntimeException(" System Error :Instrument is not linked with voucher  ");
        }
        InstrumentHeader oldInstrumentHeader = instrumentVoucher.getInstrumentHeaderId();
        if (!oldContraVoucher.getFromBankAccountId().getId().toString().equals(this.contraBean.getFromBankAccountId()) || !oldContraVoucher.getToBankAccountId().getId().toString().equals(this.contraBean.getToBankAccountId())) {
            this.instrumentService.cancelInstrument(oldInstrumentHeader);
            if (instrumentVoucher2 != null) {
                this.instrumentService.cancelInstrument(instrumentVoucher2.getInstrumentHeaderId());
            }
            this.persistenceService.getSession().flush();
            if (this.contraBean.getModeOfCollection().equals(MDC_CHEQUE)) {
                if (!this.egovCommon.isShowChequeNumber()) {
                    try {
                        this.contraBean.setChequeNumber(this.chequeService.nextChequeNumber(this.contraBean.getFromBankAccountId(), 1, this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                    }
                    catch (ApplicationRuntimeException e) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                    }
                } else {
                    this.validateChqNumber(this.contraBean.getChequeNumber(), this.contraVoucher.getFromBankAccountId().getId(), this.voucherHeader);
                }
            }
            List instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean, this.contraVoucher));
            this.updateInstrument((InstrumentHeader)instrumentList.get(0), oldVoucher);
            this.persistenceService.getSession().flush();
            ContraJournalVoucher contraVoucher = this.addOrupdateContraJournalVoucher(oldContraVoucher, (InstrumentHeader)instrumentList.get(0), oldVoucher);
            if (this.voucherHeader2 != null) {
                List createInstrumentMap = this.createInstrumentsForReceipt(this.contraBean, contraVoucher);
                ((Map)createInstrumentMap.get(0)).put("Is pay cheque", "0");
                List instrumentList2 = this.instrumentService.addToInstrument(createInstrumentMap);
                oldContraVoucher2 = this.addOrupdateContraJournalVoucher(oldContraVoucher2, (InstrumentHeader)instrumentList2.get(0), this.voucherHeader2);
                this.updateInstrument((InstrumentHeader)instrumentList2.get(0), this.voucherHeader2);
            }
            if (this.contraBean.getToFundId() != null && !this.voucherHeader.getFundId().getId().equals(this.contraBean.getToFundId())) {
                this.voucherHeader = this.createLedgerAndPostForInterfund(this.voucherHeader, contraVoucher);
            } else {
                this.createLedgerAndPost(oldVoucher, contraVoucher);
            }
        } else {
            this.checkAndUpdateInstrument(oldInstrumentHeader, this.contraVoucher, oldVoucher);
        }
        this.LoadAjaxedDropDowns();
        this.addActionMessage(this.getText("transaction.success") + oldVoucher.getVoucherNumber());
        this.voucherHeader = oldVoucher;
        this.setVhId(this.voucherHeader.getId());
        return "edit";
    }

    private CVoucherHeader createLedgerAndPostForInterfund(CVoucherHeader voucher, ContraJournalVoucher contraVoucher2) {
        try {
            this.persistenceService.find("from Fund where id=?", new Object[]{this.contraBean.getToFundId()});
            this.createVoucher.deleteVoucherdetailAndGL(this.voucherHeader);
            this.createVoucher.deleteVoucherdetailAndGL(this.voucherHeader2);
            this.persistenceService.getSession().flush();
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", this.contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", this.contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", this.contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", this.contraBean.getSourceGlcode());
            accountdetails.add(detailMap);
            List transactions = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, voucher);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat(DD_MMM_YYYY);
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(voucher.getVoucherDate()))) {
                throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
            }
            accountdetails = new ArrayList();
            detailMap = new HashMap();
            detailMap.put("creditamount", this.contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", this.contraBean.getDestinationGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", this.contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", this.contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            List transactions2 = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, this.voucherHeader2);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList2 = new Transaxtion[transactions2.size()];
            txnList2 = transactions2.toArray(txnList2);
            if (!this.chartOfAccounts.postTransaxtions(txnList2, formatter.format(this.voucherHeader2.getVoucherDate()))) {
                throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Posted to Ledger ");
        }
        return voucher;
    }

    private List<EgwStatus> getExcludeStatusListForInstruments() {
        ArrayList<EgwStatus> exList = new ArrayList<EgwStatus>();
        EgwStatus statusId = this.instrumentService.getStatusId("Cancelled");
        exList.add(statusId);
        return exList;
    }

    public String execute() {
        return "new";
    }

    public String getAmount() {
        return this.amount;
    }

    public String getButton() {
        return this.button;
    }

    public ContraJournalVoucher getContraVoucher() {
        return this.contraVoucher;
    }

    public Map<String, String> getFromBankBranchMap() {
        return this.fromBankBranchMap;
    }

    public String getMode() {
        return this.mode;
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        this.voucherHeader.setType("Contra");
        if (this.voucherHeader.getName() == null || this.voucherHeader.getName().isEmpty()) {
            this.voucherHeader.setName("BankToBank");
        }
        return this.voucherHeader;
    }

    public Map<String, String> getModeOfCollectionMap() {
        return this.ModeOfCollectionMap;
    }

    public Map<String, String> getToBankBranchMap() {
        return this.toBankBranchMap;
    }

    public Long getVhId() {
        return this.vhId;
    }

    public VoucherTypeBean getVoucherTypeBean() {
        return this.voucherTypeBean;
    }

    @SkipValidation
    @Action(value="/contra/contraBTB-newform")
    public String newform() {
        try {
            this.reset();
            this.LoadAjaxedDropDowns();
            this.loadDefalutDates();
            Date currDate = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            this.contraBean.setChequeDate(sdf.format(currDate));
            this.voucherDate = sdf.parse(sdf.format(currDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "new";
    }

    public String reset() {
        this.voucherHeader.reset();
        this.contraBean.reset();
        this.setAmount(null);
        return "new";
    }

    @ValidationErrorPage(value="reverse")
    @Action(value="/contra/contraBTB-reverse")
    public String reverse() {
        CVoucherHeader reversalVoucher = null;
        HashMap<String, Object> reversalVoucherMap = new HashMap<String, Object>();
        reversalVoucherMap.put("Original voucher header id", this.voucherHeader.getId());
        reversalVoucherMap.put("Reversal voucher type", "Receipt");
        reversalVoucherMap.put("Reversal voucher name", "Contra");
        try {
            reversalVoucherMap.put("Reversal voucher date", this.sdf.parse(this.getReversalVoucherDate()));
        }
        catch (ParseException e1) {
            LOGGER.error((Object)("Error in reverse" + e1.getMessage()));
            throw new ValidationException(Arrays.asList(new ValidationError("reversalVocuherDate", "reversalVocuherDate.notinproperformat")));
        }
        reversalVoucherMap.put("Reversal voucher number", this.getReversalVoucherNumber());
        ArrayList<HashMap<String, Object>> reversalList = new ArrayList<HashMap<String, Object>>();
        reversalList.add(reversalVoucherMap);
        try {
            reversalVoucher = this.createVoucher.reverseVoucher(reversalList);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)("Error in reverse" + e.getMessage()));
            throw new ValidationException(Arrays.asList(new ValidationError("Failed while Reversing", "Failed while Reversing")));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error in reverse" + e.getMessage()));
            throw new ValidationException(Arrays.asList(new ValidationError("Date is not in proper Format", "Date is not in proper Format")));
        }
        this.LoadAjaxedDropDowns();
        this.addActionMessage(this.getText("contra.reverse.transaction.success") + reversalVoucher.getVoucherNumber());
        this.setVhId(reversalVoucher.getId());
        return REVERSE;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setButton(String button) {
        this.button = button;
    }

    public void setContraBean(ContraBean contraBean) {
        this.contraBean = contraBean;
    }

    public void setContraVoucher(ContraJournalVoucher cjv) {
        this.contraVoucher = cjv;
    }

    public void setFromBankBranchMap(Map<String, String> fromBankBranchMap) {
        this.fromBankBranchMap = fromBankBranchMap;
    }

    public boolean checkIfInterFund() {
        if (this.voucherHeader.getFundId() != null) {
            this.contraBean.setFromFundId(this.voucherHeader.getFundId().getId());
            return this.contraBean.getToFundId() != null && this.contraBean.getFromFundId() != null && !this.contraBean.getFromFundId().equals(this.contraBean.getToFundId());
        }
        return false;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setModeOfCollectionMap(Map<String, String> modeOfCollectionMap) {
        this.ModeOfCollectionMap = modeOfCollectionMap;
    }

    public void setToBankBranchMap(Map<String, String> toBankBranchMap) {
        this.toBankBranchMap = toBankBranchMap;
    }

    public void setVhId(Long vhId) {
        this.vhId = vhId;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public void setVoucherTypeBean(VoucherTypeBean voucherTypeBean) {
        this.voucherTypeBean = voucherTypeBean;
    }

    public void validate() {
        if (this.getButton().contains("Reverse")) {
            if (this.getReversalVoucherDate() == null) {
                this.addFieldError("reversalVocuherDate", this.getText("reversalVocuherDate.required"));
            } else {
                try {
                    this.sdf.parse(this.getReversalVoucherDate());
                    this.checkMandatoryField("voucherNumber", (Object)this.getReversalVoucherNumber(), "voucherNumberRequired");
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Error in validate>>>>" + e.getMessage()));
                    this.addFieldError("reversalVocuherDate", this.getText("reversalVocuherDate.notinproperformat"));
                }
                catch (ValidationException e) {
                    LOGGER.error((Object)("Error in validate----" + e.getMessage()));
                    this.addFieldError("reversalVocuherNumber", this.getText("reversalVocuherDate.required"));
                }
            }
        } else {
            if (this.contraBean.getFromBankId() == null || this.contraBean.getFromBankId().equals("-1")) {
                this.addFieldError("contraBean.fromBankId", this.getText("fromBankId.required"));
            }
            if (this.contraBean.getToBankId() == null || this.contraBean.getToBankId().equals("-1")) {
                this.addFieldError("contraBean.toBankId()", this.getText("toBankId.required"));
            }
            if (this.contraBean.getFromBankAccountId() == null || this.contraBean.getFromBankAccountId().equals("-1")) {
                this.addFieldError("contraBean.frombankAccountId", this.getText("fromBankAccountId.required"));
            }
            if (this.contraBean.getToBankAccountId() == null || this.contraBean.getToBankAccountId().equals("-1")) {
                this.addFieldError("contraBean.toBankAccountId()", this.getText("toBankAccountId.required"));
            }
            if (this.voucherHeader.getVouchermis().getDepartmentid() == null || this.voucherHeader.getVouchermis().getDepartmentid().getId() == null) {
                this.addFieldError("voucherHeader.vouchermis.departmentid.id", this.getText("fromDepartment.required"));
            }
            if (this.voucherHeader.getVouchermis().getFunction() == null || this.voucherHeader.getVouchermis().getFunction().getId() == null) {
                this.addFieldError("voucherHeader.vouchermis.departmentid.id", this.getText("fromFunction.required"));
            }
            if (this.egovCommon.isShowChequeNumber() || this.contraBean.getModeOfCollection().equals(MDC_OTHER)) {
                if (this.contraBean.getChequeNumber() == null || this.contraBean.getChequeNumber().isEmpty()) {
                    this.addFieldError("contraBean.chequeNumber", this.getText("ChequeNumber.required"));
                }
                if (this.contraBean.getChequeDate() == null || this.contraBean.getChequeDate().isEmpty()) {
                    this.addFieldError("contraBean.chequeDate", this.getText("fromChequeDate.required"));
                }
            }
            if (this.checkIfInterFund()) {
                if (this.contraBean.getDestinationGlcode() == null || this.contraBean.getDestinationGlcode().equals("-1")) {
                    this.addFieldError("contraBean.destinationGlcode", this.getText("destinationGlcode.required"));
                }
                if (this.contraBean.getSourceGlcode() == null || this.contraBean.getSourceGlcode().equals("-1")) {
                    this.addFieldError("contraBean.sourceGlcode", this.getText("sourceGlcode.required"));
                }
                if (this.contraBean.getToDepartment() == null || this.contraBean.getToDepartment().equals("-1")) {
                    this.addFieldError("contraBean.contraBean.toDepartment()", this.getText("toDepartment.required"));
                }
            }
            if (this.getAmount() == null) {
                this.addFieldError("amount", this.getText("amount.required"));
            } else {
                try {
                    this.contraBean.setAmount(new BigDecimal(this.getAmount()));
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)("Error in validate" + e.getMessage()));
                    this.addFieldError("amount", this.getText("amount.nonnumeric"));
                }
            }
            if (this.contraBean.getFromBankAccountId() != null && !this.contraBean.getFromBankAccountId().equals("-1") && this.contraBean.getToBankAccountId() != null && !this.contraBean.getToBankAccountId().equals("-1") && this.contraBean.getFromBankAccountId().equalsIgnoreCase(this.contraBean.getToBankAccountId())) {
                this.addFieldError("contraBean.fromBankId", this.getText("same.Account.Transfer.notAllowed"));
            }
            this.getHibObjectsFromContraBean();
            this.LoadAjaxedDropDowns();
        }
    }

    private ContraJournalVoucher addOrupdateContraJournalVoucher(ContraJournalVoucher cjv, InstrumentHeader ih, CVoucherHeader vh) {
        cjv.setInstrumentHeaderId(ih);
        cjv.setVoucherHeaderId(vh);
        this.getHibObjectsFromContraBean();
        cjv.setFromBankAccountId(this.contraVoucher.getFromBankAccountId());
        cjv.setToBankAccountId(this.contraVoucher.getToBankAccountId());
        if (cjv.getId() != null) {
            this.contraJournalVoucherService.applyAuditing((AbstractAuditable)cjv);
            this.contraJournalVoucherService.update((Object)cjv);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Contra Journal Voucher Updated");
            }
        } else {
            this.contraJournalVoucherService.applyAuditing((AbstractAuditable)cjv);
            this.contraJournalVoucherService.persist((Object)cjv);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Contra Journal Voucher created");
            }
        }
        return cjv;
    }

    private CVoucherHeader callCreateVoucher(CVoucherHeader voucher, ContraJournalVoucher contraVoucher) {
        try {
            HashMap headerDetails = this.createHeaderAndMisDetails();
            headerDetails.put("sourcepath", "/EGF/contra/contraBTB!beforeView.action?voucherHeader.id=");
            if (this.voucherHeader.getFundId().getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            }
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", this.contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", this.contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            this.voucherHeader = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + this.voucherHeader.getId()));
        }
        return this.voucherHeader;
    }

    private CVoucherHeader callCreateVoucherForInterFund(CVoucherHeader voucher, ContraJournalVoucher contraVoucher) {
        try {
            Fund toFund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.contraBean.getToFundId()});
            Department toDepartment = new Department();
            if (this.contraBean.getToDepartment() != null && !this.contraBean.getToDepartment().equals("-1")) {
                toDepartment = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.contraBean.getToDepartment().longValue()});
            }
            HashMap headerDetails = this.createHeaderAndMisDetails();
            headerDetails.put("vouchername", "InterFundTransfer");
            if (this.voucherHeader.getFundId().getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            }
            headerDetails.put("sourcepath", "/EGF/contra/contraBTB!beforeView.action?voucherHeader.id=");
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", this.contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            this.toFundCode = this.voucherHeader.getFundId();
            detailMap = new HashMap();
            detailMap.put("fundcode", toFund.getCode());
            detailMap.put("debitamount", this.contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", this.contraBean.getSourceGlcode());
            accountdetails.add(detailMap);
            this.voucherHeader = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
            accountdetails = new ArrayList();
            headerDetails.put("vouchername", "InterFundTransfer");
            headerDetails.put("vouchername", this.voucherHeader.getName());
            headerDetails.put("fundcode", toFund.getCode());
            if (toFund.getCode().equalsIgnoreCase("03")) {
                Department department = (Department)this.persistenceService.find("from Department where code=?", new Object[]{"Z"});
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", department.getCode());
            } else {
                headerDetails.remove("departmentcode");
                headerDetails.put("departmentcode", toDepartment == null ? "" : toDepartment.getCode());
            }
            headerDetails.remove("schemecode");
            headerDetails.remove("subschemecode");
            headerDetails.remove("fundsourcecode");
            headerDetails.remove("divisionid");
            headerDetails.remove("functionarycode");
            detailMap = new HashMap();
            detailMap.put("creditamount", this.contraBean.getAmount().toString());
            detailMap.put("debitamount", "0");
            detailMap.put("glcode", this.contraBean.getDestinationGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("debitamount", this.contraBean.getAmount().toString());
            detailMap.put("creditamount", "0");
            detailMap.put("glcode", contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            this.voucherHeader2 = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + this.voucherHeader.getId()));
        }
        return this.voucherHeader;
    }

    private boolean checkAndUpdateInstrument(InstrumentHeader oldInstrumentHeader, ContraJournalVoucher contraVoucher2, CVoucherHeader oldVoucher) {
        boolean updateInstrument;
        block17: {
            Date newInstrumentDate = null;
            updateInstrument = false;
            try {
                ContraJournalVoucher contraVoucher;
                List instrumentList;
                if (this.contraBean.getModeOfCollection().equalsIgnoreCase(MDC_CHEQUE)) {
                    if (oldInstrumentHeader.getInstrumentNumber() != null) {
                        if (!oldInstrumentHeader.getInstrumentNumber().equalsIgnoreCase(this.contraBean.getChequeNumber())) {
                            this.instrumentService.cancelInstrument(oldInstrumentHeader);
                            this.persistenceService.getSession().flush();
                            this.validateChqNumber(this.contraBean.getChequeNumber(), contraVoucher2.getFromBankAccountId().getId(), oldVoucher);
                            instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean, contraVoucher2));
                            this.updateInstrument((InstrumentHeader)instrumentList.get(0), oldVoucher);
                            this.persistenceService.getSession().flush();
                            contraVoucher = this.addOrupdateContraJournalVoucher(contraVoucher2, (InstrumentHeader)instrumentList.get(0), oldVoucher);
                            this.createLedgerAndPost(oldVoucher, contraVoucher);
                        } else {
                            newInstrumentDate = Constants.DDMMYYYYFORMAT2.parse(this.contraBean.getChequeDate());
                            if (oldInstrumentHeader.getInstrumentDate().compareTo(newInstrumentDate) != 0) {
                                oldInstrumentHeader.setInstrumentDate(newInstrumentDate);
                                updateInstrument = true;
                            }
                            if (oldInstrumentHeader.getInstrumentAmount().compareTo(this.contraBean.getAmount()) != 0) {
                                oldInstrumentHeader.setInstrumentAmount(this.contraBean.getAmount());
                                updateInstrument = true;
                            }
                            updateInstrument = true;
                        }
                        break block17;
                    }
                    this.instrumentService.cancelInstrument(oldInstrumentHeader);
                    this.persistenceService.getSession().flush();
                    if (!this.egovCommon.isShowChequeNumber()) {
                        try {
                            this.contraBean.setChequeNumber(this.chequeService.nextChequeNumber(this.contraBean.getFromBankAccountId(), 1, this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                        }
                        catch (ApplicationRuntimeException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                        }
                    }
                    this.validateChqNumber(this.contraBean.getChequeNumber(), contraVoucher2.getFromBankAccountId().getId(), oldVoucher);
                    instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean, contraVoucher2));
                    this.updateInstrument((InstrumentHeader)instrumentList.get(0), oldVoucher);
                    this.persistenceService.getSession().flush();
                    contraVoucher = this.addOrupdateContraJournalVoucher(contraVoucher2, (InstrumentHeader)instrumentList.get(0), oldVoucher);
                    this.createLedgerAndPost(oldVoucher, contraVoucher);
                    break block17;
                }
                if (this.contraBean.getModeOfCollection().equalsIgnoreCase(MDC_OTHER)) {
                    if (oldInstrumentHeader.getInstrumentNumber() != null) {
                        this.instrumentService.cancelInstrument(oldInstrumentHeader);
                        this.persistenceService.getSession().flush();
                        instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean, contraVoucher2));
                        this.updateInstrument((InstrumentHeader)instrumentList.get(0), oldVoucher);
                        this.persistenceService.getSession().flush();
                        contraVoucher = this.addOrupdateContraJournalVoucher(contraVoucher2, (InstrumentHeader)instrumentList.get(0), oldVoucher);
                        this.createLedgerAndPost(oldVoucher, contraVoucher);
                    } else {
                        newInstrumentDate = Constants.DDMMYYYYFORMAT2.parse(this.contraBean.getChequeDate());
                        oldInstrumentHeader.setInstrumentDate(null);
                        oldInstrumentHeader.setTransactionDate(newInstrumentDate);
                        updateInstrument = true;
                        if (this.contraBean.getAmount().compareTo(new BigDecimal(oldInstrumentHeader.getInstrumentAmount().toString())) != 0) {
                            oldInstrumentHeader.setInstrumentAmount(this.contraBean.getAmount());
                            oldInstrumentHeader.setTransactionNumber(this.contraBean.getChequeNumber());
                            updateInstrument = true;
                        }
                    }
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)e.getMessage());
                throw new ApplicationRuntimeException(e.getMessage());
            }
        }
        if (updateInstrument) {
            this.instrumentHeaderService.update((Object)oldInstrumentHeader);
            if (this.voucherHeader2 != null) {
                List exludeStatusList = this.getExcludeStatusListForInstruments();
                InstrumentVoucher instrumentVoucher2 = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher iv where iv.instrumentHeaderId.statusId not in (?) and voucherHeaderId.id=?", new Object[]{exludeStatusList.get(0), this.voucherHeader2.getId()});
                InstrumentHeader oldInstrumentHeader2 = instrumentVoucher2.getInstrumentHeaderId();
                oldInstrumentHeader2.setBankAccountId(oldInstrumentHeader.getBankAccountId());
                oldInstrumentHeader2.setBankBranchName(oldInstrumentHeader.getBankBranchName());
                oldInstrumentHeader2.setBankId(oldInstrumentHeader.getBankId());
                oldInstrumentHeader2.setDetailKeyId(oldInstrumentHeader.getDetailKeyId());
                oldInstrumentHeader2.setDetailTypeId(oldInstrumentHeader.getDetailTypeId());
                oldInstrumentHeader2.setInstrumentAmount(oldInstrumentHeader.getInstrumentAmount());
                oldInstrumentHeader2.setInstrumentDate(oldInstrumentHeader.getInstrumentDate());
                oldInstrumentHeader2.setInstrumentNumber(oldInstrumentHeader.getInstrumentNumber());
                oldInstrumentHeader2.setInstrumentType(oldInstrumentHeader.getInstrumentType());
                oldInstrumentHeader2.setIsPayCheque("0");
                oldInstrumentHeader2.setPayee(oldInstrumentHeader.getPayee());
                oldInstrumentHeader2.setPayTo(oldInstrumentHeader.getPayTo());
                oldInstrumentHeader2.setTransactionDate(oldInstrumentHeader.getTransactionDate());
                oldInstrumentHeader2.setTransactionNumber(oldInstrumentHeader.getTransactionNumber());
                oldInstrumentHeader2.setTransactionNumber(oldInstrumentHeader.getSurrendarReason());
                oldInstrumentHeader2.setStatusId(oldInstrumentHeader2.getStatusId());
                this.instrumentHeaderService.update((Object)oldInstrumentHeader2);
            }
            this.createLedgerAndPost(oldVoucher, contraVoucher2);
        }
        return updateInstrument;
    }

    private List<Map<String, Object>> createInstruments(ContraBean cBean, ContraJournalVoucher cVoucher) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        Date dt = null;
        iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
        iMap.put("Bank code", this.contraVoucher.getFromBankAccountId().getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", cVoucher.getFromBankAccountId().getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", cVoucher.getFromBankAccountId().getId());
        if (cBean.getModeOfCollection().equalsIgnoreCase(MDC_CHEQUE)) {
            if (!this.egovCommon.isShowChequeNumber()) {
                try {
                    iMap.put("Instrument number", this.chequeService.nextChequeNumber(cVoucher.getFromBankAccountId().getId().toString(), 1, this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                }
                catch (ApplicationRuntimeException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                }
                iMap.put("Instrument date", new Date());
            } else {
                iMap.put("Instrument number", cBean.getChequeNumber());
                try {
                    dt = this.sdf.parse(this.contraBean.getChequeDate());
                }
                catch (ParseException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                }
                iMap.put("Instrument date", dt);
            }
            iMap.put("Instrument type", MDC_CHEQUE);
        } else {
            iMap.put("Transaction number", cBean.getChequeNumber());
            try {
                dt = this.sdf.parse(this.contraBean.getChequeDate());
            }
            catch (ParseException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
            }
            iMap.put("Transaction date", dt);
            iMap.put("Instrument type", "bankchallan");
        }
        iMap.put("Is pay cheque", "1");
        iList.add(iMap);
        return iList;
    }

    private List<Map<String, Object>> createInstrumentsForReceipt(ContraBean cBean, ContraJournalVoucher cVoucher) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        Date dt = null;
        iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
        iMap.put("Bank code", this.contraVoucher.getToBankAccountId().getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", cVoucher.getToBankAccountId().getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", cVoucher.getToBankAccountId().getId());
        if (cBean.getModeOfCollection().equalsIgnoreCase(MDC_CHEQUE)) {
            if (!this.egovCommon.isShowChequeNumber()) {
                try {
                    iMap.put("Instrument number", this.chequeService.nextChequeNumber(cVoucher.getToBankAccountId().getId().toString(), 1, this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
                }
                catch (ApplicationRuntimeException e) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while getting Cheque Number  ", e.getMessage())));
                }
                iMap.put("Instrument date", new Date());
            } else {
                iMap.put("Instrument number", cBean.getChequeNumber());
                try {
                    dt = this.sdf.parse(this.contraBean.getChequeDate());
                }
                catch (ParseException e) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                }
                iMap.put("Instrument date", dt);
            }
            iMap.put("Instrument type", MDC_CHEQUE);
        } else {
            iMap.put("Transaction number", cBean.getChequeNumber());
            try {
                dt = this.sdf.parse(this.contraBean.getChequeDate());
            }
            catch (ParseException e) {
                throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
            }
            iMap.put("Transaction date", dt);
            iMap.put("Instrument type", "bankchallan");
        }
        iMap.put("Is pay cheque", "0");
        iList.add(iMap);
        return iList;
    }

    private void createLedgerAndPost(CVoucherHeader voucher, ContraJournalVoucher contraVoucher) {
        try {
            if (this.voucherHeader2 != null) {
                this.createLedgerAndPostForInterfund(voucher, contraVoucher);
            } else {
                this.createVoucher.deleteVoucherdetailAndGL(voucher);
                this.persistenceService.getSession().flush();
                HashMap<String, String> detailMap = null;
                ArrayList accountdetails = new ArrayList();
                ArrayList subledgerDetails = new ArrayList();
                detailMap = new HashMap<String, String>();
                detailMap.put("creditamount", this.contraBean.getAmount().toString());
                detailMap.put("debitamount", "0");
                detailMap.put("glcode", contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode());
                accountdetails.add(detailMap);
                detailMap = new HashMap();
                detailMap.put("debitamount", this.contraBean.getAmount().toString());
                detailMap.put("creditamount", "0");
                detailMap.put("glcode", contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode());
                accountdetails.add(detailMap);
                List transactions = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, voucher);
                this.persistenceService.getSession().flush();
                Transaxtion[] txnList = new Transaxtion[transactions.size()];
                txnList = transactions.toArray(txnList);
                SimpleDateFormat formatter = new SimpleDateFormat(DD_MMM_YYYY);
                if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(voucher.getVoucherDate()))) {
                    throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
                }
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Posted to Ledger ");
        }
    }

    private List<Bankaccount> getAccountNumbers(Integer branchId, Integer fundId, String typeOfAccount) {
        List<Object> accountNumbersList = new ArrayList<Bankaccount>();
        typeOfAccount.split(",");
        if (branchId != null) {
            accountNumbersList = this.persistenceService.findAllBy("from Bankaccount account where account.bankbranch.id=? and account.fund.id=?  and account.isactive=true ", new Object[]{branchId, fundId});
        }
        return accountNumbersList;
    }

    private Map getBankBranches(Integer fundId, String typeOfAccount) {
        typeOfAccount.split(",");
        LinkedHashMap<String, String> bankBrmap = new LinkedHashMap<String, String>();
        if (fundId != null) {
            List bankBranch = this.persistenceService.findAllBy("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),bankBranch.branchname) as bankbranchname  FROM Bank bank,Bankbranch bankBranch,Bankaccount bankaccount  where  bank.isactive=true  and bankBranch.isactive=true and bankaccount.isactive=true and bank.id = bankBranch.bank.id and bankBranch.id = bankaccount.bankbranch.id and bankaccount.fund.id=?", new Object[]{fundId});
            for (Object[] element : bankBranch) {
                bankBrmap.put(element[0].toString(), element[1].toString());
            }
        }
        return bankBrmap;
    }

    private void getHibObjectsFromContraBean() {
        String bankQry = "from Bankaccount where id=?";
        if (this.contraBean != null && this.contraBean.getFromBankAccountId() != null && !this.contraBean.getFromBankAccountId().equals("-1")) {
            this.contraVoucher.setFromBankAccountId((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(this.contraBean.getFromBankAccountId())}));
        }
        if (this.contraBean != null && this.contraBean.getToBankAccountId() != null && !this.contraBean.getFromBankAccountId().equals("-1")) {
            this.contraVoucher.setToBankAccountId((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(this.contraBean.getToBankAccountId())}));
        }
    }

    private void loadAccountNumbers() {
        String[] split;
        if (this.contraVoucher != null && this.contraVoucher.getFromBankAccountId() != null) {
            this.addDropdownData("fromAccNumList", this.getAccountNumbers(this.contraVoucher.getFromBankAccountId().getBankbranch().getId(), this.contraBean.getFromFundId(), "RECEIPTS_PAYMENTS,RECEIPTS"));
        } else if (this.contraBean.getFromBankId() != null && !this.contraBean.getFromBankId().equals("-1")) {
            String fromBankId = this.contraBean.getFromBankId();
            split = fromBankId.split("-");
            if (split[1] != null && !split[1].isEmpty()) {
                if (this.contraBean.getFromFundId() != null && this.contraBean.getFromFundId() != -1) {
                    this.addDropdownData("fromAccNumList", this.getAccountNumbers(Integer.valueOf(split[1]), Integer.valueOf(this.contraBean.getFromFundId()), "RECEIPTS_PAYMENTS,RECEIPTS"));
                } else {
                    this.addDropdownData("fromAccNumList", Collections.EMPTY_LIST);
                }
            }
        } else {
            this.addDropdownData("fromAccNumList", Collections.EMPTY_LIST);
        }
        if (this.contraVoucher != null && this.contraVoucher.getToBankAccountId() != null) {
            this.addDropdownData("toAccNumList", this.getAccountNumbers(this.contraVoucher.getToBankAccountId().getBankbranch().getId(), this.contraBean.getToFundId(), "RECEIPTS_PAYMENTS,PAYMENTS"));
        } else if (this.contraBean.getToBankId() != null && !this.contraBean.getToBankId().equals("-1")) {
            String toBankId = this.contraBean.getToBankId();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)this.contraBean.getFromFundId());
            }
            if ((split = toBankId.split("-"))[1] != null && !split[1].isEmpty()) {
                this.addDropdownData("toAccNumList", this.getAccountNumbers(Integer.valueOf(split[1]), this.contraBean.getToFundId(), "RECEIPTS_PAYMENTS,PAYMENTS"));
            }
        } else {
            this.addDropdownData("toAccNumList", Collections.EMPTY_LIST);
        }
    }

    private void LoadAjaxedDropDowns() {
        this.loadSchemeSubscheme();
        this.loadBankBranch();
        this.loadAccountNumbers();
        this.loadBankBalances();
    }

    private void loadBankBalances() {
        this.egovCommon.setPersistenceService(this.persistenceService);
        this.egovCommon.setFundFlowService(this.fundFlowService);
        if (this.contraVoucher != null && this.contraVoucher.getFromBankAccountId() != null) {
            BigDecimal fromBalance;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)this.voucherHeader.getVoucherDate());
            }
            try {
                fromBalance = this.egovCommon.getAccountBalance(this.voucherHeader.getVoucherDate(), this.contraVoucher.getFromBankAccountId().getId());
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage());
                fromBalance = BigDecimal.valueOf(-1L);
            }
            this.contraBean.setFromBankBalance(fromBalance.setScale(2).toString());
        } else {
            this.contraBean.setFromBankBalance(null);
        }
        if (this.contraVoucher != null && this.contraVoucher.getToBankAccountId() != null) {
            BigDecimal toBalance;
            try {
                toBalance = this.egovCommon.getAccountBalance(this.voucherHeader.getVoucherDate(), this.contraVoucher.getToBankAccountId().getId());
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage());
                toBalance = BigDecimal.valueOf(-1L);
            }
            this.contraBean.setToBankBalance(toBalance.setScale(2).toString());
        } else {
            this.contraBean.setToBankBalance(null);
        }
    }

    private void loadBankBranch() {
        if (this.voucherHeader.getFundId() != null && this.voucherHeader.getFundId().getId() != null) {
            this.fromBankBranchMap = this.getBankBranches(this.voucherHeader.getFundId().getId(), "RECEIPTS_PAYMENTS,RECEIPTS");
            this.toBankBranchMap = this.getBankBranches(this.contraBean.getToFundId(), "RECEIPTS_PAYMENTS,PAYMENTS");
        } else {
            this.fromBankBranchMap = Collections.EMPTY_MAP;
            this.toBankBranchMap = Collections.EMPTY_MAP;
        }
    }

    private void prepareForViewModifyReverse() {
        this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{this.voucherHeader.getId()});
        if (this.voucherHeader.getRefvhId() != null) {
            this.voucherHeaderDes = this.voucherHeader;
            this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id =?", new Object[]{this.voucherHeader.getRefvhId()});
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucherHeader.fundId.id" + this.voucherHeader.getFundId().getId()));
        }
        this.generalLedgerSrcList = this.persistenceService.findAllBy("from CGeneralLedger where voucherHeaderId = ?", new Object[]{this.voucherHeader});
        this.contraVoucher = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where voucherHeaderId=?", new Object[]{this.voucherHeader});
        for (CGeneralLedger generalled : this.generalLedgerSrcList) {
            if (generalled.getGlcode().equals(this.contraVoucher.getFromBankAccountId().getChartofaccounts().getGlcode())) continue;
            this.contraBean.setSourceGlcode(generalled.getGlcode());
        }
        this.contraBean.setFromFundId(this.voucherHeader.getFundId().getId());
        this.contraBean.setFromBankAccountId(this.contraVoucher.getFromBankAccountId().getId().toString());
        this.fromAccnumnar = this.contraVoucher.getFromBankAccountId().getNarration();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("fromAccnumnar.............." + this.fromAccnumnar));
        }
        this.toAccnumnar = this.contraVoucher.getToBankAccountId().getNarration();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("toAccnumnar.............." + this.toAccnumnar));
        }
        if (this.voucherHeaderDes != null) {
            this.generalLedgerDesList = this.persistenceService.findAllBy("from CGeneralLedger where voucherHeaderId = ?", new Object[]{this.voucherHeaderDes});
            for (CGeneralLedger generalled : this.generalLedgerDesList) {
                if (generalled.getGlcode().equalsIgnoreCase(this.contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode())) continue;
                this.contraBean.setDestinationGlcode(generalled.getGlcode());
            }
        } else {
            this.generalLedgerDesList = this.persistenceService.findAllBy("from CGeneralLedger where voucherHeaderId.refvhId = ?", new Object[]{this.voucherHeader.getId()});
            for (CGeneralLedger generalled : this.generalLedgerDesList) {
                if (generalled.getGlcode().equalsIgnoreCase(this.contraVoucher.getToBankAccountId().getChartofaccounts().getGlcode())) continue;
                this.contraBean.setDestinationGlcode(generalled.getGlcode());
            }
        }
        this.contraBean.setToBankAccountId(this.contraVoucher.getToBankAccountId().getId().toString());
        String fromBankAndBranchId = this.contraVoucher.getFromBankAccountId().getBankbranch().getBank().getId().toString() + "-" + this.contraVoucher.getFromBankAccountId().getBankbranch().getId().toString();
        String toBankAndBranchId = this.contraVoucher.getToBankAccountId().getBankbranch().getBank().getId().toString() + "-" + this.contraVoucher.getToBankAccountId().getBankbranch().getId().toString();
        this.contraBean.setFromBankId(fromBankAndBranchId);
        this.contraBean.setToBankId(toBankAndBranchId);
        this.contraBean.setToFundId(this.contraVoucher.getToBankAccountId().getFund().getId());
        List exludeStatusList = this.getExcludeStatusListForInstruments();
        InstrumentVoucher instrumentVoucher = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher iv where iv.instrumentHeaderId.statusId not in (?) and  voucherHeaderId=?", new Object[]{exludeStatusList.get(0), this.voucherHeader});
        if (instrumentVoucher == null) {
            LOGGER.error((Object)"System Error :Instrument is not linked with voucher ");
            throw new ApplicationRuntimeException(" System Error :Instrument is not linked with voucher  ");
        }
        InstrumentHeader instrumentHeader = instrumentVoucher.getInstrumentHeaderId();
        this.contraBean.setAmount(instrumentHeader.getInstrumentAmount());
        this.setAmount(this.contraBean.getAmount().setScale(2).toString());
        if (instrumentHeader.getTransactionNumber() != null) {
            this.contraBean.setModeOfCollection(MDC_OTHER);
            this.contraBean.setChequeNumber(instrumentHeader.getTransactionNumber());
            String chequeDate = Constants.DDMMYYYYFORMAT2.format(instrumentHeader.getTransactionDate());
            this.contraBean.setChequeDate(chequeDate);
        } else {
            this.contraBean.setModeOfCollection(MDC_CHEQUE);
            this.contraBean.setChequeNumber(instrumentHeader.getInstrumentNumber());
            String chequeDate = Constants.DDMMYYYYFORMAT2.format(instrumentHeader.getInstrumentDate());
            this.contraBean.setChequeDate(chequeDate);
        }
        this.LoadAjaxedDropDowns();
    }

    private void updateInstrument(InstrumentHeader ih, CVoucherHeader vh) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
        iMap.put("Instrument header", ih);
        iMap.put("Voucher header", vh);
        iList.add(iMap);
        this.instrumentService.updateInstrumentVoucherReference(iList);
    }

    private void validateChqNumber(String chqNo, Long bankaccId, CVoucherHeader voucherHeader) {
        if (!this.instrumentService.isChequeNumberValid(chqNo, bankaccId, Integer.valueOf(voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), null)) {
            throw new ValidationException(Arrays.asList(new ValidationError("Invalid cheque number", "Invalid cheque number")));
        }
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getToAccnumnar() {
        return this.toAccnumnar;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public void setToAccnumnar(String toAccnumnar) {
        this.toAccnumnar = toAccnumnar;
    }

    public String getSourceGlcode() {
        return this.sourceGlcode;
    }

    public void setSourceGlcode(String sourceGlcode) {
        this.sourceGlcode = sourceGlcode;
    }

    public String getDestinationGlcode() {
        return this.destinationGlcode;
    }

    public void setDestinationGlcode(String destinationGlcode) {
        this.destinationGlcode = destinationGlcode;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setPaymentheader(Paymentheader paymentheader) {
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public Integer getUserDepartment() throws ParseException {
        return this.paymentService.getAssignment().getDepartment().getId().intValue();
    }

    public void setFundFlowService(FundFlowService fundFlowService) {
        this.fundFlowService = fundFlowService;
    }

    public String getFromAccnumnar() {
        return this.fromAccnumnar;
    }

    public Date getVoucherDate() {
        return this.voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public void setFromAccnumnar(String fromAccnumnar) {
        this.fromAccnumnar = fromAccnumnar;
    }

    public ChartOfAccounts getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(ChartOfAccounts chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }
}

