/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.egf.model.BudgetAmountView;
import org.egov.egf.web.actions.budget.BaseBudgetDetailAction;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new-re"}, location="budgetDetail-new-re.jsp"), @Result(name={"budgets"}, location="budgetDetail-budgets.jsp"), @Result(name={"functions"}, location="budgetDetail-functions.jsp"), @Result(name={"budgetGroup"}, location="budgetDetail-budgetGroup.jsp"), @Result(name={"AJAX_RESULT"}, type="stream", location="returnStream", params={"contentType", "text/plain"})})
public class BudgetDetailAction
extends BaseBudgetDetailAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private static final String ACTIONNAME = "actionName";
    private Budget topBudget;
    private Map<Long, BigDecimal> beNextYearAmounts = new HashMap();
    private static Logger LOGGER = Logger.getLogger(BudgetDetailAction.class);
    String streamResult = "";
    private Long function;
    private Long budgetGroups;
    List<CFunction> functionList = Collections.EMPTY_LIST;
    List<BudgetGroup> budgetGroupList = Collections.EMPTY_LIST;

    public void setBudgetGroupList(List budgetGroupList) {
        this.budgetGroupList = budgetGroupList;
    }

    public InputStream getReturnStream() {
        ByteArrayInputStream is = new ByteArrayInputStream(this.streamResult.getBytes());
        return is;
    }

    protected void saveAndStartWorkFlow(BudgetDetail detail) {
        try {
            if (this.budgetDocumentNumber != null && this.budgetDetail.getBudget() != null) {
                Budget b = (Budget)this.budgetService.findById((Serializable)this.budgetDetail.getBudget().getId(), false);
                b.setDocumentNumber(this.budgetDocumentNumber);
                this.budgetService.persist((Object)b);
                this.persistenceService.getSession().flush();
            }
            BudgetDetail persist = this.budgetDetailService.createBudgetDetail(detail, this.getPosition(), this.getPersistenceService());
            this.populateSavedbudgetDetailListFor(persist.getBudget());
            this.headerDisabled = true;
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Duplication in budget details" + e.getMessage()), (Throwable)e);
            this.handleDuplicateBudgetDetailError(e);
            this.populateSavedbudgetDetailListFor(this.budgetDetail.getBudget());
        }
    }

    protected void handleDuplicateBudgetDetailError(ValidationException e) {
        for (ValidationError error : e.getErrors()) {
            if (!"budgetDetail.duplicate".equals(error.getKey())) continue;
            this.headerDisabled = true;
            break;
        }
        throw e;
    }

    public void populateSavedbudgetDetailListFor(Budget budget) {
        if (budget != null) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget=? order by function.name,budgetGroup.name", new Object[]{budget});
        }
    }

    public void populateSavedbudgetDetailListForDetail(BudgetDetail bd) {
        if (bd != null) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget=? and function=? order by function.name,budgetGroup.name", new Object[]{bd.getBudget(), bd.getFunction()});
        }
        this.savedbudgetDetailList.addAll(this.budgetDetailService.findAllBy("from BudgetDetail where budget=(select bd from Budget bd where referenceBudget=?) and function=? order by function.name,budgetGroup.name", new Object[]{bd.getBudget(), bd.getFunction()}));
    }

    public String ajaxLoadBudgetDetailList() {
        Long id = (Long)this.request.get("id");
        if (!Long.valueOf(0L).equals(id)) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{id});
            Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
            this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
            this.budgetDetail.setBudget(budget);
            this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
            this.budgetDocumentNumber = budget.getDocumentNumber();
        }
        this.populateBeNextYearAmounts();
        this.populateFinancialYear();
        return "savedData";
    }

    @SkipValidation
    public String loadBudgetDetailList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Initiating load budgets .....");
        }
        Long id = this.budgetDetail.getBudget().getId();
        this.showRe = true;
        this.getDetailsFilterdBy();
        Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
        this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
        this.budgetDetail.setBudget(budget);
        this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
        this.budgetDocumentNumber = budget.getDocumentNumber();
        this.budgetAmountView = new ArrayList(this.savedbudgetDetailList.size());
        for (int i = 0; i < this.savedbudgetDetailList.size(); ++i) {
            this.budgetAmountView.add(new BudgetAmountView());
        }
        this.budgetDetailList = this.savedbudgetDetailList;
        this.populateBeNextYearAmountsAndBEAmounts();
        this.populateFinancialYear();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Budgets Loadded Succesfully");
        }
        this.showDetails = true;
        return "new-re";
    }

    private void loadAjaxedFunctionAndBudgetGroup() {
        if (this.budgetDetail.getBudget() != null) {
            String sqlStr = "select distinct (f.name)  as name,f.id as id   from function f,egf_budgetdetail bd where  f.id=bd.function and bd.budget=" + this.budgetDetail.getBudget().getId() + "  order  by f.name";
            SQLQuery sqlQuery = this.persistenceService.getSession().createSQLQuery(sqlStr);
            sqlQuery.addScalar("name").addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CFunction.class));
            this.functionList = sqlQuery.list();
            sqlStr = "select  distinct (bg.name) as name ,bg.id  as id from egf_budgetgroup bg,egf_budgetdetail  bd where  bg.id=bd.budgetgroup and bd.budget=" + this.budgetDetail.getBudget().getId() + "  order  by bg.name";
            sqlQuery = this.persistenceService.getSession().createSQLQuery(sqlStr);
            sqlQuery.addScalar("name").addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BudgetGroup.class));
            this.budgetGroupList = sqlQuery.list();
        }
    }

    @Action(value="/budget/budgetDetail-ajaxLoadBudgets")
    public String ajaxLoadBudgets() {
        String bere = ((String[])this.parameters.get("bere"))[0];
        this.loadBudgets(bere);
        return "budgets";
    }

    @Action(value="/budget/budgetDetail-ajaxLoadFunctions")
    public String ajaxLoadFunctions() {
        Long id = (Long)this.request.get("id");
        String sqlStr = "select distinct (f.name)  as name,f.id as id   from function f,egf_budgetdetail bd where  f.id=bd.function and bd.budget=" + id + "  order  by f.name";
        SQLQuery sqlQuery = this.persistenceService.getSession().createSQLQuery(sqlStr);
        sqlQuery.addScalar("name").addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CFunction.class));
        this.functionList = sqlQuery.list();
        return "functions";
    }

    @Action(value="/budget/budgetDetail-ajaxLoadBudgetGroups")
    public String ajaxLoadBudgetGroups() {
        Long id = (Long)this.request.get("id");
        String sqlStr = "select  distinct (bg.name) as name ,bg.id  as id from egf_budgetgroup bg,egf_budgetdetail  bd where  bg.id=bd.budgetgroup and bd.budget=" + id + "  order  by bg.name";
        SQLQuery sqlQuery = this.persistenceService.getSession().createSQLQuery(sqlStr);
        sqlQuery.addScalar("name").addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BudgetGroup.class));
        this.budgetGroupList = sqlQuery.list();
        return "budgetGroup";
    }

    public String saveAndNew() {
        return this.create();
    }

    public String saveAndNewRe() {
        return this.createRe();
    }

    public void prepare() {
        super.prepare();
        this.populateSavedbudgetDetailListFor(this.budgetDetail.getBudget());
        if (this.parameters.containsKey("re")) {
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
        }
        this.loadAjaxedFunctionAndBudgetGroup();
    }

    public boolean isShowMessage() {
        return super.isShowMessage();
    }

    public String getActionMessage() {
        if (this.getActionMessages() != null && this.getActionMessages().iterator() != null && this.getActionMessages().iterator().next() != null) {
            return ((String)this.getActionMessages().iterator().next()).toString();
        }
        return "";
    }

    private void populateBeNextYearAmounts() {
        if (this.savedbudgetDetailList == null || this.savedbudgetDetailList.size() == 0) {
            return;
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, budgetDetail)) continue;
                    this.beNextYearAmounts.put(budgetDetail.getId(), row.getOriginalAmount().setScale(2));
                }
            }
        }
    }

    private void populateBeNextYearAmountsAndBEAmounts() {
        if (this.savedbudgetDetailList == null || this.savedbudgetDetailList.size() == 0) {
            return;
        }
        this.beAmounts = new ArrayList(this.savedbudgetDetailList.size());
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, budgetDetail)) continue;
                    this.beNextYearAmounts.put(budgetDetail.getId(), row.getOriginalAmount().setScale(2));
                    this.beAmounts.add(row.getOriginalAmount());
                }
            }
        }
    }

    protected void saveAndStartWorkFlowForRe(BudgetDetail detail, int index, CFinancialYear finYear, Budget refBudget) {
        try {
            if (this.budgetDocumentNumber != null && this.budgetDetail.getBudget() != null) {
                Budget b = (Budget)this.budgetService.findById((Serializable)this.budgetDetail.getBudget().getId(), false);
                b.setDocumentNumber(this.budgetDocumentNumber);
                this.budgetService.persist((Object)b);
                this.persistenceService.getSession().flush();
            }
            detail.getBudget().setFinancialYear(finYear);
            BudgetDetail reCurrentYear = this.budgetDetailService.createBudgetDetail(detail, this.getPosition(), this.getPersistenceService());
            this.headerDisabled = true;
            BudgetDetail beNextYear = new BudgetDetail();
            beNextYear.copyFrom(detail);
            beNextYear.setBudget(refBudget);
            beNextYear.setOriginalAmount((BigDecimal)this.beAmounts.get(index));
            beNextYear.setDocumentNumber(detail.getDocumentNumber());
            beNextYear.setAnticipatoryAmount(reCurrentYear.getAnticipatoryAmount());
            beNextYear = this.budgetDetailService.createBudgetDetail(beNextYear, this.getPosition(), this.getPersistenceService());
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.populateBeNextYearAmounts();
            this.handleDuplicateBudgetDetailError(e);
            this.populateSavedbudgetDetailListFor(this.budgetDetail.getBudget());
            throw e;
        }
    }

    public void approve() {
        this.topBudget = ((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget();
        this.setTopBudget(this.topBudget);
        String budgetComment = "";
        if (this.parameters.get("budget.comments") != null) {
            budgetComment = ((String[])this.parameters.get("budget.comments"))[0];
        }
        Integer userId = null;
        userId = ((String[])this.parameters.get(ACTIONNAME))[0] != null && ((String[])this.parameters.get(ACTIONNAME))[0].contains("reject") ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : (null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
        for (BudgetDetail detail : this.savedbudgetDetailList) {
            if (!new String("forward").equals(((String[])this.parameters.get(ACTIONNAME))[0])) continue;
            detail.transition(true).withStateValue("Forwarded by " + this.getPosition().getName()).withOwner(this.getPositionByUserId(userId)).withComments(detail.getComment());
        }
        this.setTopBudget(this.budgetService.getReferenceBudgetFor(this.topBudget));
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approve")) {
            if (this.topBudget.getState().getValue().equals("END")) {
                this.addActionMessage(this.getMessage("budgetdetail.approved.end"));
            } else {
                this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(this.topBudget.getState().getOwnerPosition()));
            }
        } else {
            this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(this.topBudget.getState().getOwnerPosition()));
        }
    }

    @Action(value="/budget/budgetDetail-newRe")
    public String newRe() {
        this.showRe = true;
        return "new-re";
    }

    @ValidationErrorPage(value="new-re")
    @Action(value="/budget/budgetDetail-loadActualsForRe")
    public String loadActualsForRe() {
        this.showRe = true;
        try {
            this.loadActuals();
            this.showDetails = true;
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.populateBudgetList();
            throw e;
        }
        this.populateBudgetList();
        return "new-re";
    }

    public void setShowRe(boolean showRe) {
        this.showRe = showRe;
    }

    public boolean isShowRe() {
        return this.showRe;
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    public Budget getTopBudget() {
        return this.topBudget;
    }

    public void setTopBudget(Budget topBudget) {
        this.topBudget = topBudget;
    }

    public void setBeNextYearAmounts(Map<Long, BigDecimal> beNextYearAmounts) {
        this.beNextYearAmounts = beNextYearAmounts;
    }

    public Map<Long, BigDecimal> getBeNextYearAmounts() {
        return this.beNextYearAmounts;
    }

    public List getFunctionList() {
        return this.functionList;
    }

    public void setFunctionList(List functionList) {
        this.functionList = functionList;
    }

    public List getBudgetGroupList() {
        return this.budgetGroupList;
    }

    public Long getFunction() {
        return this.function;
    }

    public void setFunction(Long function) {
        this.function = function;
    }

    public Long getBudgetGroups() {
        return this.budgetGroups;
    }

    public void setBudgetGroups(Long budgetGroups) {
        this.budgetGroups = budgetGroups;
    }
}

