/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.model.BudgetAmountView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetDetailHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseBudgetDetailAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    protected BudgetDetail budgetDetail = new BudgetDetail();
    protected List<BudgetDetail> budgetDetailList = new ArrayList();
    protected List<BudgetDetail> savedbudgetDetailList = new ArrayList();
    protected BudgetDetailService budgetDetailService;
    BudgetService budgetService;
    private PersistenceService<CFinancialYear, Long> finYearService;
    protected List<String> headerFields = new ArrayList();
    protected List<String> gridFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    protected WorkflowService<Budget> budgetWorkflowService;
    protected WorkflowService<BudgetDetail> budgetDetailWorkflowService;
    protected boolean headerDisabled = false;
    protected List<BudgetAmountView> budgetAmountView = new ArrayList();
    protected String currentYearRange;
    protected String previousYearRange;
    private String nextYearRange;
    protected String lastButOneYearRange;
    protected List<Scheme> subSchemes;
    protected Integer schemeId;
    protected Date asOnDate;
    private EisCommonService eisCommonService;
    BudgetDetailHelper budgetDetailHelper;
    protected boolean addNewDetails = false;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    protected BudgetDetailConfig budgetDetailConfig;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    static final Integer INT_ZERO = 0;
    static final Long LONG_ZERO = 0L;
    FinancialYearDAO financialYearDAO;
    protected boolean re = false;
    private boolean showMessage = false;
    protected List<BigDecimal> beAmounts = new ArrayList();
    private Budget referenceBudget;
    private CFinancialYear financialYear;
    protected List<Budget> budgetList = new ArrayList();
    protected boolean showRe;
    Long budgetDocumentNumber;
    protected boolean showDetails;
    protected Long searchfunctionid;
    protected Long searchbudgetGroupid;
    private static Logger LOGGER = Logger.getLogger(BaseBudgetDetailAction.class);

    public boolean isAddNewDetails() {
        return this.addNewDetails;
    }

    public void setAddNewDetails(boolean addNewDetails) {
        this.addNewDetails = addNewDetails;
    }

    public abstract void populateSavedbudgetDetailListFor(Budget var1);

    public abstract void populateSavedbudgetDetailListForDetail(BudgetDetail var1);

    public void setBudgetDocumentNumber(Long documentNumber) {
        this.budgetDocumentNumber = documentNumber;
    }

    public Long getBudgetDocumentNumber() {
        return this.budgetDocumentNumber;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public boolean isRe() {
        return this.re;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetHelper) {
        this.budgetDetailHelper = budgetHelper;
    }

    public void setFinYearService(PersistenceService<CFinancialYear, Long> finYearService) {
        this.finYearService = finYearService;
    }

    public Date getAsOnDate() {
        return this.asOnDate == null ? new Date() : this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public Integer getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Integer schemeId) {
        this.schemeId = schemeId;
    }

    public List<Scheme> getSubSchemes() {
        return this.subSchemes;
    }

    public String execute() throws Exception {
        return "new";
    }

    public String create() {
        this.validateMandatoryFields();
        this.budgetDetailHelper.removeEmptyBudgetDetails(this.budgetDetailList);
        this.saveBudgetDetails(false, this.financialYear, this.budgetDetail.getBudget());
        this.setAsOnDateOnSelectedBudget();
        this.showMessage = true;
        this.addActionMessage("Budget details saved successfully");
        return "new";
    }

    @ValidationErrorPage(value="new-re")
    public String createRe() {
        this.showRe = true;
        try {
            this.getActionMessages().clear();
            this.validateMandatoryFields();
            this.budgetDetailHelper.removeEmptyBudgetDetails(this.budgetDetailList);
            if (!this.addNewDetails) {
                this.deleteExisting();
            }
            this.validateAmounts(this.budgetDetailList);
            this.saveBudgetDetails(true, this.financialYear, this.budgetDetail.getBudget());
            this.setAsOnDateOnSelectedBudget();
            this.showMessage = true;
            this.addActionMessage("RE proposal for current year and BE proposal for next year saved successfully");
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
            this.budgetDetail = new BudgetDetail();
            this.budgetDetail.setExecutingDepartment(null);
        }
        catch (ValidationException e) {
            this.loadBudgets("RE");
            this.dropdownData.put("budgetList", this.budgetList);
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
            throw e;
        }
        return "new-re";
    }

    @ValidationErrorPage(value="newDetail-re")
    public String createBudgetDetail() {
        this.showRe = true;
        this.re = this.budgetService.hasReForYear(this.budgetDetail.getBudget().getFinancialYear().getId());
        try {
            this.getActionMessages().clear();
            this.removeEmptyBudgetDetails(this.budgetDetailList);
            this.validateIsPrimary();
            if (!this.rowsEmpty()) {
                if (!this.addNewDetails) {
                    this.deleteExisting();
                }
                this.validateMandatoryFields();
                this.saveNewBudgetDetailItems(true, this.financialYear, this.budgetDetail.getBudget());
            }
            this.setAsOnDateOnSelectedBudget();
            this.showMessage = true;
            this.addActionMessage("RE proposal for current year and BE proposal for next year saved successfully");
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
            this.budgetDetail = new BudgetDetail();
            this.budgetDetail.setExecutingDepartment(null);
        }
        catch (ValidationException e) {
            this.loadBudgets("RE");
            this.dropdownData.put("budgetList", this.budgetList);
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
            throw e;
        }
        return "newDetail-re";
    }

    @ValidationErrorPage(value="new-re")
    public String createReAndForward() {
        this.showRe = true;
        try {
            this.getActionMessages().clear();
            this.removeEmptyBudgetDetails(this.budgetDetailList);
            this.validateIsPrimary();
            if (!this.rowsEmpty()) {
                if (!this.addNewDetails) {
                    this.deleteExisting();
                }
                this.validateMandatoryFields();
                this.saveBudgetDetails(true, this.financialYear, this.budgetDetail.getBudget());
            }
            this.setAsOnDateOnSelectedBudget();
            this.approve();
            this.showMessage = true;
            this.addActionMessage("RE proposal for current year and BE proposal for next year saved successfully");
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
            this.budgetDetail = new BudgetDetail();
            this.budgetDetail.setExecutingDepartment(null);
        }
        catch (ValidationException e) {
            this.loadBudgets("RE");
            this.dropdownData.put("budgetList", this.budgetList);
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
            throw e;
        }
        return "new-re";
    }

    private void deleteExisting() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Initiating deletion ..........");
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
        StringBuffer addlCondtion = new StringBuffer(50);
        if (this.searchfunctionid != null && this.searchfunctionid != 0L) {
            addlCondtion.append("and function=" + this.searchfunctionid);
        }
        if (this.searchbudgetGroupid != null && this.searchbudgetGroupid != 0L) {
            addlCondtion.append("and budgetGroup.id=" + this.searchbudgetGroupid);
        }
        new ArrayList();
        int executeUpdate = this.persistenceService.getSession().createSQLQuery("delete from egf_budgetdetail where budget=" + this.budgetDetail.getBudget().getId() + addlCondtion).executeUpdate();
        int executeUpdate2 = this.persistenceService.getSession().createSQLQuery("delete from egf_budgetdetail where budget=" + referenceBudgetFor.getId() + addlCondtion).executeUpdate();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Deleting complete. deleted " + executeUpdate + " RE  and " + executeUpdate2 + " BE items "));
        }
        this.persistenceService.getSession().flush();
    }

    private void validateIsPrimary() {
        if (this.budgetDetail.getBudget() != null && !this.budgetDetail.getBudget().getIsPrimaryBudget()) {
            throw new ValidationException(Arrays.asList(new ValidationError("budget.not.primary", "budget.not.primary")));
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
        if (this.budgetDetail.getBudget() != null && referenceBudgetFor != null && !referenceBudgetFor.getIsPrimaryBudget()) {
            throw new ValidationException(Arrays.asList(new ValidationError("budget.not.primary", "budget.not.primary")));
        }
    }

    private boolean rowsEmpty() {
        if (this.budgetDetailList == null) {
            return true;
        }
        for (BudgetDetail row : this.budgetDetailList) {
            if (this.gridFields.contains("executingDepartment") && row.getExecutingDepartment().getId() != -1L && row.getExecutingDepartment().getId() != 0L) {
                return false;
            }
            if (this.gridFields.contains("function") && row.getFunction().getId() != -1L && row.getFunction().getId() != 0L) {
                return false;
            }
            if (this.gridFields.contains("fund") && row.getFund().getId() != -1 && row.getFund().getId() != 0) {
                return false;
            }
            if (this.gridFields.contains("scheme") && row.getScheme().getId() != -1 && row.getScheme().getId() != 0) {
                return false;
            }
            if (this.gridFields.contains("subScheme") && row.getSubScheme().getId() != -1 && row.getSubScheme().getId() != 0) {
                return false;
            }
            if (this.gridFields.contains("boundary") && row.getBoundary().getId() != -1L && row.getBoundary().getId() != 0L) {
                return false;
            }
            if (row.getBudgetGroup().getId() == -1L || row.getBudgetGroup().getId() == 0L) continue;
            return false;
        }
        return true;
    }

    private void validateAmounts(List<BudgetDetail> detailList) {
        for (int i = 0; i < detailList.size(); ++i) {
            if (this.beAmounts.get(i) == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.re.amount", "budgetDetail.re.amount")));
            }
            if (detailList.get(i).getOriginalAmount() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.be.amount", "budgetDetail.be.amount")));
        }
    }

    protected void validateMandatoryFields() {
        this.checkHeaderMandatoryField("executingDepartment", (Object)this.budgetDetail.getExecutingDepartment(), "budgetDetail.executingDepartment.mandatory");
        this.checkHeaderMandatoryField("function", (Object)this.budgetDetail.getFunction(), "budgetDetail.function.mandatory");
        this.checkHeaderMandatoryField("functionary", (Object)this.budgetDetail.getFunctionary(), "budgetDetail.functionary.mandatory");
        this.checkHeaderMandatoryField("scheme", (Object)this.budgetDetail.getScheme(), "budgetDetail.scheme.mandatory");
        this.checkHeaderMandatoryField("subScheme", (Object)this.budgetDetail.getSubScheme(), "budgetDetail.subScheme.mandatory");
        this.checkHeaderMandatoryField("fund", (Object)this.budgetDetail.getFund(), "budgetDetail.fund.mandatory");
        this.checkHeaderMandatoryField("boundary", (Object)this.budgetDetail.getBoundary(), "budgetDetail.boundary.mandatory");
        for (BudgetDetail detail : this.budgetDetailList) {
            this.setRelatedValues(detail);
            this.checkGridMandatoryField("executingDepartment", (Object)detail.getExecutingDepartment(), "budgetDetail.executingDepartment.mandatory");
            this.checkGridMandatoryField("function", (Object)detail.getFunction(), "budgetDetail.function.mandatory");
            this.checkGridMandatoryField("functionary", (Object)detail.getFunctionary(), "budgetDetail.functionary.mandatory");
            this.checkGridMandatoryField("scheme", (Object)detail.getScheme(), "budgetDetail.scheme.mandatory");
            this.checkGridMandatoryField("subScheme", (Object)detail.getSubScheme(), "budgetDetail.subScheme.mandatory");
            this.checkGridMandatoryField("fund", (Object)detail.getFund(), "budgetDetail.fund.mandatory");
            this.checkGridMandatoryField("boundary", (Object)detail.getBoundary(), "budgetDetail.boundary.mandatory");
        }
    }

    private void setRelatedValues(BudgetDetail detail) {
        if (detail.getExecutingDepartment() != null && detail.getExecutingDepartment().getId() == 0L) {
            detail.setExecutingDepartment(null);
        }
        if (detail.getFunction() != null && detail.getFunction().getId() == 0L) {
            detail.setFunction(null);
        }
        if (detail.getScheme() != null && detail.getScheme().getId() == 0) {
            detail.setScheme(null);
        }
        if (detail.getSubScheme() != null && detail.getSubScheme().getId() == 0) {
            detail.setSubScheme(null);
        }
        if (detail.getFunctionary() != null && detail.getFunctionary().getId() == 0) {
            detail.setFunctionary(null);
        }
        if (detail.getBoundary() != null && detail.getBoundary().getId() == 0L) {
            detail.setBoundary(null);
        }
        if (detail.getFund() != null && detail.getFund().getId() == 0) {
            detail.setFund(null);
        }
    }

    protected void checkHeaderMandatoryField(String fieldName, Object value, String errorKey) {
        if (this.headerFields.contains(fieldName) && this.mandatoryFields.contains(fieldName) && value == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(errorKey, errorKey)));
        }
    }

    protected void checkGridMandatoryField(String fieldName, Object value, String errorKey) {
        if (this.gridFields.contains(fieldName) && this.mandatoryFields.contains(fieldName) && value == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(errorKey, errorKey)));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    private void saveBudgetDetails(boolean withRe, CFinancialYear finYear, Budget budget) {
        int index = 0;
        Budget refBudget = null;
        if (withRe && (refBudget = this.budgetService.getReferenceBudgetFor(budget)) == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("no.reference.budget", "no.reference.budget")));
        }
        finYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{finYear.getId()});
        int i = 0;
        for (BudgetDetail detail : this.budgetDetailList) {
            if (detail != null) {
                if (detail.getId() == null) {
                    detail.setUniqueNo(detail.getFund().getId() + "-" + detail.getExecutingDepartment().getId() + "-" + detail.getFunction().getId() + "-" + detail.getBudgetGroup().getId());
                } else {
                    detail.setId(null);
                }
                if (withRe) {
                    this.saveAndStartWorkFlowForRe(detail, index, finYear, refBudget);
                } else {
                    this.saveAndStartWorkFlow(detail);
                }
            }
            ++index;
            if (++i % 5 == 0) {
                this.persistenceService.getSession().flush();
            }
            LOGGER.error((Object)("saved" + i + "Item"));
        }
        this.populateSavedbudgetDetailListForDetail((BudgetDetail)this.budgetDetailList.get(0));
        this.budgetDetailList.clear();
    }

    private void saveNewBudgetDetailItems(boolean withRe, CFinancialYear finYear, Budget budget) {
        int index = 0;
        Budget refBudget = null;
        if (withRe && (refBudget = this.budgetService.getReferenceBudgetFor(budget)) == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("no.reference.budget", "no.reference.budget")));
        }
        finYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{finYear.getId()});
        int i = 0;
        for (BudgetDetail detail : this.budgetDetailList) {
            if (detail != null) {
                detail.transition(true).withStateValue("END").withOwner(this.getPosition()).withComments("");
                if (detail.getId() == null) {
                    detail.setUniqueNo(detail.getFund().getId() + "-" + detail.getExecutingDepartment().getId() + "-" + detail.getFunction().getId() + "-" + detail.getBudgetGroup().getId());
                } else {
                    detail.setId(null);
                }
                if (withRe) {
                    this.saveAndStartWorkFlowForRe(detail, index, finYear, refBudget);
                } else {
                    this.saveAndStartWorkFlow(detail);
                }
            }
            ++index;
            if (++i % 5 == 0) {
                this.persistenceService.getSession().flush();
            }
            LOGGER.error((Object)("saved" + i + "Item"));
        }
        this.populateSavedbudgetDetailListForDetail((BudgetDetail)this.budgetDetailList.get(0));
        this.budgetDetailList.clear();
    }

    private void setAsOnDateOnSelectedBudget() {
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != null) {
            Budget selectedBudget = (Budget)this.getPersistenceService().find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()});
            selectedBudget.setAsOnDate(this.getAsOnDate());
            this.budgetService.persist((Object)selectedBudget);
        }
    }

    void loadBudgets(String bere) {
        this.budgetList = new ArrayList();
        if (!this.addNewDetails) {
            this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = 1 and state.type='Budget' and isbere='" + bere.toUpperCase() + "' and (state.value='NEW' or lower(state.value) like lower('Forwarded by SMADMIN%')) and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
        } else {
            this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = 1 and state.type='Budget' and isbere='" + bere.toUpperCase() + "'  and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
        }
    }

    public void prepare() {
        super.prepare();
        this.populateFinancialYear();
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.addRelatedEntity("budget", Budget.class);
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        if (this.shouldShowField("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.shouldShowField("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.shouldShowField("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.shouldShowField("subScheme")) {
            this.addRelatedEntity("subScheme", SubScheme.class);
        }
        if (this.shouldShowField("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.shouldShowField("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.shouldShowField("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        this.defaultToCurrentUsersExecutingDepartment();
        this.setupDropdownsInHeader();
        this.re = this.budgetService.hasReForYear(Long.valueOf(this.financialYearDAO.getCurrYearFiscalId()));
    }

    private void setupDropdownsInHeader() {
        this.setupDropdownDataExcluding(new String[]{"subScheme"});
        this.setBudgetDropDown();
        this.dropdownData.put("budgetGroupList", this.masterDataCache.get("egf-budgetGroup"));
        if (this.shouldShowField("subScheme")) {
            this.dropdownData.put("subSchemeList", Collections.EMPTY_LIST);
        }
        if (this.shouldShowField("functionary")) {
            this.dropdownData.put("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.shouldShowField("function")) {
            this.dropdownData.put("functionList", this.masterDataCache.get("egi-function"));
        }
        if (this.shouldShowField("scheme")) {
            this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("executingDepartment")) {
            this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.shouldShowField("fund")) {
            this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isNotLeaf=0 and isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("boundary")) {
            this.dropdownData.put("boundaryList", this.persistenceService.findAllBy("from Boundary order by name", new Object[0]));
        }
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.dropdownData.put("departmentList", this.masterDataCache.get("egi-department"));
        this.dropdownData.put("designationList", Collections.EMPTY_LIST);
        this.dropdownData.put("userList", Collections.EMPTY_LIST);
    }

    protected void populateFinancialYear() {
        Budget budget = this.budgetDetail.getBudget();
        if (budget != null) {
            this.populateYearRange(budget);
            return;
        }
        if (this.request.get("id") != null) {
            Long id = (Long)this.request.get("id");
            if (!Long.valueOf(0L).equals(id)) {
                Budget b = (Budget)this.budgetService.findById((Serializable)id, false);
                this.populateYearRange(b);
                return;
            }
        }
        CFinancialYear finYear = (CFinancialYear)this.finYearService.findById((Serializable)this.budgetDetailHelper.getFinancialYear(), false);
        this.currentYearRange = finYear.getFinYearRange();
        this.computePreviousYearRange();
        this.computeLastButOneYearRange();
        this.computeNextYearRange();
    }

    private void populateYearRange(Budget budget) {
        if (budget != null) {
            this.currentYearRange = budget.getFinancialYear() != null ? budget.getFinancialYear().getFinYearRange() : ((CFinancialYear)this.finYearService.findById((Serializable)this.budgetDetailHelper.getFinancialYear(), false)).getFinYearRange();
            this.computePreviousYearRange();
            this.computeLastButOneYearRange();
            this.computeNextYearRange();
        }
    }

    public String computeYearRange(String range) {
        if (StringUtils.isNotBlank((String)range)) {
            String[] list = range.split("-");
            return this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
        return "";
    }

    public String addYearRange(String range) {
        if (StringUtils.isNotBlank((String)range)) {
            String[] list = range.split("-");
            return this.add(list[0]) + "-" + this.add(list[1]);
        }
        return "";
    }

    private void computeLastButOneYearRange() {
        if (StringUtils.isNotBlank((String)this.previousYearRange)) {
            String[] list = this.previousYearRange.split("-");
            this.lastButOneYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computePreviousYearRange() {
        if (StringUtils.isNotBlank((String)this.currentYearRange)) {
            String[] list = this.currentYearRange.split("-");
            this.previousYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computeNextYearRange() {
        if (StringUtils.isNotBlank((String)this.currentYearRange)) {
            String[] list = this.currentYearRange.split("-");
            this.nextYearRange = this.add(list[0]) + "-" + this.add(list[1]);
        }
    }

    protected String subtract(String value) {
        int val = Integer.parseInt(value) - 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    protected String add(String value) {
        int val = Integer.parseInt(value) + 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    public String getCurrentYearRange() {
        return this.currentYearRange;
    }

    public String getPreviousYearRange() {
        return this.previousYearRange;
    }

    public String getLastButOneYearRange() {
        return this.lastButOneYearRange;
    }

    protected void setBudgetDropDown() {
        if (this.addNewDetails) {
            if (this.getFinancialYear() != null && this.getFinancialYear().getId() != null) {
                this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = 1 and state.type='Budget' and isbere='RE' and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
                this.dropdownData.put("budgetList", this.budgetList);
            } else {
                this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
            }
        } else {
            this.dropdownData.put("budgetList", this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = 1 and state.type='Budget' and (state.value='NEW' or lower(state.value) like lower('Forwarded by SMADMIN%')) order by name", new Object[0]));
        }
    }

    public List<BudgetDetail> getSavedbudgetDetailList() {
        return this.savedbudgetDetailList;
    }

    private void defaultToCurrentUsersExecutingDepartment() {
        if (this.shouldShowHeaderField("executingDepartment")) {
            User user = this.getUser();
        }
    }

    private Department findDepartment(Integer id) {
        return (Department)this.persistenceService.find("from Department where ID_DEPT=?", new Object[]{id});
    }

    public List<BudgetDetail> getBudgetDetailList() {
        return this.budgetDetailList;
    }

    public void setBudgetDetailList(List<BudgetDetail> budgetDetailList) {
        this.budgetDetailList = budgetDetailList;
    }

    public List<BudgetAmountView> getBudgetAmountView() {
        return this.budgetAmountView;
    }

    protected abstract void saveAndStartWorkFlow(BudgetDetail var1);

    protected abstract void saveAndStartWorkFlowForRe(BudgetDetail var1, int var2, CFinancialYear var3, Budget var4);

    protected abstract void approve();

    protected User getUser() {
        return (User)this.persistenceService.find("from User where id_user=?", new Object[]{ApplicationThreadLocals.getUserId()});
    }

    protected Position getPosition() {
        return this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
    }

    protected Position getPositionByUserId(Integer userId) {
        return this.eisCommonService.getPositionByUserId(Long.valueOf(userId.longValue()));
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setBudgetDetailWorkflowService(WorkflowService<BudgetDetail> budgetDetailWorkflowService) {
        this.budgetDetailWorkflowService = budgetDetailWorkflowService;
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetails) {
        this.budgetDetail = budgetDetails;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailsService) {
        this.budgetDetailService = budgetDetailsService;
    }

    public String loadActuals() {
        this.validateAsOnDate();
        this.getDetailsFilterdBy();
        this.re = this.budgetService.hasReForYear(this.budgetDetail.getBudget().getFinancialYear().getId());
        this.budgetDetailHelper.removeEmptyBudgetDetails(this.budgetDetailList);
        this.budgetAmountView.addAll(this.populateAmountData(this.budgetDetailList, this.getAsOnDate(), this.budgetDetail.getBudget().getFinancialYear()));
        this.loadBeAmounts(this.budgetDetailList);
        return "new";
    }

    protected void getDetailsFilterdBy() {
        StringBuffer mainQry = new StringBuffer(100);
        StringBuffer addlCondtion = new StringBuffer(50);
        if (this.searchfunctionid != null && this.searchfunctionid != 0L) {
            addlCondtion.append("and function.id=" + this.searchfunctionid);
        }
        if (this.searchbudgetGroupid != null && this.searchbudgetGroupid != 0L) {
            addlCondtion.append("and budgetGroup.id=" + this.searchbudgetGroupid);
        }
        mainQry.append("from BudgetDetail where budget.id=? " + addlCondtion + " order by function.name,budgetGroup.name ");
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != 0L) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy(mainQry.toString(), new Object[]{this.budgetDetail.getBudget().getId()});
        }
    }

    protected void loadBeAmounts(List<BudgetDetail> savedbudgetDetailList2) {
        this.beAmounts = new ArrayList(savedbudgetDetailList2.size());
        if (this.savedbudgetDetailList == null || this.savedbudgetDetailList.size() == 0) {
            return;
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, budgetDetail)) continue;
                    this.beAmounts.add(row.getOriginalAmount());
                }
            }
        }
    }

    protected boolean compareDetails(BudgetDetail nextYear, BudgetDetail current) {
        if (nextYear.getExecutingDepartment() != null && current.getExecutingDepartment() != null && current.getExecutingDepartment().getId() != nextYear.getExecutingDepartment().getId()) {
            return false;
        }
        if (nextYear.getFunction() != null && current.getFunction() != null && current.getFunction().getId() != nextYear.getFunction().getId()) {
            return false;
        }
        if (nextYear.getFund() != null && current.getFund() != null && current.getFund().getId() != nextYear.getFund().getId()) {
            return false;
        }
        if (nextYear.getFunctionary() != null && current.getFunctionary() != null && current.getFunctionary().getId() != nextYear.getFunctionary().getId()) {
            return false;
        }
        if (nextYear.getScheme() != null && current.getScheme() != null && current.getScheme().getId() != nextYear.getScheme().getId()) {
            return false;
        }
        if (nextYear.getSubScheme() != null && current.getSubScheme() != null && current.getSubScheme().getId() != nextYear.getSubScheme().getId()) {
            return false;
        }
        if (nextYear.getBoundary() != null && current.getBoundary() != null && current.getBoundary().getId() != nextYear.getBoundary().getId()) {
            return false;
        }
        if (nextYear.getBudgetGroup() != null && current.getBudgetGroup() != null && current.getBudgetGroup().getId() != nextYear.getBudgetGroup().getId()) {
            return false;
        }
        return nextYear.getBudget() == null || current.getBudget() == null || current.getBudget().getId() != nextYear.getBudget().getId();
    }

    protected boolean compareREandBEDetails(BudgetDetail nextYear, BudgetDetail current) {
        if (nextYear.getExecutingDepartment() != null && current.getExecutingDepartment() != null && current.getExecutingDepartment().getId().intValue() != nextYear.getExecutingDepartment().getId().intValue()) {
            return false;
        }
        if (nextYear.getFunction() != null && current.getFunction() != null && current.getFunction().getId().intValue() != nextYear.getFunction().getId().intValue()) {
            return false;
        }
        if (nextYear.getFund() != null && current.getFund() != null && current.getFund().getId().intValue() != nextYear.getFund().getId().intValue()) {
            return false;
        }
        if (nextYear.getFunctionary() != null && current.getFunctionary() != null && current.getFunctionary().getId().intValue() != nextYear.getFunctionary().getId().intValue()) {
            return false;
        }
        if (nextYear.getScheme() != null && current.getScheme() != null && current.getScheme().getId().intValue() != nextYear.getScheme().getId().intValue()) {
            return false;
        }
        if (nextYear.getSubScheme() != null && current.getSubScheme() != null && current.getSubScheme().getId().intValue() != nextYear.getSubScheme().getId().intValue()) {
            return false;
        }
        if (nextYear.getBoundary() != null && current.getBoundary() != null && current.getBoundary().getId().intValue() != nextYear.getBoundary().getId().intValue()) {
            return false;
        }
        return nextYear.getBudgetGroup() == null || current.getBudgetGroup() == null || current.getBudgetGroup().getId().intValue() == nextYear.getBudgetGroup().getId().intValue();
    }

    protected void populateBudgetList() {
        this.loadBudgets("RE");
        this.dropdownData.put("budgetList", this.budgetList);
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != null) {
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
        }
    }

    private void validateAsOnDate() {
        if (this.budgetDetail.getBudget() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.budget.mandatory", "budgetDetail.budget.mandatory")));
        }
        if (this.getAsOnDate().compareTo(this.budgetDetail.getBudget().getFinancialYear().getStartingDate()) < 0 || this.getAsOnDate().compareTo(this.budgetDetail.getBudget().getFinancialYear().getEndingDate()) > 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.invalid.asondate", "budgetDetail.invalid.asondate")));
        }
    }

    public Date getPreviousYearFor(Date date) {
        GregorianCalendar previousYearToDate = new GregorianCalendar();
        previousYearToDate.setTime(date);
        int prevYear = previousYearToDate.get(1) - 1;
        previousYearToDate.set(1, prevYear);
        return previousYearToDate.getTime();
    }

    public List<String> getGridFields() {
        return this.gridFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public boolean isHeaderDisabled() {
        return this.headerDisabled;
    }

    public final boolean shouldShowHeaderField(String field) {
        return this.headerFields.isEmpty() || this.headerFields.contains(field);
    }

    public final boolean shouldShowField(String field) {
        if (this.headerFields.isEmpty() && this.gridFields.isEmpty()) {
            return true;
        }
        return this.shouldShowHeaderField(field) || this.shouldShowGridField(field);
    }

    public final boolean shouldShowGridField(String field) {
        return this.gridFields.isEmpty() || this.gridFields.contains(field);
    }

    public String ajaxLoadSubSchemes() {
        this.subSchemes = this.getPersistenceService().findAllBy("from SubScheme where scheme.id=? and isActive=true order by name", new Object[]{this.schemeId});
        return "subSchemes";
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    public List<BudgetAmountView> populateAmountData(List<BudgetDetail> budgetDetails, Date asOnDate, CFinancialYear finYear) {
        ArrayList<BudgetAmountView> list = new ArrayList<BudgetAmountView>();
        Long finYearId = finYear.getId();
        for (BudgetDetail detail : budgetDetails) {
            Map paramMap = this.budgetDetailHelper.constructParamMap(this.getValueStack(), detail);
            BudgetAmountView view = new BudgetAmountView();
            this.budgetDetailHelper.populateData(view, paramMap, asOnDate, this.re);
            BudgetDetail detailWithoutBudget = new BudgetDetail();
            detailWithoutBudget.copyFrom(detail);
            detailWithoutBudget.setBudget(null);
            List budgetDetail = this.budgetDetailService.searchByCriteriaWithTypeAndFY(finYearId, "BE", detailWithoutBudget);
            if (budgetDetail != null && budgetDetail.size() > 0) {
                BigDecimal approvedAmount = ((BudgetDetail)budgetDetail.get(0)).getApprovedAmount();
                view.setCurrentYearBeApproved(approvedAmount == null ? BigDecimal.ZERO.toString() : approvedAmount.toString());
                view.setReappropriation(((BudgetDetail)budgetDetail.get(0)).getApprovedReAppropriationsTotal().toString());
            }
            view.setTotal(new BigDecimal(view.getCurrentYearBeApproved()).add(new BigDecimal(view.getReappropriation())).toString());
            list.add(view);
        }
        return list;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setBeAmounts(List<BigDecimal> beAmounts) {
        this.beAmounts = beAmounts;
    }

    public List<BigDecimal> getBeAmounts() {
        return this.beAmounts;
    }

    public void setNextYearRange(String nextYearRange) {
        this.nextYearRange = nextYearRange;
    }

    public String getNextYearRange() {
        return this.nextYearRange;
    }

    public void setReferenceBudget(Budget referenceBudget) {
        this.referenceBudget = referenceBudget;
    }

    public Budget getReferenceBudget() {
        return this.referenceBudget;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setBudgetList(List<Budget> budgetList) {
        this.budgetList = budgetList;
    }

    public List<Budget> getBudgetList() {
        return this.budgetList;
    }

    public void setBudgetWorkflowService(WorkflowService<Budget> budgetWorkflowService) {
        this.budgetWorkflowService = budgetWorkflowService;
    }

    public void removeEmptyBudgetDetails(List<BudgetDetail> budgetDetailList) {
        int i = 0;
        Iterator<BudgetDetail> detail = budgetDetailList.iterator();
        while (detail.hasNext()) {
            if (detail.next() == null) {
                detail.remove();
            }
            if (this.beAmounts.get(i) == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.re.amount", "budgetDetail.re.amount")));
            }
            if (budgetDetailList.get(i).getOriginalAmount() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.be.amount", "budgetDetail.be.amount")));
            }
            ++i;
        }
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Long getSearchfunctionid() {
        return this.searchfunctionid;
    }

    public void setSearchfunctionid(Long searchfunctionid) {
        this.searchfunctionid = searchfunctionid;
    }

    public Long getSearchbudgetGroupid() {
        return this.searchbudgetGroupid;
    }

    public void setSearchbudgetGroupid(Long searchbudgetGroupid) {
        this.searchbudgetGroupid = searchbudgetGroupid;
    }
}

