/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.bill;

import com.exilant.eGov.src.transactions.CommonMethodsImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.bills.EgSalaryCodes;
import org.egov.model.voucher.PreApprovedVoucher;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
public class SalaryBillRegisterAction
extends BaseFormAction {
    private static final long serialVersionUID = -1417150690192038536L;
    private EgBillregister billregister = new EgBillregister();
    private EgBillregistermis billregistermis = new EgBillregistermis();
    private PersistenceService<EgBillregister, Long> billRegisterService;
    private PersistenceService<EgBillregistermis, Long> billRegisterMisService;
    private PersistenceService<EgBilldetails, Long> billDetailsService;
    private PersistenceService<EgBillPayeedetails, Long> billPayeeDetailsService;
    private List<EgBilldetails> earningsList = new ArrayList();
    private List<EgBilldetails> deductionsList = new ArrayList();
    private List<EgBilldetails> netPayList = new ArrayList();
    private List<PreApprovedVoucher> subledgerList = new ArrayList();
    private final Map<BigDecimal, CChartOfAccounts> coaAndIds = new HashMap();
    private final Map<BigDecimal, String> coaIdAndHead = new HashMap();
    private List<CChartOfAccounts> glcodesList = new ArrayList();
    private CommonMethodsImpl commonMethodsImpl;
    private ScriptService scriptExecutionService;
    private boolean close = false;
    private String message = "";
    private Long billregisterId;
    private List<EgSalaryCodes> earningsCodes = new ArrayList();
    private List<EgSalaryCodes> deductionsCodes = new ArrayList();
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private CChartOfAccounts defaultNetPayCode;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public SalaryBillRegisterAction() {
        this.addRelatedEntity("fieldList", Boundary.class);
        this.addRelatedEntity("functionaryList", Functionary.class);
        this.addRelatedEntity("departmentList", Department.class);
        this.addRelatedEntity("financialYearList", CFinancialYear.class);
    }

    public Object getModel() {
        return this.getBillregister();
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
        this.addDropdownData("financialYearList", this.persistenceService.findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.addDropdownData("detailTypeList", Collections.EMPTY_LIST);
        this.populateSalaryCode();
        this.populateEarningCodes();
        this.populateDeductionCodes();
        this.addDropdownData("glcodeList", this.getGlcodesList());
    }

    private void populateEarningCodes() {
        this.earningsList = new ArrayList();
        this.earningsCodes = this.persistenceService.findAllBy("from EgSalaryCodes where salType='Earnings' order by chartOfAccount.glcode", new Object[0]);
        for (EgSalaryCodes row : this.earningsCodes) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(BigDecimal.valueOf(row.getChartOfAccount().getId()));
            billdetails.setDebitamount(BigDecimal.ZERO);
            this.earningsList.add(billdetails);
            this.coaAndIds.put(BigDecimal.valueOf(row.getChartOfAccount().getId()), row.getChartOfAccount());
            this.coaIdAndHead.put(BigDecimal.valueOf(row.getChartOfAccount().getId()), row.getHead());
            this.glcodesList.add(row.getChartOfAccount());
        }
    }

    private void populateDeductionCodes() {
        this.deductionsList = new ArrayList();
        this.deductionsCodes = this.persistenceService.findAllBy("from EgSalaryCodes where salType='Deduction' order by chartOfAccount.glcode", new Object[0]);
        for (EgSalaryCodes row : this.deductionsCodes) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setCreditamount(BigDecimal.ZERO);
            billdetails.setGlcodeid(BigDecimal.valueOf(row.getChartOfAccount().getId()));
            this.deductionsList.add(billdetails);
            this.coaAndIds.put(BigDecimal.valueOf(row.getChartOfAccount().getId()), row.getChartOfAccount());
            this.coaIdAndHead.put(BigDecimal.valueOf(row.getChartOfAccount().getId()), row.getHead());
            this.glcodesList.add(row.getChartOfAccount());
        }
    }

    private void populateSalaryCode() {
        this.netPayList = new ArrayList();
        this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "salaryBillPurposeIds");
        List defaultConfigValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "salaryBillDefaultPurposeId");
        String cBillDefaulPurposeId = ((AppConfigValues)defaultConfigValuesByModuleAndKey.get(0)).getValue();
        List salaryPayableCoa = this.persistenceService.findAllBy("FROM CChartOfAccounts WHERE purposeid in (" + cBillDefaulPurposeId + ") and isactiveforposting = true and classification=4", new Object[0]);
        for (CChartOfAccounts chartOfAccounts : salaryPayableCoa) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(BigDecimal.valueOf(chartOfAccounts.getId()));
            this.netPayList.add(billdetails);
            this.coaAndIds.put(BigDecimal.valueOf(chartOfAccounts.getId()), chartOfAccounts);
            if (!cBillDefaulPurposeId.equals(chartOfAccounts.getPurposeId())) continue;
            this.defaultNetPayCode = chartOfAccounts;
        }
    }

    public String execute() throws Exception {
        return "new";
    }

    private void save() {
        this.saveBillRegister();
        this.billregistermis.setEgBillregister(this.getBillregister());
        this.setValuesOnBillRegisterMis();
        this.billregistermis = (EgBillregistermis)this.billRegisterMisService.persist((Object)this.billregistermis);
        this.saveBilldetails();
        this.saveBillPayeeDetails();
        this.populateSalaryCode();
        this.populateEarningCodes();
        this.populateDeductionCodes();
    }

    private void saveBillRegister() {
        this.billregister.setBillnumber(this.generateBillNumber());
        this.billregister.setExpendituretype("Salary");
        this.billregister.setBillstatus("Created");
        this.billregister.setBillamount(((EgBilldetails)this.netPayList.get(0)).getCreditamount());
        this.billregister.setStatus((EgwStatus)this.persistenceService.find("from EgwStatus where moduletype='SALBILL' and description='Created'"));
        this.billregister.setEgBillregistermis(null);
        this.setBillregister((EgBillregister)this.billRegisterService.persist((Object)this.billregister));
    }

    private void saveBilldetails() {
        for (EgBilldetails row : this.earningsList) {
            row.setEgBillregister(this.getBillregister());
            if (row.getFunctionid() != null && BigDecimal.ZERO.compareTo(row.getFunctionid()) == 0) {
                row.setFunctionid(null);
            }
            this.billDetailsService.persist((Object)row);
        }
        for (EgBilldetails row : this.deductionsList) {
            row.setEgBillregister(this.getBillregister());
            if (row.getFunctionid() != null && BigDecimal.ZERO.compareTo(row.getFunctionid()) == 0) {
                row.setFunctionid(null);
            }
            this.billDetailsService.persist((Object)row);
        }
    }

    private void saveBillPayeeDetails() {
        for (PreApprovedVoucher row : this.subledgerList) {
            EgBillPayeedetails billPayeedetails = new EgBillPayeedetails();
            billPayeedetails.setAccountDetailKeyId(row.getDetailKeyId());
            billPayeedetails.setAccountDetailTypeId(row.getDetailType().getId());
            billPayeedetails.setCreditAmount(row.getCreditAmount());
            billPayeedetails.setDebitAmount(row.getDebitAmount());
            billPayeedetails.setEgBilldetailsId(this.getEgBillDetailsForGlCode((CChartOfAccounts)this.coaAndIds.get(new BigDecimal(row.getGlcode().getId()))));
            this.billPayeeDetailsService.persist((Object)billPayeedetails);
        }
    }

    private EgBilldetails getEgBillDetailsForGlCode(CChartOfAccounts chartOfAccounts) {
        for (EgBilldetails row : this.earningsList) {
            if (chartOfAccounts == null || chartOfAccounts.getId() == null || !chartOfAccounts.getId().equals(row.getGlcodeid().longValue())) continue;
            return row;
        }
        for (EgBilldetails row : this.deductionsList) {
            if (chartOfAccounts == null || chartOfAccounts.getId() == null || !chartOfAccounts.getId().equals(row.getGlcodeid().longValue())) continue;
            return row;
        }
        return null;
    }

    private void setValuesOnBillRegisterMis() {
        if (this.billregistermis.getEgDepartment() != null && this.billregistermis.getEgDepartment().getId() != null) {
            this.billregistermis.setEgDepartment((Department)this.persistenceService.find("from Department where id=?", new Object[]{this.billregistermis.getEgDepartment().getId()}));
        }
        if (this.billregistermis.getFinancialyear() != null && this.billregistermis.getFinancialyear().getId() != null) {
            this.billregistermis.setFinancialyear((CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{this.billregistermis.getFinancialyear().getId()}));
        }
        if (this.billregistermis.getFieldid() != null && this.billregistermis.getFieldid().getId() != null) {
            this.billregistermis.setFieldid((Boundary)this.persistenceService.find("from Boundary where id=?", new Object[]{this.billregistermis.getFieldid().getId()}));
        }
        if (this.billregistermis.getFunctionaryid() != null && this.billregistermis.getFunctionaryid().getId() != null) {
            this.billregistermis.setFunctionaryid((Functionary)this.persistenceService.find("from Functionary where id=?", new Object[]{this.billregistermis.getFunctionaryid().getId()}));
        }
        this.billregistermis.setLastupdatedtime(new Date());
    }

    public String saveAndNew() {
        this.save();
        this.message = this.getText("salary.bill.saved.successfully") + " " + this.getBillregister().getBillnumber();
        this.addActionMessage(this.message);
        this.setBillregister(new EgBillregister());
        this.billregistermis = new EgBillregistermis();
        return "new";
    }

    public String saveAndClose() {
        this.save();
        this.message = this.getText("salary.bill.saved.successfully") + " " + this.getBillregister().getBillnumber();
        this.addActionMessage(this.message);
        this.setClose(true);
        return "new";
    }

    public String view() {
        this.setBillregister((EgBillregister)this.persistenceService.find("from EgBillregister where id=?", new Object[]{this.billregisterId}));
        this.billregistermis = this.getBillregister().getEgBillregistermis();
        this.earningsList = this.persistenceService.findAllBy("from EgBilldetails where egBillregister.id=? and glcodeid in (" + this.getGlCodeIds(this.earningsCodes) + ")", new Object[]{this.billregisterId});
        this.deductionsList = this.persistenceService.findAllBy("from EgBilldetails where egBillregister.id=? and glcodeid in (" + this.getGlCodeIds(this.deductionsCodes) + ")", new Object[]{this.billregisterId});
        this.subledgerList = this.persistenceService.findAllBy("from EgBillPayeedetails where egBilldetailsId.id in (" + this.getBillDetailsId(this.earningsList, this.deductionsList) + ")", new Object[0]);
        return "view";
    }

    private String getBillDetailsId(List<EgBilldetails> earningsList, List<EgBilldetails> deductionsList) {
        String billDetailIds = "0,";
        for (EgBilldetails egBilldetails : earningsList) {
            billDetailIds = billDetailIds.concat(egBilldetails.getId().toString()).concat(",");
        }
        for (EgBilldetails egBilldetails : deductionsList) {
            billDetailIds = billDetailIds.concat(egBilldetails.getId().toString()).concat(",");
        }
        billDetailIds = billDetailIds.substring(0, billDetailIds.length() - 2);
        return billDetailIds;
    }

    private String getGlCodeIds(List<EgSalaryCodes> earningsCodes) {
        String glcodeIds = "0";
        for (EgSalaryCodes egSalaryCodes : earningsCodes) {
            glcodeIds = glcodeIds.concat(",").concat(egSalaryCodes.getChartOfAccount().getId().toString());
        }
        if (glcodeIds.length() > 1) {
            glcodeIds = glcodeIds.substring(0, glcodeIds.length() - 2);
        }
        return glcodeIds;
    }

    public void setBillRegisterService(PersistenceService<EgBillregister, Long> billRegisterService) {
        this.billRegisterService = billRegisterService;
    }

    public void setEarningsList(List<EgBilldetails> earningsList) {
        this.earningsList = earningsList;
    }

    public List<EgBilldetails> getEarningsList() {
        return this.earningsList;
    }

    public void setDeductionsList(List<EgBilldetails> deductionsList) {
        this.deductionsList = deductionsList;
    }

    public List<EgBilldetails> getDeductionsList() {
        return this.deductionsList;
    }

    public void setSubledgerList(List<PreApprovedVoucher> earningsSubledgerList) {
        this.subledgerList = earningsSubledgerList;
    }

    public List<PreApprovedVoucher> getSubledgerList() {
        return this.subledgerList;
    }

    public Map<BigDecimal, CChartOfAccounts> getCoaAndIds() {
        return this.coaAndIds;
    }

    public void setNetPayList(List<EgBilldetails> netPayList) {
        this.netPayList = netPayList;
    }

    public List<EgBilldetails> getNetPayList() {
        return this.netPayList;
    }

    public Map<BigDecimal, String> getCoaIdAndHead() {
        return this.coaIdAndHead;
    }

    public void setBillRegisterMisService(PersistenceService<EgBillregistermis, Long> billRegisterMisService) {
        this.billRegisterMisService = billRegisterMisService;
    }

    public void setBillDetailsService(PersistenceService<EgBilldetails, Long> billDetailsService) {
        this.billDetailsService = billDetailsService;
    }

    public EgBillregistermis getBillregistermis() {
        return this.billregistermis;
    }

    protected String generateBillNumber() {
        Script billNumberScript = (Script)this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{"salary.billnumber"}).get(0);
        Object connection = null;
        return (String)this.scriptExecutionService.executeScript(billNumberScript, ScriptService.createContext((Object[])new Object[]{"commonMethodsImpl", this.commonMethodsImpl, "connection", connection, "wfItem", this.getBillregister()}));
    }

    public void setCommonMethodsImpl(CommonMethodsImpl commonMethodsImpl) {
        this.commonMethodsImpl = commonMethodsImpl;
    }

    public void setScriptExecutionService(ScriptService scriptExecutionService) {
        this.scriptExecutionService = scriptExecutionService;
    }

    public void setGlcodesList(List<CChartOfAccounts> glcodesList) {
        this.glcodesList = glcodesList;
    }

    public List<CChartOfAccounts> getGlcodesList() {
        return this.glcodesList;
    }

    public void setBillPayeeDetailsService(PersistenceService<EgBillPayeedetails, Long> billPayeeDetailsService) {
        this.billPayeeDetailsService = billPayeeDetailsService;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setBillregisterId(Long billregisterId) {
        this.billregisterId = billregisterId;
    }

    public Long getBillregisterId() {
        return this.billregisterId;
    }

    public void setBillregister(EgBillregister billregister) {
        this.billregister = billregister;
    }

    public EgBillregister getBillregister() {
        return this.billregister;
    }

    public void setDefaultNetPayCode(CChartOfAccounts defaultNetPayCode) {
        this.defaultNetPayCode = defaultNetPayCode;
    }

    public CChartOfAccounts getDefaultNetPayCode() {
        return this.defaultNetPayCode;
    }
}

