/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.voucher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

@Controller
public abstract class BaseVoucherController
extends GenericWorkFlowController {
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    @Autowired
    public BaseVoucherController(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
        this.getHeaderMandateFields();
    }

    protected void getHeaderMandateFields() {
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf("|"));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf("|") + 1);
            if (!"M".equals(mandate)) continue;
            this.mandatoryFields.add(header);
        }
        this.mandatoryFields.add("voucherdate");
    }

    protected void setDropDownValues(Model model) {
        if (this.headerFields.contains("department")) {
            model.addAttribute("departments", (Object)this.masterDataCache.get("egi-department"));
        }
        if (this.headerFields.contains("functionary")) {
            model.addAttribute("functionarys", (Object)this.masterDataCache.get("egi-functionary"));
        }
        if (this.headerFields.contains("function")) {
            model.addAttribute("functions", (Object)this.masterDataCache.get("egi-function"));
        }
        if (this.headerFields.contains("fund")) {
            model.addAttribute("funds", (Object)this.masterDataCache.get("egi-fund"));
        }
        if (this.headerFields.contains("fundsource")) {
            model.addAttribute("fundsources", (Object)this.masterDataCache.get("egi-fundSource"));
        }
        if (this.headerFields.contains("field")) {
            model.addAttribute("fields", (Object)this.masterDataCache.get("egi-ward"));
        }
        if (this.headerFields.contains("scheme")) {
            model.addAttribute("schemes", (Object)Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            model.addAttribute("subschemes", (Object)Collections.EMPTY_LIST);
        }
        model.addAttribute("headerFields", (Object)this.headerFields);
        model.addAttribute("mandatoryFields", (Object)this.mandatoryFields);
    }
}

