/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.web.controller.expensebill.BaseBillController;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.model.bills.EgBillregister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/expensebill"})
public class CreateExpenseBillController
extends BaseBillController {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ExpenseBillService expenseBillService;

    public CreateExpenseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
    }

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model) {
        this.setDropDownValues(model);
        egBillregister.setBilldate(new Date());
        return "expenseBill-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model, BindingResult resultBinder) throws IOException {
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            return "expenseBill-form";
        }
        this.expenseBillService.create(egBillregister);
        return "redirect:/expensebill/success?billNumber=" + egBillregister.getBillnumber();
    }

    @RequestMapping(value={"/success"}, method={RequestMethod.GET})
    public String showContractorBillSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.expense.bill.create.success", (Object[])new String[]{billNumber}, null));
        return "expenseBill-success";
    }
}

