/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.repository.CFinancialYearRepository;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.web.adaptor.CFinancialYearJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/cfinancialyear"})
public class CFinancialYearController {
    private static final String CFINANCIALYEAR_NEW = "cfinancialyear-new";
    private static final String CFINANCIALYEAR_RESULT = "cfinancialyear-result";
    private static final String CFINANCIALYEAR_EDIT = "cfinancialyear-edit";
    private static final String CFINANCIALYEAR_VIEW = "cfinancialyear-view";
    private static final String CFINANCIALYEAR_SEARCH = "cfinancialyear-search";
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private CFinancialYearRepository cFinancialYearRepository;
    @Autowired
    private MessageSource messageSource;
    private final SimpleDateFormat dtFormat = new SimpleDateFormat("dd/MM/yyyy");

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        CFinancialYear financialYear = new CFinancialYear();
        if (financialYear.getcFiscalPeriod().isEmpty()) {
            financialYear.addCFiscalPeriod(new CFiscalPeriod());
        }
        Date nextStartingDate = this.cFinancialYearService.getNextFinancialYearStartingDate();
        model.addAttribute("startingDate", (Object)this.dtFormat.format(nextStartingDate));
        model.addAttribute("CFinancialYear", (Object)financialYear);
        model.addAttribute("mode", (Object)"create");
        return CFINANCIALYEAR_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CFinancialYear cFinancialYear, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        Boolean flag = false;
        Boolean isActive = true;
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            model.addAttribute("mode", (Object)"create");
            return CFINANCIALYEAR_NEW;
        }
        CFiscalPeriod fiscalPeriod = new CFiscalPeriod();
        List fiscalList = cFinancialYear.getcFiscalPeriod();
        for (CFiscalPeriod fiscal : fiscalList) {
            fiscalPeriod = this.cFinancialYearService.findByFiscalName(fiscal.getName());
            if (fiscalPeriod == null) continue;
            this.prepareNewForm(model);
            redirectAttrs.addFlashAttribute("financialYear", (Object)cFinancialYear);
            model.addAttribute("message", (Object)("Entered Fiscal Period Name " + fiscalPeriod.getName() + " already Exists"));
            model.addAttribute("mode", (Object)"create");
            return CFINANCIALYEAR_NEW;
        }
        cFinancialYear.setIsActive(isActive);
        cFinancialYear.setIsClosed(flag);
        cFinancialYear.setTransferClosingBalance(flag);
        cFinancialYear = this.buildFiscalPeriodDetails(cFinancialYear, cFinancialYear.getcFiscalPeriod());
        this.cFinancialYearService.create(cFinancialYear);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.cFinancialYear.success", null, Locale.ENGLISH));
        return "redirect:/cfinancialyear/result/" + cFinancialYear.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CFinancialYear cFinancialYear = this.cFinancialYearService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("CFinancialYear", (Object)cFinancialYear);
        model.addAttribute("mode", (Object)"edit");
        return CFINANCIALYEAR_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute CFinancialYear cFinancialYear, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return CFINANCIALYEAR_EDIT;
        }
        this.cFinancialYearService.update(cFinancialYear);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.cFinancialYear.success", null, Locale.ENGLISH));
        return "redirect:/cfinancialyear/result/" + cFinancialYear.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CFinancialYear cFinancialYear = this.cFinancialYearService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("CFinancialYear", (Object)cFinancialYear);
        return CFINANCIALYEAR_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CFinancialYear cFinancialYear = this.cFinancialYearService.findOne(id);
        model.addAttribute("CFinancialYear", (Object)cFinancialYear);
        return CFINANCIALYEAR_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CFinancialYear cFinancialYear = new CFinancialYear();
        model.addAttribute("financialYears", (Object)this.cFinancialYearRepository.findAll());
        this.prepareNewForm(model);
        model.addAttribute("CFinancialYear", (Object)cFinancialYear);
        return CFINANCIALYEAR_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CFinancialYear cFinancialYear) {
        List searchResultList = this.cFinancialYearService.search(cFinancialYear);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CFinancialYear.class, (Object)new CFinancialYearJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private CFinancialYear buildFiscalPeriodDetails(CFinancialYear cFinancialYear, List<CFiscalPeriod> fiscalPeriodDetail) {
        Boolean flag = false;
        HashSet<CFiscalPeriod> fiscalPeriodSet = new HashSet<CFiscalPeriod>();
        for (CFiscalPeriod fpDetail : fiscalPeriodDetail) {
            fpDetail.setIsActive(flag);
            fpDetail.setIsActiveForPosting(flag);
            fpDetail.setIsClosed(flag);
            fpDetail.setcFinancialYear(cFinancialYear);
            fiscalPeriodSet.add(fpDetail);
        }
        cFinancialYear.getcFiscalPeriod().clear();
        cFinancialYear.getcFiscalPeriod().addAll(fiscalPeriodSet);
        return cFinancialYear;
    }
}

