/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.web.adaptor.BudgetApprovalAdaptor;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetApproval;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.service.BudgetApprovalService;
import org.egov.model.service.BudgetDefinitionService;
import org.egov.services.budget.BudgetDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/budgetapproval"})
public class BudgetApprovalController {
    private static final String BUDGETAPPROVAL_SEARCH = "budgetapproval-search";
    private static final String BUDGETAPPROVAL_RESULT = "budgetapproval-result";
    @Autowired
    private BudgetApprovalService budgetApprovalService;
    @Autowired
    private BudgetDefinitionService budgetDefinitionService;
    @Autowired
    private BudgetApprovalAdaptor budgetApprovalAdaptor;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernate;
    @Autowired
    private BudgetDetailService budgetDetailService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
        model.addAttribute("financialYearList", (Object)this.budgetApprovalService.financialYearList());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        BudgetDetail budgetDetail = new BudgetDetail();
        this.prepareNewForm(model);
        model.addAttribute("budgetDetail", (Object)budgetDetail);
        return BUDGETAPPROVAL_SEARCH;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String search(Model model, @ModelAttribute BudgetDetail budgetDetail) {
        List searchResultList = this.budgetApprovalService.search(budgetDetail.getBudget().getFinancialYear().getId());
        this.prepareNewForm(model);
        ArrayList<BudgetApproval> budgetApprovalList = new ArrayList<BudgetApproval>();
        for (BudgetDetail ba : searchResultList) {
            BudgetApproval budgetApproval = new BudgetApproval();
            budgetApproval.setId(ba.getId());
            budgetApproval.setDepartment(ba.getExecutingDepartment().getName());
            budgetApproval.setParent(ba.getBudget().getParent().getName());
            budgetApproval.setReferenceBudget(ba.getBudget().getReferenceBudget().getName());
            budgetApproval.setBeAmount(ba.getOriginalAmount());
            budgetApproval.setReAmount(ba.getApprovedAmount());
            budgetApprovalList.add(budgetApproval);
        }
        String result = "{ \"data\":" + this.toSearchResultJson(budgetApprovalList) + "}";
        return result;
    }

    @RequestMapping(value={"/approve"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String approve(@ModelAttribute BudgetDetail budgetDetail, BindingResult errors, Model model, RedirectAttributes redirectAttrs, @RequestParam(value="checkedArray") List<String> checkedArray, @RequestParam(value="comments") String comments) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String checkListId : checkedArray) {
            if (checkListId.isEmpty()) continue;
            idList.add(Long.parseLong(checkListId));
        }
        List budgetDetailList = this.budgetDetailService.getBudgets(idList);
        Budget budget = new Budget();
        for (BudgetDetail budgetDetails : budgetDetailList) {
            budgetDetails.setStatus(this.egwStatusHibernate.getStatusByModuleAndCode("BUDGETDETAIL", "Approved"));
            budget = this.budgetDefinitionService.findOne(budgetDetails.getBudget().getId());
            budget.getParent().setStatus(this.egwStatusHibernate.getStatusByModuleAndCode("BUDGET", "Approved"));
            budget.getReferenceBudget().setStatus(this.egwStatusHibernate.getStatusByModuleAndCode("BUDGET", "Approved"));
            this.budgetDefinitionService.update(budget);
            this.budgetDetailService.update((Object)budgetDetails);
        }
        String message = this.messageSource.getMessage("msg.budgetdetail.approve", (Object[])new String[]{budget.getReferenceBudget().getName(), budget.getParent().getName()}, Locale.ENGLISH);
        return message;
    }

    @RequestMapping(value={"/success"})
    public String success(@ModelAttribute Budget budget, BindingResult errors, Model model, @RequestParam(value="message") String message) {
        model.addAttribute("message", (Object)message);
        return BUDGETAPPROVAL_RESULT;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(BudgetApproval.class, (Object)this.budgetApprovalAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

