/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.egf.web.adaptor.AccountdetailtypeJsonAdaptor;
import org.egov.infra.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/accountdetailtype"})
public class AccountdetailtypeController {
    private static final String ACCOUNTDETAILTYPE_NEW = "accountdetailtype-new";
    private static final String ACCOUNTDETAILTYPE_RESULT = "accountdetailtype-result";
    private static final String ACCOUNTDETAILTYPE_EDIT = "accountdetailtype-edit";
    private static final String ACCOUNTDETAILTYPE_VIEW = "accountdetailtype-view";
    private static final String ACCOUNTDETAILTYPE_SEARCH = "accountdetailtype-search";
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("accountdetailtype", (Object)new Accountdetailtype());
        return ACCOUNTDETAILTYPE_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Accountdetailtype accountdetailtype, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ACCOUNTDETAILTYPE_NEW;
        }
        accountdetailtype.setTablename("accountEntityMaster");
        accountdetailtype.setAttributename(accountdetailtype.getName() + "_id");
        accountdetailtype.setNbroflevels(BigDecimal.ONE);
        accountdetailtype.setColumnname("id");
        accountdetailtype.setFullQualifiedName("org.egov.masters.model.AccountEntity");
        accountdetailtype.setCreated(new Date());
        accountdetailtype.setLastmodified(new Date());
        accountdetailtype.setModifiedby(this.securityUtils.getCurrentUser().getId());
        this.accountdetailtypeService.create(accountdetailtype);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.accountdetailtype.success", null, null));
        return "redirect:/accountdetailtype/result/" + accountdetailtype.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("accountdetailtype", (Object)accountdetailtype);
        return ACCOUNTDETAILTYPE_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute Accountdetailtype accountdetailtype, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ACCOUNTDETAILTYPE_EDIT;
        }
        accountdetailtype.setTablename("accountEntityMaster");
        accountdetailtype.setAttributename(accountdetailtype.getName() + "_id");
        accountdetailtype.setNbroflevels(BigDecimal.ONE);
        accountdetailtype.setColumnname("id");
        accountdetailtype.setFullQualifiedName("org.egov.masters.model.AccountEntity");
        accountdetailtype.setLastmodified(new Date());
        accountdetailtype.setModifiedby(this.securityUtils.getCurrentUser().getId());
        this.accountdetailtypeService.update(accountdetailtype);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.accountdetailtype.success", null, Locale.ENGLISH));
        return "redirect:/accountdetailtype/result/" + accountdetailtype.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("accountdetailtype", (Object)accountdetailtype);
        return ACCOUNTDETAILTYPE_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Integer id, Model model) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeService.findOne(id);
        model.addAttribute("accountdetailtype", (Object)accountdetailtype);
        return ACCOUNTDETAILTYPE_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Accountdetailtype accountdetailtype = new Accountdetailtype();
        this.prepareNewForm(model);
        model.addAttribute("accountdetailtype", (Object)accountdetailtype);
        return ACCOUNTDETAILTYPE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Accountdetailtype accountdetailtype) {
        List searchResultList = this.accountdetailtypeService.search(accountdetailtype, mode);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Accountdetailtype.class, (Object)new AccountdetailtypeJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

