/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Fund;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.report.FundFlowBean;
import org.egov.services.report.FundFlowService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="fundFlow-new.jsp"), @Result(name={"report"}, location="fundFlow-report.jsp"), @Result(name={"edit"}, location="fundFlow-edit.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=FundFlowReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=FundFlowReport.xls"})})
public class FundFlowAction
extends BaseFormAction {
    private static Logger LOGGER = Logger.getLogger(FundFlowAction.class);
    private static final long serialVersionUID = 1L;
    private List<FundFlowBean> receiptList;
    private List<FundFlowBean> concurrancePaymentList;
    private List<FundFlowBean> outStandingPaymentList;
    private List<FundFlowBean> paymentList;
    private Long fund;
    private Date asOnDate;
    private List<FundFlowBean> total;
    private List<FundFlowBean> totalrepList = new ArrayList();
    private List<FundFlowBean> totalpayList = new ArrayList();
    private final String jasperpath = "FundFlowReport";
    private InputStream inputStream;
    private ReportService reportService;
    SimpleDateFormat sqlformat = new SimpleDateFormat("dd-MMM-yyyy");
    Date openignBalanceCalculatedDate;
    private FundFlowService fundFlowService;
    private String mode;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
    }

    @Action(value="/report/fundFlow-beforeSearch")
    public String beforeSearch() {
        this.loadDefalutDates();
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/fundFlow-search")
    public String search() {
        SQLQuery alreadyExistsQry;
        List existsList;
        StringBuffer alreadyExistsQryStr = new StringBuffer(100);
        alreadyExistsQryStr.append("select openingBalance From egf_fundflow ff,bankaccount ba where ba.id=ff.bankaccountid and to_date(reportdate)='" + this.sqlformat.format(this.asOnDate) + "' ");
        if (this.fund != null && this.fund != -1L) {
            alreadyExistsQryStr.append(" and ba.fundId=" + this.fund + " ");
        }
        if ((existsList = (alreadyExistsQry = this.persistenceService.getSession().createSQLQuery(alreadyExistsQryStr.toString())).list()).size() > 0) {
            this.paymentList = null;
            this.receiptList = null;
            throw new ValidationException(Arrays.asList(new ValidationError("fundflow.report.already.generated", "Fund Flow report is already Generated for the Date and Fund. Open in modify Mode")));
        }
        new ArrayList();
        this.receiptList = this.fundFlowService.getAllReceiptAccounts(this.fund);
        List btbPaymentList = this.fundFlowService.getContraPaymentsForTheDay(this.asOnDate, this.fund);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("all Bank accounts ------" + this.receiptList.size()));
        }
        for (Object fall : this.receiptList) {
            for (Object ftemp : btbPaymentList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbPayment(ftemp.getBtbPayment());
            }
        }
        List btbReceiptList = this.fundFlowService.getContraReceiptsForTheDay(this.asOnDate, this.fund);
        for (FundFlowBean fall : this.receiptList) {
            for (FundFlowBean ftemp : btbReceiptList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbReceipt(ftemp.getBtbReceipt());
            }
        }
        this.paymentList = this.fundFlowService.getAllpaymentAccounts(this.fund);
        for (FundFlowBean fall : this.paymentList) {
            for (FundFlowBean ftemp : btbReceiptList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbReceipt(ftemp.getBtbReceipt());
            }
        }
        List btbRceipt_PaymentList = this.fundFlowService.getContraPaymentsForTheDayFromPaymentBanks(this.asOnDate, this.fund);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("all Bank accounts ------" + btbRceipt_PaymentList.size()));
        }
        for (FundFlowBean fall : this.paymentList) {
            for (FundFlowBean ftemp : btbRceipt_PaymentList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbPayment(ftemp.getBtbPayment());
            }
        }
        this.getPreviousDayClosingBalance();
        this.concurrancePaymentList = this.fundFlowService.getConcurrancePayments(this.asOnDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setConcurranceBPV(fop.getConcurranceBPV());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setConcurranceBPV(fop.getConcurranceBPV());
            }
        }
        this.outStandingPaymentList = this.fundFlowService.getOutStandingPayments(this.asOnDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
        this.setFundsAvailableTotalPay();
        this.setFundsAvailableTotalRep();
        return "new";
    }

    public List<FundFlowBean> setFundsAvailableTotalRep() {
        if (this.fund == null) {
            BigDecimal openingBal = new BigDecimal("0");
            BigDecimal btbpay = new BigDecimal("0");
            BigDecimal btbrep = new BigDecimal("0");
            BigDecimal curReceipt = new BigDecimal("0");
            String fundNam = ((FundFlowBean)this.receiptList.get(0)).getFundName();
            int lastIndr = 0;
            int sizer = this.receiptList.size() - 1;
            for (FundFlowBean fBean : this.receiptList) {
                if (fBean.getFundName().equalsIgnoreCase(fundNam)) {
                    this.totalrepList.add(fBean);
                    btbpay = btbpay.add(fBean.getBtbPayment());
                    btbrep = btbrep.add(fBean.getBtbReceipt());
                    openingBal = openingBal.add(fBean.getOpeningBalance());
                    curReceipt = curReceipt.add(fBean.getCurrentReceipt());
                } else {
                    this.totalrepList.add(new FundFlowBean(fundNam, "Total", openingBal, curReceipt, btbpay, btbrep));
                    this.totalrepList.add(fBean);
                    btbpay = BigDecimal.ZERO;
                    btbrep = BigDecimal.ZERO;
                    openingBal = BigDecimal.ZERO;
                    curReceipt = BigDecimal.ZERO;
                    fundNam = fBean.getFundName();
                    openingBal = openingBal.add(fBean.getOpeningBalance());
                    curReceipt = curReceipt.add(fBean.getCurrentReceipt());
                    btbpay = btbpay.add(fBean.getBtbPayment());
                    btbrep = btbrep.add(fBean.getBtbReceipt());
                }
                if ((lastIndr = this.receiptList.indexOf(fBean)) != sizer) continue;
                this.totalrepList.add(new FundFlowBean(fundNam, "Total", openingBal, curReceipt, btbpay, btbrep));
            }
            this.receiptList = this.totalrepList;
        }
        return this.receiptList;
    }

    public List<FundFlowBean> setFundsAvailableTotalPay() {
        if (this.fund == null) {
            BigDecimal openingBalp = new BigDecimal("0");
            BigDecimal btbpayp = new BigDecimal("0");
            BigDecimal curReceiptp = new BigDecimal("0");
            BigDecimal btbReceiptp = new BigDecimal("0");
            BigDecimal conBpvp = new BigDecimal("0");
            BigDecimal outBpvp = new BigDecimal("0");
            int sizep = this.paymentList.size() - 1;
            int lastInd = 0;
            String fndNamp = ((FundFlowBean)this.paymentList.get(0)).getFundName();
            for (FundFlowBean fBean : this.paymentList) {
                if (fBean.getFundName().equalsIgnoreCase(fndNamp)) {
                    this.totalpayList.add(fBean);
                    openingBalp = openingBalp.add(fBean.getOpeningBalance());
                    btbpayp = btbpayp.add(fBean.getBtbPayment());
                    curReceiptp = curReceiptp.add(fBean.getCurrentReceipt());
                    btbReceiptp = btbReceiptp.add(fBean.getBtbReceipt());
                    conBpvp = conBpvp.add(fBean.getConcurranceBPV());
                    outBpvp = outBpvp.add(fBean.getOutStandingBPV());
                } else {
                    this.totalpayList.add(new FundFlowBean(fndNamp, "Total", openingBalp, curReceiptp, btbpayp, btbReceiptp, conBpvp, outBpvp));
                    openingBalp = BigDecimal.ZERO;
                    btbpayp = BigDecimal.ZERO;
                    curReceiptp = BigDecimal.ZERO;
                    btbReceiptp = BigDecimal.ZERO;
                    conBpvp = BigDecimal.ZERO;
                    outBpvp = BigDecimal.ZERO;
                    this.totalpayList.add(fBean);
                    openingBalp = openingBalp.add(fBean.getOpeningBalance());
                    btbpayp = btbpayp.add(fBean.getBtbPayment());
                    curReceiptp = curReceiptp.add(fBean.getCurrentReceipt());
                    btbReceiptp = btbReceiptp.add(fBean.getBtbReceipt());
                    conBpvp = conBpvp.add(fBean.getConcurranceBPV());
                    outBpvp = outBpvp.add(fBean.getOutStandingBPV());
                    fndNamp = fBean.getFundName();
                }
                if ((lastInd = this.paymentList.indexOf(fBean)) != sizep) continue;
                this.totalpayList.add(new FundFlowBean(fndNamp, "Total", openingBalp, curReceiptp, btbpayp, btbReceiptp, conBpvp, outBpvp));
            }
            this.paymentList = this.totalpayList;
        }
        return this.totalpayList;
    }

    public String recalculateOpeningBalance() {
        this.getPreviousDayClosingBalance();
        return "edit";
    }

    public void getPreviousDayClosingBalance() {
        List openingBalnaceAllList = this.getOpeningBalance(this.asOnDate, this.fund);
        for (Object fBean : this.receiptList) {
            for (Object fop : openingBalnaceAllList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fop.getOpeningBalance());
            }
        }
        for (Object fBean : this.paymentList) {
            for (Object fop : openingBalnaceAllList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fop.getOpeningBalance());
            }
        }
        List previousDaybtbPaymentList = this.fundFlowService.getContraPaymentsForTheDay(this.openignBalanceCalculatedDate, this.fund);
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : previousDaybtbPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().subtract(fop.getBtbPayment()));
            }
        }
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : previousDaybtbPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().subtract(fop.getBtbPayment()));
            }
        }
        List previousDaybtbReceiptList = this.fundFlowService.getContraReceiptsForTheDay(this.openignBalanceCalculatedDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : previousDaybtbReceiptList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().add(fop.getBtbReceipt()));
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : previousDaybtbReceiptList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().add(fop.getBtbReceipt()));
            }
        }
        this.concurrancePaymentList = this.fundFlowService.getConcurrancePayments(this.openignBalanceCalculatedDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().subtract(fop.getConcurranceBPV()));
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fBean.getOpeningBalance().subtract(fop.getConcurranceBPV()));
            }
        }
        this.outStandingPaymentList = this.fundFlowService.getOutStandingPayments(this.asOnDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
    }

    @Action(value="/report/fundFlow-create")
    public String create() {
        SQLQuery alreadyExistsQry;
        List existsList;
        StringBuffer alreadyExistsQryStr = new StringBuffer(100);
        alreadyExistsQryStr.append("select openingBalance From egf_fundflow ff,bankaccount ba where ba.id=ff.bankaccountid and to_date(reportdate)='" + this.sqlformat.format(this.asOnDate) + "' ");
        if (this.fund != null && this.fund != -1L) {
            alreadyExistsQryStr.append("and ba.fundId=" + this.fund + " ");
        }
        if ((existsList = (alreadyExistsQry = this.persistenceService.getSession().createSQLQuery(alreadyExistsQryStr.toString())).list()).size() > 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("fundflow.report.already.generated", "Fund Flow report is already Generated for the Date and Fund. Open in modify Mode")));
        }
        List finalList = this.merge(this.receiptList, this.paymentList);
        for (FundFlowBean fbean : finalList) {
            fbean.setReportDate(this.asOnDate);
            this.persistenceService.persist((Object)fbean);
        }
        this.addActionMessage(this.getText("fundflowreport.create.succesful"));
        this.mode = "new";
        return "report";
    }

    @Action(value="/report/fundFlow-beforeEditSearch")
    public String beforeEditSearch() {
        this.loadDefalutDates();
        return "edit";
    }

    public String beforeEdit() {
        List openingBalnaceAllList = new ArrayList();
        openingBalnaceAllList = this.getCurrentDayOpeningBalance(this.asOnDate, this.fund);
        if (openingBalnaceAllList == null || openingBalnaceAllList.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("fundflow.report.not.generated", "Fund Flow report is not Generated for the Date and Fund. open in create Mode")));
        }
        this.receiptList = this.fundFlowService.getAllReceiptAccounts(this.fund);
        List btbPaymentList = this.fundFlowService.getContraPaymentsForTheDay(this.asOnDate, this.fund);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("all Bank accounts ------" + this.receiptList.size()));
        }
        for (Object fall : this.receiptList) {
            for (Object ftemp : btbPaymentList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbPayment(ftemp.getBtbPayment());
            }
        }
        List btbReceiptList = this.fundFlowService.getContraReceiptsForTheDay(this.asOnDate, this.fund);
        for (FundFlowBean fall : this.receiptList) {
            for (FundFlowBean ftemp : btbReceiptList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbReceipt(ftemp.getBtbReceipt());
            }
        }
        this.paymentList = this.fundFlowService.getAllpaymentAccounts(this.fund);
        for (FundFlowBean fall : this.paymentList) {
            for (FundFlowBean ftemp : btbReceiptList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbReceipt(ftemp.getBtbReceipt());
            }
        }
        List btbReceipt_PaymentList = this.fundFlowService.getContraPaymentsForTheDayFromPaymentBanks(this.asOnDate, this.fund);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("all Bank accounts ------" + this.receiptList.size()));
        }
        for (FundFlowBean fall : this.paymentList) {
            for (FundFlowBean ftemp : btbReceipt_PaymentList) {
                if (!fall.getAccountNumber().equalsIgnoreCase(ftemp.getAccountNumber())) continue;
                fall.setBtbPayment(ftemp.getBtbPayment());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : openingBalnaceAllList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fop.getOpeningBalance());
                fBean.setCurrentReceipt(fop.getCurrentReceipt());
                fBean.setBankAccountId(fop.getBankAccountId());
                fBean.setId(fop.getId());
            }
        }
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : openingBalnaceAllList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOpeningBalance(fop.getOpeningBalance());
                fBean.setCurrentReceipt(fop.getCurrentReceipt());
                fBean.setBankAccountId(fop.getBankAccountId());
                fBean.setId(fop.getId());
            }
        }
        this.concurrancePaymentList = this.fundFlowService.getConcurrancePayments(this.asOnDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setConcurranceBPV(fop.getConcurranceBPV());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.concurrancePaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setConcurranceBPV(fop.getConcurranceBPV());
            }
        }
        this.outStandingPaymentList = this.fundFlowService.getOutStandingPayments(this.asOnDate, this.fund);
        for (FundFlowBean fBean : this.paymentList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
        for (FundFlowBean fBean : this.receiptList) {
            for (FundFlowBean fop : this.outStandingPaymentList) {
                if (!fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                fBean.setOutStandingBPV(fop.getOutStandingBPV());
            }
        }
        this.setFundsAvailableTotalPay();
        this.setFundsAvailableTotalRep();
        return "edit";
    }

    @Action(value="/report/fundFlow-edit")
    public String edit() {
        List finalList = this.merge(this.receiptList, this.paymentList);
        for (FundFlowBean fbean : finalList) {
            fbean.setReportDate(this.asOnDate);
            this.persistenceService.persist((Object)fbean);
        }
        this.addActionMessage(this.getText("fundflowreport.update.succesful"));
        this.mode = "edit";
        return "report";
    }

    private List<FundFlowBean> getOpeningBalance(Date asPerDate, Long fundId) {
        Date reportDate = asPerDate;
        int i = 0;
        List<Object> openingBalnaceList = new ArrayList<FundFlowBean>();
        while (openingBalnaceList.size() == 0) {
            try {
                reportDate = this.sqlformat.parse(this.sqlformat.format(reportDate.getTime() - 86400000L));
            }
            catch (ParseException e) {
                throw new ValidationException(Arrays.asList(new ValidationError("parserExeception", "parser exception")));
            }
            StringBuffer openingBalanceQryStr = new StringBuffer(100);
            openingBalanceQryStr.append("select ba.id as bankAccountId,ba.accountnumber as accountNumber,ff.openingBalance+ff.currentReceipt as openingBalance from egf_fundflow ff,bankaccount ba      where ff.bankaccountid=ba.id ");
            if (fundId != null && fundId != -1L) {
                openingBalanceQryStr.append("and ba.fundid=" + fundId);
            }
            openingBalanceQryStr.append(" and to_date(reportdate)='" + this.sqlformat.format(reportDate) + "'");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getting Opening Balance for " + reportDate + "    sqlformat.format(reportDate)" + this.sqlformat.format(reportDate)));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" Opening Balance Qry " + openingBalanceQryStr.toString()));
            }
            Query openingBalanceQry = this.persistenceService.getSession().createSQLQuery(openingBalanceQryStr.toString()).addScalar("bankAccountId").addScalar("accountNumber").addScalar("openingBalance").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
            openingBalnaceList = openingBalanceQry.list();
            if (++i < 100) continue;
            this.receiptList = null;
            this.paymentList = null;
            throw new ValidationException(Arrays.asList(new ValidationError("fundflow.not.done.for.more.than.100", "fundflow  not done for more than 100 Days please start from last date")));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"////////////////////////////////////////");
        }
        LOGGER.info((Object)("--------------------------Last Entry for Fund Flow Data is on " + reportDate + "and this report is for " + asPerDate));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"///////////////////////////////////////");
        }
        this.setOpenignBalanceCalculatedDate(reportDate);
        return openingBalnaceList;
    }

    private List<FundFlowBean> getCurrentDayOpeningBalance(Date asOnDate2, Long fund2) {
        StringBuffer currentOpbAndRcptQryStr = new StringBuffer(100);
        currentOpbAndRcptQryStr.append("select ff.openingBalance as openingBalance,ff.currentreceipt as currentReceipt,ff.id as id ,ba.accountNumber as accountNumber,ff.bankAccountId as bankAccountId From egf_fundflow ff,bankaccount ba where ba.id=ff.bankaccountid and to_date(reportdate)='" + this.sqlformat.format(asOnDate2) + "' ");
        if (fund2 != null && fund2 != -1L) {
            currentOpbAndRcptQryStr.append(" and ba.fundId=" + fund2 + " ");
        }
        Query currentOpbAndRcptQry = this.persistenceService.getSession().createSQLQuery(currentOpbAndRcptQryStr.toString()).addScalar("openingBalance").addScalar("currentReceipt").addScalar("id", (Type)LongType.INSTANCE).addScalar("accountNumber").addScalar("bankAccountId").setResultTransformer(Transformers.aliasToBean(FundFlowBean.class));
        return currentOpbAndRcptQry.list();
    }

    private List<FundFlowBean> merge(List<FundFlowBean> receiptList2, List<FundFlowBean> paymentList2) {
        boolean insert;
        ArrayList<FundFlowBean> finalList = new ArrayList<FundFlowBean>();
        if (receiptList2 == null) {
            receiptList2 = new ArrayList<FundFlowBean>();
        }
        for (FundFlowBean fBean : receiptList2) {
            insert = true;
            if (fBean.getAccountNumber().contains("Total")) {
                insert = false;
                continue;
            }
            if (!insert) continue;
            finalList.add(fBean);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting Merging..................................... ");
        }
        for (FundFlowBean fBean : paymentList2) {
            insert = true;
            if (fBean.getAccountNumber().contains("Total")) continue;
            for (FundFlowBean fop : receiptList2) {
                if (fop.getAccountNumber().contains("Total") || !fBean.getAccountNumber().equalsIgnoreCase(fop.getAccountNumber())) continue;
                insert = false;
                break;
            }
            if (!insert) continue;
            finalList.add(fBean);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completed Merging....................");
        }
        return finalList;
    }

    public String exportPdf() {
        this.generateReport();
        return "PDF";
    }

    public String exportXls() {
        this.updateListsForTotals();
        ReportRequest reportInput = new ReportRequest("FundFlowReport", (Collection)this.receiptList, this.getParamMap());
        reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "XLS";
    }

    private void generateReport() {
        this.updateListsForTotals();
        ReportRequest reportInput = new ReportRequest("FundFlowReport", (Collection)this.receiptList, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
    }

    private void updateListsForTotals() {
        if (this.total.get(0) != null) {
            ((FundFlowBean)this.total.get(0)).setAccountNumber("Total (A)");
            ((FundFlowBean)this.total.get(0)).setBankName(" ");
            ((FundFlowBean)this.total.get(0)).setGlcode(null);
            this.receiptList.add(this.total.get(0));
        }
        if (this.total.get(1) != null) {
            ((FundFlowBean)this.total.get(1)).setAccountNumber("Total (B)");
            ((FundFlowBean)this.total.get(1)).setBankName(" ");
            ((FundFlowBean)this.total.get(1)).setGlcode(null);
            this.paymentList.add(this.total.get(1));
        }
        ((FundFlowBean)this.total.get(2)).setAccountNumber("Grand Total (A+B)");
        ((FundFlowBean)this.total.get(2)).setBankName(" ");
        ((FundFlowBean)this.total.get(2)).setGlcode(null);
        ((FundFlowBean)this.total.get(2)).setCurrentReceipt(null);
        ((FundFlowBean)this.total.get(2)).setBtbPayment(null);
        ((FundFlowBean)this.total.get(2)).setBtbReceipt(null);
        ((FundFlowBean)this.total.get(2)).setConcurranceBPV(null);
        this.paymentList.add(this.total.get(2));
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("FundFlowReport_paymentDetailsJasper", ReportUtil.getTemplateAsStream((String)"FundFlowReport_paymentDetails.jasper"));
        paramMap.put("receiptList", this.receiptList);
        paramMap.put("paymentList", this.paymentList);
        if (this.fund != null && this.fund != -1L) {
            Fund fundObj = (Fund)this.persistenceService.find("from Fund where id=" + this.fund);
            paramMap.put("fundName", fundObj.getName());
        } else {
            paramMap.put("fundName", "");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        paramMap.put("asOnDate", sdf.format(this.asOnDate));
        paramMap.put("ulbName", this.getUlbName());
        return paramMap;
    }

    private void loadDefalutDates() {
        Date currDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.asOnDate = sdf.parse(sdf.format(currDate));
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting as on date", "Transaction failed")));
        }
    }

    public List<FundFlowBean> getOutStandingPaymentList() {
        return this.outStandingPaymentList;
    }

    public void setOutStandingPaymentList(List<FundFlowBean> outStandingPaymentList) {
        this.outStandingPaymentList = outStandingPaymentList;
    }

    public List<FundFlowBean> getPaymentList() {
        return this.paymentList;
    }

    public void setPaymentList(List<FundFlowBean> paymentList) {
        this.paymentList = paymentList;
    }

    public Long getFund() {
        return this.fund;
    }

    public List<FundFlowBean> getReceiptList() {
        return this.receiptList;
    }

    public void setReceiptList(List<FundFlowBean> receiptList) {
        this.receiptList = receiptList;
    }

    public void setFund(Long fund) {
        this.fund = fund;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public List<FundFlowBean> getTotal() {
        return this.total;
    }

    public void setTotal(List<FundFlowBean> total) {
        this.total = total;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public FundFlowService getFundFlowService() {
        return this.fundFlowService;
    }

    public void setFundFlowService(FundFlowService fundFlowService) {
        this.fundFlowService = fundFlowService;
    }

    public List<FundFlowBean> getTotalrepList() {
        return this.totalrepList;
    }

    public void setTotalrepList(List<FundFlowBean> totalrepList) {
        this.totalrepList = totalrepList;
    }

    public List<FundFlowBean> getTotalpayList() {
        return this.totalpayList;
    }

    public void setTotalpayList(List<FundFlowBean> totalpayList) {
        this.totalpayList = totalpayList;
    }

    public Date getOpenignBalanceCalculatedDate() {
        return this.openignBalanceCalculatedDate;
    }

    public void setOpenignBalanceCalculatedDate(Date openignBalanceCalculatedDate) {
        this.openignBalanceCalculatedDate = openignBalanceCalculatedDate;
    }

    public List<FundFlowBean> getConcurrancePaymentList() {
        return this.concurrancePaymentList;
    }

    public void setConcurrancePaymentList(List<FundFlowBean> concurrancePaymentList) {
        this.concurrancePaymentList = concurrancePaymentList;
    }

    private String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

