/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.budget.BudgetProposalBean;
import org.egov.services.budget.BudgetDetailService;
import org.egov.utils.ReportHelper;

@ParentPackage(value="egov")
@Results(value={@Result(name={"reportSearch"}, location="consolidatedBudgetReport-reportSearch.jsp"), @Result(name={"reportview"}, type="stream", location="inputStream", params={"contentType", "${contentType}", "contentDisposition", "attachment; filename=${fileName}"})})
public class ConsolidatedBudgetReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private CFinancialYear financialYear;
    private String fundType;
    private String budgetType;
    private CFinancialYear prevFinYear;
    private String prevFinYearRange;
    private String currentFinYearRange;
    private String nextFinYearRange;
    private static final String DETAIL = "detail";
    private static final String HEADING = "heading";
    private static final Logger LOGGER = Logger.getLogger(ConsolidatedBudgetReportAction.class);
    protected BudgetDetailService budgetDetailService;
    protected FinancialYearHibernateDAO financialYearDAO;
    private String contentType;
    private String fileName;
    private ReportService reportService;
    private final Map<String, String> majorCodeAndNameMap = new TreeMap();
    private final Map<String, String> glCodeAndNameMap = new TreeMap();
    private List<BudgetProposalBean> bpBeanMajList;
    private List<BudgetProposalBean> bpBeanDetList;
    private List<BudgetProposalBean> bpBeanList;
    private final Map<String, BigDecimal> previousYearBudgetDetailIdsAndAmount = new HashMap();
    private ReportHelper reportHelper;
    private InputStream inputStream;

    public Object getModel() {
        return null;
    }

    @Action(value="/report/consolidatedBudgetReport-consolidatedReport")
    public String consolidatedReport() {
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        return "reportSearch";
    }

    @Action(value="/report/consolidatedBudgetReport-search")
    public String search() {
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.populateData();
        return "reportSearch";
    }

    public void populateData() {
        this.financialYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{this.financialYear.getId()});
        this.prevFinYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.financialYear.getStartingDate());
        this.prevFinYearRange = this.prevFinYear.getFinYearRange();
        this.currentFinYearRange = this.financialYear.getFinYearRange();
        this.nextFinYearRange = this.getFinancialYearDAO().getNextFinancialYearByDate(this.financialYear.getStartingDate()).getFinYearRange();
        this.bpBeanMajList = new ArrayList();
        this.bpBeanDetList = new ArrayList();
        this.getMajorCodeData();
        this.populateMajorCodewiseDetailDataForReport();
    }

    void getMajorCodeData() {
        HashMap majorCodePreviousYearActuals = new HashMap();
        HashMap majorCodeBEMap = new HashMap();
        HashMap majorCodeREMap = new HashMap();
        HashMap majorCodeNextYrBEMap = new HashMap();
        List resultMajorCode = this.budgetDetailService.fetchMajorCodeAndNameForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMap(resultMajorCode, this.majorCodeAndNameMap);
        List resultCurrentActuals = this.budgetDetailService.fetchMajorCodeAndActualsForReport(this.financialYear, this.prevFinYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultCurrentActuals, majorCodePreviousYearActuals);
        List resultMajorCodeBE = this.budgetDetailService.fetchMajorCodeAndBEAmountForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeBE, majorCodeBEMap);
        List resultMajorCodeApproved = this.budgetDetailService.fetchMajorCodeAndApprovedAmountForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeApproved, majorCodeREMap);
        List resultMajorCodeBENextYrApproved = this.budgetDetailService.fetchMajorCodeAndBENextYrApprovedForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeBENextYrApproved, majorCodeNextYrBEMap);
        BudgetProposalBean bpbeanTotal = new BudgetProposalBean();
        BigDecimal bigThousand = new BigDecimal(1000);
        Integer i = 1;
        for (Map.Entry entry : this.majorCodeAndNameMap.entrySet()) {
            BudgetProposalBean bpbean = new BudgetProposalBean();
            bpbean.setAccountCode(i.toString());
            bpbean.setBudgetGroup((String)entry.getValue());
            bpbean.setPreviousYearActuals(majorCodePreviousYearActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.toString() : ((BigDecimal)majorCodePreviousYearActuals.get(entry.getKey())).divide(bigThousand).setScale(0, 4).toString());
            bpbean.setCurrentYearBE(majorCodeBEMap.get(entry.getKey()) == null ? BigDecimal.ZERO.toString() : ((BigDecimal)majorCodeBEMap.get(entry.getKey())).setScale(0, 4).toString());
            bpbean.setApprovedRE(majorCodeREMap.get(entry.getKey()) == null ? BigDecimal.ZERO : ((BigDecimal)majorCodeREMap.get(entry.getKey())).setScale(0, 4));
            bpbean.setApprovedBE(majorCodeNextYrBEMap.get(entry.getKey()) == null ? BigDecimal.ZERO : ((BigDecimal)majorCodeNextYrBEMap.get(entry.getKey())).setScale(0, 4));
            bpbean.setRowType(DETAIL);
            this.bpBeanMajList.add(bpbean);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            this.computeTotal(bpbeanTotal, bpbean);
        }
        bpbeanTotal.setRowType(HEADING);
        bpbeanTotal.setAccountCode(null);
        this.bpBeanMajList.add(bpbeanTotal);
    }

    void populateMajorCodewiseDetailDataForReport() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populateMajorCodewiseDetailData()................");
        }
        HashMap glCodeBEMap = new HashMap();
        HashMap glCodeREMap = new HashMap();
        HashMap glCodeNextYrBEMap = new HashMap();
        List resultMajorCode = this.budgetDetailService.fetchGlCodeAndNameForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMap(resultMajorCode, this.glCodeAndNameMap);
        List resultPreviousActuals = this.budgetDetailService.fetchActualsForReport(this.financialYear, this.prevFinYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultPreviousActuals, this.previousYearBudgetDetailIdsAndAmount);
        List resultMajorCodeBE = this.budgetDetailService.fetchGlCodeAndBEAmountForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeBE, glCodeBEMap);
        List resultMajorCodeApproved = this.budgetDetailService.fetchGlCodeAndApprovedAmountForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeApproved, glCodeREMap);
        List resultMajorCodeBENextYrApproved = this.budgetDetailService.fetchGlCodeAndBENextYrApprovedForReport(this.financialYear, this.fundType, this.budgetType);
        this.addToMapStringBigDecimal(resultMajorCodeBENextYrApproved, glCodeNextYrBEMap);
        BigDecimal bigThousand = new BigDecimal(1000);
        for (Map.Entry entry : this.majorCodeAndNameMap.entrySet()) {
            this.bpBeanDetList.add(new BudgetProposalBean((String)entry.getValue(), HEADING));
            BudgetProposalBean bpbeanTotal = new BudgetProposalBean();
            for (Map.Entry glEntry : this.glCodeAndNameMap.entrySet()) {
                if (!((String)entry.getKey()).equals(((String)glEntry.getKey()).substring(0, 3))) continue;
                BudgetProposalBean bpbean = new BudgetProposalBean();
                bpbean.setAccountCode((String)glEntry.getKey());
                bpbean.setBudgetGroup((String)glEntry.getValue());
                bpbean.setPreviousYearActuals(this.previousYearBudgetDetailIdsAndAmount.get(glEntry.getKey()) == null ? BigDecimal.ZERO.toString() : ((BigDecimal)this.previousYearBudgetDetailIdsAndAmount.get(glEntry.getKey())).divide(bigThousand).setScale(0, 4).toString());
                bpbean.setCurrentYearBE(glCodeBEMap.get(glEntry.getKey()) == null ? BigDecimal.ZERO.toString() : ((BigDecimal)glCodeBEMap.get(glEntry.getKey())).setScale(0, 4).toString());
                bpbean.setApprovedRE(glCodeREMap.get(glEntry.getKey()) == null ? BigDecimal.ZERO : ((BigDecimal)glCodeREMap.get(glEntry.getKey())).setScale(0, 4));
                bpbean.setApprovedBE(glCodeNextYrBEMap.get(glEntry.getKey()) == null ? BigDecimal.ZERO : ((BigDecimal)glCodeNextYrBEMap.get(glEntry.getKey())).setScale(0, 4));
                bpbean.setRowType(DETAIL);
                this.bpBeanDetList.add(bpbean);
                this.computeTotal(bpbeanTotal, bpbean);
            }
            bpbeanTotal.setRowType(HEADING);
            this.bpBeanDetList.add(bpbeanTotal);
            this.bpBeanDetList.add(new BudgetProposalBean("", DETAIL));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished populateMajorCodewiseDetailData()");
        }
    }

    private Map<String, String> addToMap(List<Object[]> tempList, Map<String, String> resultMap) {
        for (Object[] row : tempList) {
            resultMap.put(row[0].toString(), row[1].toString());
        }
        return resultMap;
    }

    private Map<String, BigDecimal> addToMapStringBigDecimal(List<Object[]> tempList, Map<String, BigDecimal> resultMap) {
        for (Object[] row : tempList) {
            resultMap.put(row[0].toString(), ((BigDecimal)row[1]).setScale(2));
        }
        return resultMap;
    }

    void computeTotal(BudgetProposalBean bpbeanTotal, BudgetProposalBean bpbean) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting computeTotal................");
        }
        bpbeanTotal.setPreviousYearActuals(bpbeanTotal.getPreviousYearActuals() == null ? bpbean.getPreviousYearActuals() : new BigDecimal(bpbeanTotal.getPreviousYearActuals()).add(new BigDecimal(bpbean.getPreviousYearActuals())).toString());
        bpbeanTotal.setCurrentYearBE(bpbeanTotal.getCurrentYearBE() == null ? bpbean.getCurrentYearBE() : new BigDecimal(bpbeanTotal.getCurrentYearBE()).add(new BigDecimal(bpbean.getCurrentYearBE())).toString());
        bpbeanTotal.setApprovedRE(bpbeanTotal.getApprovedRE() == null ? bpbean.getApprovedRE() : bpbeanTotal.getApprovedRE().add(bpbean.getApprovedRE()).setScale(0));
        bpbeanTotal.setApprovedBE(bpbeanTotal.getApprovedBE() == null ? bpbean.getApprovedBE() : bpbeanTotal.getApprovedBE().add(bpbean.getApprovedBE()).setScale(0));
        bpbeanTotal.setBudgetGroup("TOTAL");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished computeTotal");
        }
    }

    @Action(value="/report/consolidatedBudgetReport-exportPDF")
    public String exportPDF() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("title", this.fundType + " " + this.budgetType);
        this.bpBeanList = new ArrayList();
        this.populateData();
        reportParams.put("prevFinYearRange", this.prevFinYearRange);
        reportParams.put("currentFinYearRange", this.currentFinYearRange);
        reportParams.put("nextFinYearRange", this.nextFinYearRange);
        this.bpBeanList.addAll(this.bpBeanMajList);
        this.bpBeanList.add(new BudgetProposalBean("", DETAIL));
        BudgetProposalBean bpbean = new BudgetProposalBean("Account Head", HEADING);
        bpbean.setAccountCode("D.P.Code");
        bpbean.setPreviousYearActuals("Actuals\n" + this.prevFinYearRange);
        bpbean.setCurrentYearBE("Budget Estimate\n" + this.currentFinYearRange);
        bpbean.setFund("Revised Estimate\n" + this.currentFinYearRange);
        bpbean.setFunction("Budget Estimate\n" + this.nextFinYearRange);
        bpbean.setRowType("jrxml");
        this.bpBeanList.add(bpbean);
        this.bpBeanList.addAll(this.bpBeanDetList);
        ReportRequest reportInput = new ReportRequest("consolidatedBudgetReport", (Collection)this.bpBeanList, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        this.contentType = ReportViewerUtil.getContentType((ReportConstants.FileFormat)ReportConstants.FileFormat.PDF);
        this.fileName = "ConsolidatedBudgetReport." + ReportConstants.FileFormat.PDF.toString().toLowerCase();
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "reportview";
    }

    @Action(value="/report/consolidatedBudgetReport-exportExcel")
    public String exportExcel() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("title", this.fundType + " " + this.budgetType);
        this.bpBeanList = new ArrayList();
        this.populateData();
        reportParams.put("prevFinYearRange", this.prevFinYearRange);
        reportParams.put("currentFinYearRange", this.currentFinYearRange);
        reportParams.put("nextFinYearRange", this.nextFinYearRange);
        this.bpBeanList.addAll(this.bpBeanMajList);
        BudgetProposalBean bpbean = new BudgetProposalBean("Account Head", HEADING);
        bpbean.setAccountCode("D.P.Code");
        bpbean.setPreviousYearActuals("Actuals\n" + this.prevFinYearRange);
        bpbean.setCurrentYearBE("Budget Estimate\n" + this.currentFinYearRange);
        bpbean.setFund("Revised Estimate\n" + this.currentFinYearRange);
        bpbean.setFunction("Budget Estimate\n" + this.nextFinYearRange);
        bpbean.setRowType("jrxml");
        this.bpBeanList.add(bpbean);
        this.bpBeanList.addAll(this.bpBeanDetList);
        ReportRequest reportInput = new ReportRequest("consolidatedBudgetReport", (Collection)this.bpBeanList, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        this.contentType = ReportViewerUtil.getContentType((ReportConstants.FileFormat)ReportConstants.FileFormat.XLS);
        this.fileName = "ConsolidatedBudgetReport." + ReportConstants.FileFormat.XLS.toString().toLowerCase();
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "reportview";
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public String getFundType() {
        return this.fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    public String getBudgetType() {
        return this.budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public BudgetDetailService getBudgetDetailService() {
        return this.budgetDetailService;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public List<BudgetProposalBean> getBpBeanMajList() {
        return this.bpBeanMajList;
    }

    public void setBpBeanMajList(List<BudgetProposalBean> bpBeanMajList) {
        this.bpBeanMajList = bpBeanMajList;
    }

    public List<BudgetProposalBean> getBpBeanDetList() {
        return this.bpBeanDetList;
    }

    public void setBpBeanDetList(List<BudgetProposalBean> bpBeanDetList) {
        this.bpBeanDetList = bpBeanDetList;
    }

    public String getPrevFinYearRange() {
        return this.prevFinYearRange;
    }

    public void setPrevFinYearRange(String prevFinYearRange) {
        this.prevFinYearRange = prevFinYearRange;
    }

    public String getCurrentFinYearRange() {
        return this.currentFinYearRange;
    }

    public void setCurrentFinYearRange(String currentFinYearRange) {
        this.currentFinYearRange = currentFinYearRange;
    }

    public String getNextFinYearRange() {
        return this.nextFinYearRange;
    }

    public void setNextFinYearRange(String nextFinYearRange) {
        this.nextFinYearRange = nextFinYearRange;
    }

    public List<BudgetProposalBean> getBpBeanList() {
        return this.bpBeanList;
    }

    public void setBpBeanList(List<BudgetProposalBean> bpBeanList) {
        this.bpBeanList = bpBeanList;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

