/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import com.opensymphony.xwork2.validator.annotations.Validations;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.payment.Paymentheader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"billpayment"}, type="redirectAction", location="payment-view", params={"namespace", "/payment", "paymentid", "${paymentid}"}), @Result(name={"advancepayment"}, type="redirectAction", location="payment-advanceView", params={"namespace", "/payment", "paymentid", "${paymentid}"}), @Result(name={"directbankpayment"}, type="redirectAction", location="directBankPayment-viewInboxItem", params={"namespace", "/payment", "paymentid", "${paymentid}"}), @Result(name={"remitRecovery"}, type="redirectAction", location="remitRecovery-viewInboxItem", params={"namespace", "/deduction", "paymentid", "${paymentid}"}), @Result(name={"contractoradvancepayment"}, type="redirectAction", location="advancePayment-viewInboxItem", params={"namespace", "/payment", "paymentid", "${paymentid}"})})
public class BasePaymentAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 8589393885303282831L;
    EisCommonService eisCommonService;
    private static Logger LOGGER = Logger.getLogger(BasePaymentAction.class);
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    protected String action = "";
    protected String paymentid = "";
    private final String BILLPAYMENT = "billpayment";
    private final String DIRECTBANKPAYMENT = "directbankpayment";
    private final String REMITTANCEPAYMENT = "remitRecovery";
    public static final String ARF_TYPE = "Contractor";
    protected static final String ACTIONNAME = "actionname";
    protected boolean canCheckBalance = false;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    protected String showMode;

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public boolean isCanCheckBalance() {
        return this.canCheckBalance;
    }

    public void setCanCheckBalance(boolean canCheckBalance) {
        this.canCheckBalance = canCheckBalance;
    }

    @SkipValidation
    @Action(value="/payment/basePayment-viewInboxItems")
    public String viewInboxItems() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting viewInboxItems..... ");
        }
        String result = null;
        Paymentheader paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(this.paymentid)});
        if (!this.validateOwner(paymentheader.getState()).booleanValue()) {
            return "invalidPage";
        }
        this.getSession().put("paymentid", this.paymentid);
        if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Advance Payment")) {
            EgAdvanceRequisition arf = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where arftype = ? and egAdvanceReqMises.voucherheader = ?", new Object[]{ARF_TYPE, paymentheader.getVoucherheader()});
            result = arf != null ? "contractoradvancepayment" : "advancepayment";
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Bill Payment") || "Salary Bill Payment".equalsIgnoreCase(paymentheader.getVoucherheader().getName()) || "Pension Bill Payment".equalsIgnoreCase(paymentheader.getVoucherheader().getName())) {
            result = "billpayment";
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Direct Bank Payment")) {
            result = "directbankpayment";
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Remittance Payment")) {
            result = "remitRecovery";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed viewInboxItems..... ");
        }
        return result;
    }

    public boolean shouldshowVoucherNumber() {
        String vNumGenMode = "Manual";
        vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
            this.mandatoryFields.add("vouchernumber");
            return true;
        }
        return false;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPaymentid() {
        return this.paymentid;
    }

    public void setPaymentid(String paymentid) {
        this.paymentid = paymentid;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public String getFinConstExpendTypeContingency() {
        return "Expense";
    }

    public String getFinConstExpendTypePension() {
        return "Pension";
    }

    public SimpleWorkflowService<Paymentheader> getPaymentHeaderWorkflowService() {
        return this.paymentHeaderWorkflowService;
    }

    public void setPaymentHeaderWorkflowService(SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService) {
        this.paymentHeaderWorkflowService = paymentHeaderWorkflowService;
    }
}

