/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.egf.web.actions.payment.BasePaymentAction;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.voucher.BankEntriesNotInBankBook;
import org.egov.services.instrument.BankEntriesService;
import org.egov.services.voucher.BankEntriesNotInBankBookActionHelper;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.DateType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="bankEntriesNotInBankBook-new.jsp"), @Result(name={"success"}, location="bankEntriesNotInBankBook-success.jsp")})
public class BankEntriesNotInBankBookAction
extends BasePaymentAction {
    private static final long serialVersionUID = 8336255427935452077L;
    private static final Logger LOGGER = Logger.getLogger(BankEntriesNotInBankBookAction.class);
    private static final SimpleDateFormat FORMATDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private Integer bankaccount;
    private Integer bank;
    private Integer bank_branch;
    private List<BankEntriesNotInBankBook> bankEntriesNotInBankBookList;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private BankBranchHibernateDAO bankBranchHibernateDAO;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private BankEntriesNotInBankBookActionHelper bankEntriesNotInBankBookActionHelper;
    @Autowired
    @Qualifier(value="bankEntriesService")
    private BankEntriesService bankEntriesService;
    private Long beId;
    private String mode;

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        return this.voucherHeader;
    }

    public void prepare() {
        super.prepare();
        this.voucherHeader.setType("Payment");
        this.voucherHeader.setName("Direct Bank Payment");
    }

    public void prepareNewform() {
        this.addDropdownData("glcodeList", this.chartOfAccountsHibernateDAO.getAccountCodesListForBankEntries());
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
    }

    @SkipValidation
    @Action(value="/payment/bankEntriesNotInBankBook-newform")
    public String newform() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Resetting all........................... ");
        }
        this.voucherHeader.reset();
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.bankEntriesNotInBankBookList = new ArrayList();
        this.bankEntriesNotInBankBookList.add(new BankEntriesNotInBankBook());
        this.loadDefalutDates();
        return "new";
    }

    @SkipValidation
    @Action(value="/payment/bankEntriesNotInBankBook-search")
    public String search() {
        Query query = null;
        query = this.persistenceService.getSession().createSQLQuery(this.getQuery()).addScalar("refNum", (Type)StringType.INSTANCE).addScalar("type", (Type)StringType.INSTANCE).addScalar("date", (Type)DateType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("remarks", (Type)StringType.INSTANCE).addScalar("glcodeDetail", (Type)StringType.INSTANCE).addScalar("beId", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BankEntriesNotInBankBook.class));
        this.bankEntriesNotInBankBookList = query.list();
        ArrayList<BankEntriesNotInBankBook> tempList = new ArrayList<BankEntriesNotInBankBook>();
        for (BankEntriesNotInBankBook bean : this.bankEntriesNotInBankBookList) {
            bean.setDateId(FORMATDDMMYYYY.format(bean.getDate()));
            tempList.add(bean);
        }
        this.bankEntriesNotInBankBookList = tempList;
        if (this.bankEntriesNotInBankBookList.size() == 0) {
            this.bankEntriesNotInBankBookList.add(new BankEntriesNotInBankBook());
        }
        this.prepareNewform();
        this.addDropdownData("bankList", this.bankHibernateDAO.getAllBanksByFund(this.voucherHeader.getFundId().getId()));
        this.addDropdownData("bankBranchList", this.bankBranchHibernateDAO.getAllBankBranchsByBank(this.bank));
        this.addDropdownData("bankAccountList", this.bankaccountHibernateDAO.getBankAccountByBankBranch(this.bank_branch));
        this.mode = "save";
        return "new";
    }

    private String getQuery() {
        String query = "";
        String subQuery = "";
        if (this.bankaccount != null) {
            subQuery = subQuery + "and be.bankaccountid = " + this.bankaccount;
        }
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            subQuery = subQuery + "and bemis.departmentid = " + this.voucherHeader.getVouchermis().getDepartmentid().getId();
        }
        if (this.voucherHeader.getFundId() != null) {
            subQuery = subQuery + "and bemis.fundid = " + this.voucherHeader.getFundId().getId();
        }
        if (this.voucherHeader.getVouchermis().getSchemeid() != null) {
            subQuery = subQuery + "and bemis.schemeid = " + this.voucherHeader.getVouchermis().getSchemeid().getId();
        }
        if (this.voucherHeader.getVouchermis().getSubschemeid() != null) {
            subQuery = subQuery + "and bemis.subschemeid = " + this.voucherHeader.getVouchermis().getSubschemeid().getId();
        }
        if (this.voucherHeader.getVouchermis().getFundsource() != null) {
            subQuery = subQuery + "and bemis.fundsourceid = " + this.voucherHeader.getVouchermis().getFundsource().getId();
        }
        if (this.voucherHeader.getVouchermis().getDivisionid() != null) {
            subQuery = subQuery + "and bemis.divisionid = " + this.voucherHeader.getVouchermis().getDivisionid().getId();
        }
        if (this.voucherHeader.getVouchermis().getFunctionary() != null) {
            subQuery = subQuery + "and bemis.functionaryid = " + this.voucherHeader.getVouchermis().getFunctionary().getId();
        }
        if (this.voucherHeader.getVouchermis().getFunction() != null) {
            subQuery = subQuery + "and bemis.functionid = " + this.voucherHeader.getVouchermis().getFunction().getId();
        }
        query = "select be.id as beId,be.refno as refnum,be.type as type,be.txndate as date,be.txnamount as amount,be.glcodeid as glcodeDetail,be.remarks as remarks  from bankentries be,bankentries_mis bemis where be.voucherheaderid is null and be.id = bemis.bankentriesid " + subQuery;
        return query;
    }

    @SkipValidation
    @Action(value="/payment/bankEntriesNotInBankBook-save")
    public String save() {
        try {
            this.bankEntriesNotInBankBookActionHelper.create(this.voucherHeader, this.bankaccount, this.bankEntriesNotInBankBookList);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "success";
    }

    @SkipValidation
    @Action(value="/payment/ajaxDeleteBankEntries")
    public void ajaxDeleteBankEntries() {
        if (this.beId != null) {
            this.bankEntriesService.delete(this.bankEntriesService.findById((Serializable)this.beId, false));
        }
    }

    public List<BankEntriesNotInBankBook> getBankEntriesNotInBankBookList() {
        return this.bankEntriesNotInBankBookList;
    }

    public void setBankEntriesNotInBankBookList(List<BankEntriesNotInBankBook> bankEntriesNotInBankBookList) {
        this.bankEntriesNotInBankBookList = bankEntriesNotInBankBookList;
    }

    public Integer getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Integer bankaccount) {
        this.bankaccount = bankaccount;
    }

    public Long getBeId() {
        return this.beId;
    }

    public void setBeId(Long beId) {
        this.beId = beId;
    }

    public Integer getBank() {
        return this.bank;
    }

    public void setBank(Integer bank) {
        this.bank = bank;
    }

    public Integer getBank_branch() {
        return this.bank_branch;
    }

    public void setBank_branch(Integer bank_branch) {
        this.bank_branch = bank_branch;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

