/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.masters.SchemeService;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="scheme-new.jsp"), @Result(name={"search"}, location="scheme-search.jsp"), @Result(name={"view"}, location="scheme-view.jsp"), @Result(name={"fieldUniqueCheck"}, location="scheme-fieldUniqueCheck.jsp")})
public class SchemeAction
extends BaseFormAction {
    private static final long serialVersionUID = 5697760395477552986L;
    private Scheme scheme = new Scheme();
    private String mode;
    private static final String REQUIRED = "required";
    public static final String UNIQUECHECKFIELD = "fieldUniqueCheck";
    private boolean uniqueCode = false;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private static final Logger LOGGER = Logger.getLogger(SchemeAction.class);
    List<Scheme> schemeList;
    @Autowired
    @Qualifier(value="schemeService")
    private SchemeService schemeService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.scheme;
    }

    public SchemeAction() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Scheme Action Constructor");
        }
        this.addRelatedEntity("fund", Fund.class);
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("fundDropDownList", this.masterDataCache.get("egi-fund"));
    }

    @SkipValidation
    @Action(value="/masters/scheme-newForm")
    public String newForm() {
        this.scheme.reset();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        this.mode = "new";
        return "new";
    }

    @SkipValidation
    @Action(value="/masters/scheme-beforeSearch")
    public String beforeSearch() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Scheme Mode=" + this.mode));
        }
        return SEARCH;
    }

    @SkipValidation
    @Action(value="/masters/scheme-beforeEdit")
    public String beforeEdit() {
        this.scheme = (Scheme)this.persistenceService.find("from Scheme where id=?", new Object[]{this.scheme.getId()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside Before Edit Method..");
        }
        this.mode = "edit";
        return "new";
    }

    @SkipValidation
    @Action(value="/masters/scheme-beforeView")
    public String beforeView() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside Before View Method..");
        }
        this.scheme = (Scheme)this.persistenceService.find("from Scheme where id=?", new Object[]{this.scheme.getId()});
        this.mode = VIEW;
        return VIEW;
    }

    @SkipValidation
    @Action(value="/masters/scheme-search")
    public String search() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Search |Search scheme Action Starts");
        }
        StringBuffer query = new StringBuffer();
        this.schemeList = new ArrayList();
        query.append("From Scheme scheme");
        if (this.scheme.getFund().getId() != null) {
            query.append(" where scheme.fund=" + this.scheme.getFund().getId());
        }
        if (this.scheme.getValidfrom() != null && this.scheme.getValidto() != null) {
            query.append(" and scheme.validfrom>='" + Constants.DDMMYYYYFORMAT1.format(this.scheme.getValidfrom()) + "'").append("and scheme.validto<='" + Constants.DDMMYYYYFORMAT1.format(this.scheme.getValidto()) + "'");
        } else if (this.scheme.getValidfrom() != null) {
            query.append(" and scheme.validfrom>='" + Constants.DDMMYYYYFORMAT1.format(this.scheme.getValidfrom()) + "'");
        } else if (this.scheme.getValidto() != null) {
            query.append("and scheme.validto<='" + Constants.DDMMYYYYFORMAT1.format(this.scheme.getValidto()) + "'");
        }
        query.append("order by scheme.name");
        this.schemeList = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Scheme List Size is" + this.schemeList.size()));
        }
        return SEARCH;
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="fund", message="", key="required"), @RequiredFieldValidator(fieldName="code", message="", key="required"), @RequiredFieldValidator(fieldName="name", message="", key="required"), @RequiredFieldValidator(fieldName="validfrom", message="", key="required"), @RequiredFieldValidator(fieldName="validto", message="", key="required")})
    @ValidationErrorPage(value="new")
    @Action(value="/masters/scheme-edit")
    public String edit() {
        try {
            this.scheme.setLastModifiedDate(new Date());
            this.scheme.setLastModifiedBy((User)this.schemeService.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            this.schemeService.persist((Object)this.scheme);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("ValidationException in creating Scheme" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while creating Scheme" + e.getMessage()));
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)".................................Scheme Modified Successfully......................");
        }
        this.addActionMessage(this.getText("Scheme Modified Successfully"));
        this.mode = "edit";
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/masters/scheme-create")
    public String create() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"............................Creating New Scheme method.......................");
        }
        try {
            this.scheme.setCreatedDate(new Date());
            this.scheme.setCreatedBy((User)this.schemeService.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            this.schemeService.persist((Object)this.scheme);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("ValidationException in create Scheme" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while creating Scheme" + e.getMessage()));
            throw new ValidationException(Arrays.asList(new ValidationError("An error occured contact Administrator", "An error occured contact Administrator")));
        }
        this.addActionMessage(this.getText("Scheme Created Successfully"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SchemeAction  | Scheme Created successfully");
        }
        this.mode = "";
        return "new";
    }

    @SkipValidation
    public boolean getCheckField() {
        Scheme scheme_validate = null;
        boolean isDuplicate = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"......Scheme Unique check Begins......");
        }
        if (this.uniqueCode) {
            if (!this.scheme.getCode().equals("") && this.scheme.getId() != null) {
                scheme_validate = (Scheme)this.persistenceService.find("from Scheme where lower(code)=? and id!=?", new Object[]{this.scheme.getCode().toLowerCase(), this.scheme.getId()});
            } else if (!this.scheme.getCode().equals("")) {
                scheme_validate = (Scheme)this.persistenceService.find("from Scheme where lower(code)=?", new Object[]{this.scheme.getCode().toLowerCase()});
            }
            this.uniqueCode = false;
        } else if (!this.scheme.getName().equals("") && this.scheme.getId() != null) {
            scheme_validate = (Scheme)this.persistenceService.find("from Scheme where lower(name)=? and id!=?", new Object[]{this.scheme.getName().toLowerCase(), this.scheme.getId()});
        } else if (!this.scheme.getName().equals("")) {
            scheme_validate = (Scheme)this.persistenceService.find("from Scheme where lower(name)=?", new Object[]{this.scheme.getName().toLowerCase()});
        }
        if (scheme_validate != null) {
            isDuplicate = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"......Scheme Unique check processed......");
        }
        return isDuplicate;
    }

    @SkipValidation
    @Action(value="/masters/scheme-codeUniqueCheck")
    public String codeUniqueCheck() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"......Scheme Unique check for code......");
        }
        this.uniqueCode = true;
        return UNIQUECHECKFIELD;
    }

    @SkipValidation
    @Action(value="/masters/scheme-nameUniqueCheck")
    public String nameUniqueCheck() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"......Scheme Unique check for Name......");
        }
        return UNIQUECHECKFIELD;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<Scheme> getSchemeList() {
        return this.schemeList;
    }

    public void setSchemeList(List<Scheme> schemeList) {
        this.schemeList = schemeList;
    }

    public SchemeService getSchemeService() {
        return this.schemeService;
    }

    public void setSchemeService(SchemeService schemeService) {
        this.schemeService = schemeService;
    }
}

