/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.CheckListService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.expensebill.BaseBillController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.models.EgChecklists;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.utils.CheckListHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/expensebill"})
public class UpdateExpenseBillController
extends BaseBillController {
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private CheckListService checkListService;

    public UpdateExpenseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    @ModelAttribute
    public EgBillregister getEgBillregister(@PathVariable String billId) {
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        return egBillregister;
    }

    @RequestMapping(value={"/update/{billId}"}, method={RequestMethod.GET})
    public String updateForm(Model model, @PathVariable String billId, HttpServletRequest request) throws ApplicationException {
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        this.setDropDownValues(model);
        model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
        if (egBillregister.getState() != null) {
            model.addAttribute("currentState", (Object)egBillregister.getState().getValue());
        }
        model.addAttribute("workflowHistory", (Object)this.expenseBillService.getHistory(egBillregister.getState(), egBillregister.getStateHistory()));
        this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
        egBillregister.getBillDetails().addAll(egBillregister.getEgBilldetailes());
        model.addAttribute("mode", (Object)"view");
        this.prepareBillDetails(egBillregister);
        this.prepareCheckList(egBillregister);
        model.addAttribute("egBillregister", (Object)egBillregister);
        return "expensebill-view";
    }

    @RequestMapping(value={"/update/{billId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="egBillregister") EgBillregister egBillregister, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String workFlowAction) throws ApplicationException, IOException {
        String mode = "";
        EgBillregister updatedEgBillregister = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            return "expensebill-view";
        }
        if (null != workFlowAction) {
            updatedEgBillregister = this.expenseBillService.update(egBillregister, approvalPosition, approvalComment, null, workFlowAction);
        }
        redirectAttributes.addFlashAttribute("egBillregister", updatedEgBillregister);
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.expenseBillService.getApprovalPositionByMatrixDesignation(egBillregister, null, mode, workFlowAction);
        }
        String approverDetails = this.financialUtils.getApproverDetails(updatedEgBillregister.getStatus(), updatedEgBillregister.getState(), updatedEgBillregister.getId(), approvalPosition);
        return "redirect:/expensebill/success?approverDetails= " + approverDetails + "&billNumber=" + updatedEgBillregister.getBillnumber();
    }

    @RequestMapping(value={"/view/{billId}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String billId, HttpServletRequest request) throws ApplicationException {
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        this.setDropDownValues(model);
        egBillregister.getBillDetails().addAll(egBillregister.getEgBilldetailes());
        model.addAttribute("mode", (Object)"readOnly");
        this.prepareBillDetails(egBillregister);
        model.addAttribute("egBillregister", (Object)egBillregister);
        return "expensebill-view";
    }

    private void prepareBillDetails(EgBillregister egBillregister) {
        for (EgBilldetails details : egBillregister.getBillDetails()) {
            details.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(details.getGlcodeid().longValue()), false));
            egBillregister.getBillPayeedetails().addAll(details.getEgBillPaydetailes());
        }
        for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
            payeeDetails.getEgBilldetailsId().setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(payeeDetails.getEgBilldetailsId().getGlcodeid().longValue()), false));
            Accountdetailtype detailType = this.accountdetailtypeService.findOne(payeeDetails.getAccountDetailTypeId());
            EntityType entity = null;
            String dataType = "";
            try {
                String table = detailType.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                String tableName = service.getSimpleName();
                Method method = service.getMethod("getId", new Class[0]);
                dataType = method.getReturnType().getSimpleName();
                entity = "Long".equals(dataType) ? (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeeDetails.getAccountDetailKeyId().longValue()}) : (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeeDetails.getAccountDetailKeyId()});
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e.getMessage());
            }
            payeeDetails.setDetailTypeName(detailType.getName());
            payeeDetails.setDetailKeyName(entity.getName());
        }
    }

    private void prepareCheckList(EgBillregister egBillregister) {
        List checkLists = this.checkListService.getByObjectId(egBillregister.getId());
        for (EgChecklists checkList : checkLists) {
            CheckListHelper helper = new CheckListHelper();
            helper.setName(checkList.getAppconfigvalue().getValue());
            helper.setVal(checkList.getChecklistvalue());
            egBillregister.getCheckLists().add(helper);
        }
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
    }
}

