/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.expensebill.BaseBillController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/expensebill"})
public class CreateExpenseBillController
extends BaseBillController {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private FinancialUtils financialUtils;

    public CreateExpenseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
    }

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model) {
        this.setDropDownValues(model);
        model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (!cutOffDateconfigValue.isEmpty()) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            List<Object> validActions = Collections.emptyList();
            validActions = Arrays.asList("Forward", "Create And Approve");
            model.addAttribute("validActionList", validActions);
            try {
                model.addAttribute("cutOffDate", (Object)DateUtils.getDefaultFormattedDate((Date)df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        egBillregister.setBilldate(new Date());
        return "expensebill-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException {
        EgBillregister savedEgBillregister;
        this.validateBillNumber(egBillregister, resultBinder);
        this.validateLedgerAndSubledger(egBillregister, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            egBillregister.setBilldate(new Date());
            model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            return "expensebill-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        this.populateBillDetails(egBillregister);
        try {
            savedEgBillregister = this.expenseBillService.create(egBillregister, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.expense.bill.budgetcheck.insufficient.amount");
        }
        String approverDetails = this.financialUtils.getApproverDetails(savedEgBillregister.getStatus(), savedEgBillregister.getState(), savedEgBillregister.getId(), approvalPosition);
        return "redirect:/expensebill/success?approverDetails= " + approverDetails + "&billNumber=" + savedEgBillregister.getBillnumber();
    }

    @RequestMapping(value={"/success"}, method={RequestMethod.GET})
    public String showContractorBillSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("approverDetails").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0].trim());
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        EgBillregister expenseBill = this.expenseBillService.getByBillnumber(billNumber);
        String message = this.getMessageByStatus(expenseBill, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return "expensebill-success";
    }

    private String getMessageByStatus(EgBillregister expenseBill, String approverName, String nextDesign) {
        String message = "";
        if ("CREATED".equals(expenseBill.getStatus().getCode())) {
            message = StringUtils.isNotBlank((String)expenseBill.getEgBillregistermis().getBudgetaryAppnumber()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) ? this.messageSource.getMessage("msg.expense.bill.create.success.with.budgetappropriation", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign, expenseBill.getEgBillregistermis().getBudgetaryAppnumber()}, null) : this.messageSource.getMessage("msg.expense.bill.create.success", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign}, null);
        } else if ("Approved".equals(expenseBill.getStatus().getCode())) {
            message = this.messageSource.getMessage("msg.expense.bill.approved.success", (Object[])new String[]{expenseBill.getBillnumber()}, null);
        } else if ("Rejected".equals(expenseBill.getState().getValue())) {
            message = this.messageSource.getMessage("msg.expense.bill.reject", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign}, null);
        } else if ("Cancelled".equals(expenseBill.getState().getValue())) {
            message = this.messageSource.getMessage("msg.expense.bill.cancel", (Object[])new String[]{expenseBill.getBillnumber()}, null);
        }
        return message;
    }

    private void populateBillDetails(EgBillregister egBillregister) {
        egBillregister.getEgBilldetailes().addAll(egBillregister.getBillDetails());
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            if (egBillregister.getEgBillregistermis().getFunction() != null) {
                details.setFunctionid(BigDecimal.valueOf(egBillregister.getEgBillregistermis().getFunction().getId()));
            }
            details.setEgBillregister(egBillregister);
            details.setLastupdatedtime(new Date());
            details.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(details.getGlcodeid().longValue()), false));
        }
        if (!egBillregister.getBillPayeedetails().isEmpty()) {
            this.populateBillPayeeDetails(egBillregister);
        }
    }

    private void populateBillPayeeDetails(EgBillregister egBillregister) {
        EgBillPayeedetails payeeDetail = null;
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
                if (!details.getGlcodeid().equals(payeeDetails.getEgBilldetailsId().getGlcodeid())) continue;
                payeeDetail = new EgBillPayeedetails();
                payeeDetail.setEgBilldetailsId(details);
                payeeDetail.setAccountDetailTypeId(payeeDetails.getAccountDetailTypeId());
                payeeDetail.setAccountDetailKeyId(payeeDetails.getAccountDetailKeyId());
                payeeDetail.setDebitAmount(payeeDetails.getDebitAmount());
                payeeDetail.setCreditAmount(payeeDetails.getCreditAmount());
                payeeDetail.setLastUpdatedTime(new Date());
                details.getEgBillPaydetailes().add(payeeDetail);
            }
        }
    }

    private void validateBillNumber(EgBillregister egBillregister, BindingResult resultBinder) {
        if (!this.expenseBillService.isBillNumberGenerationAuto() && !this.isBillNumUnique(egBillregister.getBillnumber())) {
            resultBinder.reject("msg.expense.bill.duplicate.bill.number", (Object[])new String[]{egBillregister.getBillnumber()}, null);
        }
    }

    private boolean isBillNumUnique(String billnumber) {
        EgBillregister bill = this.expenseBillService.getByBillnumber(billnumber);
        return bill == null;
    }

    private void validateLedgerAndSubledger(EgBillregister egBillregister, BindingResult resultBinder) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            if (details.getDebitamount() != null) {
                totalDrAmt = totalDrAmt.add(details.getDebitamount());
            }
            if (details.getCreditamount() != null) {
                totalCrAmt = totalCrAmt.add(details.getCreditamount());
            }
            if (details.getGlcodeid() == null) {
                resultBinder.rejectValue("msg.expense.bill.accdetail.accmissing", "msg.expense.bill.accdetail.accmissing");
            }
            if (details.getDebitamount() != null && details.getCreditamount() != null && details.getDebitamount().equals(BigDecimal.ZERO) && details.getCreditamount().equals(BigDecimal.ZERO) && details.getGlcodeid() != null) {
                resultBinder.reject("msg.expense.bill.accdetail.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
            }
            if (details.getDebitamount() == null || details.getCreditamount() == null || details.getDebitamount().compareTo(BigDecimal.ZERO) != 1 || details.getCreditamount().compareTo(BigDecimal.ZERO) != 1) continue;
            resultBinder.reject("msg.expense.bill.accdetail.amount", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
        }
        if (totalDrAmt.compareTo(totalCrAmt) != 0) {
            resultBinder.rejectValue("msg.expense.bill.accdetail.drcrmatch", "msg.expense.bill.accdetail.drcrmatch");
        }
        this.validateSubledgerDetails(egBillregister, resultBinder);
    }

    private void validateSubledgerDetails(EgBillregister egBillregister, BindingResult resultBinder) {
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            BigDecimal detailAmt = BigDecimal.ZERO;
            BigDecimal payeeDetailAmt = BigDecimal.ZERO;
            if (details.getDebitamount() != null && details.getDebitamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getDebitamount();
            } else if (details.getCreditamount() != null && details.getCreditamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getCreditamount();
            }
            for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getCreditAmount() != null && payeeDetails.getDebitAmount().equals(BigDecimal.ZERO) && payeeDetails.getCreditAmount().equals(BigDecimal.ZERO)) {
                    resultBinder.reject("msg.expense.bill.subledger.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
                }
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getCreditAmount() != null && payeeDetails.getDebitAmount().compareTo(BigDecimal.ZERO) == 1 && payeeDetails.getCreditAmount().compareTo(BigDecimal.ZERO) == 1) {
                    resultBinder.reject("msg.expense.bill.subledger.amount", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
                }
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getDebitAmount().compareTo(BigDecimal.ZERO) == 1) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getDebitAmount());
                } else if (payeeDetails.getCreditAmount() != null && payeeDetails.getCreditAmount().compareTo(BigDecimal.ZERO) == 1) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getCreditAmount());
                }
                Boolean check = false;
                for (CChartOfAccountDetail coaDetails : details.getChartOfAccounts().getChartOfAccountDetails()) {
                    if (payeeDetails.getAccountDetailTypeId() != coaDetails.getDetailTypeId().getId()) continue;
                    check = true;
                }
                if (check.booleanValue()) continue;
                resultBinder.reject("msg.expense.bill.subledger.mismatch", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
            }
            if (detailAmt.compareTo(payeeDetailAmt) == 0) continue;
            resultBinder.reject("msg.expense.bill.subledger.amtnotmatchinng", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
        }
    }
}

