/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.web.adaptor.BudgetJsonAdaptor;
import org.egov.model.budget.Budget;
import org.egov.model.service.BudgetDefinitionService;
import org.egov.utils.BeReType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/budgetdefinition"})
public class BudgetDefinitionController {
    private static final String BUDGET_NEW = "budgetdefinition-new";
    private static final String BUDGET_RESULT = "budgetdefinition-result";
    private static final String BUDGET_EDIT = "budgetdefinition-edit";
    private static final String BUDGET_VIEW = "budgetdefinition-view";
    private static final String BUDGET_SEARCH = "budgetdefinition-search";
    @Autowired
    private BudgetDefinitionService budgetDefinitionService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CFinancialYearService cFinancialYearService;

    private void prepareNewForm(Model model) {
        model.addAttribute("financialYearList", (Object)this.cFinancialYearService.getFinancialYearNotClosed());
        model.addAttribute("isBereList", Arrays.asList(BeReType.values()));
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        model.addAttribute("budget", (Object)new Budget());
        this.prepareNewForm(model);
        return BUDGET_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Budget budget, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        String validationMessage = this.budgetDefinitionService.validate(budget, errors);
        if (errors.hasErrors() || !StringUtils.isEmpty((String)validationMessage)) {
            this.prepareNewForm(model);
            model.addAttribute("budget", (Object)new Budget());
            model.addAttribute("validationMessage", (Object)validationMessage);
            return BUDGET_NEW;
        }
        budget.setStatus(this.budgetDefinitionService.getBudgetStatus("Created"));
        this.budgetDefinitionService.create(budget);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.budget.success", null, Locale.ENGLISH));
        return "redirect:/budgetdefinition/result/" + budget.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Budget budget = this.budgetDefinitionService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("budget", (Object)budget);
        model.addAttribute("modify", (Object)"modify");
        List bd = this.budgetDefinitionService.getBudgetDetailList(budget.getId());
        if (!bd.isEmpty()) {
            model.addAttribute("mode", (Object)"edit");
        }
        return BUDGET_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Budget budget, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        String validationMessage = this.budgetDefinitionService.validate(budget, errors);
        if (errors.hasErrors() || !StringUtils.isEmpty((String)validationMessage)) {
            this.prepareNewForm(model);
            model.addAttribute("validationMessage", (Object)validationMessage);
            model.addAttribute("modify", (Object)"modify");
            return BUDGET_EDIT;
        }
        this.budgetDefinitionService.update(budget);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.budget.update", null, null));
        return "redirect:/budgetdefinition/result/" + budget.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Budget budget = this.budgetDefinitionService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("budget", (Object)budget);
        return BUDGET_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Budget budget = this.budgetDefinitionService.findOne(id);
        model.addAttribute("budget", (Object)budget);
        return BUDGET_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Budget budget = new Budget();
        this.prepareNewForm(model);
        model.addAttribute("budget", (Object)budget);
        return BUDGET_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Budget budget) {
        List searchResultList = this.budgetDefinitionService.search(budget);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Budget.class, (Object)new BudgetJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/parents"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getParents(@RequestParam(value="financialYearId") String financialYearId, @RequestParam(value="isBeRe") String isBere) {
        List budgetList = this.budgetDefinitionService.parentList(isBere, Long.valueOf(Long.parseLong(financialYearId)));
        String jsonResponse = this.toSearchResultJson((Object)budgetList).toString();
        return jsonResponse;
    }

    @RequestMapping(value={"/referencebudget"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getRefencebudget(@RequestParam(value="financialYearId") String financialYearId) {
        List referenceBudgetList = this.budgetDefinitionService.referenceBudgetList(Long.valueOf(Long.parseLong(financialYearId)));
        String jsonResponse = this.toSearchResultJson((Object)referenceBudgetList).toString();
        return jsonResponse;
    }

    @RequestMapping(value={"/ajaxgetdropdownsformodify"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getReferenceBudgetForModify(@RequestParam(value="budgetId") String budgetId) {
        Budget budget = this.budgetDefinitionService.findOne(Long.valueOf(Long.parseLong(budgetId)));
        String jsonResponse = "{ \"data\":" + this.toSearchResultJson((Object)budget) + "}";
        return jsonResponse;
    }
}

