/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.Fund;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infstr.services.PersistenceService;

public class VoucherReport {
    private CGeneralLedger generalLedger = new CGeneralLedger();
    private CGeneralLedger voucherDetail = new CGeneralLedger();
    private PersistenceService persistenceService;
    private Department department;
    private static final String MULTIPLE = "MULTIPLE";
    private static final Logger LOGGER = Logger.getLogger(VoucherReport.class);
    private EgovCommon egovCommon;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public VoucherReport(PersistenceService persistenceService, Integer voucherId, CGeneralLedger voucherDetail, EgovCommon egovCommon) {
        this.persistenceService = persistenceService;
        this.egovCommon = egovCommon;
        this.generalLedger = this.getGeneralLedger(voucherId, voucherDetail);
        this.voucherDetail = voucherDetail;
    }

    public CGeneralLedger getGeneralLedger() {
        return this.generalLedger;
    }

    public CGeneralLedger getVoucherDetail() {
        return this.voucherDetail;
    }

    public String getSlCode() {
        if (this.generalLedger != null) {
            List generalLedgerDetail = this.persistenceService.findAllBy("from CGeneralLedgerDetail where generalLedgerId.id=?", new Object[]{this.generalLedger.getId()});
            if (generalLedgerDetail.size() > 1) {
                return MULTIPLE;
            }
            if (generalLedgerDetail.size() > 0) {
                EntityType entityType;
                block5: {
                    Integer detailTypeId = ((CGeneralLedgerDetail)generalLedgerDetail.get(0)).getDetailTypeId().getId();
                    List detailType = this.persistenceService.findAllBy("from Accountdetailtype where id=?", new Object[]{detailTypeId});
                    this.egovCommon.setPersistenceService(this.persistenceService);
                    Integer detailKeyId = ((CGeneralLedgerDetail)generalLedgerDetail.get(0)).getDetailKeyId();
                    entityType = null;
                    try {
                        entityType = this.egovCommon.getEntityType((Accountdetailtype)detailType.get(0), (Serializable)detailKeyId);
                    }
                    catch (ApplicationException e) {
                        if (!LOGGER.isDebugEnabled()) break block5;
                        LOGGER.debug((Object)("Error" + e.getMessage()), (Throwable)e);
                    }
                }
                return entityType.getCode() + "/" + entityType.getEntityDescription();
            }
        }
        return "";
    }

    public String getFunctionName() {
        if (this.generalLedger != null) {
            if (this.generalLedger.getFunctionId() != null) {
                CFunction function = this.fetchFunction(this.generalLedger.getFunctionId());
                return function == null ? "" : function.getName();
            }
        } else if (this.voucherDetail != null && this.voucherDetail.getVoucherHeaderId() != null && this.voucherDetail.getVoucherHeaderId().getVouchermis().getFunction() != null) {
            CFunction function = this.fetchFunction(this.generalLedger.getFunctionId());
            return function == null ? "" : function.getName();
        }
        return "";
    }

    private CFunction fetchFunction(Integer functionId) {
        return (CFunction)this.persistenceService.findById((Serializable)Long.valueOf(functionId.intValue()), false);
    }

    public String getFundName() {
        if (this.voucherDetail != null && this.voucherDetail.getVoucherHeaderId().getFundId() != null) {
            Fund fund = (Fund)this.persistenceService.findById((Serializable)this.voucherDetail.getVoucherHeaderId().getFundId().getId(), false);
            return fund == null ? "" : fund.getName();
        }
        return "";
    }

    private CGeneralLedger getGeneralLedger(Integer voucherId, CGeneralLedger voucherLineId) {
        return (CGeneralLedger)this.persistenceService.find("from CGeneralLedger where voucherHeaderId.id=? and glcode=? and voucherlineId=?", new Object[]{(long)voucherId.intValue(), voucherLineId.getGlcode(), voucherLineId.getVoucherlineId()});
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Department getDepartment() {
        return this.department;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }
}

